/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.compression;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.IndexedGeometryStripArray;
import org.jogamp.java3d.IndexedLineArray;
import org.jogamp.java3d.IndexedLineStripArray;
import org.jogamp.java3d.IndexedQuadArray;
import org.jogamp.java3d.IndexedTriangleArray;
import org.jogamp.java3d.IndexedTriangleFanArray;
import org.jogamp.java3d.IndexedTriangleStripArray;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.LineStripArray;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.java3d.internal.BufferWrapper;
import org.jogamp.java3d.utils.compression.CommandStream;
import org.jogamp.java3d.utils.compression.CompressionStreamColor;
import org.jogamp.java3d.utils.compression.CompressionStreamElement;
import org.jogamp.java3d.utils.compression.CompressionStreamNormal;
import org.jogamp.java3d.utils.compression.CompressionStreamVertex;
import org.jogamp.java3d.utils.compression.HuffmanTable;
import org.jogamp.java3d.utils.compression.MeshBuffer;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Point3i;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Vector3f;

public class CompressionStream {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    private static final boolean noMeshNormalSubstitution = true;
    static final int RESTART = 1;
    static final int REPLACE_MIDDLE = 2;
    static final int REPLACE_OLDEST = 3;
    static final int MESH_PUSH = 1;
    static final int NO_MESH_PUSH = 0;
    static final float ByteToFloatScale = 0.003921569f;
    int streamType;
    int vertexComponents;
    boolean vertexColors;
    boolean vertexColor3;
    boolean vertexColor4;
    boolean vertexNormals;
    boolean vertexTextures;
    boolean vertexTexture2;
    boolean vertexTexture3;
    boolean vertexTexture4;
    Point3d[] mcBounds = new Point3d[2];
    Point3d[] ncBounds = new Point3d[2];
    Point3i[] qcBounds = new Point3i[2];
    double[] center = new double[3];
    double positionRangeMaximum;
    double scale;
    int positionQuant;
    int colorQuant;
    int normalQuant;
    boolean positionQuantChanged;
    boolean colorQuantChanged;
    boolean normalQuantChanged;
    int[] lastPosition = new int[3];
    int[] lastColor = new int[4];
    int lastSextant;
    int lastOctant;
    int lastU;
    int lastV;
    boolean lastSpecialNormal;
    boolean firstPosition;
    boolean firstColor;
    boolean firstNormal;
    int byteCount = 0;
    int vertexCount = 0;
    int meshReferenceCount = 0;
    MeshBuffer meshBuffer = new MeshBuffer();
    private Collection stream;
    private boolean lastElementColor = false;
    private boolean lastLastElementColor = false;
    private boolean lastElementNormal = false;
    private boolean lastLastElementNormal = false;
    private Point3f p3f = new Point3f();
    private Color3f c3f = new Color3f();
    private Color4f c4f = new Color4f();
    private Vector3f n3f = new Vector3f();

    private CompressionStream() {
        this.stream = new LinkedList();
        this.mcBounds[0] = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.mcBounds[1] = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.qcBounds[0] = new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.qcBounds[1] = new Point3i(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.ncBounds[0] = new Point3d();
        this.ncBounds[1] = new Point3d();
    }

    CompressionStream(int streamType, int vertexComponents) {
        this();
        this.streamType = streamType;
        this.vertexComponents = this.getVertexComponents(vertexComponents);
    }

    private int getVertexComponents(int vertexFormat) {
        int components = 0;
        this.vertexTexture4 = false;
        this.vertexTexture3 = false;
        this.vertexTexture2 = false;
        this.vertexTextures = false;
        this.vertexNormals = false;
        this.vertexColor4 = false;
        this.vertexColor3 = false;
        this.vertexColors = false;
        if ((vertexFormat & 2) != 0) {
            this.vertexNormals = true;
            components &= 2;
        }
        if ((vertexFormat & 4) != 0) {
            this.vertexColors = true;
            if ((vertexFormat & 0xC) != 0) {
                this.vertexColor4 = true;
                components &= 0xC;
            } else {
                this.vertexColor3 = true;
                components &= 4;
            }
        }
        if ((vertexFormat & 0x20) != 0) {
            this.vertexTextures = true;
            this.vertexTexture2 = true;
            components &= 0x20;
        } else if ((vertexFormat & 0x40) != 0) {
            this.vertexTextures = true;
            this.vertexTexture3 = true;
            components &= 0x40;
        } else if ((vertexFormat & 0x400) != 0) {
            this.vertexTextures = true;
            this.vertexTexture4 = true;
            components &= 0x400;
        }
        if (this.vertexTextures) {
            throw new UnsupportedOperationException("\ncompression of texture coordinates is not supported");
        }
        return components;
    }

    private int getStreamType(GeometryArray ga) {
        if (ga instanceof TriangleStripArray || ga instanceof IndexedTriangleStripArray || ga instanceof TriangleFanArray || ga instanceof IndexedTriangleFanArray || ga instanceof TriangleArray || ga instanceof IndexedTriangleArray || ga instanceof QuadArray || ga instanceof IndexedQuadArray) {
            return 2;
        }
        if (ga instanceof LineArray || ga instanceof IndexedLineArray || ga instanceof LineStripArray || ga instanceof IndexedLineStripArray) {
            return 1;
        }
        return 0;
    }

    void quantize(HuffmanTable huffmanTable) {
        this.positionQuant = 16;
        this.colorQuant = 9;
        this.normalQuant = 6;
        this.center[0] = (this.mcBounds[1].x + this.mcBounds[0].x) / 2.0;
        this.center[1] = (this.mcBounds[1].y + this.mcBounds[0].y) / 2.0;
        this.center[2] = (this.mcBounds[1].z + this.mcBounds[0].z) / 2.0;
        double xRange = this.mcBounds[1].x - this.mcBounds[0].x;
        double yRange = this.mcBounds[1].y - this.mcBounds[0].y;
        double zRange = this.mcBounds[1].z - this.mcBounds[0].z;
        this.positionRangeMaximum = xRange > yRange ? xRange : yRange;
        if (zRange > this.positionRangeMaximum) {
            this.positionRangeMaximum = zRange;
        }
        this.scale = 2.0 / this.positionRangeMaximum * 0.999969482421875;
        this.normalQuantChanged = true;
        this.colorQuantChanged = true;
        this.positionQuantChanged = true;
        this.firstNormal = true;
        this.firstColor = true;
        this.firstPosition = true;
        for (Object o : this.stream) {
            if (!(o instanceof CompressionStreamElement)) continue;
            ((CompressionStreamElement)o).quantize(this, huffmanTable);
            this.lastLastElementColor = this.lastElementColor;
            this.lastLastElementNormal = this.lastElementNormal;
            this.lastElementNormal = false;
            this.lastElementColor = false;
            if (o instanceof CompressionStreamColor) {
                this.lastElementColor = true;
                continue;
            }
            if (!(o instanceof CompressionStreamNormal)) continue;
            this.lastElementNormal = true;
        }
        this.ncBounds[0].x = (double)this.qcBounds[0].x / 32768.0;
        this.ncBounds[0].y = (double)this.qcBounds[0].y / 32768.0;
        this.ncBounds[0].z = (double)this.qcBounds[0].z / 32768.0;
        this.ncBounds[1].x = (double)this.qcBounds[1].x / 32768.0;
        this.ncBounds[1].y = (double)this.qcBounds[1].y / 32768.0;
        this.ncBounds[1].z = (double)this.qcBounds[1].z / 32768.0;
    }

    void outputCommands(HuffmanTable huffmanTable, CommandStream outputBuffer) {
        int bnv = this.vertexNormals ? 1 : 0;
        int bcv = this.vertexColor3 || this.vertexColor4 ? 1 : 0;
        int cap = this.vertexColor4 ? 1 : 0;
        int command = 0x18 | bnv;
        long data = bcv << 2 | cap << 1;
        outputBuffer.addCommand(command, 8, data, 3);
        huffmanTable.outputCommands(outputBuffer);
        for (Object o : this.stream) {
            if (!(o instanceof CompressionStreamElement)) continue;
            ((CompressionStreamElement)o).outputCommand(huffmanTable, outputBuffer);
        }
        outputBuffer.end();
    }

    int getByteCount() {
        return this.byteCount;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    int getMeshReferenceCount() {
        return this.meshReferenceCount;
    }

    void addVertex(Point3f pos, int stripFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, null, null, stripFlag, 0));
    }

    void addVertex(Point3f pos, Vector3f norm, int stripFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, norm, null, stripFlag, 0));
    }

    void addVertex(Point3f pos, Color3f color, int stripFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, null, color, stripFlag, 0));
    }

    void addVertex(Point3f pos, Color4f color, int stripFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, null, color, stripFlag, 0));
    }

    void addVertex(Point3f pos, Vector3f norm, Color3f color, int stripFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, norm, color, stripFlag, 0));
    }

    void addVertex(Point3f pos, Vector3f norm, Color4f color, int stripFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, norm, color, stripFlag, 0));
    }

    void addVertex(Point3f pos, int stripFlag, int meshFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, null, null, stripFlag, meshFlag));
    }

    void addVertex(Point3f pos, Vector3f norm, int stripFlag, int meshFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, norm, null, stripFlag, meshFlag));
    }

    void addVertex(Point3f pos, Color3f color, int stripFlag, int meshFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, null, color, stripFlag, meshFlag));
    }

    void addVertex(Point3f pos, Color4f color, int stripFlag, int meshFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, null, color, stripFlag, meshFlag));
    }

    void addVertex(Point3f pos, Vector3f norm, Color3f color, int stripFlag, int meshFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, norm, color, stripFlag, meshFlag));
    }

    void addVertex(Point3f pos, Vector3f norm, Color4f color, int stripFlag, int meshFlag) {
        this.stream.add(new CompressionStreamVertex(this, pos, norm, color, stripFlag, meshFlag));
    }

    void addVertex(Point3f pos, Vector3f norm, Object color, int stripFlag, int meshFlag) {
        if (this.vertexColor3) {
            this.stream.add(new CompressionStreamVertex(this, pos, norm, (Color3f)color, stripFlag, meshFlag));
        } else {
            this.stream.add(new CompressionStreamVertex(this, pos, norm, (Color4f)color, stripFlag, meshFlag));
        }
    }

    void addMeshReference(int stripFlag, int meshIndex) {
        this.stream.add(new MeshReference(stripFlag, meshIndex));
    }

    void addColor(Color3f c3f) {
        this.stream.add(new CompressionStreamColor(this, c3f));
    }

    void addColor(Color4f c4f) {
        this.stream.add(new CompressionStreamColor(this, c4f));
    }

    void addNormal(Vector3f n) {
        this.stream.add(new CompressionStreamNormal(this, n));
    }

    void addPositionQuantization(int value) {
        this.stream.add(new PositionQuant(value));
    }

    void addColorQuantization(int value) {
        this.stream.add(new ColorQuant(value));
    }

    void addNormalQuantization(int value) {
        this.stream.add(new NormalQuant(value));
    }

    private void getIndexArrays(GeometryArray ga, IndexArrays ia) {
        IndexedGeometryArray iga = (IndexedGeometryArray)ga;
        int initialIndexIndex = iga.getInitialIndexIndex();
        int indexCount = iga.getValidIndexCount();
        int vertexFormat = iga.getVertexFormat();
        boolean useCoordIndexOnly = false;
        if ((vertexFormat & 0x200) != 0) {
            useCoordIndexOnly = true;
        }
        ia.positionIndices = new int[indexCount];
        iga.getCoordinateIndices(initialIndexIndex, ia.positionIndices);
        if (this.vertexNormals) {
            if (useCoordIndexOnly) {
                ia.normalIndices = ia.positionIndices;
            } else {
                ia.normalIndices = new int[indexCount];
                iga.getNormalIndices(initialIndexIndex, ia.normalIndices);
            }
        }
        if (this.vertexColor3 || this.vertexColor4) {
            if (useCoordIndexOnly) {
                ia.colorIndices = ia.positionIndices;
            } else {
                ia.colorIndices = new int[indexCount];
                iga.getColorIndices(initialIndexIndex, ia.colorIndices);
            }
        }
    }

    private void getVertexIndices(int v, IndexArrays ia, VertexIndices vi) {
        vi.pi = ia.positionIndices[v];
        if (this.vertexNormals) {
            vi.ni = ia.normalIndices[v];
        }
        if (this.vertexColors) {
            vi.ci = ia.colorIndices[v];
        }
    }

    private void processVertexCopy(VertexCopy vc, int stripFlag) {
        int r = this.meshBuffer.getMeshReference(vc.p);
        if (r == -1 || this.vertexNormals && !vc.n.equals((Tuple3f)this.meshBuffer.getNormal(r))) {
            this.addVertex(vc.p, vc.n, vc.c, stripFlag, 1);
            this.meshBuffer.push(vc.p, vc.c, vc.n);
        } else {
            if (this.vertexColor3 && !vc.c3.equals((Tuple3f)this.meshBuffer.getColor3(r))) {
                this.addColor(vc.c3);
            } else if (this.vertexColor4 && !vc.c4.equals((Tuple4f)this.meshBuffer.getColor4(r))) {
                this.addColor(vc.c4);
            }
            this.addMeshReference(stripFlag, r);
        }
    }

    private void processIndexedVertexCopy(VertexCopy vc, VertexIndices vi, int stripFlag) {
        int r = this.meshBuffer.getMeshReference(vi.pi);
        if (r == -1 || this.vertexNormals && vi.ni != this.meshBuffer.getNormalIndex(r)) {
            this.addVertex(vc.p, vc.n, vc.c, stripFlag, 1);
            this.meshBuffer.push(vi.pi, vi.ci, vi.ni);
        } else {
            if (this.vertexColor3 && vi.ci != this.meshBuffer.getColorIndex(r)) {
                this.addColor(vc.c3);
            } else if (this.vertexColor4 && vi.ci != this.meshBuffer.getColorIndex(r)) {
                this.addColor(vc.c4);
            }
            this.addMeshReference(stripFlag, r);
        }
    }

    /*
     * Unable to fully structure code
     */
    void addGeometryArray(GeometryArray ga) {
        block36: {
            block35: {
                firstVertex = 0;
                validVertexCount = 0;
                vertexFormat = ga.getVertexFormat();
                geometryAccessor = null;
                if (this.streamType != this.getStreamType(ga)) {
                    throw new IllegalArgumentException("GeometryArray has inconsistent dimensionality");
                }
                if (this.vertexComponents != this.getVertexComponents(vertexFormat)) {
                    throw new IllegalArgumentException("GeometryArray has inconsistent vertex components");
                }
                NIO = (vertexFormat & 2048) != 0;
                byRef = (vertexFormat & 128) != 0;
                interleaved = (vertexFormat & 256) != 0;
                indexedGeometry = ga instanceof IndexedGeometryArray;
                if (indexedGeometry) {
                    firstVertex = 0;
                    validVertexCount = ((IndexedGeometryArray)ga).getValidIndexCount();
                }
                if (!byRef) {
                    if (indexedGeometry) {
                        geometryAccessor = new IndexedByCopyGeometry(ga);
                    } else {
                        firstVertex = 0;
                        validVertexCount = ga.getValidVertexCount();
                        geometryAccessor = new ByCopyGeometry(ga);
                    }
                } else if (interleaved && NIO) {
                    if (indexedGeometry) {
                        geometryAccessor = new IndexedInterleavedGeometryNIO(ga);
                    } else {
                        firstVertex = ga.getInitialVertexIndex();
                        validVertexCount = ga.getValidVertexCount();
                        geometryAccessor = new InterleavedGeometryNIO(ga);
                    }
                } else if (interleaved && !NIO) {
                    if (indexedGeometry) {
                        geometryAccessor = new IndexedInterleavedGeometryFloat(ga);
                    } else {
                        firstVertex = ga.getInitialVertexIndex();
                        validVertexCount = ga.getValidVertexCount();
                        geometryAccessor = new InterleavedGeometryFloat(ga);
                    }
                } else if (!interleaved && NIO) {
                    if (indexedGeometry) {
                        geometryAccessor = new IndexedByRefGeometryNIO(ga);
                    } else {
                        firstVertex = 0;
                        validVertexCount = ga.getValidVertexCount();
                        geometryAccessor = new ByRefGeometryNIO(ga);
                    }
                } else if (!interleaved && !NIO) {
                    if (indexedGeometry) {
                        geometryAccessor = new IndexedByRefGeometry(ga);
                    } else {
                        firstVertex = 0;
                        validVertexCount = ga.getValidVertexCount();
                        geometryAccessor = new ByRefGeometry(ga);
                    }
                }
                stripCount = 0;
                stripCounts = null;
                constantStripLength = 0;
                replaceCode = 1;
                strips = false;
                implicitStrips = false;
                if (ga instanceof TriangleStripArray || ga instanceof IndexedTriangleStripArray || ga instanceof LineStripArray || ga instanceof IndexedLineStripArray) {
                    strips = true;
                    replaceCode = 3;
                } else if (ga instanceof TriangleFanArray || ga instanceof IndexedTriangleFanArray) {
                    strips = true;
                    replaceCode = 2;
                } else if (ga instanceof QuadArray || ga instanceof IndexedQuadArray) {
                    implicitStrips = true;
                    constantStripLength = 4;
                    replaceCode = 2;
                }
                if (strips) {
                    if (indexedGeometry) {
                        igsa = (IndexedGeometryStripArray)ga;
                        stripCount = igsa.getNumStrips();
                        stripCounts = new int[stripCount];
                        igsa.getStripIndexCounts(stripCounts);
                    } else {
                        gsa = (GeometryStripArray)ga;
                        stripCount = gsa.getNumStrips();
                        stripCounts = new int[stripCount];
                        gsa.getStripVertexCounts(stripCounts);
                    }
                }
                v = firstVertex;
                if (!strips) break block35;
                i = 0;
                while (i < stripCount) {
                    geometryAccessor.processVertex(v++, 1);
                    j = 1;
                    while (j < stripCounts[i]) {
                        geometryAccessor.processVertex(v++, replaceCode);
                        ++j;
                    }
                    ++i;
                }
                break block36;
            }
            if (!implicitStrips) ** GOTO lbl109
            while (v < firstVertex + validVertexCount) {
                geometryAccessor.processVertex(v++, 1);
                j = 1;
                while (j < constantStripLength) {
                    geometryAccessor.processVertex(v++, replaceCode);
                    ++j;
                }
            }
            break block36;
lbl-1000:
            // 1 sources

            {
                geometryAccessor.processVertex(v++, 1);
lbl109:
                // 2 sources

                ** while (v < firstVertex + validVertexCount)
            }
        }
    }

    void print() {
        System.out.println("\nstream has " + this.stream.size() + " entries");
        System.out.println("uncompressed size " + this.byteCount + " bytes");
        System.out.println("upper position bound: " + this.mcBounds[1].toString());
        System.out.println("lower position bound: " + this.mcBounds[0].toString());
        System.out.println("X, Y, Z centers (" + (float)this.center[0] + " " + (float)this.center[1] + " " + (float)this.center[2] + ")\n" + "scale " + (float)this.scale + "\n");
        Iterator i = this.stream.iterator();
        while (i.hasNext()) {
            System.out.println(String.valueOf(i.next().toString()) + "\n");
        }
    }

    public CompressionStream(int positionQuant, int colorQuant, int normalQuant, Shape3D[] shapes) {
        this();
        if (shapes == null) {
            throw new IllegalArgumentException("null Shape3D array");
        }
        if (shapes.length == 0) {
            throw new IllegalArgumentException("zero-length Shape3D array");
        }
        if (shapes[0] == null) {
            throw new IllegalArgumentException("Shape3D at index 0 is null");
        }
        long startTime = 0L;
        Geometry g = shapes[0].getGeometry();
        if (!(g instanceof GeometryArray)) {
            throw new IllegalArgumentException("Shape3D at index 0 is not a GeometryArray");
        }
        GeometryArray ga = (GeometryArray)g;
        this.streamType = this.getStreamType(ga);
        this.vertexComponents = this.getVertexComponents(ga.getVertexFormat());
        this.addPositionQuantization(positionQuant);
        this.addColorQuantization(colorQuant);
        this.addNormalQuantization(normalQuant);
        int s = 0;
        while (s < shapes.length) {
            Material m;
            g = shapes[s].getGeometry();
            if (!(g instanceof GeometryArray)) {
                throw new IllegalArgumentException("Shape3D at index " + s + " is not a GeometryArray");
            }
            Appearance a = shapes[s].getAppearance();
            if (a != null && (m = a.getMaterial()) != null) {
                m.getDiffuseColor(this.c3f);
                if (this.vertexColor4) {
                    this.c4f.set(this.c3f.x, this.c3f.y, this.c3f.z, 1.0f);
                    this.addColor(this.c4f);
                } else {
                    this.addColor(this.c3f);
                }
            }
            this.addGeometryArray((GeometryArray)g);
            ++s;
        }
    }

    public CompressionStream(Shape3D[] shapes) {
        this(16, 9, 6, shapes);
    }

    public CompressionStream(int positionQuant, int colorQuant, int normalQuant, GeometryInfo[] geometry) {
        this();
        if (geometry == null) {
            throw new IllegalArgumentException("null GeometryInfo array");
        }
        if (geometry.length == 0) {
            throw new IllegalArgumentException("zero-length GeometryInfo array");
        }
        if (geometry[0] == null) {
            throw new IllegalArgumentException("GeometryInfo at index 0 is null");
        }
        long startTime = 0L;
        GeometryArray ga = geometry[0].getGeometryArray();
        this.streamType = this.getStreamType(ga);
        this.vertexComponents = this.getVertexComponents(ga.getVertexFormat());
        this.addPositionQuantization(positionQuant);
        this.addColorQuantization(colorQuant);
        this.addNormalQuantization(normalQuant);
        int i = 0;
        while (i < geometry.length) {
            this.addGeometryArray(geometry[i].getGeometryArray());
            ++i;
        }
    }

    public CompressionStream(GeometryInfo[] geometry) {
        this(16, 9, 6, geometry);
    }

    public Point3d[] getModelBounds() {
        Point3d[] bounds = new Point3d[]{new Point3d(this.mcBounds[0]), new Point3d(this.mcBounds[1])};
        return bounds;
    }

    public Point3d[] getNormalizedBounds() {
        Point3d[] bounds = new Point3d[]{new Point3d(this.ncBounds[0]), new Point3d(this.ncBounds[1])};
        return bounds;
    }

    private class ByCopyGeometry
    implements GeometryAccessor {
        Point3f[] positions = null;
        Vector3f[] normals = null;
        Color3f[] colors3 = null;
        Color4f[] colors4 = null;

        ByCopyGeometry(GeometryArray ga) {
            this(ga, ga.getInitialVertexIndex(), ga.getValidVertexCount());
        }

        ByCopyGeometry(GeometryArray ga, int firstVertex, int validVertexCount) {
            this.positions = new Point3f[validVertexCount];
            int i = 0;
            while (i < validVertexCount) {
                this.positions[i] = new Point3f();
                ++i;
            }
            ga.getCoordinates(firstVertex, this.positions);
            if (CompressionStream.this.vertexNormals) {
                this.normals = new Vector3f[validVertexCount];
                i = 0;
                while (i < validVertexCount) {
                    this.normals[i] = new Vector3f();
                    ++i;
                }
                ga.getNormals(firstVertex, this.normals);
            }
            if (CompressionStream.this.vertexColor3) {
                this.colors3 = new Color3f[validVertexCount];
                i = 0;
                while (i < validVertexCount) {
                    this.colors3[i] = new Color3f();
                    ++i;
                }
                ga.getColors(firstVertex, this.colors3);
            } else if (CompressionStream.this.vertexColor4) {
                this.colors4 = new Color4f[validVertexCount];
                i = 0;
                while (i < validVertexCount) {
                    this.colors4[i] = new Color4f();
                    ++i;
                }
                ga.getColors(firstVertex, this.colors4);
            }
        }

        @Override
        public void processVertex(int v, int stripFlag) {
            Point3f p = this.positions[v];
            int r = CompressionStream.this.meshBuffer.getMeshReference(p);
            if (r == -1 || CompressionStream.this.vertexNormals && !this.normals[v].equals((Tuple3f)CompressionStream.this.meshBuffer.getNormal(r))) {
                Vector3f n;
                Vector3f vector3f = n = CompressionStream.this.vertexNormals ? this.normals[v] : null;
                Color3f c = CompressionStream.this.vertexColor3 ? this.colors3[v] : (CompressionStream.this.vertexColor4 ? this.colors4[v] : null);
                CompressionStream.this.addVertex(p, n, (Object)c, stripFlag, 1);
                CompressionStream.this.meshBuffer.push(p, (Object)c, n);
            } else {
                if (CompressionStream.this.vertexColor3 && !this.colors3[v].equals((Tuple3f)CompressionStream.this.meshBuffer.getColor3(r))) {
                    CompressionStream.this.addColor(this.colors3[v]);
                } else if (CompressionStream.this.vertexColor4 && !this.colors4[v].equals((Tuple4f)CompressionStream.this.meshBuffer.getColor4(r))) {
                    CompressionStream.this.addColor(this.colors4[v]);
                }
                CompressionStream.this.addMeshReference(stripFlag, r);
            }
        }
    }

    private class ByRefGeometry
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        byte[] colorsB = null;
        float[] colorsF = null;
        float[] normals = null;
        float[] positionsF = null;
        double[] positionsD = null;
        int initialPositionIndex = 0;
        int initialNormalIndex = 0;
        int initialColorIndex = 0;

        ByRefGeometry(GeometryArray ga) {
            this.positionsF = ga.getCoordRefFloat();
            this.positionsD = ga.getCoordRefDouble();
            if (this.positionsF == null && this.positionsD == null) {
                throw new UnsupportedOperationException("\nby-reference access to Point3{d,f} arrays");
            }
            this.initialPositionIndex = ga.getInitialCoordIndex();
            if (CompressionStream.this.vertexColors) {
                this.colorsB = ga.getColorRefByte();
                this.colorsF = ga.getColorRefFloat();
                if (this.colorsB == null && this.colorsF == null) {
                    throw new UnsupportedOperationException("\nby-reference access to Color{3b,3f,4b,4f} arrays");
                }
                this.initialColorIndex = ga.getInitialColorIndex();
            }
            if (CompressionStream.this.vertexNormals) {
                this.normals = ga.getNormalRefFloat();
                if (this.normals == null) {
                    throw new UnsupportedOperationException("\nby-reference access to Normal3f array");
                }
                this.initialNormalIndex = ga.getInitialNormalIndex();
            }
        }

        void copyVertex(int pi, int ni, int ci, VertexCopy vc) {
            vc.p = this.positionsF != null ? new Point3f(this.positionsF[pi + 0], this.positionsF[pi + 1], this.positionsF[pi + 2]) : new Point3f((float)this.positionsD[(pi *= 3) + 0], (float)this.positionsD[pi + 1], (float)this.positionsD[pi + 2]);
            ni *= 3;
            if (CompressionStream.this.vertexNormals) {
                vc.n = new Vector3f(this.normals[ni + 0], this.normals[ni + 1], this.normals[ni + 2]);
            }
            if (CompressionStream.this.vertexColor3) {
                vc.c3 = this.colorsB != null ? new Color3f((float)(this.colorsB[ci + 0] & 0xFF) * 0.003921569f, (float)(this.colorsB[ci + 1] & 0xFF) * 0.003921569f, (float)(this.colorsB[ci + 2] & 0xFF) * 0.003921569f) : new Color3f(this.colorsF[(ci *= 3) + 0], this.colorsF[ci + 1], this.colorsF[ci + 2]);
                vc.c = vc.c3;
            } else if (CompressionStream.this.vertexColor4) {
                vc.c4 = this.colorsB != null ? new Color4f((float)(this.colorsB[ci + 0] & 0xFF) * 0.003921569f, (float)(this.colorsB[ci + 1] & 0xFF) * 0.003921569f, (float)(this.colorsB[ci + 2] & 0xFF) * 0.003921569f, (float)(this.colorsB[ci + 3] & 0xFF) * 0.003921569f) : new Color4f(this.colorsF[(ci *= 4) + 0], this.colorsF[ci + 1], this.colorsF[ci + 2], this.colorsF[ci + 3]);
                vc.c = vc.c4;
            }
        }

        @Override
        public void processVertex(int v, int stripFlag) {
            this.copyVertex(v + this.initialPositionIndex, v + this.initialNormalIndex, v + this.initialColorIndex, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, stripFlag);
        }
    }

    private class ByRefGeometryNIO
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        ByteBuffer colorsB = null;
        FloatBuffer colorsF = null;
        FloatBuffer normals = null;
        FloatBuffer positionsF = null;
        DoubleBuffer positionsD = null;
        int initialPositionIndex = 0;
        int initialNormalIndex = 0;
        int initialColorIndex = 0;

        ByRefGeometryNIO(GeometryArray ga) {
            J3DBuffer buffer = ga.getCoordRefBuffer();
            this.initialPositionIndex = ga.getInitialCoordIndex();
            switch (BufferWrapper.getBufferType(buffer)) {
                case 3: {
                    this.positionsF = (FloatBuffer)buffer.getBuffer();
                    break;
                }
                case 4: {
                    this.positionsD = (DoubleBuffer)buffer.getBuffer();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\nposition buffer must be FloatBuffer or DoubleBuffer");
                }
            }
            if (CompressionStream.this.vertexColors) {
                buffer = ga.getColorRefBuffer();
                this.initialColorIndex = ga.getInitialColorIndex();
                switch (BufferWrapper.getBufferType(buffer)) {
                    case 2: {
                        this.colorsB = (ByteBuffer)buffer.getBuffer();
                        break;
                    }
                    case 3: {
                        this.colorsF = (FloatBuffer)buffer.getBuffer();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\ncolor buffer must be ByteBuffer or FloatBuffer");
                    }
                }
            }
            if (CompressionStream.this.vertexNormals) {
                buffer = ga.getNormalRefBuffer();
                this.initialNormalIndex = ga.getInitialNormalIndex();
                switch (BufferWrapper.getBufferType(buffer)) {
                    case 3: {
                        this.normals = (FloatBuffer)buffer.getBuffer();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\nnormal buffer must be FloatBuffer");
                    }
                }
            }
        }

        void copyVertex(int pi, int ni, int ci, VertexCopy vc) {
            vc.p = this.positionsF != null ? new Point3f(this.positionsF.get(pi + 0), this.positionsF.get(pi + 1), this.positionsF.get(pi + 2)) : new Point3f((float)this.positionsD.get((pi *= 3) + 0), (float)this.positionsD.get(pi + 1), (float)this.positionsD.get(pi + 2));
            ni *= 3;
            if (CompressionStream.this.vertexNormals) {
                vc.n = new Vector3f(this.normals.get(ni + 0), this.normals.get(ni + 1), this.normals.get(ni + 2));
            }
            if (CompressionStream.this.vertexColor3) {
                vc.c3 = this.colorsB != null ? new Color3f((float)(this.colorsB.get(ci + 0) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(ci + 1) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(ci + 2) & 0xFF) * 0.003921569f) : new Color3f(this.colorsF.get((ci *= 3) + 0), this.colorsF.get(ci + 1), this.colorsF.get(ci + 2));
                vc.c = vc.c3;
            } else if (CompressionStream.this.vertexColor4) {
                vc.c4 = this.colorsB != null ? new Color4f((float)(this.colorsB.get(ci + 0) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(ci + 1) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(ci + 2) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(ci + 3) & 0xFF) * 0.003921569f) : new Color4f(this.colorsF.get((ci *= 4) + 0), this.colorsF.get(ci + 1), this.colorsF.get(ci + 2), this.colorsF.get(ci + 3));
                vc.c = vc.c4;
            }
        }

        @Override
        public void processVertex(int v, int stripFlag) {
            this.copyVertex(v + this.initialPositionIndex, v + this.initialNormalIndex, v + this.initialColorIndex, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, stripFlag);
        }
    }

    private class ColorQuant
    extends CompressionStreamElement {
        int value;

        ColorQuant(int value) {
            this.value = value;
        }

        @Override
        void quantize(CompressionStream s, HuffmanTable t) {
            CompressionStream.this.colorQuant = this.value;
            CompressionStream.this.colorQuantChanged = true;
        }

        public String toString() {
            return "colorQuant: " + this.value;
        }
    }

    private static interface GeometryAccessor {
        public void processVertex(int var1, int var2);
    }

    private static class IndexArrays {
        int[] colorIndices = null;
        int[] normalIndices = null;
        int[] positionIndices = null;

        private IndexArrays() {
        }
    }

    private class IndexedByCopyGeometry
    extends ByCopyGeometry {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByCopyGeometry(GeometryArray ga) {
            super(ga, 0, ga.getVertexCount());
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(ga, this.ia);
        }

        @Override
        public void processVertex(int v, int stripFlag) {
            CompressionStream.this.getVertexIndices(v, this.ia, this.vi);
            int r = CompressionStream.this.meshBuffer.getMeshReference(this.vi.pi);
            if (r == -1 || CompressionStream.this.vertexNormals && this.vi.ni != CompressionStream.this.meshBuffer.getNormalIndex(r)) {
                Vector3f n;
                Point3f p = this.positions[this.vi.pi];
                Vector3f vector3f = n = CompressionStream.this.vertexNormals ? this.normals[this.vi.ni] : null;
                Color3f c = CompressionStream.this.vertexColor3 ? this.colors3[this.vi.ci] : (CompressionStream.this.vertexColor4 ? this.colors4[this.vi.ci] : null);
                CompressionStream.this.addVertex(p, n, (Object)c, stripFlag, 1);
                CompressionStream.this.meshBuffer.push(this.vi.pi, this.vi.ci, this.vi.ni);
            } else {
                if (CompressionStream.this.vertexColor3 && this.vi.ci != CompressionStream.this.meshBuffer.getColorIndex(r)) {
                    CompressionStream.this.addColor(this.colors3[this.vi.ci]);
                } else if (CompressionStream.this.vertexColor4 && this.vi.ci != CompressionStream.this.meshBuffer.getColorIndex(r)) {
                    CompressionStream.this.addColor(this.colors4[this.vi.ci]);
                }
                CompressionStream.this.addMeshReference(stripFlag, r);
            }
        }
    }

    private class IndexedByRefGeometry
    extends ByRefGeometry {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByRefGeometry(GeometryArray ga) {
            super(ga);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(ga, this.ia);
        }

        @Override
        public void processVertex(int v, int stripFlag) {
            CompressionStream.this.getVertexIndices(v, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, stripFlag);
        }
    }

    private class IndexedByRefGeometryNIO
    extends ByRefGeometryNIO {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByRefGeometryNIO(GeometryArray ga) {
            super(ga);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(ga, this.ia);
        }

        @Override
        public void processVertex(int v, int stripFlag) {
            CompressionStream.this.getVertexIndices(v, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, stripFlag);
        }
    }

    private class IndexedInterleavedGeometryFloat
    extends InterleavedGeometryFloat {
        IndexArrays ia;
        VertexIndices vi;

        IndexedInterleavedGeometryFloat(GeometryArray ga) {
            super(ga);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(ga, this.ia);
        }

        @Override
        public void processVertex(int v, int stripFlag) {
            CompressionStream.this.getVertexIndices(v, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, stripFlag);
        }
    }

    private class IndexedInterleavedGeometryNIO
    extends InterleavedGeometryNIO {
        IndexArrays ia;
        VertexIndices vi;

        IndexedInterleavedGeometryNIO(GeometryArray ga) {
            super(ga);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(ga, this.ia);
        }

        @Override
        public void processVertex(int v, int stripFlag) {
            CompressionStream.this.getVertexIndices(v, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, stripFlag);
        }
    }

    private abstract class InterleavedGeometry
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        int vstride = 0;
        int coffset = 0;
        int noffset = 0;
        int poffset = 0;
        int tstride = 0;
        int tcount = 0;

        InterleavedGeometry(GeometryArray ga) {
            if (CompressionStream.this.vertexTextures) {
                if (CompressionStream.this.vertexTexture2) {
                    this.tstride = 2;
                } else if (CompressionStream.this.vertexTexture3) {
                    this.tstride = 3;
                } else if (CompressionStream.this.vertexTexture4) {
                    this.tstride = 4;
                }
                this.tcount = ga.getTexCoordSetCount();
                this.vstride += this.tcount * this.tstride;
            }
            if (CompressionStream.this.vertexColors) {
                this.coffset = this.vstride;
                this.vstride = CompressionStream.this.vertexColor3 ? (this.vstride += 3) : (this.vstride += 4);
            }
            if (CompressionStream.this.vertexNormals) {
                this.noffset = this.vstride;
                this.vstride += 3;
            }
            this.poffset = this.vstride;
            this.vstride += 3;
        }

        abstract void copyVertex(int var1, int var2, int var3, VertexCopy var4);

        @Override
        public void processVertex(int v, int stripFlag) {
            this.copyVertex(v, v, v, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, stripFlag);
        }
    }

    private class InterleavedGeometryFloat
    extends InterleavedGeometry {
        float[] vdata;

        InterleavedGeometryFloat(GeometryArray ga) {
            super(ga);
            this.vdata = null;
            this.vdata = ga.getInterleavedVertices();
        }

        @Override
        void copyVertex(int pi, int ni, int ci, VertexCopy vc) {
            int voffset = pi * this.vstride;
            vc.p = new Point3f(this.vdata[voffset + this.poffset + 0], this.vdata[voffset + this.poffset + 1], this.vdata[voffset + this.poffset + 2]);
            if (CompressionStream.this.vertexNormals) {
                voffset = ni * this.vstride;
                vc.n = new Vector3f(this.vdata[voffset + this.noffset + 0], this.vdata[voffset + this.noffset + 1], this.vdata[voffset + this.noffset + 2]);
            }
            if (CompressionStream.this.vertexColor3) {
                voffset = ci * this.vstride;
                vc.c3 = new Color3f(this.vdata[voffset + this.coffset + 0], this.vdata[voffset + this.coffset + 1], this.vdata[voffset + this.coffset + 2]);
                vc.c = vc.c3;
            } else if (CompressionStream.this.vertexColor4) {
                voffset = ci * this.vstride;
                vc.c4 = new Color4f(this.vdata[voffset + this.coffset + 0], this.vdata[voffset + this.coffset + 1], this.vdata[voffset + this.coffset + 2], this.vdata[voffset + this.coffset + 3]);
                vc.c = vc.c4;
            }
        }
    }

    private class InterleavedGeometryNIO
    extends InterleavedGeometry {
        FloatBuffer fbw;

        InterleavedGeometryNIO(GeometryArray ga) {
            super(ga);
            this.fbw = null;
            J3DBuffer buffer = ga.getInterleavedVertexBuffer();
            if (BufferWrapper.getBufferType(buffer) != 3) {
                throw new IllegalArgumentException("\ninterleaved vertex buffer must be FloatBuffer");
            }
            this.fbw = (FloatBuffer)buffer.getBuffer();
        }

        @Override
        void copyVertex(int pi, int ni, int ci, VertexCopy vc) {
            int voffset = pi * this.vstride;
            vc.p = new Point3f(this.fbw.get(voffset + this.poffset + 0), this.fbw.get(voffset + this.poffset + 1), this.fbw.get(voffset + this.poffset + 2));
            if (CompressionStream.this.vertexNormals) {
                voffset = ni * this.vstride;
                vc.n = new Vector3f(this.fbw.get(voffset + this.noffset + 0), this.fbw.get(voffset + this.noffset + 1), this.fbw.get(voffset + this.noffset + 2));
            }
            if (CompressionStream.this.vertexColor3) {
                voffset = ci * this.vstride;
                vc.c3 = new Color3f(this.fbw.get(voffset + this.coffset + 0), this.fbw.get(voffset + this.coffset + 1), this.fbw.get(voffset + this.coffset + 2));
                vc.c = vc.c3;
            } else if (CompressionStream.this.vertexColor4) {
                voffset = ci * this.vstride;
                vc.c4 = new Color4f(this.fbw.get(voffset + this.coffset + 0), this.fbw.get(voffset + this.coffset + 1), this.fbw.get(voffset + this.coffset + 2), this.fbw.get(voffset + this.coffset + 3));
                vc.c = vc.c4;
            }
        }
    }

    private class MeshReference
    extends CompressionStreamElement {
        int stripFlag;
        int meshIndex;

        MeshReference(int stripFlag, int meshIndex) {
            this.stripFlag = stripFlag;
            this.meshIndex = meshIndex;
            ++CompressionStream.this.meshReferenceCount;
        }

        @Override
        void quantize(CompressionStream s, HuffmanTable t) {
            CompressionStreamVertex v = CompressionStream.this.meshBuffer.getVertex(this.meshIndex);
            CompressionStream.this.lastPosition[0] = v.xAbsolute;
            CompressionStream.this.lastPosition[1] = v.yAbsolute;
            CompressionStream.this.lastPosition[2] = v.zAbsolute;
            if (!(v.color == null || CompressionStream.this.lastElementColor || CompressionStream.this.lastElementNormal && CompressionStream.this.lastLastElementColor)) {
                CompressionStream.this.lastColor[0] = v.color.rAbsolute;
                CompressionStream.this.lastColor[1] = v.color.gAbsolute;
                CompressionStream.this.lastColor[2] = v.color.bAbsolute;
                CompressionStream.this.lastColor[3] = v.color.aAbsolute;
            }
            if (!(v.normal == null || CompressionStream.this.lastElementNormal || CompressionStream.this.lastElementColor && CompressionStream.this.lastLastElementNormal)) {
                CompressionStream.this.lastSextant = v.normal.sextant;
                CompressionStream.this.lastOctant = v.normal.octant;
                CompressionStream.this.lastU = v.normal.uAbsolute;
                CompressionStream.this.lastV = v.normal.vAbsolute;
                CompressionStream.this.lastSpecialNormal = v.normal.specialNormal;
            }
        }

        @Override
        void outputCommand(HuffmanTable t, CommandStream outputBuffer) {
            int command = 32;
            long data = this.stripFlag & 1;
            outputBuffer.addCommand(command |= (this.meshIndex & 0xF) << 1 | this.stripFlag >> 1, 8, data, 1);
        }

        public String toString() {
            return "meshReference: stripFlag " + this.stripFlag + " meshIndex " + this.meshIndex;
        }
    }

    private class NormalQuant
    extends CompressionStreamElement {
        int value;

        NormalQuant(int value) {
            this.value = value;
        }

        @Override
        void quantize(CompressionStream s, HuffmanTable t) {
            CompressionStream.this.normalQuant = this.value;
            CompressionStream.this.normalQuantChanged = true;
        }

        public String toString() {
            return "normalQuant: " + this.value;
        }
    }

    private class PositionQuant
    extends CompressionStreamElement {
        int value;

        PositionQuant(int value) {
            this.value = value;
        }

        @Override
        void quantize(CompressionStream s, HuffmanTable t) {
            CompressionStream.this.positionQuant = this.value;
            CompressionStream.this.positionQuantChanged = true;
            CompressionStream.this.scale = 2.0 / CompressionStream.this.positionRangeMaximum * ((double)((1 << this.value - 1) - 1) / (double)(1 << this.value - 1));
        }

        public String toString() {
            return "positionQuant: " + this.value;
        }
    }

    private static class VertexCopy {
        Object c = null;
        Point3f p = null;
        Vector3f n = null;
        Color3f c3 = null;
        Color4f c4 = null;

        private VertexCopy() {
        }
    }

    private static class VertexIndices {
        int pi;
        int ni;
        int ci;

        private VertexIndices() {
        }
    }
}

