/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.picking;

import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Link;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.geometry.Primitive;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class PickObject {
    public static final int SHAPE3D = 1;
    public static final int MORPH = 2;
    public static final int PRIMITIVE = 4;
    public static final int LINK = 8;
    public static final int GROUP = 16;
    public static final int TRANSFORM_GROUP = 32;
    public static final int BRANCH_GROUP = 64;
    public static final int SWITCH = 128;
    public static final int USE_GEOMETRY = 256;
    public static final int USE_BOUNDS = 512;
    BranchGroup pickRoot;
    Canvas3D canvas;
    Point3d origin = new Point3d();
    Vector3d direction = new Vector3d();
    PickRay pickRay = new PickRay();
    SceneGraphPath sceneGraphPath = null;
    SceneGraphPath[] sceneGraphPathArr = null;
    int pickBy;
    static final boolean debug = false;
    private double[] distance;
    private int[] position;

    public PickObject(Canvas3D c, BranchGroup root) {
        this.pickRoot = root;
        this.canvas = c;
    }

    public PickShape generatePickRay(int xpos, int ypos) {
        Transform3D motion = new Transform3D();
        Point3d eyePosn = new Point3d();
        Point3d mousePosn = new Point3d();
        Vector3d mouseVec = new Vector3d();
        this.canvas.getCenterEyeInImagePlate(eyePosn);
        this.canvas.getPixelLocationInImagePlate(xpos, ypos, mousePosn);
        if (this.canvas.getView().getProjectionPolicy() == 0) {
            eyePosn.x = mousePosn.x;
            eyePosn.y = mousePosn.y;
        }
        this.canvas.getImagePlateToVworld(motion);
        motion.transform(eyePosn);
        motion.transform(mousePosn);
        mouseVec.sub((Tuple3d)mousePosn, (Tuple3d)eyePosn);
        mouseVec.normalize();
        this.pickRay.set(eyePosn, mouseVec);
        return this.pickRay;
    }

    public SceneGraphPath[] pickAll(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAll((PickShape)this.pickRay);
        return this.sceneGraphPathArr;
    }

    public SceneGraphPath[] pickAllSorted(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAllSorted((PickShape)this.pickRay);
        return this.sceneGraphPathArr;
    }

    public SceneGraphPath pickAny(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPath = this.pickRoot.pickAny((PickShape)this.pickRay);
        return this.sceneGraphPath;
    }

    public SceneGraphPath pickClosest(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPath = this.pickRoot.pickClosest((PickShape)this.pickRay);
        return this.sceneGraphPath;
    }

    public SceneGraphPath[] pickAll(int xpos, int ypos, int flag) {
        if (flag == 512) {
            return this.pickAll(xpos, ypos);
        }
        if (flag == 256) {
            return this.pickGeomAll(xpos, ypos);
        }
        return null;
    }

    public SceneGraphPath[] pickAllSorted(int xpos, int ypos, int flag) {
        if (flag == 512) {
            return this.pickAllSorted(xpos, ypos);
        }
        if (flag == 256) {
            return this.pickGeomAllSorted(xpos, ypos);
        }
        return null;
    }

    public SceneGraphPath pickAny(int xpos, int ypos, int flag) {
        if (flag == 512) {
            return this.pickAny(xpos, ypos);
        }
        if (flag == 256) {
            return this.pickGeomAny(xpos, ypos);
        }
        return null;
    }

    public SceneGraphPath pickClosest(int xpos, int ypos, int flag) {
        if (flag == 512) {
            return this.pickClosest(xpos, ypos);
        }
        if (flag == 256) {
            return this.pickGeomClosest(xpos, ypos);
        }
        return null;
    }

    private SceneGraphPath[] pickGeomAll(int xpos, int ypos) {
        int cnt = 0;
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAll((PickShape)this.pickRay);
        if (this.sceneGraphPathArr == null) {
            return null;
        }
        boolean[] found = new boolean[this.sceneGraphPathArr.length];
        int i = 0;
        while (i < this.sceneGraphPathArr.length) {
            Node obj = this.sceneGraphPathArr[i].getObject();
            if (obj instanceof Shape3D) {
                found[i] = ((Shape3D)obj).intersect(this.sceneGraphPathArr[i], (PickShape)this.pickRay);
            } else if (obj instanceof Morph) {
                found[i] = ((Morph)obj).intersect(this.sceneGraphPathArr[i], (PickShape)this.pickRay);
            }
            if (found[i]) {
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            return null;
        }
        SceneGraphPath[] newSceneGraphPathArr = new SceneGraphPath[cnt];
        cnt = 0;
        i = 0;
        while (i < this.sceneGraphPathArr.length) {
            if (found[i]) {
                newSceneGraphPathArr[cnt++] = this.sceneGraphPathArr[i];
            }
            ++i;
        }
        return newSceneGraphPathArr;
    }

    private SceneGraphPath[] pickGeomAllSorted(int xpos, int ypos) {
        int cnt = 0;
        double[] dist = new double[1];
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAll((PickShape)this.pickRay);
        if (this.sceneGraphPathArr == null) {
            return null;
        }
        boolean[] found = new boolean[this.sceneGraphPathArr.length];
        double[] distArr = new double[this.sceneGraphPathArr.length];
        int i = 0;
        while (i < this.sceneGraphPathArr.length) {
            Node obj = this.sceneGraphPathArr[i].getObject();
            if (obj instanceof Shape3D) {
                found[i] = ((Shape3D)obj).intersect(this.sceneGraphPathArr[i], this.pickRay, dist);
                distArr[i] = dist[0];
            } else if (obj instanceof Morph) {
                found[i] = ((Morph)obj).intersect(this.sceneGraphPathArr[i], this.pickRay, dist);
                distArr[i] = dist[0];
            }
            if (found[i]) {
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            return null;
        }
        SceneGraphPath[] newSceneGraphPathArr = new SceneGraphPath[cnt];
        this.distance = new double[cnt];
        cnt = 0;
        i = 0;
        while (i < this.sceneGraphPathArr.length) {
            if (found[i]) {
                newSceneGraphPathArr[cnt] = this.sceneGraphPathArr[i];
                this.distance[cnt++] = distArr[i];
            }
            ++i;
        }
        return this.sort(newSceneGraphPathArr);
    }

    private SceneGraphPath pickGeomClosest(int xpos, int ypos) {
        SceneGraphPath[] sgpArr = this.pickGeomAllSorted(xpos, ypos);
        if (sgpArr == null) {
            return null;
        }
        return sgpArr[0];
    }

    private SceneGraphPath pickGeomAny(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAll((PickShape)this.pickRay);
        int i = 0;
        while (i < this.sceneGraphPathArr.length) {
            Node obj = this.sceneGraphPathArr[i].getObject();
            if (obj instanceof Shape3D ? ((Shape3D)obj).intersect(this.sceneGraphPathArr[i], (PickShape)this.pickRay) : obj instanceof Morph && ((Morph)obj).intersect(this.sceneGraphPathArr[i], (PickShape)this.pickRay)) {
                return this.sceneGraphPathArr[i];
            }
            ++i;
        }
        return null;
    }

    private SceneGraphPath[] sort(SceneGraphPath[] sgpArr) {
        if (sgpArr == null) {
            return null;
        }
        SceneGraphPath[] sorted = new SceneGraphPath[sgpArr.length];
        this.position = new int[sgpArr.length];
        int i = 0;
        while (i < sgpArr.length) {
            this.position[i] = i;
            ++i;
        }
        this.quicksort(0, this.distance.length - 1);
        i = 0;
        while (i < this.distance.length) {
            sorted[i] = sgpArr[this.position[i]];
            ++i;
        }
        return sorted;
    }

    private final void quicksort(int l, int r) {
        int i = l;
        int j = r;
        double k = this.distance[(l + r) / 2];
        while (true) {
            if (this.distance[i] < k) {
                ++i;
                continue;
            }
            while (k < this.distance[j]) {
                --j;
            }
            if (i <= j) {
                double tmp = this.distance[i];
                this.distance[i] = this.distance[j];
                this.distance[j] = tmp;
                int p = this.position[i];
                this.position[i] = this.position[j];
                this.position[j] = p;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.quicksort(l, j);
        }
        if (l < r) {
            this.quicksort(i, r);
        }
    }

    public Node pickNode(SceneGraphPath sgPath, int flags) {
        if (sgPath != null) {
            Node pickedNode = sgPath.getObject();
            if (pickedNode instanceof Shape3D && (flags & 1) != 0) {
                return pickedNode;
            }
            if (pickedNode instanceof Morph && (flags & 2) != 0) {
                return pickedNode;
            }
            int j = sgPath.nodeCount() - 1;
            while (j >= 0) {
                pickedNode = sgPath.getNode(j);
                if (pickedNode instanceof Primitive && (flags & 4) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof Link && (flags & 8) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof Switch && (flags & 0x80) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof TransformGroup && (flags & 0x20) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof BranchGroup && (flags & 0x40) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof Group && (flags & 0x10) != 0) {
                    return pickedNode;
                }
                --j;
            }
            if (pickedNode == null) {
                // empty if block
            }
        }
        return null;
    }

    public Node pickNode(SceneGraphPath sgPath, int flags, int occurrence) {
        int curCnt = 0;
        if (sgPath != null) {
            Node pickedNode = sgPath.getObject();
            if (pickedNode instanceof Shape3D && (flags & 1) != 0) {
                return pickedNode;
            }
            if (pickedNode instanceof Morph && (flags & 2) != 0) {
                return pickedNode;
            }
            int j = 0;
            while (j < sgPath.nodeCount()) {
                pickedNode = sgPath.getNode(j);
                if (pickedNode instanceof Group && (flags & 0x10) != 0 ? ++curCnt == occurrence : (pickedNode instanceof BranchGroup && (flags & 0x40) != 0 ? ++curCnt == occurrence : (pickedNode instanceof TransformGroup && (flags & 0x20) != 0 ? ++curCnt == occurrence : (pickedNode instanceof Primitive && (flags & 4) != 0 ? ++curCnt == occurrence : pickedNode instanceof Link && (flags & 8) != 0 && ++curCnt == occurrence)))) {
                    return pickedNode;
                }
                ++j;
            }
            if (pickedNode == null) {
                // empty if block
            }
        }
        return null;
    }
}

