/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.lw3d.DebugOutput;

class TextfileParser {
    static int WORD = -3;
    static int NUMBER = -2;
    int currentLevel = 3;
    static final int TRACE = 1;
    static final int VALUES = 2;
    static final int MISC = 4;
    static final int LINE_TRACE = 8;
    static final int NONE = 0;
    static final int EXCEPTION = 16;
    static final int TIME = 32;
    protected DebugOutput debugPrinter = new DebugOutput(16);
    char lineSeparatorChar = '\u0000';

    TextfileParser() {
        String lineSeparator = System.getProperty("line.separator");
        this.lineSeparatorChar = lineSeparator.charAt(0);
        this.debugOutputLn(2, "lineSeparatorChar = " + this.lineSeparatorChar);
    }

    protected void debugOutputLn(int outputType, String theOutput) {
        if (theOutput.equals("")) {
            this.debugPrinter.println(outputType, theOutput);
        } else {
            this.debugPrinter.println(outputType, String.valueOf(this.getClass().getName()) + "::" + theOutput);
        }
    }

    protected void debugOutput(int outputType, String theOutput) {
        this.debugPrinter.print(outputType, theOutput);
    }

    void skipUntilString(StreamTokenizer st, String theString) throws ParsingErrorException {
        boolean done = false;
        try {
            while (!done) {
                st.nextToken();
                if (st.ttype != WORD || !st.sval.equals(theString)) continue;
                done = true;
            }
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
    }

    double getNumber(StreamTokenizer st) throws ParsingErrorException, NumberFormatException {
        try {
            int n = st.nextToken();
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
        this.checkType(st, WORD);
        return Double.valueOf(st.sval);
    }

    String getString(StreamTokenizer st) throws ParsingErrorException {
        try {
            st.nextToken();
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
        this.checkType(st, WORD);
        return st.sval;
    }

    String getName(StreamTokenizer st) throws ParsingErrorException {
        String theName = "";
        st.ordinaryChar(this.lineSeparatorChar);
        st.ordinaryChar(10);
        st.ordinaryChar(13);
        try {
            st.nextToken();
            while (st.ttype != this.lineSeparatorChar && st.ttype != 13 && st.ttype != 10) {
                if (st.ttype != 40 && st.ttype != 41) {
                    theName = String.valueOf(theName) + st.sval;
                }
                st.nextToken();
            }
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
        st.whitespaceChars(this.lineSeparatorChar, this.lineSeparatorChar);
        st.whitespaceChars(10, 10);
        st.whitespaceChars(13, 13);
        this.debugOutputLn(2, "name = " + theName);
        return theName;
    }

    void getAndCheckString(StreamTokenizer st, String expectedValue) throws ParsingErrorException {
        try {
            st.nextToken();
            this.checkString(st, expectedValue);
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
    }

    void checkString(StreamTokenizer st, String theString) throws ParsingErrorException {
        if (st.ttype != -3 || !st.sval.equals(theString)) {
            throw new ParsingErrorException("Bad String Token (wanted " + theString + ", got " + st.sval + ": " + st.toString());
        }
    }

    void checkType(StreamTokenizer st, int theType) throws ParsingErrorException {
        if (st.ttype != theType) {
            throw new ParsingErrorException("Bad Type Token, Expected " + theType + " and received" + st.ttype);
        }
    }

    void skip(StreamTokenizer st, String tokenString, int skipVals) throws ParsingErrorException {
        try {
            st.nextToken();
            this.checkString(st, tokenString);
            int i = 0;
            while (i < skipVals) {
                st.nextToken();
                ++i;
            }
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
    }

    boolean isCurrentToken(StreamTokenizer st, String tokenString) {
        if (st.ttype == WORD) {
            return st.sval.equals(tokenString);
        }
        return false;
    }
}

