/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.stereo.AbstractStereo;
import org.openscience.cdk.stereo.Octahedral;

public final class TrigonalBipyramidal
extends AbstractStereo<IAtom, IAtom> {
    private static final int[][] PERMUTATIONS = new int[][]{{0, 1, 2, 3, 4, 0, 2, 3, 1, 4, 0, 3, 1, 2, 4, 4, 3, 2, 1, 0, 4, 1, 3, 2, 0, 4, 2, 1, 3, 0}, {0, 3, 2, 1, 4, 0, 2, 1, 3, 4, 0, 1, 3, 2, 4, 4, 1, 2, 3, 0, 4, 3, 1, 2, 0, 4, 2, 3, 1, 0}, {0, 1, 2, 4, 3, 0, 2, 4, 1, 3, 0, 4, 1, 2, 3, 3, 4, 2, 1, 0, 3, 1, 4, 2, 0, 3, 2, 1, 4, 0}, {0, 4, 2, 1, 3, 0, 2, 1, 4, 3, 0, 1, 4, 2, 3, 3, 1, 2, 4, 0, 3, 4, 1, 2, 0, 3, 2, 4, 1, 0}, {0, 1, 3, 4, 2, 0, 3, 4, 1, 2, 0, 4, 1, 3, 2, 2, 4, 3, 1, 0, 2, 1, 4, 3, 0, 2, 3, 1, 4, 0}, {0, 4, 3, 1, 2, 0, 3, 1, 4, 2, 0, 1, 4, 3, 2, 2, 1, 3, 4, 0, 2, 4, 1, 3, 0, 2, 3, 4, 1, 0}, {0, 2, 3, 4, 1, 0, 3, 4, 2, 1, 0, 4, 2, 3, 1, 1, 4, 3, 2, 0, 1, 2, 4, 3, 0, 1, 3, 2, 4, 0}, {0, 4, 3, 2, 1, 0, 3, 2, 4, 1, 0, 2, 4, 3, 1, 1, 2, 3, 4, 0, 1, 4, 2, 3, 0, 1, 3, 4, 2, 0}, {1, 0, 2, 3, 4, 1, 2, 3, 0, 4, 1, 3, 0, 2, 4, 4, 3, 2, 0, 1, 4, 0, 3, 2, 1, 4, 2, 0, 3, 1}, {1, 0, 2, 4, 3, 1, 2, 4, 0, 3, 1, 4, 0, 2, 3, 3, 4, 2, 0, 1, 3, 0, 4, 2, 1, 3, 2, 0, 4, 1}, {1, 3, 2, 0, 4, 1, 2, 0, 3, 4, 1, 0, 3, 2, 4, 4, 0, 2, 3, 1, 4, 3, 0, 2, 1, 4, 2, 3, 0, 1}, {1, 4, 2, 0, 3, 1, 2, 0, 4, 3, 1, 0, 4, 2, 3, 3, 0, 2, 4, 1, 3, 4, 0, 2, 1, 3, 2, 4, 0, 1}, {1, 0, 3, 4, 2, 1, 3, 4, 0, 2, 1, 4, 0, 3, 2, 2, 4, 3, 0, 1, 2, 0, 4, 3, 1, 2, 3, 0, 4, 1}, {1, 4, 3, 0, 2, 1, 3, 0, 4, 2, 1, 0, 4, 3, 2, 2, 0, 3, 4, 1, 2, 4, 0, 3, 1, 2, 3, 4, 0, 1}, {2, 0, 1, 3, 4, 2, 1, 3, 0, 4, 2, 3, 0, 1, 4, 4, 3, 1, 0, 2, 4, 0, 3, 1, 2, 4, 1, 0, 3, 2}, {2, 0, 1, 4, 3, 2, 1, 4, 0, 3, 2, 4, 0, 1, 3, 3, 4, 1, 0, 2, 3, 0, 4, 1, 2, 3, 1, 0, 4, 2}, {3, 0, 1, 2, 4, 3, 1, 2, 0, 4, 3, 2, 0, 1, 4, 4, 2, 1, 0, 3, 4, 0, 2, 1, 3, 4, 1, 0, 2, 3}, {3, 2, 1, 0, 4, 3, 1, 0, 2, 4, 3, 0, 2, 1, 4, 4, 0, 1, 2, 3, 4, 2, 0, 1, 3, 4, 1, 2, 0, 3}, {2, 4, 1, 0, 3, 2, 1, 0, 4, 3, 2, 0, 4, 1, 3, 3, 0, 1, 4, 2, 3, 4, 0, 1, 2, 3, 1, 4, 0, 2}, {2, 3, 1, 0, 4, 2, 1, 0, 3, 4, 2, 0, 3, 1, 4, 4, 0, 1, 3, 2, 4, 3, 0, 1, 2, 4, 1, 3, 0, 2}};

    public TrigonalBipyramidal(IAtom focus, IAtom[] carriers, int order) {
        super((IChemObject)focus, (IChemObject[])carriers, 0x5200 | order & 0xFF);
        if (this.getConfigOrder() < 0 || this.getConfigOrder() > 20) {
            throw new IllegalArgumentException("Invalid configuration order,should be between 1-20");
        }
    }

    public TrigonalBipyramidal normalize() {
        int cfg = this.getConfigOrder();
        if (cfg == 1) {
            return this;
        }
        IAtom[] carriers = TrigonalBipyramidal.invapply(this.getCarriers().toArray(new IAtom[5]), PERMUTATIONS[cfg - 1]);
        return new TrigonalBipyramidal((IAtom)this.getFocus(), carriers, 1);
    }

    protected TrigonalBipyramidal create(IAtom focus, List<IAtom> carriers, int cfg) {
        return new TrigonalBipyramidal(focus, carriers.toArray(new IAtom[5]), cfg);
    }

    private static boolean same(List<IAtom> a, List<IAtom> b, int[] perm, int i) {
        for (int j = i; j < i + 5; ++j) {
            if (b.get(j - i).equals(a.get(perm[j]))) continue;
            return false;
        }
        return true;
    }

    public static int reorder(List<IAtom> current, List<IAtom> required) {
        for (int order = 0; order < PERMUTATIONS.length; ++order) {
            int[] local = PERMUTATIONS[order];
            for (int k = 0; k < local.length; k += 5) {
                if (!TrigonalBipyramidal.same(current, required, local, k)) continue;
                return order + 1;
            }
        }
        return -1;
    }

    public boolean canBeOctahedral() {
        int numExplicit = 0;
        IAtom focus = (IAtom)this.getFocus();
        for (IAtom atom : this.getCarriers()) {
            if (atom.equals(focus)) continue;
            ++numExplicit;
        }
        if (numExplicit > 3) {
            return false;
        }
        TrigonalBipyramidal normalized = this.normalize();
        List carriers = normalized.getCarriers();
        int numEquatorial = 0;
        for (int i = 1; i < 4; ++i) {
            if (((IAtom)carriers.get(i)).equals(focus)) continue;
            ++numEquatorial;
        }
        return numEquatorial <= 1;
    }

    public Octahedral asOctahedral() {
        TrigonalBipyramidal normalized = this.normalize();
        if (!normalized.canBeOctahedral()) {
            return null;
        }
        IAtom focus = (IAtom)normalized.getFocus();
        ArrayList<IAtom> carriers = new ArrayList<IAtom>(normalized.getCarriers());
        carriers.add(1, focus);
        return new Octahedral((IAtom)this.getFocus(), carriers.toArray(new IAtom[6]), 1);
    }
}

