/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.stereo.AbstractStereo;
import org.openscience.cdk.stereo.TrigonalBipyramidal;

public final class Octahedral
extends AbstractStereo<IAtom, IAtom> {
    public static final int[][] PERMUTATIONS = new int[][]{{0, 1, 2, 3, 4, 5, 0, 2, 3, 4, 1, 5, 0, 3, 4, 1, 2, 5, 0, 4, 1, 2, 3, 5, 1, 0, 4, 5, 2, 3, 1, 2, 0, 4, 5, 3, 1, 4, 5, 2, 0, 3, 1, 5, 2, 0, 4, 3, 2, 0, 1, 5, 3, 4, 2, 1, 5, 3, 0, 4, 2, 3, 0, 1, 5, 4, 2, 5, 3, 0, 1, 4, 3, 0, 2, 5, 4, 1, 3, 2, 5, 4, 0, 1, 3, 4, 0, 2, 5, 1, 3, 5, 4, 0, 2, 1, 4, 0, 3, 5, 1, 2, 4, 1, 0, 3, 5, 2, 4, 3, 5, 1, 0, 2, 4, 5, 1, 0, 3, 2, 5, 1, 4, 3, 2, 0, 5, 2, 1, 4, 3, 0, 5, 3, 2, 1, 4, 0, 5, 4, 3, 2, 1, 0}, {0, 1, 4, 3, 2, 5, 0, 2, 1, 4, 3, 5, 0, 3, 2, 1, 4, 5, 0, 4, 3, 2, 1, 5, 1, 0, 2, 5, 4, 3, 1, 2, 5, 4, 0, 3, 1, 4, 0, 2, 5, 3, 1, 5, 4, 0, 2, 3, 2, 0, 3, 5, 1, 4, 2, 1, 0, 3, 5, 4, 2, 3, 5, 1, 0, 4, 2, 5, 1, 0, 3, 4, 3, 0, 4, 5, 2, 1, 3, 2, 0, 4, 5, 1, 3, 4, 5, 2, 0, 1, 3, 5, 2, 0, 4, 1, 4, 0, 1, 5, 3, 2, 4, 1, 5, 3, 0, 2, 4, 3, 0, 1, 5, 2, 4, 5, 3, 0, 1, 2, 5, 1, 2, 3, 4, 0, 5, 2, 3, 4, 1, 0, 5, 3, 4, 1, 2, 0, 5, 4, 1, 2, 3, 0}, {0, 1, 2, 3, 5, 4, 0, 2, 3, 5, 1, 4, 0, 3, 5, 1, 2, 4, 0, 5, 1, 2, 3, 4, 1, 0, 5, 4, 2, 3, 1, 2, 0, 5, 4, 3, 1, 4, 2, 0, 5, 3, 1, 5, 4, 2, 0, 3, 2, 0, 1, 4, 3, 5, 2, 1, 4, 3, 0, 5, 2, 3, 0, 1, 4, 5, 2, 4, 3, 0, 1, 5, 3, 0, 2, 4, 5, 1, 3, 2, 4, 5, 0, 1, 3, 4, 5, 0, 2, 1, 3, 5, 0, 2, 4, 1, 4, 1, 5, 3, 2, 0, 4, 2, 1, 5, 3, 0, 4, 3, 2, 1, 5, 0, 4, 5, 3, 2, 1, 0, 5, 0, 3, 4, 1, 2, 5, 1, 0, 3, 4, 2, 5, 3, 4, 1, 0, 2, 5, 4, 1, 0, 3, 2}, {0, 1, 2, 4, 3, 5, 0, 2, 4, 3, 1, 5, 0, 3, 1, 2, 4, 5, 0, 4, 3, 1, 2, 5, 1, 0, 3, 5, 2, 4, 1, 2, 0, 3, 5, 4, 1, 3, 5, 2, 0, 4, 1, 5, 2, 0, 3, 4, 2, 0, 1, 5, 4, 3, 2, 1, 5, 4, 0, 3, 2, 4, 0, 1, 5, 3, 2, 5, 4, 0, 1, 3, 3, 0, 4, 5, 1, 2, 3, 1, 0, 4, 5, 2, 3, 4, 5, 1, 0, 2, 3, 5, 1, 0, 4, 2, 4, 0, 2, 5, 3, 1, 4, 2, 5, 3, 0, 1, 4, 3, 0, 2, 5, 1, 4, 5, 3, 0, 2, 1, 5, 1, 3, 4, 2, 0, 5, 2, 1, 3, 4, 0, 5, 3, 4, 2, 1, 0, 5, 4, 2, 1, 3, 0}, {0, 1, 2, 5, 3, 4, 0, 2, 5, 3, 1, 4, 0, 3, 1, 2, 5, 4, 0, 5, 3, 1, 2, 4, 1, 0, 3, 4, 2, 5, 1, 2, 0, 3, 4, 5, 1, 3, 4, 2, 0, 5, 1, 4, 2, 0, 3, 5, 2, 0, 1, 4, 5, 3, 2, 1, 4, 5, 0, 3, 2, 4, 5, 0, 1, 3, 2, 5, 0, 1, 4, 3, 3, 0, 5, 4, 1, 2, 3, 1, 0, 5, 4, 2, 3, 4, 1, 0, 5, 2, 3, 5, 4, 1, 0, 2, 4, 1, 3, 5, 2, 0, 4, 2, 1, 3, 5, 0, 4, 3, 5, 2, 1, 0, 4, 5, 2, 1, 3, 0, 5, 0, 2, 4, 3, 1, 5, 2, 4, 3, 0, 1, 5, 3, 0, 2, 4, 1, 5, 4, 3, 0, 2, 1}, {0, 1, 2, 4, 5, 3, 0, 2, 4, 5, 1, 3, 0, 4, 5, 1, 2, 3, 0, 5, 1, 2, 4, 3, 1, 0, 5, 3, 2, 4, 1, 2, 0, 5, 3, 4, 1, 3, 2, 0, 5, 4, 1, 5, 3, 2, 0, 4, 2, 0, 1, 3, 4, 5, 2, 1, 3, 4, 0, 5, 2, 3, 4, 0, 1, 5, 2, 4, 0, 1, 3, 5, 3, 1, 5, 4, 2, 0, 3, 2, 1, 5, 4, 0, 3, 4, 2, 1, 5, 0, 3, 5, 4, 2, 1, 0, 4, 0, 2, 3, 5, 1, 4, 2, 3, 5, 0, 1, 4, 3, 5, 0, 2, 1, 4, 5, 0, 2, 3, 1, 5, 0, 4, 3, 1, 2, 5, 1, 0, 4, 3, 2, 5, 3, 1, 0, 4, 2, 5, 4, 3, 1, 0, 2}, {0, 1, 2, 5, 4, 3, 0, 2, 5, 4, 1, 3, 0, 4, 1, 2, 5, 3, 0, 5, 4, 1, 2, 3, 1, 0, 4, 3, 2, 5, 1, 2, 0, 4, 3, 5, 1, 3, 2, 0, 4, 5, 1, 4, 3, 2, 0, 5, 2, 0, 1, 3, 5, 4, 2, 1, 3, 5, 0, 4, 2, 3, 5, 0, 1, 4, 2, 5, 0, 1, 3, 4, 3, 1, 4, 5, 2, 0, 3, 2, 1, 4, 5, 0, 3, 4, 5, 2, 1, 0, 3, 5, 2, 1, 4, 0, 4, 0, 5, 3, 1, 2, 4, 1, 0, 5, 3, 2, 4, 3, 1, 0, 5, 2, 4, 5, 3, 1, 0, 2, 5, 0, 2, 3, 4, 1, 5, 2, 3, 4, 0, 1, 5, 3, 4, 0, 2, 1, 5, 4, 0, 2, 3, 1}, {0, 1, 3, 2, 4, 5, 0, 2, 4, 1, 3, 5, 0, 3, 2, 4, 1, 5, 0, 4, 1, 3, 2, 5, 1, 0, 4, 5, 3, 2, 1, 3, 0, 4, 5, 2, 1, 4, 5, 3, 0, 2, 1, 5, 3, 0, 4, 2, 2, 0, 3, 5, 4, 1, 2, 3, 5, 4, 0, 1, 2, 4, 0, 3, 5, 1, 2, 5, 4, 0, 3, 1, 3, 0, 1, 5, 2, 4, 3, 1, 5, 2, 0, 4, 3, 2, 0, 1, 5, 4, 3, 5, 2, 0, 1, 4, 4, 0, 2, 5, 1, 3, 4, 1, 0, 2, 5, 3, 4, 2, 5, 1, 0, 3, 4, 5, 1, 0, 2, 3, 5, 1, 4, 2, 3, 0, 5, 2, 3, 1, 4, 0, 5, 3, 1, 4, 2, 0, 5, 4, 2, 3, 1, 0}, {0, 1, 3, 2, 5, 4, 0, 2, 5, 1, 3, 4, 0, 3, 2, 5, 1, 4, 0, 5, 1, 3, 2, 4, 1, 0, 5, 4, 3, 2, 1, 3, 0, 5, 4, 2, 1, 4, 3, 0, 5, 2, 1, 5, 4, 3, 0, 2, 2, 0, 3, 4, 5, 1, 2, 3, 4, 5, 0, 1, 2, 4, 5, 0, 3, 1, 2, 5, 0, 3, 4, 1, 3, 0, 1, 4, 2, 5, 3, 1, 4, 2, 0, 5, 3, 2, 0, 1, 4, 5, 3, 4, 2, 0, 1, 5, 4, 1, 5, 2, 3, 0, 4, 2, 3, 1, 5, 0, 4, 3, 1, 5, 2, 0, 4, 5, 2, 3, 1, 0, 5, 0, 2, 4, 1, 3, 5, 1, 0, 2, 4, 3, 5, 2, 4, 1, 0, 3, 5, 4, 1, 0, 2, 3}, {0, 1, 4, 2, 3, 5, 0, 2, 3, 1, 4, 5, 0, 3, 1, 4, 2, 5, 0, 4, 2, 3, 1, 5, 1, 0, 3, 5, 4, 2, 1, 3, 5, 4, 0, 2, 1, 4, 0, 3, 5, 2, 1, 5, 4, 0, 3, 2, 2, 0, 4, 5, 3, 1, 2, 3, 0, 4, 5, 1, 2, 4, 5, 3, 0, 1, 2, 5, 3, 0, 4, 1, 3, 0, 2, 5, 1, 4, 3, 1, 0, 2, 5, 4, 3, 2, 5, 1, 0, 4, 3, 5, 1, 0, 2, 4, 4, 0, 1, 5, 2, 3, 4, 1, 5, 2, 0, 3, 4, 2, 0, 1, 5, 3, 4, 5, 2, 0, 1, 3, 5, 1, 3, 2, 4, 0, 5, 2, 4, 1, 3, 0, 5, 3, 2, 4, 1, 0, 5, 4, 1, 3, 2, 0}, {0, 1, 5, 2, 3, 4, 0, 2, 3, 1, 5, 4, 0, 3, 1, 5, 2, 4, 0, 5, 2, 3, 1, 4, 1, 0, 3, 4, 5, 2, 1, 3, 4, 5, 0, 2, 1, 4, 5, 0, 3, 2, 1, 5, 0, 3, 4, 2, 2, 0, 5, 4, 3, 1, 2, 3, 0, 5, 4, 1, 2, 4, 3, 0, 5, 1, 2, 5, 4, 3, 0, 1, 3, 0, 2, 4, 1, 5, 3, 1, 0, 2, 4, 5, 3, 2, 4, 1, 0, 5, 3, 4, 1, 0, 2, 5, 4, 1, 3, 2, 5, 0, 4, 2, 5, 1, 3, 0, 4, 3, 2, 5, 1, 0, 4, 5, 1, 3, 2, 0, 5, 0, 1, 4, 2, 3, 5, 1, 4, 2, 0, 3, 5, 2, 0, 1, 4, 3, 5, 4, 2, 0, 1, 3}, {0, 1, 4, 2, 5, 3, 0, 2, 5, 1, 4, 3, 0, 4, 2, 5, 1, 3, 0, 5, 1, 4, 2, 3, 1, 0, 5, 3, 4, 2, 1, 3, 4, 0, 5, 2, 1, 4, 0, 5, 3, 2, 1, 5, 3, 4, 0, 2, 2, 0, 4, 3, 5, 1, 2, 3, 5, 0, 4, 1, 2, 4, 3, 5, 0, 1, 2, 5, 0, 4, 3, 1, 3, 1, 5, 2, 4, 0, 3, 2, 4, 1, 5, 0, 3, 4, 1, 5, 2, 0, 3, 5, 2, 4, 1, 0, 4, 0, 1, 3, 2, 5, 4, 1, 3, 2, 0, 5, 4, 2, 0, 1, 3, 5, 4, 3, 2, 0, 1, 5, 5, 0, 2, 3, 1, 4, 5, 1, 0, 2, 3, 4, 5, 2, 3, 1, 0, 4, 5, 3, 1, 0, 2, 4}, {0, 1, 5, 2, 4, 3, 0, 2, 4, 1, 5, 3, 0, 4, 1, 5, 2, 3, 0, 5, 2, 4, 1, 3, 1, 0, 4, 3, 5, 2, 1, 3, 5, 0, 4, 2, 1, 4, 3, 5, 0, 2, 1, 5, 0, 4, 3, 2, 2, 0, 5, 3, 4, 1, 2, 3, 4, 0, 5, 1, 2, 4, 0, 5, 3, 1, 2, 5, 3, 4, 0, 1, 3, 1, 4, 2, 5, 0, 3, 2, 5, 1, 4, 0, 3, 4, 2, 5, 1, 0, 3, 5, 1, 4, 2, 0, 4, 0, 2, 3, 1, 5, 4, 1, 0, 2, 3, 5, 4, 2, 3, 1, 0, 5, 4, 3, 1, 0, 2, 5, 5, 0, 1, 3, 2, 4, 5, 1, 3, 2, 0, 4, 5, 2, 0, 1, 3, 4, 5, 3, 2, 0, 1, 4}, {0, 1, 3, 4, 2, 5, 0, 2, 1, 3, 4, 5, 0, 3, 4, 2, 1, 5, 0, 4, 2, 1, 3, 5, 1, 0, 2, 5, 3, 4, 1, 2, 5, 3, 0, 4, 1, 3, 0, 2, 5, 4, 1, 5, 3, 0, 2, 4, 2, 0, 4, 5, 1, 3, 2, 1, 0, 4, 5, 3, 2, 4, 5, 1, 0, 3, 2, 5, 1, 0, 4, 3, 3, 0, 1, 5, 4, 2, 3, 1, 5, 4, 0, 2, 3, 4, 0, 1, 5, 2, 3, 5, 4, 0, 1, 2, 4, 0, 3, 5, 2, 1, 4, 2, 0, 3, 5, 1, 4, 3, 5, 2, 0, 1, 4, 5, 2, 0, 3, 1, 5, 1, 2, 4, 3, 0, 5, 2, 4, 3, 1, 0, 5, 3, 1, 2, 4, 0, 5, 4, 3, 1, 2, 0}, {0, 1, 3, 5, 2, 4, 0, 2, 1, 3, 5, 4, 0, 3, 5, 2, 1, 4, 0, 5, 2, 1, 3, 4, 1, 0, 2, 4, 3, 5, 1, 2, 4, 3, 0, 5, 1, 3, 0, 2, 4, 5, 1, 4, 3, 0, 2, 5, 2, 0, 5, 4, 1, 3, 2, 1, 0, 5, 4, 3, 2, 4, 1, 0, 5, 3, 2, 5, 4, 1, 0, 3, 3, 0, 1, 4, 5, 2, 3, 1, 4, 5, 0, 2, 3, 4, 5, 0, 1, 2, 3, 5, 0, 1, 4, 2, 4, 1, 2, 5, 3, 0, 4, 2, 5, 3, 1, 0, 4, 3, 1, 2, 5, 0, 4, 5, 3, 1, 2, 0, 5, 0, 3, 4, 2, 1, 5, 2, 0, 3, 4, 1, 5, 3, 4, 2, 0, 1, 5, 4, 2, 0, 3, 1}, {0, 1, 5, 3, 2, 4, 0, 2, 1, 5, 3, 4, 0, 3, 2, 1, 5, 4, 0, 5, 3, 2, 1, 4, 1, 0, 2, 4, 5, 3, 1, 2, 4, 5, 0, 3, 1, 4, 5, 0, 2, 3, 1, 5, 0, 2, 4, 3, 2, 0, 3, 4, 1, 5, 2, 1, 0, 3, 4, 5, 2, 3, 4, 1, 0, 5, 2, 4, 1, 0, 3, 5, 3, 0, 5, 4, 2, 1, 3, 2, 0, 5, 4, 1, 3, 4, 2, 0, 5, 1, 3, 5, 4, 2, 0, 1, 4, 1, 2, 3, 5, 0, 4, 2, 3, 5, 1, 0, 4, 3, 5, 1, 2, 0, 4, 5, 1, 2, 3, 0, 5, 0, 1, 4, 3, 2, 5, 1, 4, 3, 0, 2, 5, 3, 0, 1, 4, 2, 5, 4, 3, 0, 1, 2}, {0, 1, 4, 5, 2, 3, 0, 2, 1, 4, 5, 3, 0, 4, 5, 2, 1, 3, 0, 5, 2, 1, 4, 3, 1, 0, 2, 3, 4, 5, 1, 2, 3, 4, 0, 5, 1, 3, 4, 0, 2, 5, 1, 4, 0, 2, 3, 5, 2, 0, 5, 3, 1, 4, 2, 1, 0, 5, 3, 4, 2, 3, 1, 0, 5, 4, 2, 5, 3, 1, 0, 4, 3, 1, 2, 5, 4, 0, 3, 2, 5, 4, 1, 0, 3, 4, 1, 2, 5, 0, 3, 5, 4, 1, 2, 0, 4, 0, 1, 3, 5, 2, 4, 1, 3, 5, 0, 2, 4, 3, 5, 0, 1, 2, 4, 5, 0, 1, 3, 2, 5, 0, 4, 3, 2, 1, 5, 2, 0, 4, 3, 1, 5, 3, 2, 0, 4, 1, 5, 4, 3, 2, 0, 1}, {0, 1, 5, 4, 2, 3, 0, 2, 1, 5, 4, 3, 0, 4, 2, 1, 5, 3, 0, 5, 4, 2, 1, 3, 1, 0, 2, 3, 5, 4, 1, 2, 3, 5, 0, 4, 1, 3, 5, 0, 2, 4, 1, 5, 0, 2, 3, 4, 2, 0, 4, 3, 1, 5, 2, 1, 0, 4, 3, 5, 2, 3, 1, 0, 4, 5, 2, 4, 3, 1, 0, 5, 3, 1, 2, 4, 5, 0, 3, 2, 4, 5, 1, 0, 3, 4, 5, 1, 2, 0, 3, 5, 1, 2, 4, 0, 4, 0, 5, 3, 2, 1, 4, 2, 0, 5, 3, 1, 4, 3, 2, 0, 5, 1, 4, 5, 3, 2, 0, 1, 5, 0, 1, 3, 4, 2, 5, 1, 3, 4, 0, 2, 5, 3, 4, 0, 1, 2, 5, 4, 0, 1, 3, 2}, {0, 1, 3, 4, 5, 2, 0, 3, 4, 5, 1, 2, 0, 4, 5, 1, 3, 2, 0, 5, 1, 3, 4, 2, 1, 0, 5, 2, 3, 4, 1, 2, 3, 0, 5, 4, 1, 3, 0, 5, 2, 4, 1, 5, 2, 3, 0, 4, 2, 1, 5, 4, 3, 0, 2, 3, 1, 5, 4, 0, 2, 4, 3, 1, 5, 0, 2, 5, 4, 3, 1, 0, 3, 0, 1, 2, 4, 5, 3, 1, 2, 4, 0, 5, 3, 2, 4, 0, 1, 5, 3, 4, 0, 1, 2, 5, 4, 0, 3, 2, 5, 1, 4, 2, 5, 0, 3, 1, 4, 3, 2, 5, 0, 1, 4, 5, 0, 3, 2, 1, 5, 0, 4, 2, 1, 3, 5, 1, 0, 4, 2, 3, 5, 2, 1, 0, 4, 3, 5, 4, 2, 1, 0, 3}, {0, 1, 3, 5, 4, 2, 0, 3, 5, 4, 1, 2, 0, 4, 1, 3, 5, 2, 0, 5, 4, 1, 3, 2, 1, 0, 4, 2, 3, 5, 1, 2, 3, 0, 4, 5, 1, 3, 0, 4, 2, 5, 1, 4, 2, 3, 0, 5, 2, 1, 4, 5, 3, 0, 2, 3, 1, 4, 5, 0, 2, 4, 5, 3, 1, 0, 2, 5, 3, 1, 4, 0, 3, 0, 1, 2, 5, 4, 3, 1, 2, 5, 0, 4, 3, 2, 5, 0, 1, 4, 3, 5, 0, 1, 2, 4, 4, 0, 5, 2, 1, 3, 4, 1, 0, 5, 2, 3, 4, 2, 1, 0, 5, 3, 4, 5, 2, 1, 0, 3, 5, 0, 3, 2, 4, 1, 5, 2, 4, 0, 3, 1, 5, 3, 2, 4, 0, 1, 5, 4, 0, 3, 2, 1}, {0, 1, 4, 3, 5, 2, 0, 3, 5, 1, 4, 2, 0, 4, 3, 5, 1, 2, 0, 5, 1, 4, 3, 2, 1, 0, 5, 2, 4, 3, 1, 2, 4, 0, 5, 3, 1, 4, 0, 5, 2, 3, 1, 5, 2, 4, 0, 3, 2, 1, 5, 3, 4, 0, 2, 3, 4, 1, 5, 0, 2, 4, 1, 5, 3, 0, 2, 5, 3, 4, 1, 0, 3, 0, 4, 2, 5, 1, 3, 2, 5, 0, 4, 1, 3, 4, 2, 5, 0, 1, 3, 5, 0, 4, 2, 1, 4, 0, 1, 2, 3, 5, 4, 1, 2, 3, 0, 5, 4, 2, 3, 0, 1, 5, 4, 3, 0, 1, 2, 5, 5, 0, 3, 2, 1, 4, 5, 1, 0, 3, 2, 4, 5, 2, 1, 0, 3, 4, 5, 3, 2, 1, 0, 4}, {0, 1, 5, 3, 4, 2, 0, 3, 4, 1, 5, 2, 0, 4, 1, 5, 3, 2, 0, 5, 3, 4, 1, 2, 1, 0, 4, 2, 5, 3, 1, 2, 5, 0, 4, 3, 1, 4, 2, 5, 0, 3, 1, 5, 0, 4, 2, 3, 2, 1, 4, 3, 5, 0, 2, 3, 5, 1, 4, 0, 2, 4, 3, 5, 1, 0, 2, 5, 1, 4, 3, 0, 3, 0, 5, 2, 4, 1, 3, 2, 4, 0, 5, 1, 3, 4, 0, 5, 2, 1, 3, 5, 2, 4, 0, 1, 4, 0, 3, 2, 1, 5, 4, 1, 0, 3, 2, 5, 4, 2, 1, 0, 3, 5, 4, 3, 2, 1, 0, 5, 5, 0, 1, 2, 3, 4, 5, 1, 2, 3, 0, 4, 5, 2, 3, 0, 1, 4, 5, 3, 0, 1, 2, 4}, {0, 1, 4, 5, 3, 2, 0, 3, 1, 4, 5, 2, 0, 4, 5, 3, 1, 2, 0, 5, 3, 1, 4, 2, 1, 0, 3, 2, 4, 5, 1, 2, 4, 0, 3, 5, 1, 3, 2, 4, 0, 5, 1, 4, 0, 3, 2, 5, 2, 1, 3, 5, 4, 0, 2, 3, 5, 4, 1, 0, 2, 4, 1, 3, 5, 0, 2, 5, 4, 1, 3, 0, 3, 0, 5, 2, 1, 4, 3, 1, 0, 5, 2, 4, 3, 2, 1, 0, 5, 4, 3, 5, 2, 1, 0, 4, 4, 0, 1, 2, 5, 3, 4, 1, 2, 5, 0, 3, 4, 2, 5, 0, 1, 3, 4, 5, 0, 1, 2, 3, 5, 0, 4, 2, 3, 1, 5, 2, 3, 0, 4, 1, 5, 3, 0, 4, 2, 1, 5, 4, 2, 3, 0, 1}, {0, 1, 5, 4, 3, 2, 0, 3, 1, 5, 4, 2, 0, 4, 3, 1, 5, 2, 0, 5, 4, 3, 1, 2, 1, 0, 3, 2, 5, 4, 1, 2, 5, 0, 3, 4, 1, 3, 2, 5, 0, 4, 1, 5, 0, 3, 2, 4, 2, 1, 3, 4, 5, 0, 2, 3, 4, 5, 1, 0, 2, 4, 5, 1, 3, 0, 2, 5, 1, 3, 4, 0, 3, 0, 4, 2, 1, 5, 3, 1, 0, 4, 2, 5, 3, 2, 1, 0, 4, 5, 3, 4, 2, 1, 0, 5, 4, 0, 5, 2, 3, 1, 4, 2, 3, 0, 5, 1, 4, 3, 0, 5, 2, 1, 4, 5, 2, 3, 0, 1, 5, 0, 1, 2, 4, 3, 5, 1, 2, 4, 0, 3, 5, 2, 4, 0, 1, 3, 5, 4, 0, 1, 2, 3}, {0, 2, 3, 4, 5, 1, 0, 3, 4, 5, 2, 1, 0, 4, 5, 2, 3, 1, 0, 5, 2, 3, 4, 1, 1, 2, 5, 4, 3, 0, 1, 3, 2, 5, 4, 0, 1, 4, 3, 2, 5, 0, 1, 5, 4, 3, 2, 0, 2, 0, 5, 1, 3, 4, 2, 1, 3, 0, 5, 4, 2, 3, 0, 5, 1, 4, 2, 5, 1, 3, 0, 4, 3, 0, 2, 1, 4, 5, 3, 1, 4, 0, 2, 5, 3, 2, 1, 4, 0, 5, 3, 4, 0, 2, 1, 5, 4, 0, 3, 1, 5, 2, 4, 1, 5, 0, 3, 2, 4, 3, 1, 5, 0, 2, 4, 5, 0, 3, 1, 2, 5, 0, 4, 1, 2, 3, 5, 1, 2, 0, 4, 3, 5, 2, 0, 4, 1, 3, 5, 4, 1, 2, 0, 3}, {0, 2, 3, 5, 4, 1, 0, 3, 5, 4, 2, 1, 0, 4, 2, 3, 5, 1, 0, 5, 4, 2, 3, 1, 1, 2, 4, 5, 3, 0, 1, 3, 2, 4, 5, 0, 1, 4, 5, 3, 2, 0, 1, 5, 3, 2, 4, 0, 2, 0, 4, 1, 3, 5, 2, 1, 3, 0, 4, 5, 2, 3, 0, 4, 1, 5, 2, 4, 1, 3, 0, 5, 3, 0, 2, 1, 5, 4, 3, 1, 5, 0, 2, 4, 3, 2, 1, 5, 0, 4, 3, 5, 0, 2, 1, 4, 4, 0, 5, 1, 2, 3, 4, 1, 2, 0, 5, 3, 4, 2, 0, 5, 1, 3, 4, 5, 1, 2, 0, 3, 5, 0, 3, 1, 4, 2, 5, 1, 4, 0, 3, 2, 5, 3, 1, 4, 0, 2, 5, 4, 0, 3, 1, 2}, {0, 2, 4, 3, 5, 1, 0, 3, 5, 2, 4, 1, 0, 4, 3, 5, 2, 1, 0, 5, 2, 4, 3, 1, 1, 2, 5, 3, 4, 0, 1, 3, 4, 2, 5, 0, 1, 4, 2, 5, 3, 0, 1, 5, 3, 4, 2, 0, 2, 0, 5, 1, 4, 3, 2, 1, 4, 0, 5, 3, 2, 4, 0, 5, 1, 3, 2, 5, 1, 4, 0, 3, 3, 0, 4, 1, 5, 2, 3, 1, 5, 0, 4, 2, 3, 4, 1, 5, 0, 2, 3, 5, 0, 4, 1, 2, 4, 0, 2, 1, 3, 5, 4, 1, 3, 0, 2, 5, 4, 2, 1, 3, 0, 5, 4, 3, 0, 2, 1, 5, 5, 0, 3, 1, 2, 4, 5, 1, 2, 0, 3, 4, 5, 2, 0, 3, 1, 4, 5, 3, 1, 2, 0, 4}, {0, 2, 5, 3, 4, 1, 0, 3, 4, 2, 5, 1, 0, 4, 2, 5, 3, 1, 0, 5, 3, 4, 2, 1, 1, 2, 4, 3, 5, 0, 1, 3, 5, 2, 4, 0, 1, 4, 3, 5, 2, 0, 1, 5, 2, 4, 3, 0, 2, 0, 4, 1, 5, 3, 2, 1, 5, 0, 4, 3, 2, 4, 1, 5, 0, 3, 2, 5, 0, 4, 1, 3, 3, 0, 5, 1, 4, 2, 3, 1, 4, 0, 5, 2, 3, 4, 0, 5, 1, 2, 3, 5, 1, 4, 0, 2, 4, 0, 3, 1, 2, 5, 4, 1, 2, 0, 3, 5, 4, 2, 0, 3, 1, 5, 4, 3, 1, 2, 0, 5, 5, 0, 2, 1, 3, 4, 5, 1, 3, 0, 2, 4, 5, 2, 1, 3, 0, 4, 5, 3, 0, 2, 1, 4}, {0, 2, 4, 5, 3, 1, 0, 3, 2, 4, 5, 1, 0, 4, 5, 3, 2, 1, 0, 5, 3, 2, 4, 1, 1, 2, 3, 5, 4, 0, 1, 3, 5, 4, 2, 0, 1, 4, 2, 3, 5, 0, 1, 5, 4, 2, 3, 0, 2, 0, 3, 1, 4, 5, 2, 1, 4, 0, 3, 5, 2, 3, 1, 4, 0, 5, 2, 4, 0, 3, 1, 5, 3, 0, 5, 1, 2, 4, 3, 1, 2, 0, 5, 4, 3, 2, 0, 5, 1, 4, 3, 5, 1, 2, 0, 4, 4, 0, 2, 1, 5, 3, 4, 1, 5, 0, 2, 3, 4, 2, 1, 5, 0, 3, 4, 5, 0, 2, 1, 3, 5, 0, 4, 1, 3, 2, 5, 1, 3, 0, 4, 2, 5, 3, 0, 4, 1, 2, 5, 4, 1, 3, 0, 2}, {0, 2, 5, 4, 3, 1, 0, 3, 2, 5, 4, 1, 0, 4, 3, 2, 5, 1, 0, 5, 4, 3, 2, 1, 1, 2, 3, 4, 5, 0, 1, 3, 4, 5, 2, 0, 1, 4, 5, 2, 3, 0, 1, 5, 2, 3, 4, 0, 2, 0, 3, 1, 5, 4, 2, 1, 5, 0, 3, 4, 2, 3, 1, 5, 0, 4, 2, 5, 0, 3, 1, 4, 3, 0, 4, 1, 2, 5, 3, 1, 2, 0, 4, 5, 3, 2, 0, 4, 1, 5, 3, 4, 1, 2, 0, 5, 4, 0, 5, 1, 3, 2, 4, 1, 3, 0, 5, 2, 4, 3, 0, 5, 1, 2, 4, 5, 1, 3, 0, 2, 5, 0, 2, 1, 4, 3, 5, 1, 4, 0, 2, 3, 5, 2, 1, 4, 0, 3, 5, 4, 0, 2, 1, 3}};

    public Octahedral(IAtom focus, IAtom[] carriers, int order) {
        super((IChemObject)focus, (IChemObject[])carriers, 0x6100 | order & 0xFF);
        if (this.getConfigOrder() < 0 || this.getConfigOrder() > 30) {
            throw new IllegalArgumentException("Invalid configuration order!Should be in range 1-30");
        }
    }

    private Octahedral normalizeImplicit() {
        if (this.getConfigOrder() != 1) {
            throw new IllegalArgumentException();
        }
        IAtom focus = (IAtom)this.getFocus();
        List carriers = this.getCarriers();
        if (((IAtom)carriers.get(0)).equals(focus)) {
            for (int i = 0; i < PERMUTATIONS[0].length; i += 6) {
                if (((IAtom)carriers.get(PERMUTATIONS[0][i])).equals(focus)) continue;
                return new Octahedral(focus, new IAtom[]{(IAtom)carriers.get(PERMUTATIONS[0][i]), (IAtom)carriers.get(PERMUTATIONS[0][i + 1]), (IAtom)carriers.get(PERMUTATIONS[0][i + 2]), (IAtom)carriers.get(PERMUTATIONS[0][i + 3]), (IAtom)carriers.get(PERMUTATIONS[0][i + 4]), (IAtom)carriers.get(PERMUTATIONS[0][i + 5])}, this.getConfigOrder());
            }
            return this;
        }
        return this;
    }

    public Octahedral normalize() {
        int cfg = this.getConfigOrder();
        if (cfg == 1) {
            return this;
        }
        if (cfg < 1 || cfg > 30) {
            throw new IllegalArgumentException("Invalid config order: " + cfg + ", octahedral should be1 <= order <= 30!");
        }
        IAtom[] carriers = Octahedral.invapply(this.getCarriers().toArray(new IAtom[6]), PERMUTATIONS[cfg - 1]);
        return new Octahedral((IAtom)this.getFocus(), carriers, 1);
    }

    protected Octahedral create(IAtom focus, List<IAtom> carriers, int cfg) {
        return new Octahedral(focus, carriers.toArray(new IAtom[6]), cfg);
    }

    private static boolean same(List<IAtom> a, List<IAtom> b, int[] perm, int i) {
        for (int j = i; j < i + 6; ++j) {
            if (b.get(j - i).equals(a.get(perm[j]))) continue;
            return false;
        }
        return true;
    }

    public static int reorder(List<IAtom> current, List<IAtom> required) {
        for (int order = 0; order < PERMUTATIONS.length; ++order) {
            int[] local = PERMUTATIONS[order];
            for (int k = 0; k < local.length; k += 6) {
                if (!Octahedral.same(current, required, local, k)) continue;
                return order + 1;
            }
        }
        return -1;
    }

    public boolean canBeTrigonalBipyramidal() {
        int numExplicit = 0;
        IAtom focus = (IAtom)this.getFocus();
        for (IAtom atom : this.getCarriers()) {
            if (atom.equals(focus)) continue;
            ++numExplicit;
        }
        if (numExplicit > 3) {
            return false;
        }
        Octahedral normalized = this.normalize();
        List carriers = normalized.getCarriers();
        int numEquatorial = 0;
        for (int i = 1; i < 5; ++i) {
            if (((IAtom)carriers.get(i)).equals(focus)) continue;
            ++numEquatorial;
        }
        return numEquatorial <= 1;
    }

    public TrigonalBipyramidal asTrigonalBipyramidal() {
        Octahedral normalized = this.normalize().normalizeImplicit();
        if (!normalized.canBeTrigonalBipyramidal()) {
            return null;
        }
        IAtom focus = (IAtom)normalized.getFocus();
        ArrayList carriers = new ArrayList(normalized.getCarriers());
        if (((IAtom)carriers.get(1)).equals(focus)) {
            carriers.remove(1);
        } else if (((IAtom)carriers.get(2)).equals(focus)) {
            carriers.remove(2);
        }
        return new TrigonalBipyramidal((IAtom)this.getFocus(), carriers.toArray(new IAtom[5]), 1);
    }
}

