/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

final class BiconnectedComponents {
    private int remaining;
    private int numBackEdges;
    private final int[] visit;

    private BiconnectedComponents(IAtomContainer mol) {
        this.visit = new int[mol.getAtomCount()];
        this.remaining = mol.getAtomCount();
    }

    private int visit(IAtom atom, IBond prev, int depth) {
        this.visit[atom.getIndex()] = depth;
        --this.remaining;
        int lo = depth + 1;
        for (IBond bond : atom.bonds()) {
            if (bond == prev) continue;
            IAtom nbr = bond.getOther(atom);
            int visit = this.visit[nbr.getIndex()];
            if (visit == 0) {
                int res = this.visit(nbr, bond, depth + 1);
                bond.setIsInRing(res <= depth);
                lo = Math.min(res, lo);
                continue;
            }
            if (visit >= depth) continue;
            ++this.numBackEdges;
            bond.setIsInRing(true);
            lo = Math.min(visit, lo);
        }
        atom.setIsInRing(lo <= depth);
        return lo;
    }

    static int mark(IAtomContainer mol) {
        BiconnectedComponents state = new BiconnectedComponents(mol);
        for (IAtom atom : mol.atoms()) {
            if (state.visit[atom.getIndex()] == 0) {
                state.visit(atom, null, 1);
            }
            if (state.remaining != 0) continue;
            break;
        }
        return state.numBackEdges;
    }
}

