/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.util.Collections;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;

final class ImmutableAtomType
implements IAtomType {
    private final String element;
    private final Integer atomicNumber;
    private final Double naturalAbundance;
    private final Double exactMass;
    private final Integer massNumber;
    private final Integer formalCharge;
    private final IAtomType.Hybridization hybridization;
    private final Integer electronValency;
    private final Integer formalNeighbourCount;
    private final String identifier;
    private final IBond.Order maxBondOrder;
    private final Double bondOrderSum;
    private final Double covalentRadius;
    private final int flags;
    private final Map<Object, Object> properties;

    ImmutableAtomType(IAtomType type) {
        Integer piBondCount;
        this.element = type.getSymbol();
        this.atomicNumber = type.getAtomicNumber();
        this.naturalAbundance = type.getNaturalAbundance();
        this.exactMass = type.getExactMass();
        this.massNumber = type.getMassNumber();
        this.formalCharge = type.getFormalCharge();
        this.hybridization = type.getHybridization();
        this.formalNeighbourCount = type.getFormalNeighbourCount();
        this.identifier = type.getAtomTypeName();
        this.maxBondOrder = type.getMaxBondOrder();
        this.bondOrderSum = type.getBondOrderSum();
        this.covalentRadius = type.getCovalentRadius();
        this.flags = type.flags();
        this.properties = Collections.unmodifiableMap(type.getProperties());
        this.electronValency = type.getValency() != null ? type.getValency() : ((piBondCount = (Integer)type.getProperty((Object)"cdk:Pi Bond Count", Integer.class)) != null && this.formalNeighbourCount != null ? Integer.valueOf(piBondCount + this.formalNeighbourCount) : null);
    }

    public void addListener(IChemObjectListener col) {
    }

    public int getListenerCount() {
        return 0;
    }

    public void removeListener(IChemObjectListener col) {
    }

    public void setNotification(boolean bool) {
    }

    public boolean getNotification() {
        return false;
    }

    public void notifyChanged() {
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
    }

    public Number getFlagValue() {
        return this.flags;
    }

    public void setProperty(Object description, Object property) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void removeProperty(Object description) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public <T> T getProperty(Object description) {
        if (!this.properties.containsKey(description)) {
            return null;
        }
        Object value = this.properties.get(description);
        return (T)value;
    }

    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.properties.get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public String getID() {
        return null;
    }

    public void setID(String identifier) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void setFlag(int flagType, boolean flagValue) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public boolean getFlag(int flagType) {
        return (this.flags & flagType) != 0;
    }

    public void setProperties(Map<Object, Object> properties) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void addProperties(Map<Object, Object> properties) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void setFlags(boolean[] flagsNew) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public boolean[] getFlags() {
        boolean[] flagArray = new boolean[14];
        for (int i = 0; i < CDKConstants.FLAG_MASKS.length; ++i) {
            int mask = CDKConstants.FLAG_MASKS[i];
            flagArray[i] = this.getFlag(mask);
        }
        return flagArray;
    }

    public void set(int flags) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void clear(int flags) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public boolean is(int flags) {
        return (this.flags & flags) == flags;
    }

    public int flags() {
        return this.flags;
    }

    public IChemObjectBuilder getBuilder() {
        return null;
    }

    public void setAtomicNumber(Integer atomicNumber) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void setSymbol(String symbol) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void setExactMass(Double exactMass) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void setNaturalAbundance(Double naturalAbundance) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void setMassNumber(Integer massNumber) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public String getSymbol() {
        return this.element;
    }

    public Integer getAtomicNumber() {
        return this.atomicNumber;
    }

    public Double getNaturalAbundance() {
        return this.naturalAbundance;
    }

    public Double getExactMass() {
        return this.exactMass;
    }

    public Integer getMassNumber() {
        return this.massNumber;
    }

    public Object clone() {
        return this;
    }

    public void setAtomTypeName(String identifier) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public void setBondOrderSum(Double bondOrderSum) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public String getAtomTypeName() {
        return this.identifier;
    }

    public IBond.Order getMaxBondOrder() {
        return this.maxBondOrder;
    }

    public Double getBondOrderSum() {
        return this.bondOrderSum;
    }

    public void setFormalCharge(Integer charge) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public Integer getFormalCharge() {
        return this.formalCharge;
    }

    public void setFormalNeighbourCount(Integer count) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public Integer getFormalNeighbourCount() {
        return this.formalNeighbourCount;
    }

    public void setHybridization(IAtomType.Hybridization hybridization) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public IAtomType.Hybridization getHybridization() {
        return this.hybridization;
    }

    public void setCovalentRadius(Double radius) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public Double getCovalentRadius() {
        return this.covalentRadius;
    }

    public void setValency(Integer valency) {
        throw new UnsupportedOperationException("Immutable atom type cannot be modified");
    }

    public Integer getValency() {
        return this.electronValency;
    }

    public String toString() {
        StringBuilder resultString = new StringBuilder(64);
        resultString.append("ImmutableAtomType(").append(this.hashCode());
        if (this.getAtomTypeName() != null) {
            resultString.append(", N:").append(this.getAtomTypeName());
        }
        if (this.getMaxBondOrder() != null) {
            resultString.append(", MBO:").append(this.getMaxBondOrder());
        }
        if (this.getBondOrderSum() != null) {
            resultString.append(", BOS:").append(this.getBondOrderSum());
        }
        if (this.getFormalCharge() != null) {
            resultString.append(", FC:").append(this.getFormalCharge());
        }
        if (this.getHybridization() != null) {
            resultString.append(", H:").append(this.getHybridization());
        }
        if (this.getFormalNeighbourCount() != null) {
            resultString.append(", NC:").append(this.getFormalNeighbourCount());
        }
        if (this.getCovalentRadius() != null) {
            resultString.append(", CR:").append(this.getCovalentRadius());
        }
        if (this.getValency() != null) {
            resultString.append(", EV:").append(this.getValency());
        }
        resultString.append(", ").append(super.toString());
        resultString.append(')');
        return resultString.toString();
    }
}

