/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.IndexedGeometryArrayRetained;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.MorphRetained;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.TextureAttributesRetained;
import org.jogamp.java3d.VirtualUniverse;

class RenderingAttributesStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList<J3dMessage> objList = new ArrayList();

    RenderingAttributesStructure() {
        super(null, 1024);
    }

    @Override
    void processMessages(long referenceTime) {
        boolean addMirrorObj = false;
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg <= 0) {
            return;
        }
        block9: for (int i = 0; i < nMsg; ++i) {
            J3dMessage m = messages[i];
            switch (m.type) {
                case 18: 
                case 47: 
                case 65: {
                    int component = (Integer)m.args[1];
                    NodeComponentRetained nc = (NodeComponentRetained)m.args[0];
                    nc.mirror.changedFrequent = (Integer)m.args[3];
                    this.updateNodeComponent(m.args);
                    if (nc.mirror.changedFrequent != 0) {
                        this.objList.add(m);
                        addMirrorObj = true;
                        nc.mirror.compChanged |= component;
                        continue block9;
                    }
                    m.decRefcount();
                    continue block9;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 63: 
                case 64: {
                    NodeComponentRetained nc = (NodeComponentRetained)m.args[0];
                    nc.mirror.changedFrequent = (Integer)m.args[3];
                    if (nc.mirror.changedFrequent != 0) {
                        this.objList.add(m);
                        addMirrorObj = true;
                        nc.mirror.compChanged = 1;
                        continue block9;
                    }
                    this.updateNodeComponent(m.args);
                    m.decRefcount();
                    continue block9;
                }
                case 54: {
                    NodeComponentRetained nc = (NodeComponentRetained)m.args[0];
                    int changes = (Integer)m.args[3];
                    if (nc.mirror != null) {
                        nc.mirror.changedFrequent = changes;
                    }
                    if (changes != 0) {
                        this.objList.add(m);
                        addMirrorObj = true;
                        continue block9;
                    }
                    this.updateNodeComponent(m.args);
                    m.decRefcount();
                    continue block9;
                }
                case 11: {
                    NodeComponentRetained nc = (NodeComponentRetained)m.args[0];
                    nc.mirror.changedFrequent = (Integer)m.args[4];
                    if (nc.mirror.changedFrequent != 0) {
                        this.objList.add(m);
                        addMirrorObj = true;
                        nc.mirror.compChanged = 1;
                        continue block9;
                    }
                    this.updateTextureAttributes(m.args);
                    m.decRefcount();
                    continue block9;
                }
                case 15: {
                    NodeComponentRetained nc = (NodeComponentRetained)m.args[0];
                    nc.mirror.changedFrequent = (Integer)m.args[3];
                    this.objList.add(m);
                    nc.mirror.compChanged = 1;
                    addMirrorObj = true;
                    continue block9;
                }
                case 17: {
                    int val;
                    GeometryRetained geo = (GeometryRetained)m.args[1];
                    if (geo instanceof IndexedGeometryArrayRetained) {
                        int val2;
                        this.objList.add(m);
                        addMirrorObj = true;
                        if (m.args[2] != null) continue block9;
                        geo.cachedChangedFrequent = val2 = ((Integer)m.args[3]).intValue();
                        continue block9;
                    }
                    geo.cachedChangedFrequent = val = ((Integer)m.args[3]).intValue();
                    m.decRefcount();
                    continue block9;
                }
                case 16: {
                    this.objList.add(m);
                    addMirrorObj = true;
                    continue block9;
                }
                default: {
                    m.decRefcount();
                }
            }
        }
        if (addMirrorObj) {
            VirtualUniverse.mc.addMirrorObject(this);
        }
        Arrays.fill(messages, 0, nMsg, null);
    }

    @Override
    public void updateObject() {
        int size = this.objList.size();
        for (int i = 0; i < size; ++i) {
            NodeComponentRetained nc;
            J3dMessage m = this.objList.get(i);
            if (m.type == 17) {
                GeometryArrayRetained geo = (GeometryArrayRetained)m.args[1];
                if (m.args[2] == null) {
                    geo.updateMirrorGeometry();
                } else {
                    geo.initMirrorGeometry();
                }
            } else if (m.type == 16) {
                MorphRetained morph = (MorphRetained)m.args[0];
                GeometryArrayRetained geo = (GeometryArrayRetained)morph.morphedGeometryArray.retained;
                geo.updateMirrorGeometry();
            } else if (m.type == 11) {
                nc = (NodeComponentRetained)m.args[0];
                nc.mirror.compChanged = 0;
                this.updateTextureAttributes(m.args);
            } else if (m.type == 18 || m.type == 65 || m.type == 47) {
                nc = (NodeComponentRetained)m.args[0];
                nc.mirror.compChanged = 0;
            } else {
                nc = (NodeComponentRetained)m.args[0];
                if (nc.mirror != null) {
                    nc.mirror.compChanged = 0;
                }
                this.updateNodeComponent(m.args);
            }
            m.decRefcount();
        }
        this.objList.clear();
    }

    private void updateNodeComponent(Object[] args) {
        NodeComponentRetained n = (NodeComponentRetained)args[0];
        n.updateMirrorObject((Integer)args[1], args[2]);
    }

    private void updateTextureAttributes(Object[] args) {
        TextureAttributesRetained n = (TextureAttributesRetained)args[0];
        n.updateMirrorObject((Integer)args[1], args[2], args[3]);
    }

    @Override
    void removeNodes(J3dMessage m) {
    }

    @Override
    void cleanup() {
    }
}

