/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.PointAttributesRetained;

public class PointAttributes
extends NodeComponent {
    public static final int ALLOW_SIZE_READ = 0;
    public static final int ALLOW_SIZE_WRITE = 1;
    public static final int ALLOW_ANTIALIASING_READ = 2;
    public static final int ALLOW_ANTIALIASING_WRITE = 3;
    private static final int[] readCapabilities = new int[]{0, 2};

    public PointAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public PointAttributes(float pointSize, boolean pointAntialiasing) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((PointAttributesRetained)this.retained).initPointSize(pointSize);
        ((PointAttributesRetained)this.retained).initPointAntialiasingEnable(pointAntialiasing);
    }

    public void setPointSize(float pointSize) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointAttributes0"));
        }
        if (this.isLive()) {
            ((PointAttributesRetained)this.retained).setPointSize(pointSize);
        } else {
            ((PointAttributesRetained)this.retained).initPointSize(pointSize);
        }
    }

    public float getPointSize() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointAttributes1"));
        }
        return ((PointAttributesRetained)this.retained).getPointSize();
    }

    public void setPointAntialiasingEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointAttributes2"));
        }
        if (this.isLive()) {
            ((PointAttributesRetained)this.retained).setPointAntialiasingEnable(state);
        } else {
            ((PointAttributesRetained)this.retained).initPointAntialiasingEnable(state);
        }
    }

    public boolean getPointAntialiasingEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("PointAttributes3"));
        }
        return ((PointAttributesRetained)this.retained).getPointAntialiasingEnable();
    }

    @Override
    void createRetained() {
        this.retained = new PointAttributesRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        PointAttributes pa = new PointAttributes();
        pa.duplicateNodeComponent(this);
        return pa;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        PointAttributesRetained attr = (PointAttributesRetained)originalNodeComponent.retained;
        PointAttributesRetained rt = (PointAttributesRetained)this.retained;
        rt.initPointSize(attr.getPointSize());
        rt.initPointAntialiasingEnable(attr.getPointAntialiasingEnable());
    }
}

