/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.JoglShaderObject;

class JoglContext
implements Context {
    protected GLContext context;
    private int maxTexCoordSets;
    private float alphaClearValue;
    private int currentTextureUnit;
    private int currentCombinerUnit;
    private boolean hasMultisample;
    private JoglShaderObject shaderProgram;
    private int glslVertexAttrOffset;

    JoglContext(GLContext context) {
        this.context = context;
    }

    GLContext getGLContext() {
        return this.context;
    }

    int getMaxTexCoordSets() {
        return this.maxTexCoordSets;
    }

    void setMaxTexCoordSets(int val) {
        this.maxTexCoordSets = val;
    }

    float getAlphaClearValue() {
        return this.alphaClearValue;
    }

    void setAlphaClearValue(float val) {
        this.alphaClearValue = val;
    }

    int getCurrentTextureUnit() {
        return this.currentTextureUnit;
    }

    void setCurrentTextureUnit(int val) {
        this.currentTextureUnit = val;
    }

    int getCurrentCombinerUnit() {
        return this.currentCombinerUnit;
    }

    void setCurrentCombinerUnit(int val) {
        this.currentCombinerUnit = val;
    }

    boolean getHasMultisample() {
        return this.hasMultisample;
    }

    void setHasMultisample(boolean val) {
        this.hasMultisample = val;
    }

    void vertexAttrPointer(GL gl, int index, int size, int type, int stride, Buffer pointer) {
        gl.getGL2().glVertexAttribPointerARB(index + this.glslVertexAttrOffset, size, type, false, stride, pointer);
    }

    void enableVertexAttrArray(GL gl, int index) {
        gl.getGL2().glEnableVertexAttribArrayARB(index + this.glslVertexAttrOffset);
    }

    void disableVertexAttrArray(GL gl, int index) {
        gl.getGL2().glDisableVertexAttribArrayARB(index + this.glslVertexAttrOffset);
    }

    void vertexAttr1fv(GL gl, int index, FloatBuffer buf) {
        gl.getGL2().glVertexAttrib1fvARB(index + this.glslVertexAttrOffset, buf);
    }

    void vertexAttr2fv(GL gl, int index, FloatBuffer buf) {
        gl.getGL2().glVertexAttrib2fvARB(index + this.glslVertexAttrOffset, buf);
    }

    void vertexAttr3fv(GL gl, int index, FloatBuffer buf) {
        gl.getGL2().glVertexAttrib3fvARB(index + this.glslVertexAttrOffset, buf);
    }

    void vertexAttr4fv(GL gl, int index, FloatBuffer buf) {
        gl.getGL2().glVertexAttrib4fvARB(index + this.glslVertexAttrOffset, buf);
    }

    JoglShaderObject getShaderProgram() {
        return this.shaderProgram;
    }

    void setShaderProgram(JoglShaderObject object) {
        this.shaderProgram = object;
    }

    int getGLSLVertexAttrOffset() {
        return this.glslVertexAttrOffset;
    }

    void setGLSLVertexAttrOffset(int offset) {
        this.glslVertexAttrOffset = offset;
    }
}

