/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Hashtable;
import org.jogamp.java3d.AppearanceRetained;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Jogl2es2Pipeline;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.ShaderAppearance;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TextureRetained;
import org.jogamp.java3d.TextureUnitState;
import org.jogamp.java3d.TextureUnitStateRetained;
import org.jogamp.java3d.TransparencyAttributes;

public class Appearance
extends NodeComponent {
    public static final int ALLOW_COLORING_ATTRIBUTES_READ = 8;
    public static final int ALLOW_COLORING_ATTRIBUTES_WRITE = 9;
    public static final int ALLOW_TRANSPARENCY_ATTRIBUTES_READ = 10;
    public static final int ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE = 11;
    public static final int ALLOW_RENDERING_ATTRIBUTES_READ = 12;
    public static final int ALLOW_RENDERING_ATTRIBUTES_WRITE = 13;
    public static final int ALLOW_POLYGON_ATTRIBUTES_READ = 14;
    public static final int ALLOW_POLYGON_ATTRIBUTES_WRITE = 15;
    public static final int ALLOW_LINE_ATTRIBUTES_READ = 16;
    public static final int ALLOW_LINE_ATTRIBUTES_WRITE = 17;
    public static final int ALLOW_POINT_ATTRIBUTES_READ = 18;
    public static final int ALLOW_POINT_ATTRIBUTES_WRITE = 19;
    public static final int ALLOW_MATERIAL_READ = 0;
    public static final int ALLOW_MATERIAL_WRITE = 1;
    public static final int ALLOW_TEXTURE_READ = 2;
    public static final int ALLOW_TEXTURE_WRITE = 3;
    public static final int ALLOW_TEXTURE_ATTRIBUTES_READ = 6;
    public static final int ALLOW_TEXTURE_ATTRIBUTES_WRITE = 7;
    public static final int ALLOW_TEXGEN_READ = 4;
    public static final int ALLOW_TEXGEN_WRITE = 5;
    public static final int ALLOW_TEXTURE_UNIT_STATE_READ = 20;
    public static final int ALLOW_TEXTURE_UNIT_STATE_WRITE = 21;
    private static final int[] readCapabilities = new int[]{8, 16, 0, 18, 14, 12, 4, 6, 2, 20, 10};

    public Appearance() {
        if (!(this instanceof ShaderAppearance) && Pipeline.getPipeline() instanceof Jogl2es2Pipeline) {
            System.err.println("Appearance will display nothing when using the Jogl2es2 Pipeline, consider using a ShaderAppearance");
        }
        this.setDefaultReadCapabilities(readCapabilities);
    }

    @Override
    void createRetained() {
        this.retained = new AppearanceRetained();
        this.retained.setSource(this);
    }

    public void setMaterial(Material material) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance0"));
        }
        ((AppearanceRetained)this.retained).setMaterial(material);
    }

    public Material getMaterial() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance1"));
        }
        return ((AppearanceRetained)this.retained).getMaterial();
    }

    public void setColoringAttributes(ColoringAttributes coloringAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance6"));
        }
        ((AppearanceRetained)this.retained).setColoringAttributes(coloringAttributes);
    }

    public ColoringAttributes getColoringAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance7"));
        }
        return ((AppearanceRetained)this.retained).getColoringAttributes();
    }

    public void setTransparencyAttributes(TransparencyAttributes transparencyAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance8"));
        }
        ((AppearanceRetained)this.retained).setTransparencyAttributes(transparencyAttributes);
    }

    public TransparencyAttributes getTransparencyAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance9"));
        }
        return ((AppearanceRetained)this.retained).getTransparencyAttributes();
    }

    public void setRenderingAttributes(RenderingAttributes renderingAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance10"));
        }
        ((AppearanceRetained)this.retained).setRenderingAttributes(renderingAttributes);
    }

    public RenderingAttributes getRenderingAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance11"));
        }
        return ((AppearanceRetained)this.retained).getRenderingAttributes();
    }

    public void setPolygonAttributes(PolygonAttributes polygonAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance12"));
        }
        ((AppearanceRetained)this.retained).setPolygonAttributes(polygonAttributes);
    }

    public PolygonAttributes getPolygonAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance13"));
        }
        return ((AppearanceRetained)this.retained).getPolygonAttributes();
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance14"));
        }
        ((AppearanceRetained)this.retained).setLineAttributes(lineAttributes);
    }

    public LineAttributes getLineAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance15"));
        }
        return ((AppearanceRetained)this.retained).getLineAttributes();
    }

    public void setPointAttributes(PointAttributes pointAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance16"));
        }
        ((AppearanceRetained)this.retained).setPointAttributes(pointAttributes);
    }

    public PointAttributes getPointAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance17"));
        }
        return ((AppearanceRetained)this.retained).getPointAttributes();
    }

    public void setTexture(Texture texture) {
        ImageComponent[] images;
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance2"));
        }
        if (texture != null && (images = ((TextureRetained)texture.retained).getImages()) != null) {
            for (int i = 0; i < images.length; ++i) {
                this.validateImageIllegalSharing(images[i]);
            }
        }
        ((AppearanceRetained)this.retained).setTexture(texture);
    }

    public Texture getTexture() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance3"));
        }
        return ((AppearanceRetained)this.retained).getTexture();
    }

    public void setTextureAttributes(TextureAttributes textureAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance4"));
        }
        ((AppearanceRetained)this.retained).setTextureAttributes(textureAttributes);
    }

    public TextureAttributes getTextureAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance5"));
        }
        return ((AppearanceRetained)this.retained).getTextureAttributes();
    }

    public void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance18"));
        }
        ((AppearanceRetained)this.retained).setTexCoordGeneration(texCoordGeneration);
    }

    public TexCoordGeneration getTexCoordGeneration() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance19"));
        }
        return ((AppearanceRetained)this.retained).getTexCoordGeneration();
    }

    public void setTextureUnitState(TextureUnitState[] stateArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance20"));
        }
        if (stateArray != null) {
            for (int j = 0; j < stateArray.length; ++j) {
                ImageComponent[] images;
                TextureRetained texRetained;
                if (stateArray[j] == null || (texRetained = ((TextureUnitStateRetained)stateArray[j].retained).texture) == null || (images = texRetained.getImages()) == null) continue;
                for (int i = 0; i < images.length; ++i) {
                    this.validateImageIllegalSharing(images[i]);
                }
            }
        }
        ((AppearanceRetained)this.retained).setTextureUnitState(stateArray);
    }

    public void setTextureUnitState(int index, TextureUnitState state) {
        ImageComponent[] images;
        TextureRetained texRetained;
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance20"));
        }
        if (state != null && (texRetained = ((TextureUnitStateRetained)state.retained).texture) != null && (images = texRetained.getImages()) != null) {
            for (int i = 0; i < images.length; ++i) {
                this.validateImageIllegalSharing(images[i]);
            }
        }
        ((AppearanceRetained)this.retained).setTextureUnitState(index, state);
    }

    public TextureUnitState[] getTextureUnitState() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance21"));
        }
        return ((AppearanceRetained)this.retained).getTextureUnitState();
    }

    public TextureUnitState getTextureUnitState(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance21"));
        }
        return ((AppearanceRetained)this.retained).getTextureUnitState(index);
    }

    public int getTextureUnitCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Appearance21"));
        }
        return ((AppearanceRetained)this.retained).getTextureUnitCount();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        Appearance a = new Appearance();
        a.duplicateNodeComponent(this);
        return a;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.checkDuplicateNodeComponent(originalNodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        Hashtable hashtable = originalNodeComponent.nodeHashtable;
        AppearanceRetained app = (AppearanceRetained)originalNodeComponent.retained;
        AppearanceRetained rt = (AppearanceRetained)this.retained;
        rt.setMaterial((Material)this.getNodeComponent(app.getMaterial(), forceDuplicate, hashtable));
        rt.setColoringAttributes((ColoringAttributes)this.getNodeComponent(app.getColoringAttributes(), forceDuplicate, hashtable));
        rt.setTransparencyAttributes((TransparencyAttributes)this.getNodeComponent(app.getTransparencyAttributes(), forceDuplicate, hashtable));
        rt.setRenderingAttributes((RenderingAttributes)this.getNodeComponent(app.getRenderingAttributes(), forceDuplicate, hashtable));
        rt.setPolygonAttributes((PolygonAttributes)this.getNodeComponent(app.getPolygonAttributes(), forceDuplicate, hashtable));
        rt.setLineAttributes((LineAttributes)this.getNodeComponent(app.getLineAttributes(), forceDuplicate, hashtable));
        rt.setPointAttributes((PointAttributes)this.getNodeComponent(app.getPointAttributes(), forceDuplicate, hashtable));
        rt.setTexture((Texture)this.getNodeComponent(app.getTexture(), forceDuplicate, hashtable));
        rt.setTextureAttributes((TextureAttributes)this.getNodeComponent(app.getTextureAttributes(), forceDuplicate, hashtable));
        rt.setTexCoordGeneration((TexCoordGeneration)this.getNodeComponent(app.getTexCoordGeneration(), forceDuplicate, hashtable));
        TextureUnitState[] state = app.getTextureUnitState();
        if (state != null) {
            rt.setTextureUnitState(state);
            for (int i = 0; i < state.length; ++i) {
                rt.setTextureUnitState(i, (TextureUnitState)this.getNodeComponent(state[i], forceDuplicate, hashtable));
            }
        }
    }

    @Override
    boolean duplicateChild() {
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        AppearanceRetained rt = (AppearanceRetained)this.retained;
        NodeComponent nc = rt.getMaterial();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getColoringAttributes();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getTransparencyAttributes();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getPolygonAttributes();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getLineAttributes();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getPointAttributes();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getTexture();
        if (nc != null && nc.duplicateChild()) {
            return true;
        }
        nc = rt.getTextureAttributes();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getTexCoordGeneration();
        return nc != null && nc.getDuplicateOnCloneTree();
    }
}

