/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class Resolution {
    public final double sampling;
    public final double resolution;
    private final double inverseResSq;

    public Resolution(double resolution, double sampling) {
        this.resolution = resolution;
        this.inverseResSq = 1.0 / (resolution * resolution);
        this.sampling = sampling;
    }

    public Resolution(double resolution) {
        this(resolution, 0.6666666666666666);
    }

    public String toString() {
        return String.format(" Resolution: %6.3f Sampling: %6.3f", this.resolution, this.sampling);
    }

    public static Resolution checkProperties(CompositeConfiguration properties, boolean isNeutron, double defaultResolution) {
        double resolution = properties.getDouble("resolution", defaultResolution);
        resolution = isNeutron ? properties.getDouble("neutron-resolution", resolution) : properties.getDouble("xray-resolution", resolution);
        double sampling = properties.getDouble("sampling", 0.6);
        if (resolution <= 0.0) {
            return null;
        }
        return new Resolution(resolution, sampling);
    }

    public boolean inInverseResSqRange(double res) {
        if (FastMath.abs((double)(res - this.inverseResSq)) < 1.0E-8) {
            return true;
        }
        return res < this.inverseResSq;
    }

    public boolean inResolutionRange(double res) {
        if (FastMath.abs((double)(res - this.resolution)) < 1.0E-8) {
            return true;
        }
        return res > this.resolution;
    }

    public double inverseResSqLimit() {
        return this.inverseResSq;
    }

    public double resolutionLimit() {
        return this.resolution;
    }

    public double samplingLimit() {
        return this.sampling;
    }
}

