/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicatesCrystal
extends Crystal {
    private static final Logger logger = Logger.getLogger(ReplicatesCrystal.class.getName());
    private final Crystal unitCell;
    private final double cutOff;
    private int l;
    private int m;
    private int n;

    public ReplicatesCrystal(Crystal unitCell, int l, int m, int n, double cutOff2) {
        super(unitCell.a * (double)l, unitCell.b * (double)m, unitCell.c * (double)n, unitCell.alpha, unitCell.beta, unitCell.gamma, unitCell.spaceGroup.shortName);
        this.unitCell = unitCell;
        assert (l >= 1);
        assert (m >= 1);
        assert (n >= 1);
        this.l = l;
        this.m = m;
        this.n = n;
        this.cutOff = cutOff2 / 2.0;
        this.updateReplicateOperators();
    }

    public int getL() {
        return this.l;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public static Crystal replicatesCrystalFactory(Crystal unitCell, double cutOff2) {
        return ReplicatesCrystal.replicatesCrystalFactory(unitCell, cutOff2, new int[3]);
    }

    public static Crystal replicatesCrystalFactory(Crystal unitCell, double cutOff2, int[] replicatesVector) {
        if (unitCell == null || unitCell.aperiodic()) {
            replicatesVector[0] = 0;
            replicatesVector[1] = 0;
            replicatesVector[2] = 0;
            return unitCell;
        }
        int l = 1;
        int m = 1;
        int n = 1;
        double cutOff = cutOff2 / 2.0;
        while (unitCell.interfacialRadiusA * (double)l < cutOff) {
            ++l;
        }
        while (unitCell.interfacialRadiusB * (double)m < cutOff) {
            ++m;
        }
        while (unitCell.interfacialRadiusC * (double)n < cutOff) {
            ++n;
        }
        replicatesVector[0] = l;
        replicatesVector[1] = m;
        replicatesVector[2] = n;
        return new ReplicatesCrystal(unitCell, l, m, n, cutOff2);
    }

    @Override
    public boolean setCellVectors(double[][] cellVectors) {
        if (this.unitCell.setCellVectors(cellVectors)) {
            return this.updateReplicatesDimensions();
        }
        return false;
    }

    @Override
    public boolean setCellVectorsAndVolume(double[][] cellVectors, double targetAUVolume) {
        if (this.unitCell.setCellVectorsAndVolume(cellVectors, targetAUVolume)) {
            return this.updateReplicatesDimensions();
        }
        return false;
    }

    @Override
    public boolean changeUnitCellParameters(double a, double b, double c, double alpha, double beta, double gamma) {
        if (this.unitCell.changeUnitCellParameters(a, b, c, alpha, beta, gamma)) {
            return this.updateReplicatesDimensions();
        }
        return false;
    }

    @Override
    public boolean changeUnitCellParametersAndVolume(double a, double b, double c, double alpha, double beta, double gamma, double targetAUVolume) {
        if (this.unitCell.changeUnitCellParametersAndVolume(a, b, c, alpha, beta, gamma, targetAUVolume)) {
            return this.updateReplicatesDimensions();
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatesCrystal replicatesCrystal = (ReplicatesCrystal)o;
        return Objects.equals(this.unitCell, replicatesCrystal.unitCell) && this.a == replicatesCrystal.a && this.b == replicatesCrystal.b && this.c == replicatesCrystal.c && this.alpha == replicatesCrystal.alpha && this.beta == replicatesCrystal.beta && this.gamma == replicatesCrystal.gamma && this.l == replicatesCrystal.l && this.m == replicatesCrystal.m && this.n == replicatesCrystal.n && this.spaceGroup.number == replicatesCrystal.spaceGroup.number && this.spaceGroup.symOps.size() == replicatesCrystal.spaceGroup.symOps.size();
    }

    @Override
    public boolean getCheckRestrictions() {
        return this.unitCell.getCheckRestrictions();
    }

    @Override
    public void setCheckRestrictions(boolean checkRestrictions) {
        this.checkRestrictions = checkRestrictions;
        this.unitCell.setCheckRestrictions(checkRestrictions);
    }

    @Override
    public double getDensity(double mass) {
        return this.unitCell.getDensity(mass);
    }

    @Override
    public Crystal getUnitCell() {
        return this.unitCell;
    }

    @Override
    public boolean randomParameters(double density, double mass) {
        boolean succeed = this.unitCell.randomParameters(density, mass);
        if (succeed) {
            this.updateReplicatesDimensions();
        }
        return succeed;
    }

    @Override
    public void setDensity(double density, double mass) {
        this.unitCell.setDensity(density, mass);
        this.updateReplicatesDimensions();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.unitCell.toString());
        if (this.l * this.m * this.n > 1) {
            sb.append("\n\n Replicates Cell\n");
            sb.append(String.format("  Dimension:                    (%3d x%3d x%3d)\n", this.l, this.m, this.n));
            sb.append(String.format("  A-axis:                              %8.3f\n", this.a));
            sb.append(String.format("  B-axis:                              %8.3f\n", this.b));
            sb.append(String.format("  C-axis:                              %8.3f\n", this.c));
            sb.append(String.format("  Alpha:                               %8.3f\n", this.alpha));
            sb.append(String.format("  Beta:                                %8.3f\n", this.beta));
            sb.append(String.format("  Gamma:                               %8.3f\n", this.gamma));
            sb.append(String.format("  Total Symmetry Operators:            %8d", this.spaceGroup.getNumberOfSymOps()));
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return String.format("%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f (%3d x%3d x%3d) ", this.a, this.b, this.c, this.alpha, this.beta, this.gamma, this.l, this.m, this.n);
    }

    private boolean updateReplicatesDimensions() {
        int ll = 1;
        int mm = 1;
        int nn = 1;
        while (this.unitCell.interfacialRadiusA * (double)ll < this.cutOff) {
            ++ll;
        }
        while (this.unitCell.interfacialRadiusB * (double)mm < this.cutOff) {
            ++mm;
        }
        while (this.unitCell.interfacialRadiusC * (double)nn < this.cutOff) {
            ++nn;
        }
        if (super.changeUnitCellParameters(this.unitCell.a * (double)ll, this.unitCell.b * (double)mm, this.unitCell.c * (double)nn, this.unitCell.alpha, this.unitCell.beta, this.unitCell.gamma)) {
            this.l = ll;
            this.m = mm;
            this.n = nn;
            this.updateReplicateOperators();
            return true;
        }
        return false;
    }

    private void updateReplicateOperators() {
        List<SymOp> symOps = this.spaceGroup.symOps;
        symOps.clear();
        double dX = 1.0 / (double)this.l;
        double dY = 1.0 / (double)this.m;
        double dZ = 1.0 / (double)this.n;
        int symOpCount = 0;
        List<SymOp> ucSymOps = this.unitCell.spaceGroup.symOps;
        for (int i = 0; i < this.l; ++i) {
            for (int j = 0; j < this.m; ++j) {
                for (int k = 0; k < this.n; ++k) {
                    int ii = 0;
                    for (SymOp symOp : ucSymOps) {
                        double[] repTrans = new double[]{(symOp.tr[0] + (double)i) * dX, (symOp.tr[1] + (double)j) * dY, (symOp.tr[2] + (double)k) * dZ};
                        SymOp repSymOp = new SymOp(symOp.rot, repTrans, new int[]{i, j, k});
                        symOps.add(repSymOp);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(String.format("\n SymOp %d (%2d,%2d,%2d): %d", symOpCount, i, j, k, ii));
                            logger.finest(repSymOp.toString());
                        }
                        ++ii;
                        ++symOpCount;
                    }
                }
            }
        }
    }
}

