/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.LaueSystem;
import ffx.crystal.Resolution;
import ffx.crystal.SpaceGroup;
import ffx.crystal.SymOp;
import ffx.numerics.math.ScalarMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class ReflectionList {
    private static final Logger logger = Logger.getLogger(ReflectionList.class.getName());
    public final ArrayList<HKL> hklList = new ArrayList();
    public final Crystal crystal;
    public final SpaceGroup spaceGroup;
    public final Resolution resolution;
    final HashMap<String, HKL> hklMap = new HashMap();
    public int nBins = 10;
    private final double[] histogram = new double[1001];
    private double minResolution;
    private double maxResolution;

    public ReflectionList(Crystal crystal, Resolution resolution) {
        this(crystal, resolution, null);
    }

    public ReflectionList(Crystal crystal, Resolution resolution, CompositeConfiguration properties) {
        int i;
        this.crystal = crystal;
        this.spaceGroup = crystal.spaceGroup;
        this.resolution = resolution;
        int hMax = (int)(this.crystal.a / this.resolution.resolutionLimit());
        int kMax = (int)(this.crystal.b / this.resolution.resolutionLimit());
        int lMax = (int)(this.crystal.c / this.resolution.resolutionLimit());
        this.minResolution = Double.POSITIVE_INFINITY;
        this.maxResolution = Double.NEGATIVE_INFINITY;
        int n = 0;
        HKL hkl = new HKL();
        for (int h = -hMax; h <= hMax; ++h) {
            hkl.setH(h);
            for (int k = -kMax; k <= kMax; ++k) {
                hkl.setK(k);
                for (int l = -lMax; l <= lMax; ++l) {
                    hkl.setL(l);
                    double res = this.crystal.invressq(hkl);
                    this.getEpsilon(hkl);
                    LaueSystem laueSystem = this.spaceGroup.laueSystem;
                    if (!laueSystem.checkRestrictions(h, k, l) || !resolution.inInverseResSqRange(res) || hkl.sysAbs()) continue;
                    this.minResolution = FastMath.min((double)res, (double)this.minResolution);
                    this.maxResolution = FastMath.max((double)res, (double)this.maxResolution);
                    String s = (h + "_" + k + "_" + l).intern();
                    this.hklMap.put(s, new HKL(hkl.getH(), hkl.getK(), hkl.getL(), hkl.getEpsilon(), hkl.allowed));
                    ++n;
                }
            }
        }
        n = 0;
        for (Map.Entry<String, HKL> entry : this.hklMap.entrySet()) {
            HKL ih = entry.getValue();
            ih.setIndex(n);
            this.hklList.add(ih);
            ++n;
        }
        for (HKL ih : this.hklList) {
            double r = (this.crystal.invressq(ih) - this.minResolution) / (this.maxResolution - this.minResolution);
            int i2 = (int)(FastMath.min((double)r, (double)0.999) * 1000.0);
            int n2 = i2 + 1;
            this.histogram[n2] = this.histogram[n2] + 1.0;
        }
        for (i = 1; i < this.histogram.length; ++i) {
            int n3 = i;
            this.histogram[n3] = this.histogram[n3] + this.histogram[i - 1];
        }
        i = 0;
        while (i < this.histogram.length) {
            int n4 = i++;
            this.histogram[n4] = this.histogram[n4] / this.histogram[this.histogram.length - 1];
        }
        this.setResolutionBins(properties);
    }

    public ReflectionList(double a, double b, double c, double alpha, double beta, double gamma, String sg, double resolution) {
        this(new Crystal(a, b, c, alpha, beta, gamma, sg), new Resolution(resolution));
    }

    public boolean findSymHKL(HKL hkl, HKL mate) {
        return this.findSymHKL(hkl, mate, false);
    }

    public boolean findSymHKL(int h, int k, int l, HKL mate) {
        return this.findSymHKL(new HKL(h, k, l), mate, false);
    }

    public boolean findSymHKL(int h, int k, int l, HKL mate, boolean transpose) {
        return this.findSymHKL(new HKL(h, k, l), mate, transpose);
    }

    public HKL getHKL(int h, int k, int l) {
        String s = h + "_" + k + "_" + l;
        return this.hklMap.get(s);
    }

    public HKL getHKL(HKL hkl) {
        return this.getHKL(hkl.getH(), hkl.getK(), hkl.getL());
    }

    public double getMaxResolution() {
        return this.maxResolution;
    }

    public double getMinResolution() {
        return this.minResolution;
    }

    public boolean hasHKL(HKL hkl) {
        return this.hasHKL(hkl.getH(), hkl.getK(), hkl.getL());
    }

    public final double ordinal(double s) {
        double r = (s - this.minResolution) / (this.maxResolution - this.minResolution);
        r = FastMath.min((double)r, (double)0.999) * 1000.0;
        int i = (int)r;
        r -= FastMath.floor((double)r);
        return (1.0 - r) * this.histogram[i] + r * this.histogram[i + 1];
    }

    public String toString() {
        return " Reflection list with " + this.hklList.size() + " reflections, spacegroup " + this.spaceGroup.shortName + " resolution limit: " + this.resolution.resolutionLimit();
    }

    private boolean findSymHKL(HKL hkl, HKL mate, boolean transpose) {
        int nsym = this.spaceGroup.numPrimitiveSymEquiv;
        for (int i = 0; i < nsym; ++i) {
            if (transpose) {
                SymOp.applyTransSymRot(hkl, mate, this.spaceGroup.symOps.get(i));
            } else {
                SymOp.applySymRot(hkl, mate, this.spaceGroup.symOps.get(i));
            }
            LaueSystem laueSystem = this.spaceGroup.laueSystem;
            if (laueSystem.checkRestrictions(mate.getH(), mate.getK(), mate.getL())) {
                return false;
            }
            if (!laueSystem.checkRestrictions(-mate.getH(), -mate.getK(), -mate.getL())) continue;
            mate.setH(-mate.getH());
            mate.setK(-mate.getK());
            mate.setL(-mate.getL());
            return true;
        }
        mate.setH(hkl.getH());
        mate.setK(hkl.getK());
        mate.setL(hkl.getL());
        return false;
    }

    private boolean hasHKL(int h, int k, int l) {
        String s = h + "_" + k + "_" + l;
        return this.hklMap.containsKey(s);
    }

    private void getEpsilon(HKL hkl) {
        int epsilon = 1;
        int allowed = 255;
        int nSym = this.spaceGroup.symOps.size();
        for (int i = 1; i < nSym; ++i) {
            HKL mate = new HKL();
            SymOp symOp = this.spaceGroup.symOps.get(i);
            SymOp.applySymRot(hkl, mate, symOp);
            double shift = symOp.symPhaseShift(hkl);
            if (mate.equals(hkl)) {
                if (FastMath.cos((double)shift) > 0.999) {
                    ++epsilon;
                    continue;
                }
                allowed = 0;
                epsilon = 0;
                break;
            }
            if (!mate.equals(hkl.neg())) continue;
            allowed = (int)FastMath.rint((double)(ScalarMath.mod((double)(-0.5 * shift), (double)Math.PI) / 0.2617993877991494));
        }
        if (hkl.getH() == 0 && hkl.getK() == 0 && hkl.getL() == 0) {
            allowed = 0;
        }
        hkl.setEpsilon(epsilon);
        hkl.setAllowed(allowed);
    }

    private void setResolutionBins(@Nullable CompositeConfiguration properties) {
        if (properties != null) {
            this.nBins = properties.getInt("reflection-bins", 10);
        }
        double nBinsDouble = this.nBins;
        for (HKL ih : this.hklList) {
            int bin = (int)(nBinsDouble * this.ordinal(this.crystal.invressq(ih)));
            ih.bin = FastMath.min((int)bin, (int)(this.nBins - 1));
        }
    }
}

