/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class NCSCrystal
extends Crystal {
    private static final Logger logger = Logger.getLogger(NCSCrystal.class.getName());
    private final Crystal unitCell;
    private final List<SymOp> NCSsymOps;

    private NCSCrystal(Crystal unitCell, List<SymOp> NCSsymOps) {
        super(unitCell.a, unitCell.b, unitCell.c, unitCell.alpha, unitCell.beta, unitCell.gamma, unitCell.spaceGroup.shortName);
        this.unitCell = unitCell;
        this.NCSsymOps = NCSsymOps;
        this.updateNCSOperators();
    }

    public static Crystal NCSCrystalFactory(Crystal unitCell, List<SymOp> symOps) {
        if (unitCell == null || unitCell.aperiodic()) {
            return unitCell;
        }
        return new NCSCrystal(unitCell, symOps);
    }

    @Override
    public boolean changeUnitCellParameters(double a, double b, double c, double alpha, double beta, double gamma) {
        if (this.unitCell.changeUnitCellParameters(a, b, c, alpha, beta, gamma) && super.changeUnitCellParameters(a, b, c, alpha, beta, gamma)) {
            this.updateNCSOperators();
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NCSCrystal ncsCrystal = (NCSCrystal)o;
        return Objects.equals(this.unitCell, ncsCrystal.unitCell) && this.a == ncsCrystal.a && this.b == ncsCrystal.b && this.c == ncsCrystal.c && this.alpha == ncsCrystal.alpha && this.beta == ncsCrystal.beta && this.gamma == ncsCrystal.gamma && this.spaceGroup.number == ncsCrystal.spaceGroup.number && this.spaceGroup.symOps.size() == ncsCrystal.spaceGroup.symOps.size();
    }

    @Override
    public Crystal getUnitCell() {
        return this.unitCell;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.unitCell.toString());
        sb.append("\n\n Non-Crystallographic Cell\n");
        sb.append(String.format("  A-axis:                              %8.3f\n", this.a));
        sb.append(String.format("  B-axis:                              %8.3f\n", this.b));
        sb.append(String.format("  C-axis:                              %8.3f\n", this.c));
        sb.append(String.format("  Alpha:                               %8.3f\n", this.alpha));
        sb.append(String.format("  Beta:                                %8.3f\n", this.beta));
        sb.append(String.format("  Gamma:                               %8.3f\n", this.gamma));
        sb.append(String.format("  UnitCell Symmetry Operators:         %8d\n", this.unitCell.spaceGroup.symOps.size()));
        sb.append(String.format("  NCS Symmetry Operators:              %8d\n", this.NCSsymOps.size()));
        sb.append(String.format("  Total Symmetry Operators:            %8d", this.spaceGroup.getNumberOfSymOps()));
        return sb.toString();
    }

    private void updateNCSOperators() {
        List<SymOp> symOps = this.spaceGroup.symOps;
        symOps.clear();
        int ii = 0;
        int soRemoved = 0;
        for (SymOp NCSsymOp : this.NCSsymOps) {
            for (SymOp symOp : this.unitCell.spaceGroup.symOps) {
                double[] NCSTrans = new double[3];
                RealMatrix NCS = MatrixUtils.createRealMatrix((double[][])NCSsymOp.rot);
                RealMatrix UC = MatrixUtils.createRealMatrix((double[][])symOp.rot);
                RealMatrix result = NCS.multiply(UC);
                double[][] NCSRot = result.getData();
                NCSTrans[0] = symOp.tr[0] + NCSsymOp.tr[0];
                NCSTrans[1] = symOp.tr[1] + NCSsymOp.tr[1];
                NCSTrans[2] = symOp.tr[2] + NCSsymOp.tr[2];
                SymOp NCSSymOp = new SymOp(NCSRot, NCSTrans);
                if (!symOps.contains(NCSSymOp)) {
                    symOps.add(NCSSymOp);
                } else {
                    ++soRemoved;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("\n SymOp: %d", ii));
                    logger.finest(NCSSymOp.toString());
                }
                ++ii;
            }
        }
        if (soRemoved != 0) {
            logger.warning(String.format("\n NCS Replicated SymOps Removed: %d", soRemoved));
        }
    }
}

