/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.numerics.math.Double3;
import ffx.potential.bonded.Atom;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class StructureMetrics {
    private static final Logger logger = Logger.getLogger(StructureMetrics.class.getName());

    public static double radiusOfGyration(Atom[] atoms) {
        Double3 radius = new Double3(StructureMetrics.radiusOfGyrationComponents(atoms));
        return radius.length();
    }

    public static double radiusOfGyration(double[] x, double[] y, double[] z, double[] mass) {
        assert (x.length == y.length);
        assert (y.length == z.length);
        Double3 radius = new Double3(StructureMetrics.radiusOfGyrationComponents(x, y, z, mass, true));
        return radius.length();
    }

    public static double radiusOfGyration(double[] xyz, double[] mass) {
        assert (xyz.length % 3 == 0);
        Double3 radius = new Double3(StructureMetrics.radiusOfGyrationComponents(xyz, mass, true));
        return radius.length();
    }

    public static double[] radiusOfGyrationComponents(Atom[] atoms) {
        int nAtoms = atoms.length;
        double[] x = new double[nAtoms];
        double[] y = new double[nAtoms];
        double[] z = new double[nAtoms];
        double[] mass = new double[nAtoms];
        int index = 0;
        for (int i = 0; i < nAtoms; ++i) {
            mass[i] = atoms[i].getMass();
            x[index] = atoms[i].getX();
            y[index] = atoms[i].getY();
            z[index] = atoms[i].getZ();
            ++index;
        }
        return StructureMetrics.radiusOfGyrationComponents(x, y, z, mass, false);
    }

    public static double[] radiusOfGyrationComponents(double[] xyz, double[] mass, boolean pmp) {
        assert (xyz.length % 3 == 0);
        int nAtoms = xyz.length / 3;
        double[] x = new double[nAtoms];
        double[] y = new double[nAtoms];
        double[] z = new double[nAtoms];
        for (int i = 0; i < nAtoms; ++i) {
            int index = i * 3;
            x[i] = xyz[index++];
            y[i] = xyz[index++];
            z[i] = xyz[index];
        }
        return StructureMetrics.radiusOfGyrationComponents(x, y, z, mass, pmp);
    }

    public static double[] radiusOfGyrationComponents(double[] x, double[] y, double[] z, double[] mass, boolean pmp) {
        assert (x.length == y.length);
        assert (y.length == z.length);
        assert (x.length <= mass.length);
        double massSum = Arrays.stream(mass).sum();
        int nAtoms = x.length;
        double xc = 0.0;
        double yc = 0.0;
        double zc = 0.0;
        for (int i = 0; i < nAtoms; ++i) {
            xc += x[i] * mass[i];
            yc += y[i] * mass[i];
            zc += z[i] * mass[i];
        }
        Double3 centroid = new Double3(xc, yc, zc);
        centroid.scaleI(1.0 / massSum);
        Double3 radius = new Double3();
        if (pmp) {
            double xx = 0.0;
            double xy = 0.0;
            double xz = 0.0;
            double yy = 0.0;
            double yz = 0.0;
            double zz = 0.0;
            for (int i = 0; i < nAtoms; ++i) {
                double xterm = x[i] - xc;
                double yterm = y[i] - yc;
                double zterm = z[i] - zc;
                xx += xterm * xterm;
                xy += xterm * yterm;
                xz += xterm * zterm;
                yy += yterm * yterm;
                yz += yterm * zterm;
                zz += zterm * zterm;
            }
            double[][] tensor = new double[3][3];
            tensor[0][0] = xx;
            tensor[0][1] = xy;
            tensor[0][2] = xz;
            tensor[1][0] = xy;
            tensor[1][1] = yy;
            tensor[1][2] = yz;
            tensor[2][0] = xz;
            tensor[2][1] = yz;
            tensor[2][2] = zz;
            Array2DRowRealMatrix cMatrix = new Array2DRowRealMatrix(tensor, false);
            EigenDecomposition eigenDecomposition = new EigenDecomposition((RealMatrix)cMatrix);
            radius.set(eigenDecomposition.getRealEigenvalues()).scaleI(1.0 / (double)nAtoms).sqrtI();
        } else {
            for (int i = 0; i < nAtoms; ++i) {
                Double3 xyz = new Double3(x[i], y[i], z[i]);
                xyz.subI(centroid);
                radius.addI(xyz.squareI());
            }
            radius.scaleI(1.0 / (double)nAtoms).sqrtI();
        }
        return radius.get();
    }

    public static double[][] momentsOfInertia(Atom[] atoms, boolean moved, boolean print, boolean pma) {
        double[] mass = new double[atoms.length];
        int nAtoms = atoms.length;
        double[] x = new double[nAtoms];
        double[] y = new double[nAtoms];
        double[] z = new double[nAtoms];
        int index = 0;
        for (Atom atom : atoms) {
            mass[index] = atom.getMass();
            x[index] = atom.getX();
            y[index] = atom.getY();
            z[index] = atom.getZ();
            ++index;
        }
        return StructureMetrics.momentsOfInertia(x, y, z, mass, moved, print, pma);
    }

    public static double[][] momentsOfInertia(double[] xyz, double[] mass, boolean moved, boolean print, boolean pma) {
        assert (xyz.length % 3 == 0);
        int nAtoms = xyz.length / 3;
        double[] x = new double[nAtoms];
        double[] y = new double[nAtoms];
        double[] z = new double[nAtoms];
        for (int i = 0; i < nAtoms; ++i) {
            int index = i * 3;
            x[i] = xyz[index++];
            y[i] = xyz[index++];
            z[i] = xyz[index];
        }
        return StructureMetrics.momentsOfInertia(x, y, z, mass, moved, print, pma);
    }

    public static double[][] momentsOfInertia(double[] x, double[] y, double[] z, double[] mass, boolean moved, boolean print, boolean pma) {
        Object vec;
        double[] moment;
        double zterm;
        double yterm;
        double xterm;
        assert (x.length == y.length);
        assert (y.length == z.length);
        double total = 0.0;
        double xcm = 0.0;
        double ycm = 0.0;
        double zcm = 0.0;
        int nAtoms = x.length;
        for (int i = 0; i < nAtoms; ++i) {
            double massValue = mass[i];
            total += massValue;
            xcm += x[i] * massValue;
            ycm += y[i] * massValue;
            zcm += z[i] * massValue;
        }
        xcm /= total;
        ycm /= total;
        zcm /= total;
        double xx = 0.0;
        double xy = 0.0;
        double xz = 0.0;
        double yy = 0.0;
        double yz = 0.0;
        double zz = 0.0;
        for (int i = 0; i < nAtoms; ++i) {
            double massValue = mass[i];
            xterm = x[i] - xcm;
            yterm = y[i] - ycm;
            zterm = z[i] - zcm;
            xx += xterm * xterm * massValue;
            xy += xterm * yterm * massValue;
            xz += xterm * zterm * massValue;
            yy += yterm * yterm * massValue;
            yz += yterm * zterm * massValue;
            zz += zterm * zterm * massValue;
        }
        double[][] tensor = new double[3][3];
        tensor[0][0] = yy + zz;
        tensor[0][1] = -xy;
        tensor[0][2] = -xz;
        tensor[1][0] = -xy;
        tensor[1][1] = xx + zz;
        tensor[1][2] = -yz;
        tensor[2][0] = -xz;
        tensor[2][1] = -yz;
        tensor[2][2] = xx + yy;
        if (pma) {
            int i;
            Array2DRowRealMatrix cMatrix = new Array2DRowRealMatrix(tensor, false);
            EigenDecomposition eigenDecomposition = new EigenDecomposition((RealMatrix)cMatrix);
            moment = eigenDecomposition.getRealEigenvalues();
            vec = eigenDecomposition.getV().getData();
            double dot = 0.0;
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < nAtoms; ++j) {
                    xterm = vec[i][0] * (x[j] - xcm);
                    yterm = vec[i][1] * (y[j] - ycm);
                    zterm = vec[i][2] * (z[j] - zcm);
                    dot = xterm + yterm + zterm;
                    if (dot < 0.0) {
                        for (int k = 0; k < 3; ++k) {
                            vec[i][k] = -vec[i][k];
                        }
                    }
                    if (dot != 0.0) break;
                }
                if (dot != 0.0) break;
            }
            if ((dot = (xterm = vec[0][0] * (vec[1][1] * vec[2][2] - vec[2][1] * vec[1][2])) + (yterm = vec[0][1] * (vec[2][0] * vec[1][2] - vec[1][0] * vec[2][2])) + (zterm = vec[0][2] * (vec[1][0] * vec[2][1] - vec[2][0] * vec[1][1]))) < 0.0) {
                for (i = 0; i < 3; ++i) {
                    vec[2][i] = -vec[2][i];
                }
            }
            if (moved) {
                int i2;
                double[][] a = new double[3][3];
                for (i2 = 0; i2 < 3; ++i2) {
                    for (int j = 0; j < 3; ++j) {
                        a[j][i2] = vec[j][i2];
                    }
                }
                for (i2 = 0; i2 < nAtoms; ++i2) {
                    xterm = x[i2] - xcm;
                    yterm = y[i2] - ycm;
                    zterm = z[i2] - zcm;
                    x[i2] = a[0][0] * xterm + a[1][0] * yterm + a[2][0] * zterm;
                    y[i2] = a[0][1] * xterm + a[1][1] * yterm + a[2][1] * zterm;
                    z[i2] = a[0][2] * xterm + a[1][2] * yterm + a[2][2] * zterm;
                }
            }
        } else {
            vec = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
            moment = new double[]{tensor[0][0], tensor[1][1], tensor[2][2]};
        }
        if (print) {
            logger.info(String.format("\n Center of Mass Coordinates: %8.4f %8.4f %8.4f", xcm, ycm, zcm));
            double[] angles = new Rotation(vec, 1.0E-7).getAngles(RotationOrder.XYZ, RotationConvention.VECTOR_OPERATOR);
            double radian = 57.29577951308232;
            int i = 0;
            while (i < 3) {
                int n = i++;
                angles[n] = angles[n] * radian;
            }
            logger.info(String.format(" Euler Angles (Phi/Theta/Psi): %8.3f %8.3f %8.3f", angles[0], angles[1], angles[2]));
            logger.info(" Moments of Inertia and Principle Axes:\n  Moments (amu Ang^2): \t X-, Y-, and Z-Components of Axes:");
            for (i = 0; i < 3; ++i) {
                logger.info(String.format("  %16.3f %12.6f %12.6f %12.6f", moment[i], vec[i][0], vec[i][1], vec[i][2]));
            }
        }
        double[][] momentsAndVectors = new double[3][4];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                momentsAndVectors[i][j] = j == 0 ? moment[i] : vec[i][j - 1];
            }
        }
        return momentsAndVectors;
    }
}

