/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.crystal.Crystal;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.PDBFileFilter;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFileFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.potential.utils.PotentialsFileOpener;
import ffx.potential.utils.PotentialsFunctions;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;

public class PotentialsUtils
implements PotentialsFunctions {
    private static final Logger logger = Logger.getLogger(PotentialsUtils.class.getName());
    private static final Logger potLog = Logger.getLogger("");
    private static Level levelBak = null;
    private final long initTime;
    private long interTime;
    private SystemFilter lastFilter;

    public PotentialsUtils() {
        this.interTime = this.initTime = System.nanoTime();
    }

    @Override
    public void close(MolecularAssembly assembly) {
        assembly.destroy();
    }

    @Override
    public void closeAll(MolecularAssembly[] assemblies) {
        for (MolecularAssembly assembly : assemblies) {
            assembly.destroy();
        }
    }

    @Override
    public ForceFieldEnergy energy(MolecularAssembly molecularAssembly) {
        if (molecularAssembly == null) {
            return null;
        }
        ForceFieldEnergy energy = molecularAssembly.getPotentialEnergy();
        if (energy == null) {
            energy = ForceFieldEnergy.energyFactory(molecularAssembly);
            molecularAssembly.setPotential(energy);
        }
        energy.energy(false, true);
        return energy;
    }

    @Override
    public ForceFieldEnergy[] energy(MolecularAssembly[] molecularAssemblies) {
        if (molecularAssemblies == null) {
            return null;
        }
        int n = molecularAssemblies.length;
        ForceFieldEnergy[] forceFieldEnergies = new ForceFieldEnergy[n];
        if (n == 1) {
            forceFieldEnergies[0] = this.energy(molecularAssemblies[0]);
        } else {
            for (int i = 0; i < n; ++i) {
                logger.info(String.format("\n Conformer %d", i + 1));
                forceFieldEnergies[i] = this.energy(molecularAssemblies[i]);
            }
        }
        return forceFieldEnergies;
    }

    @Override
    public SystemFilter getFilter() {
        return this.lastFilter;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public MolecularAssembly open(String filename) {
        PotentialsFileOpener opener = new PotentialsFileOpener(filename);
        opener.run();
        this.lastFilter = opener.getFilter();
        if (opener.getAllAssemblies().length > 1) {
            logger.log(Level.WARNING, "Found multiple assemblies in file {0}, opening first.", filename);
        }
        return opener.getAssembly();
    }

    public MolecularAssembly open(File file) {
        PotentialsFileOpener opener = new PotentialsFileOpener(file);
        opener.run();
        this.lastFilter = opener.getFilter();
        if (opener.getAllAssemblies().length > 1) {
            logger.log(Level.WARNING, "Found multiple assemblies in file {0}, opening first.", file.getName());
        }
        return opener.getAssembly();
    }

    @Override
    public MolecularAssembly[] open(String[] files, int nThreads) {
        PotentialsFileOpener opener = new PotentialsFileOpener(files);
        opener.setNThreads(nThreads);
        opener.run();
        this.lastFilter = opener.getFilter();
        return opener.getAllAssemblies();
    }

    @Override
    public MolecularAssembly[] openAll(String file) {
        PotentialsFileOpener opener = new PotentialsFileOpener(file);
        opener.run();
        this.lastFilter = opener.getFilter();
        return opener.getAllAssemblies();
    }

    @Override
    public MolecularAssembly[] openAll(String[] files) {
        PotentialsFileOpener opener = new PotentialsFileOpener(files);
        opener.run();
        this.lastFilter = opener.getFilter();
        logger.info(" Filter type: " + this.lastFilter.toString());
        return opener.getAllAssemblies();
    }

    @Override
    public MolecularAssembly[] openAll(String file, int nThreads) {
        PotentialsFileOpener opener = new PotentialsFileOpener(file);
        opener.setNThreads(nThreads);
        opener.run();
        this.lastFilter = opener.getFilter();
        logger.info(" Filter type: " + this.lastFilter.toString());
        return opener.getAllAssemblies();
    }

    public MolecularAssembly openQuietly(String filename) {
        this.setSilentPotential(true);
        MolecularAssembly molecularAssembly = this.open(filename);
        this.setSilentPotential(false);
        return molecularAssembly;
    }

    public MolecularAssembly openWithMutations(File file, List<PDBFilter.Mutation> mutations) {
        PotentialsFileOpener opener = new PotentialsFileOpener(file);
        opener.setMutations(mutations);
        opener.run();
        this.lastFilter = opener.getFilter();
        if (opener.getAllAssemblies().length > 1) {
            logger.log(Level.WARNING, "Found multiple assemblies in file {0}, opening first.", file.getName());
        }
        return opener.getAssembly();
    }

    @Override
    public double returnEnergy(MolecularAssembly assembly) {
        if (assembly == null) {
            logger.info(" Molecular assembly was null - skipping energy");
            return 0.0;
        }
        ForceFieldEnergy energy = assembly.getPotentialEnergy();
        if (energy == null) {
            energy = ForceFieldEnergy.energyFactory(assembly);
            assembly.setPotential(energy);
        }
        return energy.energy(false, true);
    }

    @Override
    public void save(MolecularAssembly assembly, File file) {
        if (XYZFileFilter.isXYZ(file)) {
            this.saveAsXYZ(assembly, file);
        } else if (PDBFileFilter.isPDB(file)) {
            this.saveAsPDB(assembly, file);
        }
    }

    @Override
    public void saveAsXYZinP1(MolecularAssembly assembly, File file) {
        if (assembly == null) {
            logger.info(" Assembly to save was null.");
        } else if (file == null) {
            logger.info(" No valid file provided to save assembly to.");
        } else {
            String spacegroup;
            double gamma;
            double beta;
            double alpha;
            double c;
            double b;
            XYZFilter filter = new XYZFilter(file, assembly, null, null);
            ForceField forceField = assembly.getForceField();
            double a = forceField.getDouble("A_AXIS", 10.0);
            Crystal crystal = new Crystal(a, b = forceField.getDouble("B_AXIS", a), c = forceField.getDouble("C_AXIS", a), alpha = forceField.getDouble("ALPHA", 90.0), beta = forceField.getDouble("BETA", 90.0), gamma = forceField.getDouble("GAMMA", 90.0), spacegroup = forceField.getString("SPACEGROUP", "P1"));
            if (!filter.writeFileAsP1(file, false, crystal)) {
                logger.info(String.format(" Save failed for %s", assembly));
            }
            this.lastFilter = filter;
        }
    }

    @Override
    public void saveAsXYZasReplicates(MolecularAssembly assembly, File file, int[] lmn) {
        if (assembly == null) {
            logger.info(" Assembly to save was null.");
        } else if (file == null) {
            logger.info(" No valid file provided to save assembly to.");
        } else {
            String spacegroup;
            double gamma;
            double beta;
            double alpha;
            double c;
            double b;
            XYZFilter filter = new XYZFilter(file, assembly, null, null);
            ForceField forceField = assembly.getForceField();
            double a = forceField.getDouble("A_AXIS", 10.0);
            Crystal crystal = new Crystal(a, b = forceField.getDouble("B_AXIS", a), c = forceField.getDouble("C_AXIS", a), alpha = forceField.getDouble("ALPHA", 90.0), beta = forceField.getDouble("BETA", 90.0), gamma = forceField.getDouble("GAMMA", 90.0), spacegroup = forceField.getString("SPACEGROUP", "P1"));
            if (!filter.writeFileAsP1(file, false, crystal, lmn, null)) {
                logger.info(String.format(" Save failed for %s", assembly));
            }
            this.lastFilter = filter;
        }
    }

    @Override
    public void saveAsPDB(MolecularAssembly assembly, File file) {
        this.saveAsPDB(assembly, file, true, false);
    }

    @Override
    public void saveAsPDB(MolecularAssembly assembly, File file, boolean writeEnd, boolean append) {
        if (assembly == null) {
            logger.info(" Assembly to save was null.");
        } else if (file == null) {
            logger.info(" No valid file provided to save assembly to.");
        } else {
            PDBFilter pdbFilter = new PDBFilter(file, assembly, assembly.getForceField(), assembly.getProperties());
            if (!pdbFilter.writeFile(file, append, false, writeEnd)) {
                logger.info(String.format(" Save failed for %s", assembly));
            }
            this.lastFilter = pdbFilter;
        }
    }

    @Override
    public void saveAsPDB(MolecularAssembly[] assemblies, File file) {
        if (assemblies == null) {
            logger.info(" Null array of molecular assemblies to write.");
        } else if (assemblies.length == 0) {
            logger.info(" Zero-length array of molecular assemblies to write.");
        } else if (file == null) {
            logger.info(" No valid file to write to.");
        } else {
            ForceField forceField = assemblies[0].getForceField();
            CompositeConfiguration properties = forceField.getProperties();
            PDBFilter pdbFilter = new PDBFilter(file, Arrays.asList(assemblies), forceField, properties);
            pdbFilter.writeFile(file, false);
            this.lastFilter = pdbFilter;
        }
    }

    @Override
    public void saveAsXYZ(MolecularAssembly assembly, File file) {
        if (assembly == null) {
            logger.info(" Assembly to save was null.");
        } else if (file == null) {
            logger.info(" No valid file provided to save assembly to.");
        } else {
            CompositeConfiguration properties;
            ForceField forceField = assembly.getForceField();
            XYZFilter xyzFilter = new XYZFilter(file, assembly, forceField, properties = forceField.getProperties());
            if (!xyzFilter.writeFile(file, false)) {
                logger.info(String.format(" Save failed for %s", assembly));
            }
            this.lastFilter = xyzFilter;
        }
    }

    @Override
    public void saveAsPDBinP1(MolecularAssembly assembly, File file) {
        this.saveAsPDBinP1(assembly, file, null);
    }

    public void saveAsPDBinP1(MolecularAssembly assembly, File file, int[] lmn) {
        if (assembly == null) {
            logger.info(" Assembly to save was null.");
        } else if (file == null) {
            logger.info(" No valid file provided to save assembly to.");
        } else {
            ForceField forceField = assembly.getForceField();
            CompositeConfiguration properties = forceField.getProperties();
            PDBFilter pdbFilter = new PDBFilter(file, assembly, forceField, properties);
            pdbFilter.setLMN(lmn);
            this.lastFilter = pdbFilter;
            pdbFilter.writeFileAsP1(file);
        }
    }

    @Override
    public double time() {
        long currTime = System.nanoTime();
        logger.info(String.format(" Time since interface established: %f", (double)(currTime - this.initTime) * 1.0E-9));
        double elapsed = (double)(currTime - this.interTime) * 1.0E-9;
        this.interTime = currTime;
        logger.info(String.format(" Time since last timer call: %f", elapsed));
        return elapsed;
    }

    void setSilentPotential(boolean silent) {
        if (silent && potLog.isLoggable(Level.INFO) && levelBak == null) {
            levelBak = potLog.getLevel();
            potLog.setLevel(Level.WARNING);
        }
        if (!silent && levelBak != null) {
            potLog.setLevel(levelBak);
            levelBak = null;
        }
    }
}

