/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Polymer;
import ffx.potential.bonded.Residue;
import ffx.potential.utils.LoopClosure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;

public class Loop {
    private static final Logger logger = Logger.getLogger(Loop.class.getName());
    private final LoopClosure loopClosure;
    private final MolecularAssembly molecularAssembly;
    private final Random random = new Random();
    private static final int MAX_SOLUTIONS = 16;
    private final double[][] rN = new double[3][3];
    private final double[][] rA = new double[3][3];
    private final double[][] rC = new double[3][3];
    private double[][] altCoords;
    private boolean useAltCoords = false;

    public Loop(MolecularAssembly molecularAssembly, int firstResidue, int endResidue) {
        this.loopClosure = new LoopClosure();
        this.molecularAssembly = molecularAssembly;
        this.generateLoops(firstResidue, endResidue);
    }

    public Loop(MolecularAssembly molecularAssembly) {
        this.loopClosure = new LoopClosure();
        this.molecularAssembly = molecularAssembly;
        this.altCoords = new double[molecularAssembly.getAtomArray().length][3];
    }

    public List<double[]> generateLoops(int firstResidue, int endResidue, double[] coordinates) {
        this.setAltCoordinates(coordinates);
        return this.generateLoops(firstResidue, endResidue);
    }

    public List<double[]> generateLoops(int firstResidue, int endResidue) {
        Atom atom;
        int resID;
        List<Atom> backBoneAtoms = this.molecularAssembly.getBackBoneAtoms();
        ArrayList<double[]> solutions = new ArrayList<double[]>();
        logger.info(String.format(" First residue:   %d\n", firstResidue));
        logger.info(String.format(" Ending residue:  %d\n", endResidue));
        Iterator<Atom> iterator = backBoneAtoms.iterator();
        while (iterator.hasNext() && (resID = (atom = iterator.next()).getResidueNumber()) <= endResidue) {
            if (resID < firstResidue) continue;
            int ir = resID - firstResidue;
            double[] initArray = this.useAltCoords ? this.altCoords[atom.getIndex() - 1] : atom.getXYZ(null);
            switch (atom.getAtomType().name) {
                case "C": {
                    this.rC[ir][0] = initArray[0];
                    this.rC[ir][1] = initArray[1];
                    this.rC[ir][2] = initArray[2];
                    break;
                }
                case "CA": {
                    this.rA[ir][0] = initArray[0];
                    this.rA[ir][1] = initArray[1];
                    this.rA[ir][2] = initArray[2];
                    break;
                }
                case "N": {
                    this.rN[ir][0] = initArray[0];
                    this.rN[ir][1] = initArray[1];
                    this.rN[ir][2] = initArray[2];
                }
            }
        }
        double[][][] rSolnN = new double[16][3][3];
        double[][][] rSolnA = new double[16][3][3];
        double[][][] rSolnC = new double[16][3][3];
        int numSolutions = this.loopClosure.solve3PepPoly(this.rN[0], this.rA[0], this.rA[2], this.rC[2], rSolnN, rSolnA, rSolnC);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(" First residue:                %d\n", firstResidue));
        sb.append(String.format(" Ending residue:               %d\n", endResidue));
        sb.append(String.format(" Number of solutions:          %d\n", numSolutions));
        logger.info(sb.toString());
        for (int k = 0; k < numSolutions; ++k) {
            solutions.add(this.getSolutionCoordinates(k, rSolnN, rSolnA, rSolnC, firstResidue, endResidue));
        }
        return solutions;
    }

    public double[][] getRA() {
        return this.rA;
    }

    public double[][] getRC() {
        return this.rC;
    }

    public double[][] getRN() {
        return this.rN;
    }

    private double[] getSolutionCoordinates(int k, double[][][] rSolnN, double[][][] rSolnA, double[][][] rSolnC, int startResidue, int endResidue) {
        int i;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                this.rN[i2][j] = rSolnN[k][i2][j];
                this.rA[i2][j] = rSolnA[k][i2][j];
                this.rC[i2][j] = rSolnC[k][i2][j];
            }
        }
        Polymer[] newChain = this.molecularAssembly.getChains();
        Atom[] atomArray = this.molecularAssembly.getAtomArray();
        double[][] coordsArray = new double[atomArray.length][3];
        if (this.useAltCoords) {
            System.arraycopy(this.altCoords, 0, coordsArray, 0, coordsArray.length);
        } else {
            for (i = 0; i < atomArray.length; ++i) {
                Atom a = atomArray[i];
                coordsArray[i][0] = a.getX();
                coordsArray[i][1] = a.getY();
                coordsArray[i][2] = a.getZ();
            }
        }
        for (i = startResidue; i <= endResidue; ++i) {
            int index;
            Residue newResidue = newChain[0].getResidue(i);
            List<Atom> backBoneAtoms = newResidue.getBackboneAtoms();
            double[] cOffset = new double[3];
            double[] nOffset = new double[3];
            double[] aOffset = new double[3];
            for (Atom backBoneAtom : backBoneAtoms) {
                index = backBoneAtom.getIndex() - 1;
                switch (backBoneAtom.getAtomType().name) {
                    case "C": {
                        cOffset[0] = this.rC[i - startResidue][0] - coordsArray[index][0];
                        cOffset[1] = this.rC[i - startResidue][1] - coordsArray[index][1];
                        cOffset[2] = this.rC[i - startResidue][2] - coordsArray[index][2];
                        System.arraycopy(this.rC[i - startResidue], 0, coordsArray[index], 0, 3);
                        break;
                    }
                    case "N": {
                        nOffset[0] = this.rN[i - startResidue][0] - coordsArray[index][0];
                        nOffset[1] = this.rN[i - startResidue][1] - coordsArray[index][1];
                        nOffset[2] = this.rN[i - startResidue][2] - coordsArray[index][2];
                        System.arraycopy(this.rN[i - startResidue], 0, coordsArray[index], 0, 3);
                        break;
                    }
                    case "CA": {
                        aOffset[0] = this.rA[i - startResidue][0] - coordsArray[index][0];
                        aOffset[1] = this.rA[i - startResidue][1] - coordsArray[index][1];
                        aOffset[2] = this.rA[i - startResidue][2] - coordsArray[index][2];
                        System.arraycopy(this.rA[i - startResidue], 0, coordsArray[index], 0, 3);
                        break;
                    }
                }
            }
            block27: for (Atom backBoneAtom : backBoneAtoms) {
                index = backBoneAtom.getIndex() - 1;
                switch (backBoneAtom.getAtomType().name) {
                    case "C": 
                    case "N": 
                    case "CA": {
                        continue block27;
                    }
                    case "O": {
                        double[] dArray = coordsArray[index];
                        dArray[0] = dArray[0] + cOffset[0];
                        double[] dArray2 = coordsArray[index];
                        dArray2[1] = dArray2[1] + cOffset[1];
                        double[] dArray3 = coordsArray[index];
                        dArray3[2] = dArray3[2] + cOffset[2];
                        continue block27;
                    }
                    case "H": {
                        double[] dArray = coordsArray[index];
                        dArray[0] = dArray[0] + nOffset[0];
                        double[] dArray4 = coordsArray[index];
                        dArray4[1] = dArray4[1] + nOffset[1];
                        double[] dArray5 = coordsArray[index];
                        dArray5[2] = dArray5[2] + nOffset[2];
                        continue block27;
                    }
                }
                double[] dArray = coordsArray[index];
                dArray[0] = dArray[0] + aOffset[0];
                double[] dArray6 = coordsArray[index];
                dArray6[1] = dArray6[1] + aOffset[1];
                double[] dArray7 = coordsArray[index];
                dArray7[2] = dArray7[2] + aOffset[2];
            }
            for (Atom sideChainAtom : newResidue.getSideChainAtoms()) {
                index = sideChainAtom.getIndex() - 1;
                double[] dArray = coordsArray[index];
                dArray[0] = dArray[0] + aOffset[0];
                double[] dArray8 = coordsArray[index];
                dArray8[1] = dArray8[1] + aOffset[1];
                double[] dArray9 = coordsArray[index];
                dArray9[2] = dArray9[2] + aOffset[2];
            }
        }
        double[] coordsArray1D = new double[atomArray.length * 3];
        for (int i3 = 0; i3 < atomArray.length; ++i3) {
            System.arraycopy(coordsArray[i3], 0, coordsArray1D, i3 * 3, 3);
        }
        return coordsArray1D;
    }

    private void setAltCoordinates(double[] coordinates) {
        for (int i = 0; i < coordinates.length / 3; ++i) {
            System.arraycopy(coordinates, i * 3, this.altCoords[i], 0, 3);
        }
        this.useAltCoords = true;
    }

    private double[][] fillCoordsArray(Atom atom, double[][] coordsArray, double[] determinedXYZ) {
        int XYZIndex = atom.getIndex() - 1;
        coordsArray[XYZIndex][0] = determinedXYZ[0];
        coordsArray[XYZIndex][1] = determinedXYZ[1];
        coordsArray[XYZIndex][2] = determinedXYZ[2];
        return coordsArray;
    }
}

