/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.numerics.Potential;
import ffx.potential.cli.GradientOptions;
import ffx.utilities.StringUtils;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class GradientUtils {
    private static final Logger logger = Logger.getLogger(GradientUtils.class.getName());
    private final Potential potential;

    public GradientUtils(Potential potential) {
        this.potential = potential;
    }

    public int testGradient(GradientOptions gradientOptions) {
        ArrayList<Integer> degreesOfFreedomToTest;
        int nFailures = 0;
        double step = gradientOptions.getDx();
        logger.info(" Finite-difference step size:\t" + step);
        boolean print = gradientOptions.getVerbose();
        logger.info(" Verbose printing:\t\t" + print);
        int nAtoms = this.potential.getNumberOfVariables() / 3;
        String gradientAtoms = gradientOptions.getGradientAtoms();
        if (gradientAtoms.equalsIgnoreCase("NONE")) {
            logger.info(" The gradient of no atoms was evaluated.");
            return nFailures;
        }
        if (gradientAtoms.equalsIgnoreCase("ALL")) {
            logger.info(" Checking gradient for all atoms.\n");
            degreesOfFreedomToTest = new ArrayList<Integer>();
            for (int i = 0; i < nAtoms; ++i) {
                degreesOfFreedomToTest.add(i);
            }
        } else {
            degreesOfFreedomToTest = StringUtils.parseAtomRanges((String)" Gradient atoms", (String)gradientAtoms, (int)nAtoms);
            logger.info(" Checking gradient for atoms in the range: " + gradientAtoms + "\n");
        }
        int n = this.potential.getNumberOfVariables();
        double[] x = new double[n];
        double[] g = new double[n];
        this.potential.getCoordinates(x);
        this.potential.energyAndGradient(x, g);
        double expGrad = 1000.0;
        double gradientTolerance = gradientOptions.getTolerance();
        double width = 2.0 * step;
        double avLen = 0.0;
        double avGrad = 0.0;
        double expGrad2 = expGrad * expGrad;
        int nTested = 0;
        int index = 0;
        double[] numeric = new double[3];
        for (int k = 0; k < nAtoms; ++k) {
            int i0 = index++;
            int i1 = index++;
            int i2 = index++;
            if (!degreesOfFreedomToTest.contains(k)) continue;
            ++nTested;
            double orig = x[i0];
            x[i0] = x[i0] + step;
            double e = this.potential.energy(x);
            x[i0] = orig - step;
            x[i0] = orig;
            numeric[0] = (e -= this.potential.energy(x)) / width;
            orig = x[i1];
            x[i1] = x[i1] + step;
            e = this.potential.energy(x);
            x[i1] = orig - step;
            x[i1] = orig;
            numeric[1] = (e -= this.potential.energy(x)) / width;
            orig = x[i2];
            x[i2] = x[i2] + step;
            e = this.potential.energy(x);
            x[i2] = orig - step;
            x[i2] = orig;
            numeric[2] = (e -= this.potential.energy(x)) / width;
            double dx = g[i0] - numeric[0];
            double dy = g[i1] - numeric[1];
            double dz = g[i2] - numeric[2];
            double len = dx * dx + dy * dy + dz * dz;
            avLen += len;
            len = FastMath.sqrt((double)len);
            double grad2 = g[i0] * g[i0] + g[i1] * g[i1] + g[i2] * g[i2];
            avGrad += grad2;
            if (len > gradientTolerance) {
                logger.info(String.format(" Atom %d\n Failed: %10.6f\n", k + 1, len) + String.format(" Analytic: (%12.4f, %12.4f, %12.4f)\n", g[i0], g[i1], g[i2]) + String.format(" Numeric:  (%12.4f, %12.4f, %12.4f)", numeric[0], numeric[1], numeric[2]));
                ++nFailures;
            } else {
                logger.info(String.format(" Atom %d\n Passed: %10.6f\n", k + 1, len) + String.format(" Analytic: (%12.4f, %12.4f, %12.4f)\n", g[i0], g[i1], g[i2]) + String.format(" Numeric:  (%12.4f, %12.4f, %12.4f)", numeric[0], numeric[1], numeric[2]));
            }
            if (grad2 > expGrad2) {
                logger.info(String.format(" Atom %d has an unusually large gradient: %10.6f", k + 1, Math.sqrt(grad2)));
            }
            logger.info("\n");
        }
        avLen /= (double)nTested;
        if ((avLen = FastMath.sqrt((double)avLen)) > gradientTolerance) {
            logger.info(String.format(" Test failure: RMSD from analytic solution is %10.6f > %10.6f", avLen, gradientTolerance));
        } else {
            logger.info(String.format(" Test success: RMSD from analytic solution is %10.6f < %10.6f", avLen, gradientTolerance));
        }
        logger.info(String.format(" Number of atoms failing analytic test: %d", nFailures));
        avGrad /= (double)nTested;
        avGrad = FastMath.sqrt((double)avGrad);
        if (avGrad > expGrad) {
            logger.info(String.format(" Unusually large RMS gradient: %10.6f > %10.6f", avGrad, expGrad));
        } else {
            logger.info(String.format(" RMS gradient: %10.6f", avGrad));
        }
        return nFailures;
    }
}

