/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.TorsionTorsion;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class TorsionTorsionPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(TorsionTorsionPotentialEnergy.class.getName());
    private final List<TorsionTorsion> torsionTorsions = new ArrayList<TorsionTorsion>();

    public TorsionTorsionPotentialEnergy(String name) {
        super(name);
    }

    public TorsionTorsionPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public TorsionTorsionPotentialEnergy(String name, int forceGroup, List<TorsionTorsion> torsionTorsions) {
        super(name, forceGroup);
        if (torsionTorsions != null) {
            Collections.sort(torsionTorsions);
            this.torsionTorsions.addAll(torsionTorsions);
            logger.info(String.format("  Torsion-Torsions:                  %10d", this.getNumberOfTorsionTorsions()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfTorsionTorsions();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getTorsionTorsionArray();
    }

    public TorsionTorsionPotentialEnergy(String name, Collection<TorsionTorsion> torsionTorsions) {
        super(name);
        if (torsionTorsions != null) {
            this.torsionTorsions.addAll(torsionTorsions);
        }
    }

    public boolean addTorsionTorsion(TorsionTorsion torsionTorsion) {
        if (torsionTorsion == null) {
            return false;
        }
        return this.torsionTorsions.add(torsionTorsion);
    }

    public boolean addTorsionTorsions(TorsionTorsion[] torsionTorsions) {
        if (torsionTorsions == null) {
            return false;
        }
        Collections.addAll(this.torsionTorsions, torsionTorsions);
        return true;
    }

    public boolean addTorsionTorsions(List<TorsionTorsion> torsionTorsions) {
        if (torsionTorsions == null) {
            return false;
        }
        this.torsionTorsions.addAll(torsionTorsions);
        return true;
    }

    public boolean removeTorsionTorsion(TorsionTorsion torsionTorsion) {
        if (torsionTorsion == null) {
            return false;
        }
        return this.torsionTorsions.remove(torsionTorsion);
    }

    public TorsionTorsion getTorsionTorsion(int index) {
        return this.torsionTorsions.get(index);
    }

    public List<TorsionTorsion> getTorsionTorsions() {
        return Collections.unmodifiableList(this.torsionTorsions);
    }

    public TorsionTorsion[] getTorsionTorsionArray() {
        return this.torsionTorsions.toArray(new TorsionTorsion[0]);
    }

    public int getNumberOfTorsionTorsions() {
        return this.torsionTorsions.size();
    }

    public void setLambda(double lambda) {
        for (TorsionTorsion torsionTorsion : this.torsionTorsions) {
            torsionTorsion.setLambda(lambda);
        }
    }

    public double getdEdL() {
        double dEdL = 0.0;
        for (TorsionTorsion torsionTorsion : this.torsionTorsions) {
            dEdL += torsionTorsion.getdEdL();
        }
        return dEdL;
    }

    public double getd2EdL2() {
        double d2EdLambda2 = 0.0;
        for (TorsionTorsion torsionTorsion : this.torsionTorsions) {
            d2EdLambda2 += torsionTorsion.getd2EdL2();
        }
        return d2EdLambda2;
    }

    @Override
    public void log() {
        if (this.getNumberOfTorsionTorsions() <= 0) {
            return;
        }
        logger.info("\n Torsion-Torsion Interactions:");
        for (TorsionTorsion torsionTorsion : this.getTorsionTorsions()) {
            logger.info(" Torsion-Torsion \t" + torsionTorsion.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfTorsionTorsions() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "TORSION-TORSION            : ", this.getEnergy(), this.getNumberOfTorsionTorsions());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Torsion-Torsion   ", this.getEnergy(), this.getNumberOfTorsionTorsions(), this.getTime());
    }
}

