/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.Torsion;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.TorsionType;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;

public class RestrainTorsionPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(RestrainTorsionPotentialEnergy.class.getName());
    private final List<Torsion> restrainTorsions = new ArrayList<Torsion>();

    public RestrainTorsionPotentialEnergy(String name) {
        super(name);
    }

    public RestrainTorsionPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public RestrainTorsionPotentialEnergy(String name, int forceGroup, List<Torsion> restrainTorsions) {
        super(name, forceGroup);
        if (restrainTorsions != null) {
            Collections.sort(restrainTorsions);
            this.restrainTorsions.addAll(restrainTorsions);
            logger.info(String.format("  Restrain Torsions:                   %10d", this.getNumberOfRestrainTorsions()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfRestrainTorsions();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getRestrainTorsionArray();
    }

    public RestrainTorsionPotentialEnergy(String name, Collection<Torsion> restrainTorsions) {
        super(name);
        if (restrainTorsions != null) {
            this.restrainTorsions.addAll(restrainTorsions);
        }
    }

    public boolean addRestrainTorsion(Torsion torsion) {
        if (torsion == null) {
            return false;
        }
        return this.restrainTorsions.add(torsion);
    }

    public boolean addRestrainTorsions(Torsion[] torsions) {
        if (torsions == null) {
            return false;
        }
        Collections.addAll(this.restrainTorsions, torsions);
        return true;
    }

    public boolean addRestrainTorsions(List<Torsion> torsions) {
        if (torsions == null) {
            return false;
        }
        this.restrainTorsions.addAll(torsions);
        return true;
    }

    public boolean removeRestrainTorsion(Torsion torsion) {
        if (torsion == null) {
            return false;
        }
        return this.restrainTorsions.remove(torsion);
    }

    public Torsion getRestrainTorsion(int index) {
        return this.restrainTorsions.get(index);
    }

    public List<Torsion> getRestrainTorsions() {
        return Collections.unmodifiableList(this.restrainTorsions);
    }

    public Torsion[] getRestrainTorsionArray() {
        return this.restrainTorsions.toArray(new Torsion[0]);
    }

    public int getNumberOfRestrainTorsions() {
        return this.restrainTorsions.size();
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfRestrainTorsions() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "RESTRAIN TORSION           : ", this.getEnergy(), this.getNumberOfRestrainTorsions());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Restrain Torsion  ", this.getEnergy(), this.getNumberOfRestrainTorsions(), this.getTime());
    }

    @Override
    public void log() {
        if (this.getNumberOfRestrainTorsions() <= 0) {
            return;
        }
        logger.info("\n Restrain Torsion Interactions:");
        for (Torsion torsion : this.getRestrainTorsions()) {
            logger.info(" Restrain Torsion \t" + torsion.toString());
        }
    }

    public static Torsion[] configureRestrainTorsions(CompositeConfiguration properties, ForceField forceField, Atom[] atoms, Torsion[] torsions) {
        StringBuilder restrainLog = new StringBuilder("\n  Restrain-Torsions");
        String[] restrainTorsions = properties.getStringArray("restrain-torsion");
        double torsionUnits = forceField.getDouble("TORSIONUNIT", 1.0);
        ArrayList<Torsion> restrainTorsionList = new ArrayList<Torsion>(restrainTorsions.length);
        for (String string : restrainTorsions) {
            String string2 = "restrain-torsion " + string;
            String input = string2.split("#+")[0];
            String[] tokens = input.trim().split(" +");
            TorsionType torsionType = TorsionType.parse(input, tokens);
            torsionType.torsionUnit = torsionUnits;
            int[] atomIndices = torsionType.atomClasses;
            int ai1 = atomIndices[0] - 1;
            int ai2 = atomIndices[1] - 1;
            int ai3 = atomIndices[2] - 1;
            int ai4 = atomIndices[3] - 1;
            Atom a1 = atoms[ai1];
            Atom a2 = atoms[ai2];
            Atom a3 = atoms[ai3];
            Atom a4 = atoms[ai4];
            Bond firstBond = a1.getBond(a2);
            Bond middleBond = a2.getBond(a3);
            Bond lastBond = a3.getBond(a4);
            Torsion torsion = new Torsion(firstBond, middleBond, lastBond);
            torsion.setTorsionType(torsionType);
            restrainTorsionList.add(torsion);
            restrainLog.append("\n   ").append(torsion);
        }
        restrainTorsionList.addAll(RestrainTorsionPotentialEnergy.restrainAllTorsions(torsions, properties));
        if (!restrainTorsionList.isEmpty()) {
            logger.info(restrainLog.toString());
            return restrainTorsionList.toArray(new Torsion[0]);
        }
        return null;
    }

    private static List<Torsion> restrainAllTorsions(Torsion[] torsions, CompositeConfiguration properties) {
        String restrainTorsions;
        ArrayList<Torsion> restrainTorsionList = new ArrayList<Torsion>();
        boolean noHydrogenTorsions = false;
        if (properties.containsKey("restrain-all-torsions")) {
            restrainTorsions = properties.getString("restrain-all-torsions");
        } else if (properties.containsKey("restrain-heavy-torsions")) {
            restrainTorsions = properties.getString("restrain-heavy-torsions");
            noHydrogenTorsions = true;
        } else {
            return restrainTorsionList;
        }
        logger.info(" Restrain torsions " + restrainTorsions);
        String input = restrainTorsions.split("#+")[0];
        String[] tokens = input.trim().split(" +");
        double forceConstant = Double.parseDouble(tokens[0]);
        logger.info(" Force constant %10.6f".formatted(forceConstant));
        for (Torsion torsion : torsions) {
            if (noHydrogenTorsions && torsion.containsHydrogen()) continue;
            TorsionType torsionType = torsion.torsionType;
            int[] atomClasses = (int[])torsionType.atomClasses.clone();
            double[] amplitude = new double[]{forceConstant};
            double[] phase = new double[]{torsion.measure() + 180.0};
            int[] periodicity = new int[]{1};
            TorsionType newTorsionType = new TorsionType(atomClasses, amplitude, phase, periodicity);
            newTorsionType.torsionUnit = torsionType.torsionUnit;
            Bond b1 = torsion.getBond(0);
            Bond b2 = torsion.getBond(1);
            Bond b3 = torsion.getBond(2);
            Torsion newTorsion = new Torsion(b1, b2, b3);
            newTorsion.setTorsionType(newTorsionType);
            restrainTorsionList.add(newTorsion);
        }
        return restrainTorsionList;
    }
}

