/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.RestrainPosition;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class RestrainPositionPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(RestrainPositionPotentialEnergy.class.getName());
    private final List<RestrainPosition> restrainPositions = new ArrayList<RestrainPosition>();

    public RestrainPositionPotentialEnergy(String name) {
        super(name);
    }

    public RestrainPositionPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public RestrainPositionPotentialEnergy(String name, int forceGroup, List<RestrainPosition> restrainPositions) {
        super(name, forceGroup);
        if (restrainPositions != null) {
            Collections.sort(restrainPositions);
            this.restrainPositions.addAll(restrainPositions);
            logger.info(String.format("  Restrain Positions:                 %10d", this.getNumberOfRestrainPositions()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfRestrainPositions();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getRestrainPositionArray();
    }

    public RestrainPositionPotentialEnergy(String name, Collection<RestrainPosition> restrainPositions) {
        super(name);
        if (restrainPositions != null) {
            this.restrainPositions.addAll(restrainPositions);
        }
    }

    public boolean addRestrainPosition(RestrainPosition restrainPosition) {
        if (restrainPosition == null) {
            return false;
        }
        return this.restrainPositions.add(restrainPosition);
    }

    public boolean addRestrainPositions(RestrainPosition[] restrainPositions) {
        if (restrainPositions == null) {
            return false;
        }
        Collections.addAll(this.restrainPositions, restrainPositions);
        return true;
    }

    public boolean addRestrainPositions(List<RestrainPosition> restrainPositions) {
        if (restrainPositions == null) {
            return false;
        }
        this.restrainPositions.addAll(restrainPositions);
        return true;
    }

    public boolean removeRestrainPosition(RestrainPosition restrainPosition) {
        if (restrainPosition == null) {
            return false;
        }
        return this.restrainPositions.remove(restrainPosition);
    }

    public RestrainPosition getRestrainPosition(int index) {
        return this.restrainPositions.get(index);
    }

    public List<RestrainPosition> getRestrainPositions() {
        return Collections.unmodifiableList(this.restrainPositions);
    }

    public RestrainPosition[] getRestrainPositionArray() {
        return this.restrainPositions.toArray(new RestrainPosition[0]);
    }

    public int getNumberOfRestrainPositions() {
        return this.restrainPositions.size();
    }

    public static String getRestrainPositionEnergyString() {
        return "k0*periodicdistance(x,y,z,x0,y0,z0)^2";
    }

    @Override
    public void log() {
        if (this.getNumberOfRestrainPositions() <= 0) {
            return;
        }
        logger.info("\n Restrain Position Interactions:");
        for (RestrainPosition restrainPosition : this.getRestrainPositions()) {
            logger.info(" Restrain Position \t" + restrainPosition.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfRestrainPositions() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "COORDINATE RESTRAINTS      : ", this.getEnergy(), this.getNumberOfRestrainPositions());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Restrain Position ", this.getEnergy(), this.getNumberOfRestrainPositions(), this.getTime());
    }
}

