/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.AngleTorsion;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class AngleTorsionPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(AngleTorsionPotentialEnergy.class.getName());
    private final List<AngleTorsion> angleTorsions = new ArrayList<AngleTorsion>();

    public AngleTorsionPotentialEnergy(String name) {
        super(name);
    }

    public AngleTorsionPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public AngleTorsionPotentialEnergy(String name, int forceGroup, List<AngleTorsion> angleTorsions) {
        super(name, forceGroup);
        if (angleTorsions != null) {
            Collections.sort(angleTorsions);
            this.angleTorsions.addAll(angleTorsions);
            logger.info(String.format("  Angle-Torsions:                    %10d", this.getNumberOfAngleTorsions()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfAngleTorsions();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getAngleTorsionArray();
    }

    public AngleTorsionPotentialEnergy(String name, Collection<AngleTorsion> angleTorsions) {
        super(name);
        if (angleTorsions != null) {
            this.angleTorsions.addAll(angleTorsions);
        }
    }

    public boolean addAngleTorsion(AngleTorsion angleTorsion) {
        if (angleTorsion == null) {
            return false;
        }
        return this.angleTorsions.add(angleTorsion);
    }

    public boolean addAngleTorsions(AngleTorsion[] angleTorsions) {
        if (angleTorsions == null) {
            return false;
        }
        Collections.addAll(this.angleTorsions, angleTorsions);
        return true;
    }

    public boolean addAngleTorsions(List<AngleTorsion> angleTorsions) {
        if (angleTorsions == null) {
            return false;
        }
        this.angleTorsions.addAll(angleTorsions);
        return true;
    }

    public boolean removeAngleTorsion(AngleTorsion angleTorsion) {
        if (angleTorsion == null) {
            return false;
        }
        return this.angleTorsions.remove(angleTorsion);
    }

    public AngleTorsion getAngleTorsion(int index) {
        return this.angleTorsions.get(index);
    }

    public List<AngleTorsion> getAngleTorsions() {
        return Collections.unmodifiableList(this.angleTorsions);
    }

    public AngleTorsion[] getAngleTorsionArray() {
        return this.angleTorsions.toArray(new AngleTorsion[0]);
    }

    public int getNumberOfAngleTorsions() {
        return this.angleTorsions.size();
    }

    @Override
    public void log() {
        if (this.getNumberOfAngleTorsions() <= 0) {
            return;
        }
        logger.info("\n Angle-Torsion Interactions:");
        for (AngleTorsion angleTorsion : this.getAngleTorsions()) {
            logger.info(" Angle-Torsion \t" + angleTorsion.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfAngleTorsions() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "ANGLE-TORSION              : ", this.getEnergy(), this.getNumberOfAngleTorsions());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Angle-Torsion     ", this.getEnergy(), this.getNumberOfAngleTorsions(), this.getTime());
    }
}

