/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.Angle;
import ffx.potential.bonded.BondedTerm;
import ffx.potential.parameters.AngleType;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class AnglePotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(AnglePotentialEnergy.class.getName());
    private final List<Angle> angles = new ArrayList<Angle>();

    public AnglePotentialEnergy(String name) {
        super(name);
    }

    public AnglePotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public AnglePotentialEnergy(String name, int forceGroup, List<Angle> angles) {
        super(name, forceGroup);
        if (angles != null) {
            Collections.sort(angles);
            this.angles.addAll(angles);
            logger.info(String.format("  Angles:                            %10d", this.getNumberOfAngles()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfAngles();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getAngleArray();
    }

    public AnglePotentialEnergy(String name, Collection<Angle> angles) {
        super(name);
        if (angles != null) {
            this.angles.addAll(angles);
        }
    }

    public boolean addAngle(Angle angle) {
        if (angle == null) {
            return false;
        }
        return this.angles.add(angle);
    }

    public boolean addAngles(Angle[] angles) {
        if (angles == null) {
            return false;
        }
        Collections.addAll(this.angles, angles);
        return true;
    }

    public boolean addAngles(List<Angle> angles) {
        if (angles == null) {
            return false;
        }
        this.angles.addAll(angles);
        return true;
    }

    public boolean removeAngle(Angle angle) {
        if (angle == null) {
            return false;
        }
        return this.angles.remove(angle);
    }

    public Angle getAngle(int index) {
        return this.angles.get(index);
    }

    public List<Angle> getAngles() {
        return Collections.unmodifiableList(this.angles);
    }

    public Angle[] getAngleArray() {
        return this.angles.toArray(new Angle[0]);
    }

    public int getNumberOfAngles() {
        return this.angles.size();
    }

    public String getAngleEnergyString() {
        AngleType angleType = this.angles.getFirst().angleType;
        String energy = angleType.angleFunction == AngleType.AngleFunction.SEXTIC ? String.format("k*(d^2 + %.15g*d^3 + %.15g*d^4 + %.15g*d^5 + %.15g*d^6);\nd=%.15g*theta-theta0;\n", angleType.cubic, angleType.quartic, angleType.pentic, angleType.sextic, 57.29577951308232) : String.format("k*(d^2);\nd=%.15g*theta-theta0;\n", 57.29577951308232);
        return energy;
    }

    public String getInPlaneAngleEnergyString() {
        AngleType angleType = this.angles.getFirst().angleType;
        String energy = String.format("k*(d^2 + %.15g*d^3 + %.15g*d^4 + %.15g*d^5 + %.15g*d^6);\nd=theta-theta0;\ntheta = %.15g*pointangle(x1, y1, z1, projx, projy, projz, x3, y3, z3);\nprojx = x2-nx*dot;\nprojy = y2-ny*dot;\nprojz = z2-nz*dot;\ndot = nx*(x2-x3) + ny*(y2-y3) + nz*(z2-z3);\nnx = px/norm;\nny = py/norm;\nnz = pz/norm;\nnorm = sqrt(px*px + py*py + pz*pz);\npx = (d1y*d2z-d1z*d2y);\npy = (d1z*d2x-d1x*d2z);\npz = (d1x*d2y-d1y*d2x);\nd1x = x1-x4;\nd1y = y1-y4;\nd1z = z1-z4;\nd2x = x3-x4;\nd2y = y3-y4;\nd2z = z3-z4;\n", angleType.cubic, angleType.quartic, angleType.pentic, angleType.sextic, 57.29577951308232);
        return energy;
    }

    @Override
    public void log() {
        if (this.getNumberOfAngles() <= 0) {
            return;
        }
        logger.info("\n Angle Bending Interactions:");
        for (Angle angle : this.getAngles()) {
            logger.info(" Angle \t" + angle.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfAngles() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("REMARK   3   %s %g (%d)\n", "ANGLE BENDING              : ", this.getEnergy(), this.getNumberOfAngles()));
        sb.append(String.format("REMARK   3   %s %g\n", "ANGLE RMSD                 : ", this.getRMSD()));
        return sb.toString();
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f (%8.5f)\n", "Angle Bending     ", this.getEnergy(), this.getNumberOfAngles(), this.getTime(), this.getRMSD());
    }
}

