/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public final class XYZFileFilter
extends FileFilter {
    public static boolean isXYZ(File file) {
        return new XYZFileFilter().accept(file);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String ext = FilenameUtils.getExtension((String)file.getName());
        return ext.toUpperCase().startsWith("XYZ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acceptDeep(File file) {
        if (file == null) return false;
        if (file.isDirectory()) return false;
        if (!file.canRead()) {
            return false;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            if (!br.ready()) {
                boolean bl = false;
                return bl;
            }
            String rawdata = br.readLine();
            String[] header = rawdata.trim().split(" +");
            if (header.length == 0) {
                boolean bl = false;
                return bl;
            }
            try {
                Integer.parseInt(header[0]);
            }
            catch (Exception e) {
                boolean bl = false;
                br.close();
                return bl;
            }
            String firstAtom = br.readLine();
            if (firstAtom == null) {
                boolean bl = false;
                return bl;
            }
            String[] data = firstAtom.trim().split(" +");
            if (data.length < 6) {
                boolean bl = false;
                return bl;
            }
            try {
                Integer.parseInt(data[0]);
            }
            catch (NumberFormatException e) {
                try {
                    Double.parseDouble(data[0]);
                }
                catch (NumberFormatException e2) {
                    boolean bl = false;
                    br.close();
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public String getDescription() {
        return "TINKER Cartesian Coordinates (*.XYZ)";
    }
}

