/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.Residue;
import ffx.potential.extended.ExtendedSystem;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.SystemFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalDouble;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.jogamp.vecmath.Vector3d;

public class XPHFilter
extends SystemFilter {
    private static final Logger logger = Logger.getLogger(XPHFilter.class.getName());
    private BufferedReader bufferedReader = null;
    private int snapShot;
    private String remarkLine;
    private ExtendedSystem extendedSystem;
    private MolecularAssembly system = null;

    public XPHFilter(File file, MolecularAssembly system, ForceField forceField, CompositeConfiguration properties, ExtendedSystem esvSystem) {
        super(file, system, forceField, properties);
        this.fileType = Utilities.FileType.XPH;
        this.extendedSystem = esvSystem;
        this.system = system;
    }

    public XPHFilter(SystemFilter systemFilter, ExtendedSystem esvSystem) {
        super(systemFilter.getFile(), systemFilter.getActiveMolecularSystem(), systemFilter.getActiveMolecularSystem().getForceField(), systemFilter.getActiveMolecularSystem().getProperties());
        this.extendedSystem = esvSystem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readOnto(File newFile, MolecularAssembly oldSystem) {
        if (newFile == null) return false;
        if (!newFile.exists()) return false;
        if (oldSystem == null) {
            return false;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(newFile));){
            String data = br.readLine();
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            String[] tokens = data.trim().split(" +");
            int num_atoms = Integer.parseInt(tokens[0]);
            if (num_atoms != oldSystem.getAtomList().size()) {
                boolean bl = false;
                return bl;
            }
            br.mark(10000);
            data = br.readLine();
            if (!XPHFilter.readPBC(data, oldSystem)) {
                br.reset();
            }
            double[][] d = new double[num_atoms][3];
            for (int i = 0; i < num_atoms; ++i) {
                if (!br.ready()) {
                    boolean bl = false;
                    return bl;
                }
                data = br.readLine();
                if (data == null) {
                    logger.warning(String.format(" Check atom %d.", i + 1));
                    boolean bl = false;
                    return bl;
                }
                tokens = data.trim().split(" +");
                if (tokens.length < 6) {
                    logger.warning(String.format(" Check atom %d.", i + 1));
                    boolean bl = false;
                    return bl;
                }
                d[i][0] = Double.parseDouble(tokens[2]);
                d[i][1] = Double.parseDouble(tokens[3]);
                d[i][2] = Double.parseDouble(tokens[4]);
            }
            List<Atom> atoms = oldSystem.getAtomList();
            for (Atom a : atoms) {
                int index = a.getIndex() - 1;
                a.setXYZ(d[index]);
            }
            oldSystem.center();
            oldSystem.setFile(newFile);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean firstTokenIsInteger(String data) {
        if (data == null) {
            return false;
        }
        if ((data = data.trim()).equals("")) {
            return false;
        }
        try {
            String[] tokens = data.split(" +");
            Integer.parseInt(tokens[0]);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean readPBC(String data, MolecularAssembly activeMolecularAssembly) {
        if (XPHFilter.firstTokenIsInteger(data)) {
            return false;
        }
        String[] tokens = data.trim().split(" +");
        if (tokens.length == 6) {
            CompositeConfiguration config = activeMolecularAssembly.getProperties();
            double a = Double.parseDouble(tokens[0]);
            double b = Double.parseDouble(tokens[1]);
            double c = Double.parseDouble(tokens[2]);
            double alpha = Double.parseDouble(tokens[3]);
            double beta = Double.parseDouble(tokens[4]);
            double gamma = Double.parseDouble(tokens[5]);
            config.setProperty("a-axis", (Object)a);
            config.setProperty("b-axis", (Object)b);
            config.setProperty("c-axis", (Object)c);
            config.setProperty("alpha", (Object)alpha);
            config.setProperty("beta", (Object)beta);
            config.setProperty("gamma", (Object)gamma);
            Crystal crystal = activeMolecularAssembly.getCrystal();
            if (crystal != null) {
                crystal.changeUnitCellParameters(a, b, c, alpha, beta, gamma);
            }
        }
        return true;
    }

    @Override
    public void closeReader() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
            }
            catch (IOException ex) {
                logger.warning(String.format(" Exception in closing XYZ filter: %s", ex));
            }
        }
    }

    @Override
    public int countNumModels() {
        int n;
        File xphFile = this.currentFile;
        int nAtoms = this.activeMolecularAssembly.getAtomArray().length;
        Pattern crystInfoPattern = Pattern.compile("^ *(?:[0-9]+\\.[0-9]+ +){3}(?:-?[0-9]+\\.[0-9]+ +){2}(?:-?[0-9]+\\.[0-9]+) *$");
        BufferedReader br = new BufferedReader(new FileReader(xphFile));
        try {
            String line = br.readLine();
            int nSnaps = 0;
            while (line != null) {
                assert (Integer.parseInt(line.trim().split("\\s+")[0]) == nAtoms);
                line = br.readLine();
                Matcher m = crystInfoPattern.matcher(line);
                if (m.matches()) {
                    br.readLine();
                }
                for (int i = 1; i < nAtoms; ++i) {
                    br.readLine();
                }
                String data = br.readLine();
                while (data != null && data.trim().equals("")) {
                    data = br.readLine();
                }
                assert (data != null);
                if (data.contains("ESV")) {
                    while (data != null && !data.trim().equals("")) {
                        data = br.readLine();
                    }
                }
                ++nSnaps;
                line = br.readLine();
            }
            n = nSnaps;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, String.format(" Exception reading trajectory file %s: %s", xphFile, ex));
                return -1;
            }
        }
        br.close();
        return n;
    }

    @Override
    public OptionalDouble getLastReadLambda() {
        String[] toks = this.remarkLine.split("\\s+");
        int nToks = toks.length;
        for (int i = 0; i < nToks - 1; ++i) {
            if (!toks[i].equals("Lambda:")) continue;
            return OptionalDouble.of(Double.parseDouble(toks[i + 1]));
        }
        return OptionalDouble.empty();
    }

    @Override
    public String[] getRemarkLines() {
        return new String[]{this.remarkLine};
    }

    @Override
    public int getSnapshot() {
        return this.snapShot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean readFile() {
        File xphFile = this.activeMolecularAssembly.getFile();
        if (this.forceField == null) {
            logger.warning(String.format(" No force field is associated with %s.", xphFile.toString()));
            return false;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(xphFile));){
            block62: {
                int switchIndex;
                List<Residue> residueList;
                int[][] bonds;
                int numberOfAtoms;
                String[] tokens;
                String data;
                block61: {
                    data = br.readLine();
                    while (data != null && data.trim().equals("")) {
                        data = br.readLine();
                    }
                    if (data == null) {
                        boolean bl = false;
                        return bl;
                    }
                    tokens = data.trim().split(" +", 2);
                    numberOfAtoms = Integer.parseInt(tokens[0]);
                    if (numberOfAtoms < 1) {
                        boolean bl = false;
                        return bl;
                    }
                    if (tokens.length == 2) {
                        this.getActiveMolecularSystem().setName(tokens[1]);
                    }
                    logger.info(String.format(" Opening %s with %d atoms\n", xphFile.getName(), numberOfAtoms));
                    this.remarkLine = data.trim();
                    br.mark(10000);
                    data = br.readLine();
                    if (!XPHFilter.readPBC(data, this.activeMolecularAssembly)) {
                        br.reset();
                    }
                    HashMap<Integer, Integer> labelHash = new HashMap<Integer, Integer>();
                    int[] label = new int[numberOfAtoms];
                    bonds = new int[numberOfAtoms][8];
                    double[][] d = new double[numberOfAtoms][3];
                    boolean renumber = false;
                    this.atomList = new ArrayList();
                    int i = 0;
                    while (true) {
                        int numberOfBonds;
                        if (i < numberOfAtoms) {
                            if (!br.ready()) {
                                boolean bl = false;
                                return bl;
                            }
                            data = br.readLine();
                            if (data == null) {
                                logger.warning(String.format(" Check atom %d in %s.", i + 1, this.activeMolecularAssembly.getFile().getName()));
                                boolean bl = false;
                                return bl;
                            }
                            tokens = data.trim().split(" +");
                            if (tokens.length < 6) {
                                logger.warning(String.format(" Check atom %d in %s.", i + 1, this.activeMolecularAssembly.getFile().getName()));
                                boolean bl = false;
                                return bl;
                            }
                            label[i] = Integer.parseInt(tokens[0]);
                            if (label[i] != i + 1) {
                                renumber = true;
                            }
                            String atomName = tokens[1];
                            d[i][0] = Double.parseDouble(tokens[2]);
                            d[i][1] = Double.parseDouble(tokens[3]);
                            d[i][2] = Double.parseDouble(tokens[4]);
                            int type = Integer.parseInt(tokens[5]);
                            AtomType atomType = this.forceField.getAtomType(Integer.toString(type));
                            if (atomType == null) {
                                StringBuilder message = new StringBuilder("Check atom type ");
                                message.append(type).append(" for Atom ").append(i + 1);
                                message.append(" in ").append(this.activeMolecularAssembly.getFile().getName());
                                logger.warning(message.toString());
                                boolean bl = false;
                                return bl;
                            }
                            Atom a = new Atom(i + 1, atomName, atomType, d[i]);
                            this.atomList.add(a);
                            numberOfBonds = tokens.length - 6;
                        } else {
                            if (br.ready()) {
                                data = br.readLine().trim();
                                while (data.equals("") && br.ready()) {
                                    data = br.readLine().trim();
                                }
                                tokens = data.split(" +", 2);
                                if (tokens.length > 0) {
                                    try {
                                        int archiveNumberOfAtoms = Integer.parseInt(tokens[0]);
                                        if (archiveNumberOfAtoms == numberOfAtoms) {
                                            this.setType(Utilities.FileType.ARC);
                                        }
                                    }
                                    catch (NumberFormatException archiveNumberOfAtoms) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (renumber) {
                                break;
                            }
                            break block61;
                        }
                        for (int b = 0; b < 8; ++b) {
                            int bond;
                            bonds[i][b] = b < numberOfBonds ? (bond = Integer.parseInt(tokens[6 + b])) : 0;
                        }
                        ++i;
                    }
                    for (i = 0; i < numberOfAtoms; ++i) {
                        if (labelHash.containsKey(label[i])) {
                            logger.warning(String.format(" Two atoms have the same index: %d.", label[i]));
                            boolean atomName = false;
                            return atomName;
                        }
                        labelHash.put(label[i], i + 1);
                    }
                    for (i = 0; i < numberOfAtoms; ++i) {
                        int j = -1;
                        while (j < 3 && bonds[i][++j] > 0) {
                            bonds[i][j] = (Integer)labelHash.get(bonds[i][j]);
                        }
                    }
                }
                this.bondList = new ArrayList();
                int[] c = new int[2];
                int a1 = 1;
                while (true) {
                    int j;
                    if (a1 <= numberOfAtoms) {
                        j = -1;
                    } else {
                        while (data != null && data.equals("") && br.ready()) {
                            data = br.readLine().trim();
                        }
                        if (data != null && (tokens = data.split(" +", 2))[0].equalsIgnoreCase("ESV")) {
                            int numOfESVs = Integer.parseInt(tokens[1]);
                            data = br.readLine().trim();
                            residueList = this.extendedSystem.getExtendedResidueList();
                            if (numOfESVs != residueList.size()) {
                                logger.severe(" Number of ESVs in archive doesn't match extended system residue list size.");
                                boolean bl = false;
                                return bl;
                            }
                            switchIndex = this.extendedSystem.getTitratingResidueList().size();
                            break;
                        }
                        break block62;
                    }
                    while (j < 7 && bonds[a1 - 1][++j] > 0) {
                        boolean a3;
                        int a2 = bonds[a1 - 1][j];
                        if (a1 >= a2) continue;
                        if (a2 > numberOfAtoms) {
                            logger.warning(String.format(" Check the bond between %d and %d in %s.", a1, a2, this.activeMolecularAssembly.getFile().getName()));
                            boolean a = false;
                            return a;
                        }
                        boolean bidirectional = false;
                        int k = -1;
                        while (k < 7 && bonds[a2 - 1][++k] > 0) {
                            a3 = bonds[a2 - 1][k];
                            if (a3 != a1) continue;
                            bidirectional = true;
                            break;
                        }
                        if (!bidirectional) {
                            logger.warning(String.format(" Check the bond between %d and %d in %s.", a1, a2, this.activeMolecularAssembly.getFile().getName()));
                            a3 = false;
                            return a3;
                        }
                        Atom atom1 = (Atom)this.atomList.get(a1 - 1);
                        Atom atom2 = (Atom)this.atomList.get(a2 - 1);
                        if (atom1 == null || atom2 == null) {
                            logger.warning(String.format(" Check the bond between %d and %d in %s.", a1, a2, this.activeMolecularAssembly.getFile().getName()));
                            boolean bl = false;
                            return bl;
                        }
                        Bond bond = new Bond(atom1, atom2);
                        BondType bondType = this.forceField.getBondType(atom1.getAtomType(), atom2.getAtomType());
                        if (bondType == null) {
                            Bond.logNoBondType(atom1, atom2, this.forceField);
                        } else {
                            bond.setBondType(bondType);
                        }
                        this.bondList.add(bond);
                    }
                    ++a1;
                }
                for (int i = 0; i < residueList.size(); ++i) {
                    tokens = data.split(" +");
                    if (i < switchIndex) {
                        this.extendedSystem.setTitrationLambda(residueList.get(i), Double.parseDouble(tokens[2]));
                    } else {
                        this.extendedSystem.setTautomerLambda(residueList.get(i), Double.parseDouble(tokens[2]));
                    }
                    data = br.readLine().trim();
                }
                for (Atom atom : this.system.getAtomList()) {
                    int atomIndex = atom.getIndex() - 1;
                    atom.setOccupancy(this.extendedSystem.getTitrationLambda(atomIndex));
                    atom.setTempFactor(this.extendedSystem.getTautomerLambda(atomIndex));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.severe(e.toString());
            return false;
        }
    }

    @Override
    public boolean readNext() {
        return this.readNext(false);
    }

    @Override
    public boolean readNext(boolean resetPosition) {
        return this.readNext(resetPosition, true);
    }

    @Override
    public boolean readNext(boolean resetPosition, boolean print) {
        return this.readNext(resetPosition, print, true);
    }

    @Override
    public boolean readNext(boolean resetPosition, boolean print, boolean parse) {
        try {
            String[] tokens;
            String data;
            Atom[] atoms = this.activeMolecularAssembly.getAtomArray();
            int nSystem = atoms.length;
            if (this.bufferedReader == null && !resetPosition) {
                this.bufferedReader = new BufferedReader(new FileReader(this.currentFile));
                for (int i = 0; i < nSystem + 1; ++i) {
                    data = this.bufferedReader.readLine();
                    while (!XPHFilter.firstTokenIsInteger(data)) {
                        data = this.bufferedReader.readLine();
                    }
                }
                this.snapShot = 1;
            } else if (resetPosition) {
                this.bufferedReader = new BufferedReader(new FileReader(this.currentFile));
                this.snapShot = 0;
            }
            ++this.snapShot;
            data = this.bufferedReader.readLine();
            while (data != null && data.trim().equals("")) {
                data = this.bufferedReader.readLine();
            }
            if (data == null) {
                return false;
            }
            if (data.contains("ESV")) {
                while (data != null && !data.trim().equals("")) {
                    data = this.bufferedReader.readLine();
                }
                data = this.bufferedReader.readLine();
                if (data == null) {
                    return false;
                }
            }
            if (print) {
                logger.info(String.format("\n Attempting to read snapshot %d.", this.snapShot));
            }
            try {
                int nArchive = Integer.parseInt(data.trim().split(" +")[0]);
                if (nArchive != nSystem) {
                    String message = String.format("Number of atoms mismatch (Archive: %d, System: %d).", nArchive, nSystem);
                    if (this.dieOnMissingAtom) {
                        logger.severe(message);
                    }
                    logger.warning(message);
                    return false;
                }
            }
            catch (NumberFormatException e) {
                logger.warning(e.toString());
                return false;
            }
            this.remarkLine = data;
            this.bufferedReader.mark(10000);
            data = this.bufferedReader.readLine();
            if (!XPHFilter.readPBC(data, this.activeMolecularAssembly)) {
                this.bufferedReader.reset();
            }
            for (int i = 0; i < nSystem; ++i) {
                data = this.bufferedReader.readLine();
                while (data != null && data.trim().equals("")) {
                    data = this.bufferedReader.readLine();
                }
                String[] tokens2 = data.trim().split(" +");
                if (tokens2.length < 6) {
                    String message = String.format("Check atom %d in %s.", i + 1, this.currentFile.getName());
                    logger.warning(message);
                    return false;
                }
                double x = Double.parseDouble(tokens2[2]);
                double y = Double.parseDouble(tokens2[3]);
                double z = Double.parseDouble(tokens2[4]);
                int xyzIndex = atoms[i].getIndex();
                if (xyzIndex != i + 1) {
                    String message = String.format("Archive atom index %d being read onto system atom index %d.", i + 1, xyzIndex);
                    logger.warning(message);
                }
                atoms[i].moveTo(x, y, z);
            }
            int counter = 0;
            while (data != null && !data.contains("ESV") && this.bufferedReader.ready()) {
                data = this.bufferedReader.readLine().trim();
                if (++counter <= 5) continue;
                logger.severe(" Read through too many lines");
            }
            if (data != null && (tokens = data.split(" +", 2))[0].equalsIgnoreCase("ESV")) {
                int numOfESVs = Integer.parseInt(tokens[1]);
                data = this.bufferedReader.readLine().trim();
                List<Residue> residueList = this.extendedSystem.getExtendedResidueList();
                if (numOfESVs == residueList.size()) {
                    int switchIndex = this.extendedSystem.getTitratingResidueList().size();
                    for (int i = 0; i < residueList.size(); ++i) {
                        tokens = data.split(" +");
                        if (i < switchIndex) {
                            this.extendedSystem.setTitrationLambda(residueList.get(i), Double.parseDouble(tokens[2]));
                        } else {
                            this.extendedSystem.setTautomerLambda(residueList.get(i), Double.parseDouble(tokens[2]));
                        }
                        data = this.bufferedReader.readLine().trim();
                    }
                } else {
                    logger.severe(" Number of ESVs in archive doesn't match extended system residue list size.");
                    return false;
                }
            }
            return true;
        }
        catch (FileNotFoundException e) {
            String message = String.format("Exception opening file %s.", this.currentFile);
            logger.log(Level.WARNING, message, e);
        }
        catch (IOException e) {
            String message = String.format("Exception reading from file %s.", this.currentFile);
            logger.log(Level.WARNING, message, e);
        }
        return false;
    }

    public ExtendedSystem getExtendedSystem() {
        return this.extendedSystem;
    }

    public void setExtendedSystem(ExtendedSystem esvSystem) {
        this.extendedSystem = esvSystem;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeFile(File saveFile, boolean append, String[] extraLines) {
        if (saveFile == null) {
            return false;
        }
        File newFile = saveFile;
        if (!append) {
            newFile = XPHFilter.version(saveFile);
        }
        this.activeMolecularAssembly.setFile(newFile);
        if (this.activeMolecularAssembly.getName() == null) {
            this.activeMolecularAssembly.setName(newFile.getName());
        }
        try {
            FileWriter fw = new FileWriter(newFile, append && newFile.exists());
            try (BufferedWriter bw2 = new BufferedWriter(fw);){
                int numberOfAtoms = this.activeMolecularAssembly.getAtomList().size();
                StringBuilder sb = new StringBuilder(String.format("%7d  %s", numberOfAtoms, this.activeMolecularAssembly.getName()));
                if (extraLines != null) {
                    for (String string : extraLines) {
                        String string2 = string.replaceAll("\n", " ");
                        sb.append(" ").append(string2);
                    }
                }
                String output = sb.append("\n").toString();
                bw2.write(output);
                Crystal crystal = this.activeMolecularAssembly.getCrystal();
                if (crystal != null && !crystal.aperiodic()) {
                    Crystal uc = crystal.getUnitCell();
                    String string = String.format("%14.8f%14.8f%14.8f%14.8f%14.8f%14.8f\n", uc.a, uc.b, uc.c, uc.alpha, uc.beta, uc.gamma);
                    bw2.write(string);
                }
                StringBuilder[] lines = new StringBuilder[numberOfAtoms];
                List<Atom> atoms = this.activeMolecularAssembly.getAtomList();
                Vector3d offset = this.activeMolecularAssembly.getOffset();
                for (Atom a : atoms) {
                    void var12_28;
                    if (this.vdwH) {
                        StringBuilder stringBuilder = new StringBuilder(String.format("%7d %3s%14.8f%14.8f%14.8f%6d", a.getIndex(), a.getAtomType().name, a.getRedX() - offset.x, a.getRedY() - offset.y, a.getRedZ() - offset.z, a.getType()));
                    } else {
                        StringBuilder stringBuilder = new StringBuilder(String.format("%7d %3s%14.8f%14.8f%14.8f%6d", a.getIndex(), a.getAtomType().name, a.getX() - offset.x, a.getY() - offset.y, a.getZ() - offset.z, a.getType()));
                    }
                    for (Bond b : a.getBonds()) {
                        Atom a2 = b.get1_2(a);
                        var12_28.append(String.format("%8d", a2.getIndex()));
                    }
                    lines[a.getIndex() - 1] = var12_28.append("\n");
                }
                StringBuilder[] esvLines = null;
                if (this.extendedSystem != null) {
                    List<Atom> residueAtoms;
                    List<Residue> residueList = this.extendedSystem.getTitratingResidueList();
                    esvLines = new StringBuilder[this.extendedSystem.getExtendedResidueList().size()];
                    int CAIndex = -1;
                    for (int i = 0; i < residueList.size(); ++i) {
                        StringBuilder stringBuilder;
                        double ESV = this.extendedSystem.getTitrationLambda(residueList.get(i));
                        residueAtoms = residueList.get(i).getAtomList(true);
                        for (Atom atom : residueAtoms) {
                            if (!atom.getAtomType().name.equalsIgnoreCase("CA")) continue;
                            CAIndex = atom.getIndex();
                        }
                        esvLines[i] = stringBuilder = new StringBuilder(String.format("%7d%7d%14.8f%7s\n", new Object[]{i, CAIndex, ESV, residueList.get(i).getAminoAcid3()}));
                        CAIndex = -1;
                    }
                    int offsetIndex = residueList.size();
                    residueList = this.extendedSystem.getTautomerizingResidueList();
                    for (int i = 0; i < residueList.size(); ++i) {
                        StringBuilder stringBuilder;
                        double ESV = this.extendedSystem.getTautomerLambda(residueList.get(i));
                        residueAtoms = residueList.get(i).getAtomList(true);
                        for (Atom atom : residueAtoms) {
                            if (!atom.getAtomType().name.equalsIgnoreCase("CA")) continue;
                            CAIndex = atom.getIndex();
                        }
                        esvLines[offsetIndex + i] = stringBuilder = new StringBuilder(String.format("%7d%7d%14.8f%7s\n", new Object[]{offsetIndex + i, CAIndex, ESV, residueList.get(i).getAminoAcid3()}));
                        CAIndex = -1;
                    }
                }
                try {
                    for (int i = 0; i < numberOfAtoms; ++i) {
                        bw2.write(lines[i].toString());
                    }
                    if (esvLines == null) return true;
                    String esvHead = String.format("\n%7s%7d\n", "ESV", esvLines.length);
                    bw2.write(esvHead);
                    int i = 0;
                    while (true) {
                        if (i >= esvLines.length) {
                            bw2.write("\n");
                            return true;
                        }
                        bw2.write(esvLines[i].toString());
                        ++i;
                    }
                }
                catch (IOException e) {
                    String message = String.format(" There was an unexpected error writing to %s.", this.getActiveMolecularSystem().toString());
                    logger.log(Level.WARNING, message, e);
                    boolean bl = false;
                    bw2.close();
                    fw.close();
                    return bl;
                }
            }
            finally {
                try {
                    fw.close();
                }
                catch (Throwable throwable) {
                    Throwable bw2;
                    bw2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            String message = String.format(" There was an unexpected error writing to %s.", this.getActiveMolecularSystem().toString());
            logger.log(Level.WARNING, message, e);
            return false;
        }
    }

    public boolean writeFileAsP1(File saveFile, boolean append, Crystal crystal) {
        return this.writeFileAsP1(saveFile, append, crystal, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean writeFileAsP1(File saveFile, boolean append, Crystal crystal, String[] extraLines) {
        if (saveFile == null) {
            return false;
        }
        File newFile = saveFile;
        if (!append) {
            newFile = XPHFilter.version(saveFile);
        }
        this.activeMolecularAssembly.setFile(newFile);
        this.activeMolecularAssembly.setName(newFile.getName());
        try {
            FileWriter fw = new FileWriter(newFile, append && newFile.exists());
            try (BufferedWriter bw2 = new BufferedWriter(fw);){
                int nSymm = crystal.spaceGroup.symOps.size();
                int numberOfAtoms = this.activeMolecularAssembly.getAtomList().size() * nSymm;
                StringBuilder sb = new StringBuilder(String.format("%7d  %s", numberOfAtoms, this.activeMolecularAssembly.toString()));
                if (extraLines != null) {
                    for (String line : extraLines) {
                        line = line.replaceAll("\n", " ");
                        sb.append(" ").append(line);
                    }
                }
                String output = sb.append("\n").toString();
                bw2.write(output);
                if (!crystal.aperiodic()) {
                    Crystal uc = crystal.getUnitCell();
                    String params = String.format("%14.8f%14.8f%14.8f%14.8f%14.8f%14.8f\n", uc.a, uc.b, uc.c, uc.alpha, uc.beta, uc.gamma);
                    bw2.write(params);
                }
                StringBuilder[] lines = new StringBuilder[numberOfAtoms];
                Atom[] atoms = this.activeMolecularAssembly.getAtomArray();
                double[] xyz = new double[3];
                for (int iSym = 0; iSym < nSymm; ++iSym) {
                    SymOp symOp = crystal.spaceGroup.getSymOp(iSym);
                    int indexOffset = iSym * atoms.length;
                    for (Atom a : atoms) {
                        int index = a.getIndex() + indexOffset;
                        String id = a.getAtomType().name;
                        if (this.vdwH) {
                            a.getRedXYZ(xyz);
                        } else {
                            xyz[0] = a.getX();
                            xyz[1] = a.getY();
                            xyz[2] = a.getZ();
                        }
                        crystal.applySymOp(xyz, xyz, symOp);
                        int type = a.getType();
                        StringBuilder line = new StringBuilder(String.format("%7d %3s%14.8f%14.8f%14.8f%6d", index, id, xyz[0], xyz[1], xyz[2], type));
                        for (Bond b : a.getBonds()) {
                            Atom a2 = b.get1_2(a);
                            line.append(String.format("%8d", a2.getIndex() + indexOffset));
                        }
                        lines[index - 1] = line.append("\n");
                    }
                }
                try {
                    for (int i = 0; i < numberOfAtoms; ++i) {
                        bw2.write(lines[i].toString());
                    }
                }
                catch (IOException e) {
                    String message = String.format(" There was an unexpected error writing to %s.", this.getActiveMolecularSystem().toString());
                    logger.log(Level.WARNING, message, e);
                    boolean bl = false;
                    bw2.close();
                    fw.close();
                    return bl;
                }
            }
            finally {
                try {
                    fw.close();
                }
                catch (Throwable throwable) {
                    Throwable bw2;
                    bw2.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            String message = String.format(" There was an unexpected error writing to %s.", this.getActiveMolecularSystem().toString());
            logger.log(Level.WARNING, message, e);
            return false;
        }
        return true;
    }
}

