/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.utilities.Keyword;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeyFilter {
    private static final Logger logger = Logger.getLogger(KeyFilter.class.getName());

    public static Hashtable<String, Keyword> open(File keyFile) {
        if (keyFile == null || !keyFile.exists() || !keyFile.canRead()) {
            return null;
        }
        Hashtable<String, Keyword> keywordHash = KeyFilter.loadSystemKeywords();
        return KeyFilter.open(keyFile, keywordHash);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Hashtable<String, Keyword> open(File keyFile, Hashtable<String, Keyword> keywordHash) {
        if (keyFile == null || !keyFile.exists() || !keyFile.canRead()) {
            return null;
        }
        if (keywordHash == null) {
            keywordHash = new Hashtable();
        }
        try (BufferedReader br = new BufferedReader(new FileReader(keyFile));){
            Keyword comments = new Keyword("COMMENTS");
            keywordHash.put("COMMENTS", comments);
            while (br.ready()) {
                String data;
                String keyword;
                String s = br.readLine();
                if (s == null || (s = s.trim()).isEmpty()) continue;
                if (s.startsWith("#") || s.toUpperCase().startsWith("ECHO")) {
                    comments.append(s);
                    continue;
                }
                int firstSpace = s.indexOf(" ");
                if (firstSpace == -1) {
                    keyword = s.trim().toUpperCase();
                    data = keyword.equalsIgnoreCase("rattle") ? "RATTLE" : null;
                } else {
                    keyword = s.substring(0, firstSpace).toUpperCase();
                    data = s.substring(firstSpace).trim();
                }
                Keyword kd = (Keyword)keywordHash.get(keyword);
                if (kd == null) {
                    kd = new Keyword(keyword);
                    keywordHash.put(keyword, kd);
                }
                if (data != null) {
                    kd.append(data);
                }
                if (keyword.equalsIgnoreCase("MULTIPOLE")) {
                    int[] mnum = new int[]{3, 1, 2, 3};
                    for (int i = 0; i < 4; ++i) {
                        if (!br.ready()) {
                            System.out.println("Check for an invalid MULTIPOLE keyword.");
                            Hashtable<String, Keyword> hashtable = null;
                            return hashtable;
                        }
                        s = br.readLine();
                        if (s == null) {
                            logger.warning("Multipole format error.");
                            Hashtable<String, Keyword> hashtable = null;
                            return hashtable;
                        }
                        if ((s = s.trim()).split(" +").length != mnum[i]) {
                            logger.warning("Multipole format error.");
                            Hashtable<String, Keyword> hashtable = null;
                            return hashtable;
                        }
                        kd.append(s);
                    }
                    continue;
                }
                if (!keyword.equalsIgnoreCase("TORTORS")) continue;
                String[] res = data.split(" +");
                if (res.length < 7) {
                    logger.warning("TORTOR format error.");
                    Hashtable<String, Keyword> i = null;
                    return i;
                }
                int xres = Integer.parseInt(res[5]);
                int yres = Integer.parseInt(res[6]);
                for (int i = 0; i < xres * yres; ++i) {
                    if (!br.ready()) {
                        System.out.println("Check for an invalid TORTOR keyword.");
                        Hashtable<String, Keyword> hashtable = null;
                        return hashtable;
                    }
                    s = br.readLine();
                    if (s == null) {
                        logger.warning("TORTOR format error.");
                        Hashtable<String, Keyword> hashtable = null;
                        return hashtable;
                    }
                    if ((s = s.trim()).split(" +").length != 3) {
                        logger.warning("TORTOR format error.");
                        Hashtable<String, Keyword> hashtable = null;
                        return hashtable;
                    }
                    kd.append(s);
                }
            }
            Hashtable<String, Object> hashtable = keywordHash;
            return hashtable;
        }
        catch (IOException e) {
            System.err.println("Error reading Key File: " + String.valueOf(e));
            return null;
        }
    }

    private static Hashtable<String, Keyword> loadSystemKeywords() {
        String path;
        File f = new File("/etc/ffx.conf");
        Hashtable<String, Keyword> systemKeywords = new Hashtable<String, Keyword>();
        if (f.exists() && f.canRead()) {
            logger.info("Reading /etc/ffx.conf");
            systemKeywords = KeyFilter.open(f, systemKeywords);
        }
        if ((f = new File(path = System.getProperty("user.home") + File.separator + ".ffx/ffx.conf")).exists() && f.canRead()) {
            logger.log(Level.INFO, "Reading {0}", path);
            systemKeywords = KeyFilter.open(f, systemKeywords);
        }
        return systemKeywords;
    }
}

