/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.potential.parameters.AngleTorsionType;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.BioType;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.ImproperTorsionType;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.OutOfPlaneBendType;
import ffx.potential.parameters.PiOrbitalTorsionType;
import ffx.potential.parameters.PolarizeType;
import ffx.potential.parameters.RelativeSolvationType;
import ffx.potential.parameters.SoluteType;
import ffx.potential.parameters.StretchBendType;
import ffx.potential.parameters.StretchTorsionType;
import ffx.potential.parameters.TorsionTorsionType;
import ffx.potential.parameters.TorsionType;
import ffx.potential.parameters.UreyBradleyType;
import ffx.potential.parameters.VDWPairType;
import ffx.potential.parameters.VDWType;
import ffx.utilities.Keyword;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class ForceFieldFilter {
    private static final Logger logger = Logger.getLogger(ForceFieldFilter.class.getName());
    private static final ForceField.ForceFieldName DEFAULT_FORCE_FIELD = ForceField.ForceFieldName.AMOEBA_BIO_2018;
    private final File forceFieldFile;
    private final CompositeConfiguration properties;
    private final ForceField forceField;

    public ForceFieldFilter(CompositeConfiguration properties) {
        this.properties = properties;
        if (properties.containsKey("parameters")) {
            String fileName = properties.getString("parameters");
            if (properties.containsKey("propertyFile")) {
                String propertyName = properties.getString("propertyFile");
                logger.info(" Property File: " + propertyName);
                File propertyFile = new File(propertyName);
                this.forceFieldFile = ForceFieldFilter.parseParameterLocation(fileName, propertyFile);
            } else {
                this.forceFieldFile = ForceFieldFilter.parseParameterLocation(fileName, null);
            }
        } else {
            this.forceFieldFile = null;
        }
        this.forceField = new ForceField(properties);
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Usage: ForceFieldFilter <file.prm>");
            System.exit(-1);
        }
        CompositeConfiguration properties = Keyword.loadProperties(null);
        properties.setProperty("parameters", (Object)args[0]);
        ForceFieldFilter forceFieldFilter = new ForceFieldFilter(properties);
        ForceField forceField = forceFieldFilter.parse();
        if (forceField != null) {
            forceField.print();
        }
    }

    private static File parseParameterLocation(String parameterLocation, File keyFile) {
        File parameterFile = null;
        if (parameterLocation != null && !parameterLocation.equalsIgnoreCase("NONE") && !(parameterFile = new File(parameterLocation = parameterLocation.replaceAll("\"", ""))).exists() && keyFile != null) {
            parameterFile = new File(keyFile.getParent() + File.separator + parameterLocation);
        }
        return parameterFile;
    }

    public ForceField parse() {
        try {
            if (this.forceFieldFile != null) {
                File fileToOpen = this.forceFieldFile;
                if (!fileToOpen.exists() && !(fileToOpen = new File(this.forceFieldFile.getAbsolutePath() + ".prm")).exists()) {
                    logger.log(Level.INFO, " {0} does not exist.", this.forceFieldFile);
                    return null;
                }
                if (!fileToOpen.canRead()) {
                    logger.log(Level.INFO, " {0} can not be read.", fileToOpen);
                    return null;
                }
                this.parse(new FileInputStream(fileToOpen));
            } else {
                ForceField.ForceFieldName ff;
                String defaultFFstring = DEFAULT_FORCE_FIELD.toString().toUpperCase().replaceAll("_", "-");
                String forceFieldString = this.properties.getString("forcefield", defaultFFstring);
                try {
                    ff = ForceField.ForceFieldName.valueOf(forceFieldString.toUpperCase().replace('-', '_'));
                }
                catch (Exception e) {
                    logger.info(String.format(" The forcefield property %s was not recognized.\n", forceFieldString));
                    ff = DEFAULT_FORCE_FIELD;
                }
                URL url = ForceField.getForceFieldURL(ff);
                if (url != null) {
                    this.forceField.forceFieldURL = url;
                    try {
                        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setURL(url)).setThrowExceptionOnMissing(true)).setIncludesAllowed(false)});
                        PropertiesConfiguration forceFieldConfiguration = (PropertiesConfiguration)builder.getConfiguration();
                        String name = ForceField.toPropertyForm(ff.toString());
                        forceFieldConfiguration.setHeader("Internal force field (" + name + ").");
                        this.properties.addConfiguration((Configuration)forceFieldConfiguration);
                    }
                    catch (ConfigurationException e) {
                        logger.warning(e.toString());
                    }
                }
            }
            if (this.properties != null) {
                this.parse(this.properties);
            }
        }
        catch (FileNotFoundException e) {
            String message = "Exception parsing force field.";
            logger.log(Level.WARNING, message, e);
        }
        String forceFieldName = this.forceField.getString("forcefield", "none");
        if (forceFieldName != null && ((forceFieldName = forceFieldName.toUpperCase()).contains("AMBER") || forceFieldName.contains("OPLS") || forceFieldName.contains("CHARMM"))) {
            this.forceField.setBondFunction(BondType.BondFunction.HARMONIC);
            this.forceField.setAngleFunction(AngleType.AngleFunction.HARMONIC);
        }
        return this.forceField;
    }

    private void parse(CompositeConfiguration properties) {
        try {
            int numConfigs = properties.getNumberOfConfigurations();
            for (int n = numConfigs - 1; n >= 0; --n) {
                Configuration config = properties.getConfiguration(n);
                if (config instanceof PropertiesConfiguration) {
                    PropertiesConfiguration propertiesConfiguration = (PropertiesConfiguration)config;
                    if (propertiesConfiguration.getHeader() != null) {
                        logger.info(" Parsing: " + propertiesConfiguration.getHeader());
                    }
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" Configuration was not an instance of PropertiesConfiguration.");
                }
                Iterator i = config.getKeys();
                block30: while (i.hasNext()) {
                    String[] list;
                    String key = (String)i.next();
                    if (!ForceField.isForceFieldType(key)) {
                        if (!logger.isLoggable(Level.FINER)) continue;
                        logger.finer(" Key value (" + key + ") is not a valid force field type.");
                        continue;
                    }
                    for (String string : list = config.getStringArray(key)) {
                        BaseType baseType;
                        ForceField.ForceFieldType type;
                        String string2 = key + " " + string;
                        String input = string2.split("#+")[0];
                        String[] tokens = input.trim().split(" +");
                        try {
                            type = ForceField.ForceFieldType.valueOf(key.toUpperCase());
                        }
                        catch (Exception e) {
                            continue block30;
                        }
                        switch (type) {
                            case ATOM: {
                                BaseType baseType2 = AtomType.parse(input, tokens);
                                break;
                            }
                            case ANGTORS: {
                                BaseType baseType2 = AngleTorsionType.parse(input, tokens);
                                break;
                            }
                            case ANGLE: {
                                BaseType baseType2 = AngleType.parse(input, tokens);
                                break;
                            }
                            case ANGLEP: {
                                BaseType baseType2 = AngleType.parseInPlane(input, tokens);
                                break;
                            }
                            case BIOTYPE: {
                                BaseType baseType2 = BioType.parse(input, tokens);
                                break;
                            }
                            case BOND: {
                                BaseType baseType2 = BondType.parse(input, tokens);
                                break;
                            }
                            case CHARGE: {
                                BaseType baseType2 = MultipoleType.parseChargeType(input, tokens);
                                break;
                            }
                            case MULTIPOLE: {
                                BaseType baseType2 = MultipoleType.parse(input, tokens);
                                break;
                            }
                            case OPBEND: {
                                BaseType baseType2 = OutOfPlaneBendType.parse(input, tokens);
                                break;
                            }
                            case STRBND: {
                                BaseType baseType2 = StretchBendType.parse(input, tokens);
                                break;
                            }
                            case PITORS: {
                                BaseType baseType2 = PiOrbitalTorsionType.parse(input, tokens);
                                break;
                            }
                            case IMPTORS: {
                                BaseType baseType2 = ImproperTorsionType.parse(input, tokens);
                                break;
                            }
                            case TORSION: {
                                BaseType baseType2 = TorsionType.parse(input, tokens);
                                break;
                            }
                            case IMPROPER: {
                                BaseType baseType2 = TorsionType.parseImproper(input, tokens);
                                break;
                            }
                            case STRTORS: {
                                BaseType baseType2 = StretchTorsionType.parse(input, tokens);
                                break;
                            }
                            case TORTORS: {
                                BaseType baseType2 = TorsionTorsionType.parse(input, tokens);
                                break;
                            }
                            case UREYBRAD: {
                                BaseType baseType2 = UreyBradleyType.parse(input, tokens);
                                break;
                            }
                            case VDW: {
                                BaseType baseType2 = VDWType.parse(input, tokens);
                                break;
                            }
                            case VDW14: {
                                BaseType baseType2 = VDWType.parseVDW14(input, tokens);
                                break;
                            }
                            case VDWPR: 
                            case VDWPAIR: {
                                BaseType baseType2 = VDWPairType.parse(input, tokens);
                                break;
                            }
                            case POLARIZE: {
                                BaseType baseType2 = PolarizeType.parse(input, tokens);
                                break;
                            }
                            case RELATIVESOLV: {
                                BaseType baseType2 = RelativeSolvationType.parse(input, tokens);
                                break;
                            }
                            case SOLUTE: {
                                BaseType baseType2 = SoluteType.parse(input, tokens);
                                break;
                            }
                            default: {
                                logger.log(Level.WARNING, "ForceField type recognized, but not stored:{0}", (Object)type);
                                BaseType baseType2 = baseType = null;
                            }
                        }
                        if (baseType == null) continue;
                        this.forceField.addForceFieldType(baseType);
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "Exception parsing force field.";
            logger.log(Level.WARNING, message, e);
        }
        logger.info("");
    }

    private void parse(InputStream stream) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            while (br.ready()) {
                String input = br.readLine();
                this.parse(input, br);
            }
        }
        catch (IOException e) {
            String message = "Error parsing force field parameters.\n";
            logger.log(Level.SEVERE, message, e);
        }
    }

    private void parse(String input, BufferedReader br) {
        String originalInput = input;
        String[] inputs = input.split("#");
        if (inputs.length < 1) {
            return;
        }
        input = inputs[0].split("#")[0];
        String[] tokens = input.trim().split(" +");
        if (tokens[0].equalsIgnoreCase("")) {
            return;
        }
        try {
            BaseType baseType;
            ForceField.ForceFieldType type = ForceField.ForceFieldType.valueOf(tokens[0].toUpperCase());
            switch (type) {
                case ATOM: {
                    BaseType baseType2 = AtomType.parse(input, tokens);
                    break;
                }
                case ANGLE: {
                    BaseType baseType2 = AngleType.parse(input, tokens);
                    break;
                }
                case ANGLEP: {
                    BaseType baseType2 = AngleType.parseInPlane(input, tokens);
                    break;
                }
                case ANGTORS: {
                    BaseType baseType2 = AngleTorsionType.parse(input, tokens);
                    break;
                }
                case BIOTYPE: {
                    BaseType baseType2 = BioType.parse(input, tokens);
                    break;
                }
                case BOND: {
                    BaseType baseType2 = BondType.parse(input, tokens);
                    break;
                }
                case CHARGE: {
                    BaseType baseType2 = MultipoleType.parseChargeType(input, tokens);
                    break;
                }
                case MULTIPOLE: {
                    BaseType baseType2 = MultipoleType.parse(input, tokens, br);
                    break;
                }
                case OPBEND: {
                    BaseType baseType2 = OutOfPlaneBendType.parse(input, tokens);
                    break;
                }
                case STRBND: {
                    BaseType baseType2 = StretchBendType.parse(input, tokens);
                    break;
                }
                case PITORS: {
                    BaseType baseType2 = PiOrbitalTorsionType.parse(input, tokens);
                    break;
                }
                case IMPTORS: {
                    BaseType baseType2 = ImproperTorsionType.parse(input, tokens);
                    break;
                }
                case STRTORS: {
                    BaseType baseType2 = StretchTorsionType.parse(input, tokens);
                    break;
                }
                case TORSION: {
                    BaseType baseType2 = TorsionType.parse(input, tokens);
                    break;
                }
                case IMPROPER: {
                    BaseType baseType2 = TorsionType.parseImproper(input, tokens);
                    break;
                }
                case TORTORS: {
                    BaseType baseType2 = TorsionTorsionType.parse(input, tokens, br);
                    break;
                }
                case UREYBRAD: {
                    BaseType baseType2 = UreyBradleyType.parse(input, tokens);
                    break;
                }
                case VDW: {
                    BaseType baseType2 = VDWType.parse(input, tokens);
                    break;
                }
                case VDW14: {
                    BaseType baseType2 = VDWType.parseVDW14(input, tokens);
                    break;
                }
                case VDWPR: 
                case VDWPAIR: {
                    BaseType baseType2 = VDWPairType.parse(input, tokens);
                    break;
                }
                case POLARIZE: {
                    BaseType baseType2 = PolarizeType.parse(input, tokens);
                    break;
                }
                case RELATIVESOLV: {
                    BaseType baseType2 = RelativeSolvationType.parse(input, tokens);
                    break;
                }
                case SOLUTE: {
                    BaseType baseType2 = SoluteType.parse(originalInput, originalInput.trim().split(" +"));
                    break;
                }
                default: {
                    logger.log(Level.WARNING, "ForceField type recognized, but not stored:{0}", (Object)type);
                    BaseType baseType2 = baseType = null;
                }
            }
            if (baseType != null) {
                this.forceField.addForceFieldType(baseType);
            }
            return;
        }
        catch (Exception type) {
            try {
                String key = tokens[0];
                String value = input.replaceFirst(tokens[0], "").trim();
                this.forceField.addProperty(key, value);
            }
            catch (Exception e) {
                logger.info(" Ignored line: " + input);
            }
            return;
        }
    }
}

