/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.potential.bonded.Residue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ESVFilter {
    private static final Logger logger = Logger.getLogger(ESVFilter.class.getName());
    private final String label;

    public ESVFilter(String label) {
        this.label = label;
    }

    public String getLambdaHistogram(List<Residue> titratingResidueList, int[][][] esvHistogram, double pH) {
        int nTitr = titratingResidueList.size();
        StringBuilder tautomerHeader = new StringBuilder("        X");
        for (int k = 0; k < 10; ++k) {
            tautomerHeader.append(String.format(" %1$10s", "[" + (double)k / 10.0 + "-" + (double)(k + 1) / 10.0 + "]"));
        }
        tautomerHeader.append("\n \u03bb\n");
        StringBuilder[] histogram = new StringBuilder[nTitr];
        for (int i = 0; i < nTitr; ++i) {
            StringBuilder hist = new StringBuilder();
            hist.append(String.format(" ESV: %s (%d) pH: %4.2f\n", titratingResidueList.get(i), i, pH));
            hist.append((CharSequence)tautomerHeader);
            for (int j = 0; j < 10; ++j) {
                hist.append(" [").append((double)j / 10.0).append("-").append((double)(j + 1) / 10.0).append("]");
                for (int k = 0; k < 10; ++k) {
                    hist.append(String.format("%1$10s", esvHistogram[i][j][k]));
                }
                hist.append("\n");
            }
            histogram[i] = hist.append("\n");
        }
        StringBuilder histograms = new StringBuilder();
        for (int i = 0; i < nTitr; ++i) {
            histograms.append((CharSequence)histogram[i]);
        }
        return String.valueOf(histograms);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readESV(File esvFile, double[] x, double[] v, double[] a, int[][][] esvHist) {
        if (!esvFile.exists()) return false;
        if (!esvFile.canRead()) {
            return false;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(esvFile));){
            int i;
            br.readLine();
            String data = br.readLine().trim();
            String[] tokens = data.split(" +");
            if (tokens.length == 0) {
                boolean bl = false;
                return bl;
            }
            int numESVs = Integer.parseInt(tokens[0]);
            br.readLine();
            for (i = 0; i < numESVs; ++i) {
                data = br.readLine().trim();
                tokens = data.split(" +");
                if (tokens.length != 1) {
                    boolean bl = false;
                    return bl;
                }
                x[i] = Double.parseDouble(tokens[0]);
            }
            br.readLine();
            for (i = 0; i < numESVs; ++i) {
                data = br.readLine().trim();
                tokens = data.split(" +");
                if (tokens.length != 1) {
                    boolean bl = false;
                    return bl;
                }
                v[i] = Double.parseDouble(tokens[0]);
            }
            br.readLine();
            for (i = 0; i < numESVs; ++i) {
                data = br.readLine().trim();
                tokens = data.split(" +");
                if (tokens.length != 1) {
                    boolean bl = false;
                    return bl;
                }
                a[i] = Double.parseDouble(tokens[0]);
            }
            i = 0;
            while (i < esvHist.length) {
                int j;
                for (j = 0; j < 4; ++j) {
                    br.readLine();
                }
                for (j = 0; j < esvHist[i].length; ++j) {
                    data = br.readLine().trim();
                    tokens = data.split(" +");
                    for (int k = 0; k < esvHist[i][j].length; ++k) {
                        esvHist[i][j][k] = Integer.parseInt(tokens[k + 1]);
                    }
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            String message = "Exception reading ESV restart file: " + String.valueOf(esvFile);
            logger.log(Level.WARNING, message, e);
        }
        return true;
    }

    public boolean writeESV(File dynFile, double[] x, double[] v, double[] a, List<Residue> titrResList, int[][][] esvHist, double pH) {
        try (FileWriter fw = new FileWriter(dynFile);
             BufferedWriter bw = new BufferedWriter(fw);){
            int i;
            bw.write(" Number of ESVs and Title :\n");
            int numberOfAtoms = x.length;
            String output = String.format("%7d  %s\n", numberOfAtoms, this.label);
            bw.write(output);
            bw.write(" Current Theta Positions :\n");
            for (i = 0; i < numberOfAtoms; ++i) {
                bw.write(String.format("%26.16E\n", x[i]));
            }
            bw.write(" Current Atomic Velocities :\n");
            for (i = 0; i < numberOfAtoms; ++i) {
                bw.write(String.format("%26.16E\n", v[i]));
            }
            bw.write(" Current Atomic Accelerations :\n");
            for (i = 0; i < numberOfAtoms; ++i) {
                bw.write(String.format("%26.16E\n", a[i]));
            }
            bw.write(" Current Lambda Histogram(s) :\n");
            bw.write(this.getLambdaHistogram(titrResList, esvHist, pH));
        }
        catch (IOException e) {
            String message = " Exception writing dynamic restart file " + String.valueOf(dynFile);
            logger.log(Level.SEVERE, message, e);
            return false;
        }
        return true;
    }
}

