/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.numerics.math.RunningStatistics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class DistanceMatrixFilter {
    private static final Logger logger = Logger.getLogger(DistanceMatrixFilter.class.getName());
    private int nRows = 0;
    private int nColumns = 0;
    private boolean fillDistanceMatrix = false;
    private double[][] distanceMatrix = null;

    public int getRestartRow() {
        return this.nRows;
    }

    public int getRestartColumn() {
        return this.nColumns;
    }

    public RunningStatistics readDistanceMatrix(String filename, List<double[]> distanceList) {
        this.fillDistanceMatrix = true;
        RunningStatistics runningStatistics = this.readDistanceMatrix(filename, -1, -1);
        if (this.distanceMatrix != null) {
            int i;
            int size = this.distanceMatrix[0].length;
            boolean square = true;
            for (i = 0; i < size; ++i) {
                if (this.distanceMatrix[i] != null && this.distanceMatrix[i].length == size) continue;
                square = false;
                break;
            }
            if (square) {
                Collections.addAll(distanceList, this.distanceMatrix);
            } else {
                for (i = 0; i < size; ++i) {
                    double[] row = new double[size];
                    for (int j = 0; j < i; ++j) {
                        double[] previousRow = distanceList.get(j);
                        row[j] = previousRow[i];
                    }
                    System.arraycopy(this.distanceMatrix[i], 0, row, i, size - i);
                    distanceList.add(row);
                }
            }
        }
        this.distanceMatrix = null;
        this.fillDistanceMatrix = false;
        return runningStatistics;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public RunningStatistics readDistanceMatrix(String filename, int expectedRows, int expectedColumns) {
        if (filename == null) {
            return null;
        }
        File distanceMatrixFile = new File(filename);
        if (!distanceMatrixFile.exists() || !distanceMatrixFile.canRead()) {
            return null;
        }
        try (FileReader fr = new FileReader(distanceMatrixFile);){
            RunningStatistics runningStatistics;
            String[] tokens;
            String data;
            BufferedReader br;
            block26: {
                block25: {
                    br = new BufferedReader(fr);
                    data = br.readLine();
                    while (data != null && data.trim().isEmpty()) {
                        data = br.readLine();
                    }
                    if (data != null) break block25;
                    logger.info(String.format("\n No data in RMSD file %s.", distanceMatrixFile));
                    RunningStatistics runningStatistics2 = null;
                    br.close();
                    return runningStatistics2;
                }
                tokens = data.trim().split(" +");
                this.nColumns = tokens.length;
                if (expectedRows == -1) {
                    expectedRows = this.nColumns;
                }
                if (expectedColumns == -1) {
                    expectedColumns = this.nColumns;
                }
                if (this.nColumns == expectedColumns) break block26;
                logger.info(String.format("\n Unexpected number of entries (%d) in the first row of the RMSD file %s.", this.nColumns, distanceMatrixFile));
                RunningStatistics runningStatistics3 = null;
                br.close();
                return runningStatistics3;
            }
            try {
                if (this.fillDistanceMatrix) {
                    this.distanceMatrix = new double[expectedRows][];
                }
                RunningStatistics runningStatistics4 = new RunningStatistics();
                for (int i = 0; i < expectedRows; ++i) {
                    double[] row = new double[this.nColumns];
                    for (int j = 0; j < this.nColumns; ++j) {
                        row[j] = Double.parseDouble(tokens[j]);
                        runningStatistics4.addValue(row[j]);
                    }
                    if (this.distanceMatrix != null && this.distanceMatrix.length > i) {
                        this.distanceMatrix[i] = row;
                    }
                    this.nRows = i + 1;
                    data = br.readLine();
                    if (data == null) break;
                    tokens = data.trim().split(" +");
                    this.nColumns = tokens.length;
                }
                runningStatistics = runningStatistics4;
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            br.close();
            return runningStatistics;
        }
        catch (IOException e) {
            logger.info(String.format(" Exception reading %s:\n %s", distanceMatrixFile, e));
            return null;
        }
    }

    public static String toDistanceMatrixString(List<double[]> distanceMatrix) {
        if (distanceMatrix == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("\n Distance Matrix:\n");
        for (double[] row : distanceMatrix) {
            sb.append("  ");
            for (int j = 0; j < row.length; ++j) {
                if (row[j] == -2.0) {
                    sb.append(String.format("%6.4f", Double.NaN));
                } else {
                    sb.append(String.format("%6.4f", row[j]));
                }
                if (j == row.length - 1) {
                    sb.append("\n");
                    continue;
                }
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public static String toDistanceMatrixString(double[][] distanceMatrix) {
        return DistanceMatrixFilter.toDistanceMatrixString(Arrays.asList(distanceMatrix));
    }

    public static boolean writeDistanceMatrix(String filename, List<double[]> distanceMatrix) {
        if (distanceMatrix == null) {
            return false;
        }
        for (double[] row : distanceMatrix) {
            boolean success = DistanceMatrixFilter.writeDistanceMatrixRow(filename, row, 0);
            if (success) continue;
            return false;
        }
        return true;
    }

    public static boolean writeDistanceMatrixRow(String filename, double[] distanceMatrixRow, int firstColumn) {
        if (filename == null) {
            return false;
        }
        File distanceMatrixFile = new File(filename);
        if (distanceMatrixFile == null || distanceMatrixRow == null) {
            return false;
        }
        try (FileWriter fw = new FileWriter(distanceMatrixFile, true);
             BufferedWriter bw = new BufferedWriter(fw);){
            int nColumn = distanceMatrixRow.length;
            for (int column = firstColumn; column < nColumn; ++column) {
                bw.write(String.format("%16.14f", distanceMatrixRow[column]));
                if (column >= nColumn - 1) continue;
                bw.write(" ");
            }
            bw.write("\n");
        }
        catch (Exception e) {
            logger.info(String.format(" Exception writing to %s:\n %s", distanceMatrixFile, e));
            return false;
        }
        return true;
    }
}

