/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.crystal.Crystal;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DYNFilter {
    private static final Logger logger = Logger.getLogger(DYNFilter.class.getName());
    private final String label;

    public DYNFilter(String label) {
        this.label = label;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readDYN(File dynFile, Crystal crystal, double[] x, double[] v, double[] a, double[] ap) {
        if (!dynFile.exists()) return false;
        if (!dynFile.canRead()) {
            return false;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(dynFile));){
            int j;
            int i;
            br.readLine();
            String data = br.readLine().trim();
            String[] tokens = data.split(" +");
            if (tokens.length == 0) {
                boolean bl = false;
                return bl;
            }
            int numAtoms = Integer.parseInt(tokens[0]);
            br.readLine();
            data = br.readLine().trim();
            tokens = data.split(" +");
            if (tokens.length != 3) {
                boolean bl = false;
                return bl;
            }
            double aAxis = Double.parseDouble(tokens[0]);
            double bAxis = Double.parseDouble(tokens[1]);
            double cAxis = Double.parseDouble(tokens[2]);
            data = br.readLine().trim();
            tokens = data.split(" +");
            if (tokens.length != 3) {
                boolean bl = false;
                return bl;
            }
            double alpha = Double.parseDouble(tokens[0]);
            double beta = Double.parseDouble(tokens[1]);
            double gamma = Double.parseDouble(tokens[2]);
            crystal.changeUnitCellParameters(aAxis, bAxis, cAxis, alpha, beta, gamma);
            br.readLine();
            for (i = 0; i < numAtoms; ++i) {
                data = br.readLine().trim();
                tokens = data.split(" +");
                if (tokens.length != 3) {
                    boolean bl = false;
                    return bl;
                }
                j = i * 3;
                x[j] = Double.parseDouble(tokens[0]);
                x[j + 1] = Double.parseDouble(tokens[1]);
                x[j + 2] = Double.parseDouble(tokens[2]);
            }
            br.readLine();
            for (i = 0; i < numAtoms; ++i) {
                data = br.readLine().trim();
                tokens = data.split(" +");
                if (tokens.length != 3) {
                    j = 0;
                    return j != 0;
                }
                j = i * 3;
                v[j] = Double.parseDouble(tokens[0]);
                v[j + 1] = Double.parseDouble(tokens[1]);
                v[j + 2] = Double.parseDouble(tokens[2]);
            }
            br.readLine();
            for (i = 0; i < numAtoms; ++i) {
                data = br.readLine().trim();
                tokens = data.split(" +");
                if (tokens.length != 3) {
                    j = 0;
                    return j != 0;
                }
                j = i * 3;
                a[j] = Double.parseDouble(tokens[0]);
                a[j + 1] = Double.parseDouble(tokens[1]);
                a[j + 2] = Double.parseDouble(tokens[2]);
            }
            br.readLine();
            i = 0;
            while (i < numAtoms) {
                data = br.readLine().trim();
                tokens = data.split(" +");
                if (tokens.length != 3) {
                    j = 0;
                    return j != 0;
                }
                j = i * 3;
                ap[j] = Double.parseDouble(tokens[0]);
                ap[j + 1] = Double.parseDouble(tokens[1]);
                ap[j + 2] = Double.parseDouble(tokens[2]);
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            String message = "Exception reading dynamic restart file: " + String.valueOf(dynFile);
            logger.log(Level.WARNING, message, e);
        }
        return true;
    }

    public boolean writeDYN(File dynFile, Crystal crystal, double[] x, double[] v, double[] a, double[] ap) {
        try (FileWriter fw = new FileWriter(dynFile);
             BufferedWriter bw = new BufferedWriter(fw);){
            int k;
            int i;
            bw.write(" Number of Atoms and Title :\n");
            assert (x.length % 3 == 0);
            int numberOfAtoms = x.length / 3;
            String output = String.format("%7d  %s\n", numberOfAtoms, this.label);
            bw.write(output);
            bw.write(" Periodic Box Dimensions :\n");
            Crystal unitCell = crystal.getUnitCell();
            bw.write(String.format("%26.16E%26.16E%26.16E\n", unitCell.a, unitCell.b, unitCell.c));
            bw.write(String.format("%26.16E%26.16E%26.16E\n", unitCell.alpha, unitCell.beta, unitCell.gamma));
            bw.write(" Current Atomic Positions :\n");
            for (i = 0; i < numberOfAtoms; ++i) {
                k = i * 3;
                bw.write(String.format("%26.16E%26.16E%26.16E\n", x[k], x[k + 1], x[k + 2]));
            }
            bw.write(" Current Atomic Velocities :\n");
            for (i = 0; i < numberOfAtoms; ++i) {
                k = i * 3;
                bw.write(String.format("%26.16E%26.16E%26.16E\n", v[k], v[k + 1], v[k + 2]));
            }
            bw.write(" Current Atomic Accelerations :\n");
            for (i = 0; i < numberOfAtoms; ++i) {
                k = i * 3;
                bw.write(String.format("%26.16E%26.16E%26.16E\n", a[k], a[k + 1], a[k + 2]));
            }
            bw.write(" Previous Atomic Accelerations :\n");
            for (i = 0; i < numberOfAtoms; ++i) {
                k = i * 3;
                bw.write(String.format("%26.16E%26.16E%26.16E\n", ap[k], ap[k + 1], ap[k + 2]));
            }
        }
        catch (IOException e) {
            String message = " Exception writing dynamic restart file " + String.valueOf(dynFile);
            logger.log(Level.SEVERE, message, e);
            return false;
        }
        return true;
    }
}

