/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parsers;

import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class BARFilter {
    private static final Logger logger = Logger.getLogger(XYZFilter.class.getName());
    private final File barFile;
    private int snaps1;
    private double temperature1;
    private double[] e1l1;
    private double[] e1l2;
    private double[] volume1;
    private int snaps2;
    private double temperature2;
    private double[] e2l1;
    private double[] e2l2;
    private double[] volume2;
    private int startingSnap = 0;
    private int endingSnap = 0;
    private int count = 0;

    public BARFilter(File barFile) {
        this.barFile = barFile;
    }

    public BARFilter(File barFile, int startingSnap, int endingSnap) {
        this.barFile = barFile;
        this.startingSnap = startingSnap;
        this.endingSnap = endingSnap;
    }

    public BARFilter(File xyzFile, double[] e1l1, double[] e1l2, double[] e2l1, double[] e2l2, double[] volume1, double[] volume2, double temperature1, double temperature2) {
        this.barFile = xyzFile;
        this.temperature1 = temperature1;
        this.e1l1 = e1l1;
        this.e1l2 = e1l2;
        this.volume1 = volume1;
        this.e2l1 = e2l1;
        this.e2l2 = e2l2;
        this.volume2 = volume2;
        this.temperature2 = temperature2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readFile() {
        ArrayList<Double> ens1lam1 = new ArrayList<Double>();
        ArrayList<Double> ens1lam2 = new ArrayList<Double>();
        ArrayList<Double> ens2lam1 = new ArrayList<Double>();
        ArrayList<Double> ens2lam2 = new ArrayList<Double>();
        ArrayList<Double> vol1 = new ArrayList<Double>();
        ArrayList<Double> vol2 = new ArrayList<Double>();
        int snapshots = 0;
        int xyzCount = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(this.barFile));){
            int i;
            String data;
            while ((data = br.readLine()) != null) {
                String[] tokens = data.trim().split(" +");
                int numTokens = tokens.length;
                if (data.contains(".xyz") || data.contains(".pdb") || numTokens < 3) {
                    if (++xyzCount == 1) {
                        this.snaps1 = Integer.parseInt(tokens[0]);
                        this.temperature1 = Double.parseDouble(tokens[1]);
                        continue;
                    }
                    if (xyzCount != 2) continue;
                    this.snaps2 = Integer.parseInt(tokens[0]);
                    this.temperature2 = Double.parseDouble(tokens[1]);
                    continue;
                }
                if (this.endingSnap != 0) {
                    ++this.count;
                    snapshots = this.endingSnap - this.startingSnap + 1;
                    if (this.count >= this.startingSnap + 1 && this.count <= this.endingSnap + 1) {
                        if (this.count <= this.snaps1) {
                            if (numTokens == 4) {
                                vol1.add(Double.parseDouble(tokens[3]));
                            }
                            ens1lam1.add(Double.parseDouble(tokens[1]));
                            ens1lam2.add(Double.parseDouble(tokens[2]));
                            continue;
                        }
                        logger.warning(String.format(" BAR entry of (%3d) is larger than total entries (%3d).", this.count, this.snaps1));
                        continue;
                    }
                    if (this.count < this.snaps1 + this.startingSnap + 1 || this.count > this.snaps1 + this.endingSnap + 1) continue;
                    if (this.count <= this.snaps1 + this.snaps2 + 1) {
                        if (numTokens == 4) {
                            vol2.add(Double.parseDouble(tokens[3]));
                        }
                        ens2lam1.add(Double.parseDouble(tokens[1]));
                        ens2lam2.add(Double.parseDouble(tokens[2]));
                        continue;
                    }
                    logger.warning(String.format(" BAR entry of (%3d) is larger than total entries (%3d).", this.count, this.snaps1 + this.snaps2));
                    continue;
                }
                ++this.count;
                if (this.count <= this.snaps1) {
                    if (numTokens == 4) {
                        vol1.add(Double.parseDouble(tokens[3]));
                    }
                    ens1lam1.add(Double.parseDouble(tokens[1]));
                    ens1lam2.add(Double.parseDouble(tokens[2]));
                    continue;
                }
                if (numTokens == 4) {
                    vol2.add(Double.parseDouble(tokens[3]));
                }
                ens2lam1.add(Double.parseDouble(tokens[1]));
                ens2lam2.add(Double.parseDouble(tokens[2]));
            }
            if (snapshots != 0) {
                this.e1l1 = new double[snapshots];
                this.e1l2 = new double[snapshots];
                this.e2l1 = new double[snapshots];
                this.e2l2 = new double[snapshots];
                this.volume1 = new double[snapshots];
                this.volume2 = new double[snapshots];
                this.snaps1 = snapshots;
            } else {
                this.e1l1 = new double[this.snaps1];
                this.e1l2 = new double[this.snaps1];
                this.e2l1 = new double[this.snaps2];
                this.e2l2 = new double[this.snaps2];
                this.volume1 = new double[this.snaps1];
                this.volume2 = new double[this.snaps2];
            }
            for (i = 0; i < ens1lam1.size(); ++i) {
                this.e1l1[i] = (Double)ens1lam1.get(i);
                this.e1l2[i] = (Double)ens1lam2.get(i);
                if (vol1.isEmpty()) continue;
                this.volume1[i] = (Double)vol1.get(i);
            }
            for (i = 0; i < ens2lam1.size(); ++i) {
                this.e2l1[i] = (Double)ens2lam1.get(i);
                this.e2l2[i] = (Double)ens2lam2.get(i);
                if (vol1.isEmpty()) continue;
                this.volume2[i] = (Double)vol2.get(i);
            }
            if (data != null) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException fileNotFoundException) {
            logger.warning(String.format(" Exception reading %s:\n %s", this.barFile, fileNotFoundException));
        }
        return true;
    }

    public boolean writeFile(String saveFile, boolean isPBC) {
        return this.writeFile(saveFile, isPBC, true);
    }

    public boolean writeFile(String saveFile, boolean isPBC, boolean append) {
        int snaps = this.e1l1.length;
        int snaps2 = this.e2l1.length;
        String name = this.barFile.getName();
        File newFile = new File(saveFile);
        if (!append) {
            newFile = SystemFilter.version(newFile);
        }
        logger.info(String.format(" Writing BAR file: %s", newFile));
        try (FileWriter fw = new FileWriter(newFile, append && newFile.exists());
             BufferedWriter bw = new BufferedWriter(fw);){
            int i;
            bw.write(String.format("%8d %9.3f %s\n", snaps, this.temperature1, name));
            for (i = 0; i < snaps; ++i) {
                if (Double.isNaN(this.e1l1[i]) || Double.isNaN(this.e1l2[i])) continue;
                if (isPBC) {
                    bw.write(String.format("%8d %20.10f %20.10f %20.10f\n", i + 1, this.e1l1[i], this.e1l2[i], this.volume2[i]));
                    continue;
                }
                bw.write(String.format("%8d %20.10f %20.10f\n", i + 1, this.e1l1[i], this.e1l2[i]));
            }
            bw.write(String.format("%8d %9.3f  %s\n", snaps2, this.temperature1, name));
            for (i = 0; i < snaps2; ++i) {
                if (Double.isNaN(this.e2l1[i]) || Double.isNaN(this.e2l2[i])) continue;
                if (isPBC) {
                    bw.write(String.format("%8d %20.10f %20.10f %20.10f\n", i + 1, this.e2l1[i], this.e2l2[i], this.volume2[i]));
                    continue;
                }
                bw.write(String.format("%8d %20.10f %20.10f\n", i + 1, this.e2l1[i], this.e2l2[i]));
            }
        }
        catch (IOException e) {
            logger.warning(String.format(" Exception writing %s", newFile));
            return false;
        }
        return true;
    }

    public double getTemperature1() {
        return this.temperature1;
    }

    public double getTemperature2() {
        return this.temperature2;
    }

    public double[] getE1l1() {
        return this.e1l1;
    }

    public double[] getE1l2() {
        return this.e1l2;
    }

    public double[] getE2l1() {
        return this.e2l1;
    }

    public double[] getE2l2() {
        return this.e2l2;
    }

    public double[] getVolume1() {
        return this.volume1;
    }

    public double[] getVolume2() {
        return this.volume2;
    }

    public int getNumberOfSnapshots() {
        return this.snaps1;
    }

    public File getFile() {
        return this.barFile;
    }
}

