/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.VDWPairType;
import ffx.utilities.FFXProperties;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperties(value={@FFXProperty(name="vdw", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[1 integer and 3 reals]\nProvides values for a single van der Waals parameter. The integer modifier, if positive,\ngives the atom class number for which vdw parameters are to be defined. Note that vdw parameters are given for atom classes, not atom types.\nThe three real number modifiers give the values of the atom size in Angstroms, homoatomic well depth in kcal/mole,\nand an optional reduction factor for univalent atoms.\n"), @FFXProperty(name="vdw14", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[1 integer and 2 reals]\nProvides values for a single van der Waals parameter for use in 1-4 nonbonded interactions.\nThe integer modifier, if positive, gives the atom class number for which vdw parameters are to be defined.\nNote that vdw parameters are given for atom classes, not atom types.\nThe two real number modifiers give the values of the atom size in Angstroms and the homoatomic well depth in kcal/mole.\nReduction factors, if used, are carried over from the vdw keyword for the same atom class.\n")})
public final class VDWType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(VDWType.class.getName());
    public static final double DEFAULT_GAMMA = 0.12;
    public static final double DEFAULT_DELTA = 0.07;
    public static final EPSILON_RULE DEFAULT_EPSILON_RULE = EPSILON_RULE.GEOMETRIC;
    public static final RADIUS_RULE DEFAULT_RADIUS_RULE = RADIUS_RULE.ARITHMETIC;
    public static final RADIUS_SIZE DEFAULT_RADIUS_SIZE = RADIUS_SIZE.RADIUS;
    public static final RADIUS_TYPE DEFAULT_RADIUS_TYPE = RADIUS_TYPE.R_MIN;
    public static final VDW_TYPE DEFAULT_VDW_TYPE = VDW_TYPE.LENNARD_JONES;
    public static final double DEFAULT_VDW_12_SCALE = 0.0;
    public static final double DEFAULT_VDW_13_SCALE = 0.0;
    public static final double DEFAULT_VDW_14_SCALE = 1.0;
    public final double radius;
    public final double wellDepth;
    public final double reductionFactor;
    public int atomClass;
    private final VDWMode vdwMode;

    public VDWType(int atomClass, double radius, double wellDepth, double reductionFactor) {
        this(atomClass, radius, wellDepth, reductionFactor, VDWMode.NORMAL);
    }

    public VDWType(int atomClass, double radius, double wellDepth, double reductionFactor, VDWMode vdwMode) {
        super(ForceField.ForceFieldType.VDW, Integer.toString(atomClass));
        this.atomClass = atomClass;
        this.radius = radius;
        this.wellDepth = StrictMath.abs(wellDepth);
        this.reductionFactor = reductionFactor;
        this.vdwMode = vdwMode;
        if (vdwMode == VDWMode.VDW14) {
            this.forceFieldType = ForceField.ForceFieldType.VDW14;
        }
    }

    public static VDWType average(VDWType vdwType1, VDWType vdwType2, int atomClass) {
        if (vdwType1 == null || vdwType2 == null) {
            return null;
        }
        double radius = (vdwType1.radius + vdwType2.radius) / 2.0;
        double wellDepth = (vdwType1.wellDepth + vdwType2.wellDepth) / 2.0;
        double reductionFactor = (vdwType1.reductionFactor + vdwType2.reductionFactor) / 2.0;
        return new VDWType(atomClass, radius, wellDepth, reductionFactor);
    }

    public static VDWType parse(String input, String[] tokens) {
        if (tokens.length < 4) {
            logger.log(Level.WARNING, "Invalid VDW type:\n{0}", input);
        } else {
            try {
                int atomType = Integer.parseInt(tokens[1]);
                double radius = Double.parseDouble(tokens[2]);
                double wellDepth = Double.parseDouble(tokens[3]);
                double reductionFactor = -1.0;
                if (tokens.length == 5) {
                    reductionFactor = Double.parseDouble(tokens[4]);
                }
                return new VDWType(atomType, radius, wellDepth, reductionFactor);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing VDW type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static VDWType parseVDW14(String input, String[] tokens) {
        if (tokens.length < 4) {
            logger.log(Level.WARNING, "Invalid VDW type:\n{0}", input);
        } else {
            try {
                int atomType = Integer.parseInt(tokens[1]);
                double radius = Double.parseDouble(tokens[2]);
                double wellDepth = Double.parseDouble(tokens[3]);
                double reductionFactor = -1.0;
                if (tokens.length == 5) {
                    reductionFactor = Double.parseDouble(tokens[4]);
                }
                return new VDWType(atomType, radius, wellDepth, reductionFactor, VDWMode.VDW14);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing VDW14 type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    @Override
    public int compare(String s1, String s2) {
        int t1 = Integer.parseInt(s1);
        int t2 = Integer.parseInt(s2);
        return Integer.compare(t1, t2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VDWType vdwType = (VDWType)o;
        return vdwType.atomClass == this.atomClass;
    }

    public int hashCode() {
        return Objects.hash(this.atomClass);
    }

    @Override
    public String toString() {
        StringBuilder vdwString = new StringBuilder("vdw");
        if (this.vdwMode == VDWMode.VDW14) {
            vdwString.append("14");
        }
        if (this.reductionFactor <= 0.0) {
            vdwString.append(String.format("  %5d  %11.9f  %11.9f", this.atomClass, this.radius, this.wellDepth));
        } else {
            vdwString.append(String.format("  %5d  %11.9f  %11.9f  %5.3f", this.atomClass, this.radius, this.wellDepth, this.reductionFactor));
        }
        return vdwString.toString();
    }

    public static Element getXMLForce(Document doc, ForceField forceField) {
        Map<String, VDWType> vdwTypes = forceField.getVDWTypes();
        Map<String, VDWPairType> vdwPairTypes = forceField.getVDWPairTypes();
        if (!vdwTypes.values().isEmpty() || !vdwPairTypes.values().isEmpty()) {
            Element node = doc.createElement("AmoebaVdwForce");
            node.setAttribute("type", forceField.getString("vdwtype", DEFAULT_VDW_TYPE.toString()));
            node.setAttribute("radiusrule", forceField.getString("radiusrule", DEFAULT_RADIUS_RULE.toString()));
            node.setAttribute("radiustype", forceField.getString("radiustype", DEFAULT_RADIUS_TYPE.toString()));
            node.setAttribute("radiussize", forceField.getString("radiussize", DEFAULT_RADIUS_SIZE.toString()));
            node.setAttribute("epsilonrule", forceField.getString("epsilonrule", DEFAULT_EPSILON_RULE.toString()));
            node.setAttribute("vdw-13-scale", String.valueOf(forceField.getDouble("vdw-13-scale", 0.0)));
            node.setAttribute("vdw-14-scale", String.valueOf(forceField.getDouble("vdw-14-scale", 1.0)));
            node.setAttribute("vdw-15-scale", String.valueOf(forceField.getDouble("vdw-15-scale", 1.0)));
            for (VDWType vdwType : vdwTypes.values()) {
                node.appendChild(vdwType.toXML(doc));
            }
            for (VDWPairType vdwPairType : vdwPairTypes.values()) {
                node.appendChild(vdwPairType.toXML(doc));
            }
            return node;
        }
        return null;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("Vdw");
        node.setAttribute("class", String.format("%d", this.atomClass));
        node.setAttribute("sigma", String.format("%.17f", this.radius * 0.1));
        node.setAttribute("epsilon", String.format("%.17f", this.wellDepth * 4.184));
        if (this.reductionFactor <= 0.0) {
            node.setAttribute("reduction", "1.0");
        } else {
            node.setAttribute("reduction", String.format("%.17f", this.reductionFactor));
        }
        return node;
    }

    void incrementClass(int increment) {
        this.atomClass += increment;
        this.setKey(Integer.toString(this.atomClass));
    }

    public static enum VDWMode {
        NORMAL,
        VDW14;

    }

    public static enum VDW_TYPE {
        BUFFERED_14_7,
        LENNARD_JONES;


        public String toString() {
            return this.name().replace("_", "-");
        }
    }

    public static enum RADIUS_RULE {
        ARITHMETIC,
        CUBIC_MEAN,
        GEOMETRIC;


        public String toString() {
            return this.name().replace("_", "-");
        }
    }

    public static enum RADIUS_TYPE {
        R_MIN,
        SIGMA;


        public String toString() {
            return this.name().replace("_", "-");
        }
    }

    public static enum RADIUS_SIZE {
        DIAMETER,
        RADIUS;

    }

    public static enum EPSILON_RULE {
        GEOMETRIC,
        HHG,
        W_H;


        public String toString() {
            return this.name().replace("_", "-");
        }
    }
}

