/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="vdwpr", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[2 integers and 2 reals]\nProvides the values for the vdw parameters for a single special heteroatomic pair of atoms.\nThe integer modifiers give the pair of atom class numbers for which special vdw parameters are to be defined.\nThe two real number modifiers give the values of the minimum energy contact distance in Angstroms and the well depth at the minimum distance in kcal/mole.\n")
public final class VDWPairType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(VDWPairType.class.getName());
    public final double radius;
    public final double wellDepth;
    public final int[] atomClasses;

    public VDWPairType(int[] atomClasses, double radius, double wellDepth) {
        super(ForceField.ForceFieldType.VDWPR, VDWPairType.sortKey(atomClasses));
        this.atomClasses = atomClasses;
        this.radius = radius;
        this.wellDepth = wellDepth;
    }

    public static VDWPairType average(VDWPairType vdwType1, VDWPairType vdwType2, int[] atomClasses) {
        if (vdwType1 == null || vdwType2 == null) {
            return null;
        }
        double radius = (vdwType1.radius + vdwType2.radius) / 2.0;
        double wellDepth = (vdwType1.wellDepth + vdwType2.wellDepth) / 2.0;
        return new VDWPairType(atomClasses, radius, wellDepth);
    }

    public static VDWPairType parse(String input, String[] tokens) {
        if (tokens.length < 5) {
            logger.log(Level.WARNING, "Invalid VDWPR type:\n{0}", input);
        } else {
            try {
                int atomClass1 = Integer.parseInt(tokens[1]);
                int atomClass2 = Integer.parseInt(tokens[2]);
                double radius = Double.parseDouble(tokens[3]);
                double wellDepth = Double.parseDouble(tokens[4]);
                return new VDWPairType(new int[]{atomClass1, atomClass2}, radius, wellDepth);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing VDWPR type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    @Override
    public int compare(String key1, String key2) {
        String[] keys1 = key1.split(" ");
        String[] keys2 = key2.split(" ");
        int[] c1 = new int[2];
        int[] c2 = new int[2];
        for (int i = 0; i < 2; ++i) {
            c1[i] = Integer.parseInt(keys1[i]);
            c2[i] = Integer.parseInt(keys2[i]);
        }
        if (c1[0] < c2[0]) {
            return -1;
        }
        if (c1[0] > c2[0]) {
            return 1;
        }
        if (c1[1] < c2[1]) {
            return -1;
        }
        if (c1[1] > c2[1]) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VDWPairType vdwPairType = (VDWPairType)o;
        return Arrays.equals(this.atomClasses, vdwPairType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    @Override
    public String toString() {
        return String.format("vdwpr  %5d  %5d  %11.9f  %11.9f", this.atomClasses[0], this.atomClasses[1], this.radius, this.wellDepth);
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("Pair");
        node.setAttribute("class1", String.format("%d", this.atomClasses[0]));
        node.setAttribute("class2", String.format("%d", this.atomClasses[1]));
        node.setAttribute("sigma", String.format("%.17f", this.radius * 0.1));
        node.setAttribute("epsilon", String.format("%.17f", this.wellDepth * 4.184));
        return node;
    }

    public static String sortKey(int[] c) {
        if (c == null || c.length != 2) {
            return null;
        }
        if (c[1] <= c[0]) {
            int temp = c[1];
            c[1] = c[0];
            c[0] = temp;
        }
        return c[0] + " " + c[1];
    }

    public void incrementClasses(int increment) {
        int i = 0;
        while (i < this.atomClasses.length) {
            int n = i++;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(VDWPairType.sortKey(this.atomClasses));
    }
}

