/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="tortors", clazz=String[].class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[7 integers, then multiple lines of 2 integers and 1 real]\nProvides the values for a single torsion-torsion parameter.\nThe first five integer modifiers give the atom class numbers for the atoms involved in the two adjacent torsional angles to be defined.\nThe last two integer modifiers contain the number of data grid points that lie along each axis of the torsion-torsion map.\nFor example, this value will be 13 for a 30 degree torsional angle spacing, i.e., 360/30 = 12, but 13\nvalues are required since data values for -180 and +180 degrees must both be supplied.\nThe subsequent lines contain the torsion-torsion map data as the integer values in degrees of each\ntorsional angle and the target energy value in kcal/mole.\n")
public final class TorsionTorsionType
extends BaseType
implements Comparator<String> {
    public static final double DEFAULT_TORTOR_UNIT = 1.0;
    @FFXProperty(name="tortorunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="1.0", description="Sets the scale factor needed to convert the energy value computed by the torsion-torsion potential into units of kcal/mole.\nThe correct value is force field dependent and typically provided in the header of the master force field parameter file.\n")
    public double torTorUnit = 1.0;
    private static final Logger logger = Logger.getLogger(TorsionTorsionType.class.getName());
    public final int[] atomClasses;
    public final double[] energy;
    public final int nx;
    public final int ny;
    public final double[] tx;
    public final double[] ty;
    public final double[] dx;
    public final double[] dy;
    public final double[] dxy;
    private final int[] gridPoints;

    public TorsionTorsionType(int[] atomClasses, int[] gridPoints, double[] torsion1, double[] torsion2, double[] energy) {
        super(ForceField.ForceFieldType.TORTORS, TorsionTorsionType.sortKey(atomClasses));
        int k;
        int j;
        this.atomClasses = atomClasses;
        this.nx = gridPoints[0];
        this.ny = gridPoints[1];
        if (this.nx != this.ny) {
            logger.severe("Untested TORTOR parameters: nx != ny: " + this.nx + ", " + this.ny);
        }
        this.energy = energy;
        this.gridPoints = gridPoints;
        this.tx = new double[this.nx];
        this.ty = new double[this.ny];
        this.dx = new double[this.nx * this.ny];
        this.dy = new double[this.nx * this.ny];
        this.dxy = new double[this.nx * this.ny];
        Arrays.sort(torsion1);
        Arrays.sort(torsion2);
        this.tx[0] = torsion1[0];
        this.ty[0] = torsion2[0];
        int j1 = 1;
        int j2 = 1;
        for (int i = 1; i < this.nx; ++i) {
            while (torsion1[j1] == this.tx[i - 1]) {
                ++j1;
            }
            while (torsion2[j2] == this.ty[i - 1]) {
                ++j2;
            }
            this.tx[i] = torsion1[j1];
            this.ty[i] = torsion2[j2];
        }
        boolean isCyclic = true;
        double eps = 1.0E-4;
        if (FastMath.abs((double)(this.tx[0] - this.tx[this.nx - 1])) - 360.0 > eps) {
            isCyclic = false;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(" tortor is aperiodic: " + this.tx[0] + ", " + this.tx[this.nx - 1]);
            }
        }
        if (isCyclic) {
            for (int i = 0; i < this.ny; ++i) {
                int k2 = i * this.nx;
                if (!(FastMath.abs((double)(energy[k2] - energy[k2 + this.nx - 1])) > eps)) continue;
                isCyclic = false;
                if (!logger.isLoggable(Level.FINEST)) break;
                logger.finest(" tortor is apreriodic: " + k2 + ", " + (k2 + this.nx - 1) + ": " + FastMath.abs((double)(energy[k2] - energy[k2 + this.nx - 1])));
                break;
            }
        }
        if (isCyclic) {
            int k3 = (this.ny - 1) * this.nx;
            for (int i = 0; i < this.nx; ++i) {
                if (!(FastMath.abs((double)(energy[i] - energy[i + k3])) > eps)) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.fine(" tortor is aperiodic: " + i + ", " + i + k3 + ": " + FastMath.abs((double)(energy[i] - energy[i + k3])));
                }
                isCyclic = false;
                break;
            }
        }
        boolean cyclic = isCyclic;
        double[] tmp1 = new double[this.nx];
        double[] tmp2 = new double[this.nx];
        double[] tmp3 = new double[this.nx];
        double[] tmp4 = new double[this.nx];
        double[] tmp5 = new double[this.nx];
        double[] tmp6 = new double[this.nx];
        double[] tmp7 = new double[this.nx];
        double[] bs = new double[this.nx];
        double[] cs = new double[this.nx];
        double[] ds = new double[this.nx];
        System.arraycopy(this.tx, 0, tmp1, 0, this.nx);
        int m = 0;
        for (j = 0; j < this.ny; ++j) {
            System.arraycopy(energy, m, tmp2, 0, this.nx);
            if (cyclic) {
                this.cspline(this.nx - 1, tmp1, tmp2, bs, cs, ds, tmp3, tmp4, tmp5, tmp6, tmp7);
            } else {
                this.nspline(this.nx - 1, tmp1, tmp2, 0.0, 0.0, bs, cs, tmp3, tmp4, tmp5, tmp6, tmp7);
            }
            System.arraycopy(bs, 0, this.dx, m, this.nx);
            m += this.nx;
        }
        System.arraycopy(this.ty, 0, tmp1, 0, this.ny);
        m = 0;
        for (j = 0; j < this.nx; ++j) {
            for (k = 0; k < this.ny; ++k) {
                tmp2[k] = energy[m + k * this.nx];
            }
            if (cyclic) {
                this.cspline(this.ny - 1, tmp1, tmp2, bs, cs, ds, tmp3, tmp4, tmp5, tmp6, tmp7);
            } else {
                this.nspline(this.ny - 1, tmp1, tmp2, 0.0, 0.0, bs, cs, tmp3, tmp4, tmp5, tmp6, tmp7);
            }
            for (k = 0; k < this.ny; ++k) {
                this.dy[m + k * this.nx] = bs[k];
            }
            ++m;
        }
        m = 0;
        for (j = 0; j < this.nx; ++j) {
            for (k = 0; k < this.ny; ++k) {
                tmp2[k] = this.dx[m + k * this.nx];
            }
            if (cyclic) {
                this.cspline(this.ny - 1, tmp1, tmp2, bs, cs, ds, tmp3, tmp4, tmp5, tmp6, tmp7);
            } else {
                this.nspline(this.ny - 1, tmp1, tmp2, 0.0, 0.0, bs, cs, tmp3, tmp4, tmp5, tmp6, tmp7);
            }
            for (k = 0; k < this.ny; ++k) {
                this.dxy[m + k * this.nx] = bs[k];
            }
            ++m;
        }
    }

    public static TorsionTorsionType average(@Nullable TorsionTorsionType torsionTorsionType1, @Nullable TorsionTorsionType torsionTorsionType2, @Nullable int[] atomClasses) {
        if (torsionTorsionType1 == null || torsionTorsionType2 == null || atomClasses == null) {
            return null;
        }
        return null;
    }

    public static TorsionTorsionType parse(String input, String[] tokens, BufferedReader br) {
        if (tokens.length < 8) {
            logger.log(Level.WARNING, "Invalid TORTORS type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[5];
                for (int i = 0; i < 5; ++i) {
                    atomClasses[i] = Integer.parseInt(tokens[i + 1]);
                }
                int[] gridPoints = new int[]{Integer.parseInt(tokens[6]), Integer.parseInt(tokens[7])};
                int points = gridPoints[0] * gridPoints[1];
                double[] torsion1 = new double[points];
                double[] torsion2 = new double[points];
                double[] energy = new double[points];
                for (int i = 0; i < points; ++i) {
                    input = br.readLine();
                    tokens = input.trim().split(" +");
                    if (tokens.length == 3) {
                        torsion1[i] = Double.parseDouble(tokens[0]);
                        torsion2[i] = Double.parseDouble(tokens[1]);
                        energy[i] = Double.parseDouble(tokens[2]);
                        continue;
                    }
                    if (tokens.length == 6) {
                        torsion1[i] = Double.parseDouble(tokens[0]);
                        torsion2[i] = Double.parseDouble(tokens[1]);
                        energy[i] = Double.parseDouble(tokens[2]);
                        torsion1[i + 1] = Double.parseDouble(tokens[3]);
                        torsion2[i + 1] = Double.parseDouble(tokens[4]);
                        energy[i + 1] = Double.parseDouble(tokens[5]);
                        ++i;
                        continue;
                    }
                    if (tokens.length == 9) {
                        torsion1[i] = Double.parseDouble(tokens[0]);
                        torsion2[i] = Double.parseDouble(tokens[1]);
                        energy[i] = Double.parseDouble(tokens[2]);
                        torsion1[i + 1] = Double.parseDouble(tokens[3]);
                        torsion2[i + 1] = Double.parseDouble(tokens[4]);
                        energy[i + 1] = Double.parseDouble(tokens[5]);
                        torsion1[i + 2] = Double.parseDouble(tokens[6]);
                        torsion2[i + 2] = Double.parseDouble(tokens[7]);
                        energy[i + 2] = Double.parseDouble(tokens[8]);
                        i += 2;
                        continue;
                    }
                    logger.log(Level.WARNING, "Invalid TORTORS type:\n{0}", input);
                    return null;
                }
                return new TorsionTorsionType(atomClasses, gridPoints, torsion1, torsion2, energy);
            }
            catch (IOException | NumberFormatException e) {
                String message = "Exception parsing TORTORS type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static TorsionTorsionType parse(String input, String[] tokens) {
        if (tokens.length < 8) {
            logger.log(Level.WARNING, "Invalid TORTORS type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[5];
                for (int i = 0; i < 5; ++i) {
                    atomClasses[i] = Integer.parseInt(tokens[i + 1]);
                }
                int[] gridPoints = new int[]{Integer.parseInt(tokens[6]), Integer.parseInt(tokens[7])};
                int points = gridPoints[0] * gridPoints[1];
                int numTokens = points * 3 + 8;
                if (tokens.length < numTokens) {
                    logger.log(Level.WARNING, "Invalid TORTORS type:\n{0}", input);
                    return null;
                }
                double[] torsion1 = new double[points];
                double[] torsion2 = new double[points];
                double[] energy = new double[points];
                int index = 8;
                for (int i = 0; i < points; ++i) {
                    torsion1[i] = Double.parseDouble(tokens[index++]);
                    torsion2[i] = Double.parseDouble(tokens[index++]);
                    energy[i] = Double.parseDouble(tokens[index++]);
                }
                return new TorsionTorsionType(atomClasses, gridPoints, torsion1, torsion2, energy);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing TORTORS type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static String reverseKey(int[] c) {
        return c[4] + " " + c[3] + " " + c[2] + " " + c[1] + " " + c[0];
    }

    public static String sortKey(int[] c) {
        return c[0] + " " + c[1] + " " + c[2] + " " + c[3] + " " + c[4];
    }

    private static int cytsy(int n, double[] dm, double[] du, double[] cr, double[] rs, double[] c) {
        if (n < 3) {
            return -2;
        }
        if (TorsionTorsionType.cytsyp(n, dm, du, cr) == 1) {
            TorsionTorsionType.cytsys(n, dm, du, cr, rs, c);
            return 1;
        }
        return -1;
    }

    private static int cytsyp(int n, double[] dm, double[] du, double[] cr) {
        int i;
        double eps = 1.0E-8;
        if (n < 3) {
            return -2;
        }
        double row = FastMath.abs((double)dm[1]) + FastMath.abs((double)du[1]) + FastMath.abs((double)du[n]);
        if (row == 0.0) {
            return 0;
        }
        double d = 1.0 / row;
        if (dm[1] < 0.0) {
            return -1;
        }
        if (FastMath.abs((double)dm[1]) * d < eps) {
            return 0;
        }
        double temp1 = du[1];
        double temp2 = 0.0;
        du[1] = du[1] / dm[1];
        cr[1] = du[n] / dm[1];
        for (i = 2; i < n; ++i) {
            row = FastMath.abs((double)dm[i]) + FastMath.abs((double)du[i]) + FastMath.abs((double)temp1);
            if (row == 0.0) {
                return 0;
            }
            d = 1.0 / row;
            dm[i] = dm[i] - temp1 * du[i - 1];
            if (dm[i] < 0.0) {
                return -1;
            }
            if (FastMath.abs((double)dm[i]) * d < eps) {
                return 0;
            }
            if (i < n - 1) {
                cr[i] = -temp1 * cr[i - 1] / dm[i];
                temp1 = du[i];
                du[i] = du[i] / dm[i];
                continue;
            }
            temp2 = du[i];
            du[i] = (du[i] - temp1 * cr[i - 1]) / dm[i];
        }
        row = FastMath.abs((double)du[n]) + FastMath.abs((double)dm[n]) + FastMath.abs((double)temp2);
        if (row == 0.0) {
            return 0;
        }
        d = 1.0 / row;
        dm[n] = dm[n] - dm[n - 1] * du[n - 1] * du[n - 1];
        temp1 = 0.0;
        for (i = 1; i < n - 1; ++i) {
            temp1 += dm[i] * cr[i] * cr[i];
        }
        dm[n] = dm[n] - temp1;
        if (dm[n] < 0.0) {
            return -1;
        }
        if (FastMath.abs((double)dm[n]) * d < eps) {
            return 0;
        }
        return 1;
    }

    private static void cytsys(int n, double[] dm, double[] du, double[] cr, double[] rs, double[] c) {
        int i;
        double temp = rs[1];
        rs[1] = temp / dm[1];
        double sum = cr[1] * temp;
        for (i = 2; i < n; ++i) {
            temp = rs[i] - du[i - 1] * temp;
            rs[i] = temp / dm[i];
            if (i == n - 1) continue;
            sum += cr[i] * temp;
        }
        temp = rs[n] - du[n - 1] * temp;
        rs[n] = (temp -= sum) / dm[n];
        c[n] = rs[n];
        c[n - 1] = rs[n - 1] - du[n - 1] * c[n];
        for (i = n - 2; i >= 1; --i) {
            c[i] = rs[i] - du[i] * c[i + 1] - cr[i] * c[n];
        }
    }

    @Override
    public int compare(String key1, String key2) {
        int c2;
        String[] keys1 = key1.split(" ");
        String[] keys2 = key2.split(" ");
        int c1 = Integer.parseInt(keys1[2]);
        if (c1 < (c2 = Integer.parseInt(keys2[2]))) {
            return -1;
        }
        if (c1 > c2) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TorsionTorsionType torsionTorsionType = (TorsionTorsionType)o;
        return Arrays.equals(this.atomClasses, torsionTorsionType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        int i = 0;
        while (i < this.atomClasses.length) {
            int n = i++;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(TorsionTorsionType.sortKey(this.atomClasses));
    }

    public void patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count > 0 && count < this.atomClasses.length) {
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < this.atomClasses.length; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    this.atomClasses[i] = knownType.atomClass;
                }
            }
            this.setKey(TorsionTorsionType.sortKey(this.atomClasses));
        }
    }

    @Override
    public String toString() {
        StringBuilder tortorBuffer = new StringBuilder("tortors");
        for (int i : this.atomClasses) {
            tortorBuffer.append(String.format("  %5d", i));
        }
        tortorBuffer.append(String.format("  %2d  %2d", this.gridPoints[0], this.gridPoints[1]));
        for (int i = 0; i < this.energy.length; ++i) {
            int nxi = i % this.nx;
            int nyi = i / this.ny;
            tortorBuffer.append(String.format(" \\\n  % 6.1f  % 6.1f  % 8.5f", this.tx[nxi], this.ty[nyi], this.energy[i]));
            if (i < this.energy.length - 1) {
                nxi = ++i % this.nx;
                nyi = i / this.ny;
                tortorBuffer.append(String.format("  % 6.1f  % 6.1f  % 8.5f", this.tx[nxi], this.ty[nyi], this.energy[i]));
            }
            if (i >= this.energy.length - 1) continue;
            nxi = ++i % this.nx;
            nyi = i / this.ny;
            tortorBuffer.append(String.format("  % 6.1f  % 6.1f  % 8.5f", this.tx[nxi], this.ty[nyi], this.energy[i]));
        }
        return tortorBuffer.toString();
    }

    public static Element getXMLForce(Document doc, ForceField forceField) {
        Map<String, TorsionTorsionType> types = forceField.getTorsionTorsionTypes();
        if (!types.values().isEmpty()) {
            Element node = doc.createElement("AmoebaTorsionTorsionForce");
            int i = 0;
            for (TorsionTorsionType torsionTorsionType : types.values()) {
                torsionTorsionType.toXML(doc, node, i);
                ++i;
            }
            return node;
        }
        return null;
    }

    public void toXML(Document doc, Element torTorNode, int label) {
        Element tortors = doc.createElement("TorsionTorsion");
        Element ttGrid = doc.createElement("TorsionTorsionGrid");
        tortors.setAttribute("class1", String.format("%d", this.atomClasses[0]));
        tortors.setAttribute("class2", String.format("%d", this.atomClasses[1]));
        tortors.setAttribute("class3", String.format("%d", this.atomClasses[2]));
        tortors.setAttribute("class4", String.format("%d", this.atomClasses[3]));
        tortors.setAttribute("class5", String.format("%d", this.atomClasses[4]));
        tortors.setAttribute("nx", String.format("%d", this.gridPoints[0]));
        tortors.setAttribute("ny", String.format("%d", this.gridPoints[1]));
        ttGrid.setAttribute("nx", String.format("%d", this.gridPoints[0]));
        ttGrid.setAttribute("ny", String.format("%d", this.gridPoints[1]));
        for (int i = 0; i < this.energy.length; ++i) {
            int nxi = i % this.nx;
            int nyi = i / this.ny;
            Element grid = doc.createElement("Grid");
            grid.setAttribute("angle1", String.format("%f", this.tx[nxi]));
            grid.setAttribute("angle2", String.format("%f", this.ty[nyi]));
            grid.setAttribute("f", String.format("%f", this.energy[i] * 4.184));
            ttGrid.appendChild(grid);
        }
        tortors.setAttribute("grid", String.valueOf(label));
        ttGrid.setAttribute("grid", String.valueOf(label));
        torTorNode.appendChild(tortors);
        torTorNode.appendChild(ttGrid);
    }

    private void nspline(int n, double[] x0, double[] y0, double y21, double y2n, double[] s1, double[] s2, double[] h, double[] g, double[] dy, double[] dla, double[] dmu) {
        int i;
        for (i = 0; i < n; ++i) {
            h[i] = x0[i + 1] - x0[i];
            dy[i] = (y0[i + 1] - y0[i]) / h[i];
        }
        for (i = 1; i < n; ++i) {
            dla[i] = h[i] / (h[i] + h[i - 1]);
            dmu[i] = 1.0 - dla[i];
            g[i] = 3.0 * (dla[i] * dy[i - 1] + dmu[i] * dy[i]);
        }
        dla[n] = 1.0;
        dla[0] = 0.0;
        dmu[n] = 0.0;
        dmu[0] = 1.0;
        g[0] = 3.0 * dy[0] - 0.5 * h[0] * y21;
        g[n] = 3.0 * dy[n - 1] + 0.5 * h[n - 1] * y2n;
        dmu[0] = 0.5 * dmu[0];
        g[0] = 0.5 * g[0];
        for (i = 1; i <= n; ++i) {
            double t = 2.0 - dmu[i - 1] * dla[i];
            dmu[i] = dmu[i] / t;
            g[i] = (g[i] - g[i - 1] * dla[i]) / t;
        }
        for (i = n - 1; i >= 0; --i) {
            g[i] = g[i] - dmu[i] * g[i + 1];
        }
        System.arraycopy(g, 0, s1, 0, n + 1);
        s2[0] = y21;
        s2[n] = y2n;
        for (i = 1; i < n; ++i) {
            s2[i] = 6.0 * (y0[i + 1] - y0[i]) / (h[i] * h[i]) - 4.0 * s1[i] / h[i] - 2.0 * s1[i + 1] / h[i];
        }
    }

    private void cspline(int n, double[] xn, double[] fn, double[] b, double[] c, double[] d, double[] h, double[] du, double[] dm, double[] rc, double[] rs) {
        int i;
        int i2;
        double mean;
        double eps = 1.0E-6;
        if (FastMath.abs((double)(fn[n] - fn[0])) > eps) {
            logger.severe("TORTOR values are not periodic.");
        }
        fn[0] = mean = 0.5 * (fn[0] + fn[n]);
        fn[n] = mean;
        for (i2 = 0; i2 < n; ++i2) {
            h[i2] = xn[i2 + 1] - xn[i2];
        }
        h[n] = h[0];
        if (n - 1 >= 0) {
            System.arraycopy(h, 1, du, 1, n - 1);
        }
        du[n] = h[0];
        for (i2 = 1; i2 <= n; ++i2) {
            dm[i2] = 2.0 * (h[i2 - 1] + h[i2]);
        }
        double temp1 = (fn[1] - fn[0]) / h[0];
        for (i = 1; i < n; ++i) {
            double temp2 = (fn[i + 1] - fn[i]) / h[i];
            rs[i] = 3.0 * (temp2 - temp1);
            temp1 = temp2;
        }
        rs[n] = 3.0 * ((fn[1] - fn[0]) / h[0] - temp1);
        if (TorsionTorsionType.cytsy(n, dm, du, rc, rs, c) != 1) {
            return;
        }
        c[0] = c[n];
        for (i = 0; i < n; ++i) {
            b[i] = (fn[i + 1] - fn[i]) / h[i] - h[i] / 3.0 * (c[i + 1] + 2.0 * c[i]);
            d[i] = (c[i + 1] - c[i]) / (3.0 * h[i]);
        }
        b[n] = (fn[1] - fn[n]) / h[n] - h[n] / 3.0 * (c[1] + 2.0 * c[n]);
    }
}

