/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="strtors", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[2 integers and 1 real]\nProvides the values for a single stretch-torsion cross term potential parameter.\nThe two integer modifiers give the atom class numbers for the atoms involved in the central bond of the torsional angles to be parameterized.\nThe real modifier gives the value of the stretch-torsion force constant for all torsional angles with the defined atom classes for the central bond.\nThe default units for the stretch-torsion force constant can be controlled via the strtorunit keyword.\n")
public final class StretchTorsionType
extends BaseType
implements Comparator<String> {
    public static final double DEFAULT_STRTOR_UNIT = 1.0;
    @FFXProperty(name="strtorunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="1.0", description="Sets the scale factor needed to convert the energy value computed by the bond stretching-torsional\nangle cross term potential into units of kcal/mole. The correct value is force field dependent and typically\nprovided in the header of the master force field parameter file.\n")
    public double strTorUnit = 1.0;
    private static final Logger logger = Logger.getLogger(StretchTorsionType.class.getName());
    public final int[] atomClasses;
    public final double[] forceConstants;

    public StretchTorsionType(int[] atomClasses, double[] forceConstants) {
        super(ForceField.ForceFieldType.STRTORS, StretchTorsionType.sortKey(atomClasses));
        this.atomClasses = atomClasses;
        this.forceConstants = forceConstants;
    }

    public static StretchTorsionType average(StretchTorsionType stretchTorsionType1, StretchTorsionType stretchTorsionType2, int[] atomClasses) {
        if (stretchTorsionType1 == null || stretchTorsionType2 == null || atomClasses == null) {
            return null;
        }
        int len = stretchTorsionType1.forceConstants.length;
        if (len != stretchTorsionType2.forceConstants.length) {
            return null;
        }
        double[] forceConstants = new double[len];
        for (int i = 0; i < len; ++i) {
            forceConstants[i] = (stretchTorsionType1.forceConstants[i] + stretchTorsionType2.forceConstants[i]) / 2.0;
        }
        return new StretchTorsionType(atomClasses, forceConstants);
    }

    public static StretchTorsionType parse(String input, String[] tokens) {
        if (tokens.length < 13) {
            logger.log(Level.WARNING, "Invalid STRTORS type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4])};
                double[] constants = new double[]{Double.parseDouble(tokens[5]), Double.parseDouble(tokens[6]), Double.parseDouble(tokens[7]), Double.parseDouble(tokens[8]), Double.parseDouble(tokens[9]), Double.parseDouble(tokens[10]), Double.parseDouble(tokens[11]), Double.parseDouble(tokens[12]), Double.parseDouble(tokens[13])};
                return new StretchTorsionType(atomClasses, constants);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing STRTORS type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static String sortKey(int[] c) {
        return c[0] + " " + c[1] + " " + c[2] + " " + c[3];
    }

    @Override
    public int compare(String s1, String s2) {
        String[] keys1 = s1.split(" ");
        String[] keys2 = s2.split(" ");
        int[] c1 = new int[4];
        int[] c2 = new int[4];
        for (int i = 0; i < 4; ++i) {
            c1[i] = Integer.parseInt(keys1[i]);
            c2[i] = Integer.parseInt(keys2[i]);
        }
        if (c1[1] < c2[1]) {
            return -1;
        }
        if (c1[1] > c2[1]) {
            return 1;
        }
        if (c1[2] < c2[2]) {
            return -1;
        }
        if (c1[2] > c2[2]) {
            return 1;
        }
        if (c1[0] < c2[0]) {
            return -1;
        }
        if (c1[0] > c2[0]) {
            return 1;
        }
        if (c1[3] < c2[3]) {
            return -1;
        }
        if (c1[3] > c2[3]) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StretchTorsionType stretchTorsionType = (StretchTorsionType)o;
        return Arrays.equals(this.atomClasses, stretchTorsionType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        int i = 0;
        while (i < this.atomClasses.length) {
            int n = i++;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(StretchTorsionType.sortKey(this.atomClasses));
    }

    public StretchTorsionType patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        int len = this.atomClasses.length;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count == 1 || count == 2) {
            int[] newClasses = Arrays.copyOf(this.atomClasses, len);
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < len; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    newClasses[i] = knownType.atomClass;
                }
            }
            return new StretchTorsionType(newClasses, this.forceConstants);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("strtors  %5d  %5d  %5d  %5d  %6.3f  %6.3f  %6.3f  %6.3f  %6.3f  %6.3f  %6.3f  %6.3f  %6.3f", this.atomClasses[0], this.atomClasses[1], this.atomClasses[2], this.atomClasses[3], this.forceConstants[0], this.forceConstants[1], this.forceConstants[2], this.forceConstants[3], this.forceConstants[4], this.forceConstants[5], this.forceConstants[6], this.forceConstants[7], this.forceConstants[8]);
    }

    public static Element getXMLForce(Document doc, ForceField forceField) {
        Map<String, StretchTorsionType> types = forceField.getStretchTorsionTypes();
        if (!types.values().isEmpty()) {
            Element node = doc.createElement("AmoebaStretchTorsionForce");
            for (StretchTorsionType stretchTorsionType : types.values()) {
                node.appendChild(stretchTorsionType.toXML(doc));
            }
            return node;
        }
        return null;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("Torsion");
        node.setAttribute("class1", String.format("%d", this.atomClasses[0]));
        node.setAttribute("class2", String.format("%d", this.atomClasses[1]));
        node.setAttribute("class3", String.format("%d", this.atomClasses[2]));
        node.setAttribute("class4", String.format("%d", this.atomClasses[3]));
        node.setAttribute("v11", String.format("%.17f", this.forceConstants[0] * 4.184 / 0.1));
        node.setAttribute("v12", String.format("%.17f", this.forceConstants[1] * 4.184 / 0.1));
        node.setAttribute("v13", String.format("%.17f", this.forceConstants[2] * 4.184 / 0.1));
        node.setAttribute("v21", String.format("%.17f", this.forceConstants[3] * 4.184 / 0.1));
        node.setAttribute("v22", String.format("%.17f", this.forceConstants[4] * 4.184 / 0.1));
        node.setAttribute("v23", String.format("%.17f", this.forceConstants[5] * 4.184 / 0.1));
        node.setAttribute("v31", String.format("%.17f", this.forceConstants[6] * 4.184 / 0.1));
        node.setAttribute("v32", String.format("%.17f", this.forceConstants[7] * 4.184 / 0.1));
        node.setAttribute("v33", String.format("%.17f", this.forceConstants[8] * 4.184 / 0.1));
        return node;
    }
}

