/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import java.util.Comparator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RelativeSolvationType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(RelativeSolvationType.class.getName());
    private final String resName;
    private final double solvEnergy;

    public RelativeSolvationType(String resname, double solvEnergy) {
        super(ForceField.ForceFieldType.RELATIVESOLV, resname);
        this.resName = resname;
        this.solvEnergy = solvEnergy;
    }

    public static RelativeSolvationType parse(String input, String[] tokens) {
        if (tokens.length < 3) {
            logger.log(Level.WARNING, "Invalid RELATIVE_SOLVATION type:\n{0}", input);
            return null;
        }
        String resName = tokens[1];
        try {
            double relSolvValue = Double.parseDouble(tokens[2]);
            return new RelativeSolvationType(resName, relSolvValue);
        }
        catch (NumberFormatException ex) {
            String message = "Exception parsing RELATIVE_SOLVATION type:\n" + input + "\n";
            logger.log(Level.SEVERE, message, ex);
            return null;
        }
    }

    @Override
    public int compare(String o1, String o2) {
        return o1.compareTo(o2);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RelativeSolvationType) {
            return ((RelativeSolvationType)o).getResName().equals(this.resName);
        }
        return false;
    }

    public String getResName() {
        return this.resName;
    }

    public double getSolvEnergy() {
        return this.solvEnergy;
    }

    public int hashCode() {
        return Objects.hash(this.resName);
    }

    @Override
    public String toString() {
        return String.format("relative solvation %10s %8.5f", this.resName, this.solvEnergy);
    }
}

