/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="polarize", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[1 integer, up to 3 reals and up to 8 integers]\nProvides the values for a single atomic dipole polarizability parameter.\nThe initial integer modifier, if positive, gives the atom type number for which a polarizability parameter is to be defined.\nIf the first integer modifier is negative, then the parameter value to follow applies only to the specific atom whose atom number is the negative of the modifier.\nThe first real number modifier gives the value of the dipole polarizability in Ang^3.\nThe second real number modifier, if present, gives the Thole damping value.\nA Thole value of zero implies undamped polarization.\nThe third real modifier, if present, gives a direct field damping value only used with the AMOEBA+ polarization model.\nThe remaining integer modifiers list the atom type numbers of atoms directly bonded to the current atom and which will be considered to be part of the current atom\u2019s polarization group.\nIf the parameter is for a specific atom, then the integers defining the polarization group are ignored.\n")
public final class PolarizeType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(PolarizeType.class.getName());
    private static final double sixth = 0.16666666666666666;
    public static final double DEFAULT_DIRECT_11_SCALE = 0.0;
    public static final double DEFAULT_DIRECT_12_SCALE = 1.0;
    public static final double DEFAULT_DIRECT_13_SCALE = 1.0;
    public static final double DEFAULT_DIRECT_14_SCALE = 1.0;
    public static final double DEFAULT_POLAR_12_SCALE = 0.0;
    public static final double DEFAULT_POLAR_13_SCALE = 0.0;
    public static final double DEFAULT_POLAR_14_SCALE = 1.0;
    public static final double DEFAULT_POLAR_15_SCALE = 1.0;
    public static final double DEFAULT_POLAR_12_INTRA = 0.0;
    public static final double DEFAULT_POLAR_13_INTRA = 0.0;
    public static final double DEFAULT_POLAR_14_INTRA = 0.5;
    public static final double DEFAULT_POLAR_15_INTRA = 1.0;
    public final double thole;
    public double pdamp;
    public final double ddp;
    public final double polarizability;
    public int type;
    public int[] polarizationGroup;

    public PolarizeType(int atomType, double polarizability, double thole, double ddp, int[] polarizationGroup) {
        super(ForceField.ForceFieldType.POLARIZE, Integer.toString(atomType));
        this.type = atomType;
        this.thole = thole;
        this.polarizability = polarizability;
        this.ddp = 0.0;
        this.polarizationGroup = polarizationGroup;
        this.pdamp = thole == 0.0 ? 0.0 : FastMath.pow((double)polarizability, (double)0.16666666666666666);
    }

    public PolarizeType(PolarizeType polarizeType, double polarizability) {
        this(polarizeType.type, polarizability, polarizeType.thole, polarizeType.ddp, Arrays.copyOf(polarizeType.polarizationGroup, polarizeType.polarizationGroup.length));
        this.pdamp = polarizeType.pdamp;
    }

    public static void assignPolarizationGroups(Atom[] atoms, int[][] ip11, int[][] ip12, int[][] ip13) {
        int i;
        ArrayList<Integer> group = new ArrayList<Integer>();
        ArrayList<Integer> polarizationGroup = new ArrayList<Integer>();
        for (Atom ai : atoms) {
            group.clear();
            polarizationGroup.clear();
            int index = ai.getIndex() - 1;
            group.add(index);
            polarizationGroup.add(ai.getType());
            PolarizeType polarizeType = ai.getPolarizeType();
            if (polarizeType != null) {
                int k;
                Iterator iterator;
                if (polarizeType.polarizationGroup != null) {
                    for (int i2 : polarizeType.polarizationGroup) {
                        if (polarizationGroup.contains(i2)) continue;
                        polarizationGroup.add(i2);
                    }
                    PolarizeType.growGroup(polarizationGroup, group, ai);
                    Collections.sort(group);
                    ip11[index] = new int[group.size()];
                    int j = 0;
                    iterator = group.iterator();
                    while (iterator.hasNext()) {
                        k = (Integer)iterator.next();
                        ip11[index][j++] = k;
                    }
                    continue;
                }
                ip11[index] = new int[group.size()];
                int j = 0;
                iterator = group.iterator();
                while (iterator.hasNext()) {
                    k = (Integer)iterator.next();
                    ip11[index][j++] = k;
                }
                continue;
            }
            String message = "The polarize keyword was not found for atom " + (index + 1) + " with type " + ai.getType();
            logger.severe(message);
        }
        int nAtoms = atoms.length;
        int[] mask = new int[nAtoms];
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Integer> keep = new ArrayList<Integer>();
        for (i = 0; i < nAtoms; ++i) {
            mask[i] = -1;
        }
        for (i = 0; i < nAtoms; ++i) {
            int j;
            list.clear();
            for (int j2 : ip11[i]) {
                list.add(j2);
                mask[j2] = i;
            }
            keep.clear();
            Object polarizeType = list.iterator();
            while (polarizeType.hasNext()) {
                j = (Integer)polarizeType.next();
                Atom aj = atoms[j];
                List<Bond> bonds = aj.getBonds();
                for (Bond b : bonds) {
                    Atom ak = b.get1_2(aj);
                    int k = ak.getIndex() - 1;
                    if (mask[k] == i) continue;
                    keep.add(k);
                }
            }
            list.clear();
            polarizeType = keep.iterator();
            while (polarizeType.hasNext()) {
                j = (Integer)polarizeType.next();
                for (int k : ip11[j]) {
                    list.add(k);
                }
            }
            Collections.sort(list);
            ip12[i] = new int[list.size()];
            int j3 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                ip12[i][j3++] = k;
            }
        }
        for (i = 0; i < nAtoms; ++i) {
            mask[i] = -1;
        }
        for (i = 0; i < nAtoms; ++i) {
            for (int j2 : ip11[i]) {
                mask[j2] = i;
            }
            for (int j2 : ip12[i]) {
                mask[j2] = i;
            }
            list.clear();
            for (int j2 : ip12[i]) {
                for (int k : ip12[j2]) {
                    if (mask[k] == i || list.contains(k)) continue;
                    list.add(k);
                }
            }
            ip13[i] = new int[list.size()];
            Collections.sort(list);
            int j = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                ip13[i][j++] = k;
            }
        }
    }

    public static PolarizeType average(PolarizeType polarizeType1, PolarizeType polarizeType2, int atomType, int[] polarizationGroup) {
        if (polarizeType1 == null || polarizeType2 == null) {
            return null;
        }
        double thole = (polarizeType1.thole + polarizeType2.thole) / 2.0;
        double polarizability = (polarizeType1.polarizability + polarizeType2.polarizability) / 2.0;
        double ddp = (polarizeType1.ddp + polarizeType2.ddp) / 2.0;
        return new PolarizeType(atomType, polarizability, thole, ddp, polarizationGroup);
    }

    public static PolarizeType parse(String input, String[] tokens) {
        if (tokens.length < 4) {
            logger.log(Level.WARNING, "Invalid POLARIZE type:\n{0}", input);
        } else {
            try {
                int atomType = Integer.parseInt(tokens[1]);
                double polarizability = Double.parseDouble(tokens[2]);
                double thole = Double.parseDouble(tokens[3]);
                double ddp = 0.0;
                int nextToken = 4;
                try {
                    Integer.parseInt(tokens[nextToken]);
                }
                catch (NumberFormatException e) {
                    ddp = Double.parseDouble(tokens[nextToken]);
                    nextToken = 5;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                int entries = tokens.length - nextToken;
                int[] polarizationGroup = null;
                if (entries > 0) {
                    polarizationGroup = new int[entries];
                    for (int i = nextToken; i < tokens.length; ++i) {
                        polarizationGroup[i - nextToken] = Integer.parseInt(tokens[i]);
                    }
                }
                return new PolarizeType(atomType, polarizability, thole, ddp, polarizationGroup);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing POLARIZE type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    private static void growGroup(List<Integer> polarizationGroup, List<Integer> group, Atom seed) {
        List<Bond> bonds = seed.getBonds();
        for (Bond bi : bonds) {
            Atom aj = bi.get1_2(seed);
            int tj = aj.getType();
            boolean added = false;
            for (int g : polarizationGroup) {
                Integer index;
                if (g != tj || group.contains(index = Integer.valueOf(aj.getIndex() - 1))) continue;
                group.add(index);
                added = true;
                break;
            }
            if (!added) continue;
            PolarizeType polarizeType = aj.getPolarizeType();
            for (int i : polarizeType.polarizationGroup) {
                if (polarizationGroup.contains(i)) continue;
                polarizationGroup.add(i);
            }
            PolarizeType.growGroup(polarizationGroup, group, aj);
        }
    }

    public static void growGroup(List<Integer> group, Atom seed) {
        List<Bond> bonds = seed.getBonds();
        for (Bond bond : bonds) {
            Atom atom = bond.get1_2(seed);
            int tj = atom.getType();
            boolean added = false;
            PolarizeType polarizeType = seed.getPolarizeType();
            for (int type : polarizeType.polarizationGroup) {
                Integer index;
                if (type != tj || group.contains(index = Integer.valueOf(atom.getIndex() - 1))) continue;
                group.add(index);
                added = true;
                break;
            }
            if (!added) continue;
            PolarizeType.growGroup(group, atom);
        }
    }

    public void add(int atomType) {
        for (int i : this.polarizationGroup) {
            if (atomType != i) continue;
            return;
        }
        int len = this.polarizationGroup.length;
        int[] newGroup = new int[len + 1];
        System.arraycopy(this.polarizationGroup, 0, newGroup, 0, len);
        newGroup[len] = atomType;
        this.polarizationGroup = newGroup;
    }

    @Override
    public int compare(String s1, String s2) {
        int t1 = Integer.parseInt(s1);
        int t2 = Integer.parseInt(s2);
        return Integer.compare(t1, t2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolarizeType polarizeType = (PolarizeType)o;
        return polarizeType.type == this.type;
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    @Override
    public String toString() {
        StringBuilder polarizeString = new StringBuilder(String.format("polarize  %5d  %8.5f %8.5f", this.type, this.polarizability, this.thole));
        if (this.ddp != 0.0) {
            polarizeString.append(String.format(" %8.5f", this.ddp));
        }
        if (this.polarizationGroup != null) {
            for (int a : this.polarizationGroup) {
                polarizeString.append(String.format("  %5d", a));
            }
        }
        return polarizeString.toString();
    }

    public static void addXMLAttributes(Element node, ForceField forceField) {
        node.setAttribute("direct11Scale", String.valueOf(forceField.getDouble("direct-11-scale", 0.0)));
        node.setAttribute("direct12Scale", String.valueOf(forceField.getDouble("direct-12-scale", 1.0)));
        node.setAttribute("direct13Scale", String.valueOf(forceField.getDouble("direct-13-scale", 1.0)));
        node.setAttribute("direct14Scale", String.valueOf(forceField.getDouble("direct-14-scale", 1.0)));
        node.setAttribute("mutual11Scale", String.valueOf(forceField.getDouble("mutual-11-scale", 1.0)));
        node.setAttribute("mutual12Scale", String.valueOf(forceField.getDouble("mutual-12-scale", 1.0)));
        node.setAttribute("mutual13Scale", String.valueOf(forceField.getDouble("mutual-13-scale", 1.0)));
        node.setAttribute("mutual14Scale", String.valueOf(forceField.getDouble("mutual-14-scale", 1.0)));
        node.setAttribute("polar12Scale", String.valueOf(forceField.getDouble("polar-12-scale", 0.0)));
        node.setAttribute("polar13Scale", String.valueOf(forceField.getDouble("polar-13-scale", 0.0)));
        node.setAttribute("polar14Scale", String.valueOf(forceField.getDouble("polar-14-scale", 1.0)));
        node.setAttribute("polar15Scale", String.valueOf(forceField.getDouble("polar-15-scale", 1.0)));
        node.setAttribute("polar14Intra", String.valueOf(forceField.getDouble("polar-14-intra", 0.5)));
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("Polarize");
        node.setAttribute("type", String.format("%d", this.type));
        node.setAttribute("polarizability", String.format("%f", this.polarizability * 0.1 * 0.1 * 0.1));
        node.setAttribute("thole", String.format("%f", this.thole));
        int i = 1;
        if (this.polarizationGroup != null) {
            for (int a : this.polarizationGroup) {
                node.setAttribute(String.format("pgrp%d", i), String.format("%d", a));
                ++i;
            }
        }
        return node;
    }

    void incrementType(int increment) {
        this.type += increment;
        this.setKey(Integer.toString(this.type));
        if (this.polarizationGroup != null) {
            int i = 0;
            while (i < this.polarizationGroup.length) {
                int n = i++;
                this.polarizationGroup[n] = this.polarizationGroup[n] + increment;
            }
        }
    }

    boolean patchTypes(HashMap<AtomType, AtomType> typeMap) {
        if (this.polarizationGroup == null) {
            return false;
        }
        int len = this.polarizationGroup.length;
        int added = 0;
        for (AtomType newType : typeMap.keySet()) {
            for (int i = 1; i < len; ++i) {
                if (this.polarizationGroup[i] != newType.type) continue;
                AtomType knownType = typeMap.get(newType);
                this.polarizationGroup = Arrays.copyOf(this.polarizationGroup, len + ++added);
                this.polarizationGroup[len + added - 1] = knownType.type;
            }
        }
        return added > 0;
    }
}

