/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="pitors", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[2 integers and 1 real]\nProvides the values for a single pi-orbital torsional angle potential parameter.\nThe two integer modifiers give the atom class numbers for the atoms involved in the central bond of the torsional angle to be parameterized.\nThe real modifier gives the value of the 2-fold Fourier amplitude for the torsional angle between p-orbitals centered on the defined bond atom classes.\nThe default units for the stretch-torsion force constant can be controlled via the pitorsunit keyword.\n")
public final class PiOrbitalTorsionType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(PiOrbitalTorsionType.class.getName());
    public static final double DEFAULT_PITORS_UNIT = 1.0;
    @FFXProperty(name="pitorsunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="1.0", description="Sets the scale factor needed to convert the energy value computed by the pi-orbital torsional angle potential into units of kcal/mole.\nThe correct value is force field dependent and typically provided in the header of the master force field parameter file.\n")
    public double piTorsUnit = 1.0;
    public final int[] atomClasses;
    public double forceConstant;

    public PiOrbitalTorsionType(int[] atomClasses, double forceConstant) {
        super(ForceField.ForceFieldType.PITORS, PiOrbitalTorsionType.sortKey(atomClasses));
        this.atomClasses = atomClasses;
        this.forceConstant = forceConstant;
    }

    public static PiOrbitalTorsionType average(@Nullable PiOrbitalTorsionType piOrbitalTorsionType1, @Nullable PiOrbitalTorsionType piOrbitalTorsionType2, @Nullable int[] atomClasses) {
        if (piOrbitalTorsionType1 == null || piOrbitalTorsionType2 == null || atomClasses == null) {
            return null;
        }
        double forceConstant = (piOrbitalTorsionType1.forceConstant + piOrbitalTorsionType2.forceConstant) / 2.0;
        return new PiOrbitalTorsionType(atomClasses, forceConstant);
    }

    public static PiOrbitalTorsionType parse(String input, String[] tokens) {
        if (tokens.length < 4) {
            logger.log(Level.WARNING, "Invalid PITORS type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2])};
                double forceConstant = Double.parseDouble(tokens[3]);
                return new PiOrbitalTorsionType(atomClasses, forceConstant);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing PITORS type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static String sortKey(int[] c) {
        if (c == null || c.length != 2) {
            return null;
        }
        if (c[1] <= c[0]) {
            int temp = c[1];
            c[1] = c[0];
            c[0] = temp;
        }
        return c[0] + " " + c[1];
    }

    @Override
    public int compare(String s1, String s2) {
        String[] keys1 = s1.split(" ");
        String[] keys2 = s2.split(" ");
        for (int i = 0; i < 2; ++i) {
            int c2;
            int c1 = Integer.parseInt(keys1[i]);
            if (c1 < (c2 = Integer.parseInt(keys2[i]))) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiOrbitalTorsionType piOrbitalTorsionType = (PiOrbitalTorsionType)o;
        return Arrays.equals(this.atomClasses, piOrbitalTorsionType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        int i = 0;
        while (i < this.atomClasses.length) {
            int n = i++;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(PiOrbitalTorsionType.sortKey(this.atomClasses));
    }

    public PiOrbitalTorsionType patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        int len = this.atomClasses.length;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count == 1) {
            int[] newClasses = Arrays.copyOf(this.atomClasses, len);
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < len; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    newClasses[i] = knownType.atomClass;
                }
            }
            return new PiOrbitalTorsionType(newClasses, this.forceConstant);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("pitors  %5d  %5d  %4.2f", this.atomClasses[0], this.atomClasses[1], this.forceConstant);
    }

    public static Element getXMLElement(Document doc, ForceField forceField) {
        Map<String, PiOrbitalTorsionType> types = forceField.getPiOrbitalTorsionTypes();
        if (!types.values().isEmpty()) {
            Element node = doc.createElement("AmoebaPiTorsionForce");
            node.setAttribute("piTorsionUnit", String.valueOf(forceField.getDouble("pitorsunit", 1.0)));
            for (PiOrbitalTorsionType piOrbitalTorsionType : types.values()) {
                node.appendChild(piOrbitalTorsionType.toXML(doc));
            }
            return node;
        }
        return null;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("PiTorsion");
        node.setAttribute("class1", String.format("%d", this.atomClasses[0]));
        node.setAttribute("class2", String.format("%d", this.atomClasses[1]));
        node.setAttribute("k", String.format("%.17f", this.forceConstant * 4.184));
        return node;
    }
}

