/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;

@FFXProperty(name="imptors", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[4 integers and up to 3 real/real/integer triples]\nProvides the values for a single AMBER-style improper torsional angle parameter.\nThe first four integer modifiers give the atom class numbers for the atoms involved in the improper torsional angle to be defined.\nBy convention, the third atom class of the four is the trigonal atom on which the improper torsion is centered.\nThe torsional angle computed is literally that defined by the four atom classes in the order specified by the keyword.\nEach of the remaining triples of real/real/integer modifiers give the half-amplitude,\nphase offset in degrees and periodicity of a particular improper torsional term, respectively.\nPeriodicities through 3-fold are allowed for improper torsional parameters.\n")
public final class ImproperTorsionType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(ImproperTorsionType.class.getName());
    public final int[] atomClasses;
    public final double k;
    public final double phase;
    public final int periodicity;
    public final double cos;
    public final double sin;
    @FFXProperty(name="imptorunit", propertyGroup=PropertyGroup.EnergyUnitConversion, defaultValue="1.0", description="Sets the scale factor needed to convert the energy value computed by the AMBER-style improper\ntorsional angle potential into units of kcal/mole.\nThe correct value is force field dependent and typically provided in the header of the master force field parameter file.\n")
    public double impTorUnit = 1.0;
    public static final double DEFAULT_IMPTOR_UNIT = 1.0;

    public ImproperTorsionType(int[] atomClasses, double k, double phase, int periodicity) {
        super(ForceField.ForceFieldType.IMPTORS, ImproperTorsionType.sortKey(atomClasses));
        this.atomClasses = atomClasses;
        double symm = 1.0;
        this.periodicity = periodicity;
        this.k = k / symm;
        this.phase = phase;
        this.cos = FastMath.cos((double)FastMath.toRadians((double)phase));
        this.sin = FastMath.sin((double)FastMath.toRadians((double)phase));
        assert (periodicity == 2);
    }

    public static ImproperTorsionType average(@Nullable ImproperTorsionType improperTorsionType1, @Nullable ImproperTorsionType improperTorsionType2, @Nullable int[] atomClasses) {
        if (improperTorsionType1 == null || improperTorsionType2 == null || atomClasses == null) {
            return null;
        }
        int periodicity = improperTorsionType1.periodicity;
        if (periodicity != improperTorsionType2.periodicity) {
            return null;
        }
        double forceConstant = (improperTorsionType1.k + improperTorsionType2.k) / 2.0;
        double phase = (improperTorsionType1.phase + improperTorsionType2.phase) / 2.0;
        return new ImproperTorsionType(atomClasses, forceConstant, phase, periodicity);
    }

    public static ImproperTorsionType parse(String input, String[] tokens) {
        if (tokens.length < 8) {
            logger.log(Level.WARNING, "Invalid IMPTORS type:\n{0}", input);
        } else {
            try {
                int[] atomClasses = new int[]{Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4])};
                double k = Double.parseDouble(tokens[5]);
                double phase = Double.parseDouble(tokens[6]);
                int period = Integer.parseInt(tokens[7]);
                return new ImproperTorsionType(atomClasses, k, phase, period);
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing IMPTORS type:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    public static String sortKey(int[] c) {
        if (c == null || c.length != 4) {
            return null;
        }
        return c[0] + " " + c[1] + " " + c[2] + " " + c[3];
    }

    public boolean assigned(int[] inputClasses, boolean allowInitialWildCards, boolean allowFinalWildCard) {
        int temp;
        if (inputClasses[2] != this.atomClasses[2]) {
            return false;
        }
        if (!(inputClasses[3] == this.atomClasses[3] || this.atomClasses[3] == 0 && allowFinalWildCard)) {
            if (inputClasses[1] == this.atomClasses[3]) {
                temp = inputClasses[3];
                inputClasses[3] = inputClasses[1];
                inputClasses[1] = temp;
            } else if (inputClasses[0] == this.atomClasses[3]) {
                temp = inputClasses[3];
                inputClasses[3] = inputClasses[0];
                inputClasses[0] = temp;
            } else {
                return false;
            }
        }
        if (!(inputClasses[1] == this.atomClasses[1] || this.atomClasses[1] == 0 && allowInitialWildCards)) {
            if (inputClasses[0] == this.atomClasses[1]) {
                temp = inputClasses[1];
                inputClasses[1] = inputClasses[0];
                inputClasses[0] = temp;
            } else {
                return false;
            }
        }
        return inputClasses[0] == this.atomClasses[0] || this.atomClasses[0] == 0 && allowInitialWildCards;
    }

    @Override
    public int compare(String s1, String s2) {
        String[] keys1 = s1.split(" ");
        String[] keys2 = s2.split(" ");
        int[] c1 = new int[4];
        int[] c2 = new int[4];
        for (int i = 0; i < 4; ++i) {
            c1[i] = Integer.parseInt(keys1[i]);
            c2[i] = Integer.parseInt(keys2[i]);
        }
        if (c1[2] < c2[2]) {
            return -1;
        }
        if (c1[2] > c2[2]) {
            return 1;
        }
        if (c1[0] < c2[0]) {
            return -1;
        }
        if (c1[0] > c2[0]) {
            return 1;
        }
        if (c1[1] < c2[1]) {
            return -1;
        }
        if (c1[1] > c2[1]) {
            return 1;
        }
        if (c1[3] < c2[3]) {
            return -1;
        }
        if (c1[3] > c2[3]) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImproperTorsionType improperTorsionType = (ImproperTorsionType)o;
        return Arrays.equals(this.atomClasses, improperTorsionType.atomClasses);
    }

    public int hashCode() {
        return Arrays.hashCode(this.atomClasses);
    }

    public void incrementClasses(int increment) {
        for (int i = 0; i < this.atomClasses.length; ++i) {
            if (this.atomClasses[i] == 0) continue;
            int n = i;
            this.atomClasses[n] = this.atomClasses[n] + increment;
        }
        this.setKey(ImproperTorsionType.sortKey(this.atomClasses));
    }

    public boolean noZeroClasses() {
        return this.atomClasses[0] != 0 && this.atomClasses[1] != 0 && this.atomClasses[3] != 0;
    }

    public void patchClasses(HashMap<AtomType, AtomType> typeMap) {
        int count = 0;
        for (AtomType newType : typeMap.keySet()) {
            for (int atomClass : this.atomClasses) {
                if (atomClass != newType.atomClass) continue;
                ++count;
            }
        }
        if (count > 0 && count < this.atomClasses.length) {
            for (AtomType newType : typeMap.keySet()) {
                for (int i = 0; i < this.atomClasses.length; ++i) {
                    if (this.atomClasses[i] != newType.atomClass) continue;
                    AtomType knownType = typeMap.get(newType);
                    this.atomClasses[i] = knownType.atomClass;
                }
            }
            this.setKey(ImproperTorsionType.sortKey(this.atomClasses));
        }
    }

    @Override
    public String toString() {
        StringBuilder imptorsBuffer = new StringBuilder("imptors");
        for (int i : this.atomClasses) {
            imptorsBuffer.append(String.format(" %5d", i));
        }
        imptorsBuffer.append(String.format(" %7.3f %7.3f %1d", this.k, this.phase, this.periodicity));
        return imptorsBuffer.toString();
    }
}

