/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.AngleTorsionType;
import ffx.potential.parameters.AngleType;
import ffx.potential.parameters.AtomType;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.BioType;
import ffx.potential.parameters.BondType;
import ffx.potential.parameters.ChargeType;
import ffx.potential.parameters.ImproperTorsionType;
import ffx.potential.parameters.MultipoleType;
import ffx.potential.parameters.OutOfPlaneBendType;
import ffx.potential.parameters.PiOrbitalTorsionType;
import ffx.potential.parameters.PolarizeType;
import ffx.potential.parameters.RelativeSolvationType;
import ffx.potential.parameters.SoluteType;
import ffx.potential.parameters.StretchBendType;
import ffx.potential.parameters.StretchTorsionType;
import ffx.potential.parameters.TorsionTorsionType;
import ffx.potential.parameters.TorsionType;
import ffx.potential.parameters.UreyBradleyType;
import ffx.potential.parameters.VDWPairType;
import ffx.potential.parameters.VDWType;
import ffx.potential.parsers.OpenMMXmlFilter;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;

@FFXProperty(name="forcefield", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[name]\nProvides a name for the force field to be used in the current calculation.\nIts value is usually set in the master force field parameter file for the calculation\n(see the PARAMETERS keyword) instead of in the property file.\n")
public class ForceField {
    private static final Logger logger = Logger.getLogger(ForceField.class.getName());
    private static final Map<ForceFieldName, URL> forceFields = new EnumMap<ForceFieldName, URL>(ForceFieldName.class);
    private final CompositeConfiguration properties;
    private final Map<String, AngleType> angleTypes;
    private final Map<String, AngleType> anglepTypes;
    private final Map<String, AtomType> atomTypes;
    private final Map<String, BioType> bioTypes;
    private final Map<String, BondType> bondTypes;
    private final Map<String, ChargeType> chargeTypes;
    private final Map<String, MultipoleType> multipoleTypes;
    private final Map<String, OutOfPlaneBendType> outOfPlaneBendTypes;
    private final Map<String, PolarizeType> polarizeTypes;
    private final Map<String, StretchBendType> stretchBendTypes;
    private final Map<String, StretchTorsionType> stretchTorsionTypes;
    private final Map<String, AngleTorsionType> angleTorsionTypes;
    private final Map<String, PiOrbitalTorsionType> piOrbitalTorsionTypes;
    private final Map<String, TorsionType> torsionTypes;
    private final Map<String, TorsionType> improperTypes;
    private final Map<String, ImproperTorsionType> imptorsTypes;
    private final Map<String, SoluteType> soluteTypes;
    private final Map<String, TorsionTorsionType> torsionTorsionTypes;
    private final Map<String, UreyBradleyType> ureyBradleyTypes;
    private final Map<String, VDWType> vanderWaalsTypes;
    private final Map<String, VDWType> vanderWaals14Types;
    private final Map<String, VDWPairType> vanderWaalsPairTypes;
    private final Map<String, RelativeSolvationType> relativeSolvationTypes;
    private final Map<ForceFieldType, Map<String, ? extends BaseType>> forceFieldTypes;
    public URL forceFieldURL;

    public ForceField(CompositeConfiguration properties) {
        this.properties = properties;
        this.angleTypes = new TreeMap<String, AngleType>(new AngleType(new int[3], 0.0, new double[1], null));
        this.anglepTypes = new TreeMap<String, AngleType>(new AngleType(new int[3], 0.0, new double[1], null, null));
        this.atomTypes = new TreeMap<String, AtomType>(new AtomType(0, 0, null, null, 0, 0.0, 0));
        this.bioTypes = new TreeMap<String, BioType>(new BioType(0, null, null, 0, null));
        this.bondTypes = new TreeMap<String, BondType>(new BondType(new int[2], 0.0, 0.0, null));
        this.chargeTypes = new TreeMap<String, ChargeType>(new ChargeType(0, 0.0));
        this.soluteTypes = new TreeMap<String, SoluteType>(new SoluteType(0, 0.0, 0.0, 0.0));
        this.multipoleTypes = new TreeMap<String, MultipoleType>(new MultipoleType(new double[10], null, null, false));
        this.outOfPlaneBendTypes = new TreeMap<String, OutOfPlaneBendType>(new OutOfPlaneBendType(new int[4], 0.0));
        this.piOrbitalTorsionTypes = new TreeMap<String, PiOrbitalTorsionType>(new PiOrbitalTorsionType(new int[2], 0.0));
        this.polarizeTypes = new TreeMap<String, PolarizeType>(new PolarizeType(0, 0.0, 0.0, 0.0, new int[1]));
        this.stretchBendTypes = new TreeMap<String, StretchBendType>(new StretchBendType(new int[3], new double[1]));
        this.stretchTorsionTypes = new TreeMap<String, StretchTorsionType>(new StretchTorsionType(new int[4], new double[1]));
        this.angleTorsionTypes = new TreeMap<String, AngleTorsionType>(new AngleTorsionType(new int[4], new double[1]));
        this.torsionTorsionTypes = new TreeMap<String, TorsionTorsionType>();
        this.torsionTypes = new TreeMap<String, TorsionType>(new TorsionType(new int[4], new double[1], new double[1], new int[1]));
        this.improperTypes = new TreeMap<String, TorsionType>(new TorsionType(new int[4], new double[1], new double[1], new int[1]));
        this.imptorsTypes = new TreeMap<String, ImproperTorsionType>(new ImproperTorsionType(new int[4], 0.0, 0.0, 2));
        this.ureyBradleyTypes = new TreeMap<String, UreyBradleyType>(new UreyBradleyType(new int[3], 0.0, 0.0));
        this.vanderWaalsTypes = new TreeMap<String, VDWType>(new VDWType(0, 0.0, 0.0, 0.0));
        this.vanderWaals14Types = new TreeMap<String, VDWType>(new VDWType(0, 0.0, 0.0, 0.0));
        this.vanderWaalsPairTypes = new TreeMap<String, VDWPairType>(new VDWPairType(new int[2], 0.0, 0.0));
        this.relativeSolvationTypes = new TreeMap<String, RelativeSolvationType>(new RelativeSolvationType("", 0.0));
        this.forceFieldTypes = new EnumMap<ForceFieldType, Map<String, ? extends BaseType>>(ForceFieldType.class);
        this.forceFieldTypes.put(ForceFieldType.ANGLE, this.angleTypes);
        this.forceFieldTypes.put(ForceFieldType.ANGLEP, this.anglepTypes);
        this.forceFieldTypes.put(ForceFieldType.ATOM, this.atomTypes);
        this.forceFieldTypes.put(ForceFieldType.BOND, this.bondTypes);
        this.forceFieldTypes.put(ForceFieldType.BIOTYPE, this.bioTypes);
        this.forceFieldTypes.put(ForceFieldType.CHARGE, this.chargeTypes);
        this.forceFieldTypes.put(ForceFieldType.SOLUTE, this.soluteTypes);
        this.forceFieldTypes.put(ForceFieldType.OPBEND, this.outOfPlaneBendTypes);
        this.forceFieldTypes.put(ForceFieldType.MULTIPOLE, this.multipoleTypes);
        this.forceFieldTypes.put(ForceFieldType.PITORS, this.piOrbitalTorsionTypes);
        this.forceFieldTypes.put(ForceFieldType.POLARIZE, this.polarizeTypes);
        this.forceFieldTypes.put(ForceFieldType.STRBND, this.stretchBendTypes);
        this.forceFieldTypes.put(ForceFieldType.STRTORS, this.stretchTorsionTypes);
        this.forceFieldTypes.put(ForceFieldType.ANGTORS, this.angleTorsionTypes);
        this.forceFieldTypes.put(ForceFieldType.TORSION, this.torsionTypes);
        this.forceFieldTypes.put(ForceFieldType.IMPROPER, this.improperTypes);
        this.forceFieldTypes.put(ForceFieldType.IMPTORS, this.imptorsTypes);
        this.forceFieldTypes.put(ForceFieldType.TORTORS, this.torsionTorsionTypes);
        this.forceFieldTypes.put(ForceFieldType.UREYBRAD, this.ureyBradleyTypes);
        this.forceFieldTypes.put(ForceFieldType.VDW, this.vanderWaalsTypes);
        this.forceFieldTypes.put(ForceFieldType.VDW14, this.vanderWaals14Types);
        this.forceFieldTypes.put(ForceFieldType.VDWPR, this.vanderWaalsPairTypes);
        this.forceFieldTypes.put(ForceFieldType.RELATIVESOLV, this.relativeSolvationTypes);
        this.trueImpliedBoolean("ELEC_LAMBDATERM", "GK_LAMBDATERM");
        this.trueImpliedBoolean("LAMBDATERM", "VDW_LAMBDATERM", "ELEC_LAMBDATERM", "GK_LAMBDATERM");
    }

    public static URL getForceFieldURL(ForceFieldName forceField) {
        if (forceField == null) {
            return null;
        }
        return forceFields.get((Object)forceField);
    }

    public static boolean isForceFieldType(String keyword) {
        keyword = ForceField.toEnumForm(keyword);
        try {
            ForceFieldType.valueOf(keyword);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String toEnumForm(String key) {
        if (key == null) {
            return null;
        }
        return key.toUpperCase().replace("-", "_");
    }

    public static String toPropertyForm(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase().replace("_", "-");
    }

    public <T extends BaseType> void addForceFieldType(T type) {
        if (type == null) {
            logger.info(" Null force field type ignored.");
            return;
        }
        Map<String, ? extends BaseType> treeMap = this.forceFieldTypes.get((Object)type.forceFieldType);
        if (treeMap == null) {
            logger.log(Level.INFO, " Unrecognized force field type ignored {0}", (Object)type.forceFieldType);
            type.print();
            return;
        }
        if (treeMap.containsKey(type.key)) {
            if (treeMap.get(type.key).toString().equalsIgnoreCase(type.toString())) {
                return;
            }
            logger.log(Level.WARNING, " A force field entry of type {0} already exists with the key: {1}\n The (discarded) old entry: {2}\n The new entry            : {3}", new Object[]{type.forceFieldType, type.key, treeMap.get(type.key).toString(), type.toString()});
        }
        treeMap.put(type.key, type);
    }

    public void addProperty(String property, String value) {
        if (property == null) {
            return;
        }
        String key = ForceField.toPropertyForm(property);
        this.properties.addProperty(key, (Object)value);
    }

    public void clearProperty(String property) {
        this.properties.clearProperty(property);
    }

    public void append(ForceField patch) {
        boolean renumber = patch.getBoolean("renumberPatch", true);
        logger.info(String.format(" Renumbering Patch: %B", renumber));
        if (renumber) {
            int classOffset = this.maxClass();
            int typeOffset = this.maxType();
            int bioTypeOffset = this.maxBioType();
            int minClass = patch.minClass();
            int minType = patch.minType();
            int minBioType = patch.minBioType();
            patch.renumberForceField(classOffset -= minClass - 1, typeOffset -= minType - 1, bioTypeOffset -= minBioType - 1);
        }
        for (AngleType angleType : patch.angleTypes.values()) {
            this.angleTypes.put(angleType.getKey(), angleType);
        }
        for (AngleType angleType : patch.anglepTypes.values()) {
            this.anglepTypes.put(angleType.getKey(), angleType);
        }
        for (AtomType atomType : patch.atomTypes.values()) {
            this.atomTypes.put(atomType.getKey(), atomType);
        }
        for (BioType bioType : patch.bioTypes.values()) {
            this.bioTypes.put(bioType.getKey(), bioType);
        }
        for (BondType bondType : patch.bondTypes.values()) {
            this.bondTypes.put(bondType.getKey(), bondType);
        }
        for (MultipoleType multipoleType : patch.multipoleTypes.values()) {
            this.multipoleTypes.put(multipoleType.getKey(), multipoleType);
        }
        for (OutOfPlaneBendType outOfPlaneBendType : patch.outOfPlaneBendTypes.values()) {
            this.outOfPlaneBendTypes.put(outOfPlaneBendType.getKey(), outOfPlaneBendType);
        }
        for (PiOrbitalTorsionType piOrbitalTorsionType : patch.piOrbitalTorsionTypes.values()) {
            this.piOrbitalTorsionTypes.put(piOrbitalTorsionType.getKey(), piOrbitalTorsionType);
        }
        for (PolarizeType polarizeType : patch.polarizeTypes.values()) {
            this.polarizeTypes.put(polarizeType.getKey(), polarizeType);
        }
        for (StretchBendType stretchBendType : patch.stretchBendTypes.values()) {
            this.stretchBendTypes.put(stretchBendType.getKey(), stretchBendType);
        }
        for (StretchTorsionType stretchTorsionType : patch.stretchTorsionTypes.values()) {
            this.stretchTorsionTypes.put(stretchTorsionType.getKey(), stretchTorsionType);
        }
        for (AngleTorsionType angleTorsionType : patch.angleTorsionTypes.values()) {
            this.angleTorsionTypes.put(angleTorsionType.getKey(), angleTorsionType);
        }
        for (TorsionTorsionType torsionTorsionType : patch.torsionTorsionTypes.values()) {
            this.torsionTorsionTypes.put(torsionTorsionType.getKey(), torsionTorsionType);
        }
        for (TorsionType torsionType : patch.torsionTypes.values()) {
            this.torsionTypes.put(torsionType.getKey(), torsionType);
        }
        for (TorsionType torsionType : patch.improperTypes.values()) {
            this.torsionTypes.put(torsionType.getKey(), torsionType);
        }
        for (ImproperTorsionType improperTorsionType : patch.imptorsTypes.values()) {
            this.imptorsTypes.put(improperTorsionType.getKey(), improperTorsionType);
        }
        for (UreyBradleyType ureyBradleyType : patch.ureyBradleyTypes.values()) {
            this.ureyBradleyTypes.put(ureyBradleyType.getKey(), ureyBradleyType);
        }
        for (VDWType vdwType : patch.vanderWaalsTypes.values()) {
            this.vanderWaalsTypes.put(vdwType.getKey(), vdwType);
        }
        for (VDWType vdwType : patch.vanderWaals14Types.values()) {
            this.vanderWaals14Types.put(vdwType.getKey(), vdwType);
        }
        for (VDWPairType vdwPairType : patch.vanderWaalsPairTypes.values()) {
            this.vanderWaalsPairTypes.put(vdwPairType.getKey(), vdwPairType);
        }
        for (SoluteType soluteType : patch.soluteTypes.values()) {
            this.soluteTypes.put(soluteType.getKey(), soluteType);
        }
        for (RelativeSolvationType rsType : patch.relativeSolvationTypes.values()) {
            this.relativeSolvationTypes.put(rsType.getKey(), rsType);
        }
        String modres = patch.getString("MODRES", "false");
        if (!modres.equalsIgnoreCase("false")) {
            logger.info(" Adding modified residue patch.");
            this.modifiedResidue(modres);
        }
    }

    public AngleTorsionType getAngleTorsionType(String key) {
        AngleTorsionType angleTorsionType = this.angleTorsionTypes.get(key);
        if (angleTorsionType != null) {
            angleTorsionType.angtorunit = this.getDouble("ANGTORUNIT", Math.PI / 180);
        }
        return angleTorsionType;
    }

    public Map<String, AngleTorsionType> getAngleTorsionTypes() {
        for (String key : this.angleTorsionTypes.keySet()) {
            this.getAngleTorsionType(key);
        }
        return this.angleTorsionTypes;
    }

    public AngleType getAngleType(String key) {
        AngleType angleType = this.angleTypes.get(key);
        if (angleType == null) {
            angleType = this.anglepTypes.get(key);
        }
        if (angleType != null) {
            angleType.angleUnit = this.getDouble("ANGLEUNIT", AngleType.DEFAULT_ANGLE_UNIT);
            angleType.cubic = this.getDouble("ANGLE-CUBIC", 0.0);
            angleType.quartic = this.getDouble("ANGLE-QUARTIC", 0.0);
            angleType.pentic = this.getDouble("ANGLE-PENTIC", 0.0);
            angleType.sextic = this.getDouble("ANGLE-SEXTIC", 0.0);
            double ridingScale = this.getDouble("RIDING_HYDROGEN_SCALE", 1.0);
            if (ridingScale > 1.0 && this.hasHydrogenAtomClass(angleType.atomClasses)) {
                angleType.angleUnit *= ridingScale;
            }
        }
        return angleType;
    }

    public Map<String, AngleType> getAngleTypes() {
        for (String key : this.angleTypes.keySet()) {
            this.getAngleType(key);
        }
        return this.angleTypes;
    }

    public Map<String, AngleType> getAnglepTypes() {
        for (String key : this.anglepTypes.keySet()) {
            this.getAngleType(key);
        }
        return this.anglepTypes;
    }

    public AngleType getAngleType(AtomType a1, AtomType a2, AtomType a3) {
        int[] c = new int[]{a1.atomClass, a2.atomClass, a3.atomClass};
        String key = AngleType.sortKey(c);
        return this.getAngleType(key);
    }

    public AtomType getAtomType(String key) {
        return this.atomTypes.get(key);
    }

    public Map<String, AtomType> getAtomTypes() {
        return this.atomTypes;
    }

    public AtomType getAtomType(String moleculeName, String atomName) {
        for (BioType bioType : this.bioTypes.values()) {
            if (!bioType.moleculeName.equalsIgnoreCase(moleculeName) || !bioType.atomName.equalsIgnoreCase(atomName)) continue;
            String key = Integer.toString(bioType.atomType);
            return this.atomTypes.get(key);
        }
        return null;
    }

    public List<AtomType> getSimilarAtomTypes(AtomType atomType) {
        ArrayList<AtomType> types = new ArrayList<AtomType>();
        for (AtomType type : this.atomTypes.values()) {
            if (type.atomicNumber != atomType.atomicNumber || type.valence != atomType.valence) continue;
            types.add(type);
        }
        return types;
    }

    public HashMap<String, AtomType> getAtomTypes(String moleculeName) {
        HashMap<String, AtomType> types = new HashMap<String, AtomType>();
        for (BioType bioType : this.bioTypes.values()) {
            if (!bioType.moleculeName.equalsIgnoreCase(moleculeName)) continue;
            String key = Integer.toString(bioType.atomType);
            AtomType type = this.atomTypes.get(key);
            types.put(bioType.atomName.toUpperCase(), type);
        }
        return types;
    }

    public BioType getBioType(String moleculeName, String atomName) {
        for (BioType bioType : this.bioTypes.values()) {
            if (!bioType.moleculeName.equalsIgnoreCase(moleculeName) || !bioType.atomName.equalsIgnoreCase(atomName)) continue;
            return bioType;
        }
        return null;
    }

    public BioType getBioType(String key) {
        return this.bioTypes.get(key);
    }

    public Map<String, BioType> getBioTypeMap() {
        return this.bioTypes;
    }

    private boolean hasHydrogenAtomClass(int[] atomClasses) {
        for (AtomType type : this.atomTypes.values()) {
            if (type.atomicNumber == 1) continue;
            for (int i : atomClasses) {
                if (type.atomClass != i) continue;
                return true;
            }
        }
        return false;
    }

    public BondType getBondType(String key) {
        BondType bondType = this.bondTypes.get(key);
        if (bondType != null) {
            bondType.bondUnit = this.getDouble("BONDUNIT", 1.0);
            bondType.cubic = this.getDouble("BOND_CUBIC", 0.0);
            bondType.quartic = this.getDouble("BOND_QUARTIC", 0.0);
            double ridingScale = this.getDouble("RIDING_HYDROGEN_SCALE", 1.0);
            if (ridingScale > 1.0 && this.hasHydrogenAtomClass(bondType.atomClasses)) {
                bondType.bondUnit *= ridingScale;
            }
        }
        return bondType;
    }

    public Map<String, BondType> getBondTypes() {
        for (String key : this.bondTypes.keySet()) {
            this.getBondType(key);
        }
        return this.bondTypes;
    }

    public BondType getBondType(AtomType a1, AtomType a2) {
        int[] c = new int[]{a1.atomClass, a2.atomClass};
        String key = BondType.sortKey(c);
        return this.getBondType(key);
    }

    public String[] getBonds(String moleculeName, String atomName) {
        for (BioType bioType : this.bioTypes.values()) {
            if (!bioType.moleculeName.equalsIgnoreCase(moleculeName) || !bioType.atomName.equalsIgnoreCase(atomName)) continue;
            return bioType.bonds;
        }
        return null;
    }

    public boolean getBoolean(String property) throws Exception {
        if (property == null) {
            throw new Exception("NULL property");
        }
        String key = ForceField.toPropertyForm(property);
        if (!this.properties.containsKey(key)) {
            throw new Exception("Undefined property: " + key);
        }
        return this.properties.getBoolean(key);
    }

    public boolean getBoolean(String property, boolean defaultBoolean) {
        try {
            return this.getBoolean(property);
        }
        catch (Exception e) {
            return defaultBoolean;
        }
    }

    public double getDouble(String property) throws Exception {
        if (property == null) {
            throw new Exception("NULL property");
        }
        String key = ForceField.toPropertyForm(property);
        if (!this.properties.containsKey(key)) {
            throw new Exception("Undefined property: " + key);
        }
        return this.properties.getDouble(key);
    }

    public double getDouble(String property, Double defaultDouble) {
        try {
            return this.getDouble(property);
        }
        catch (Exception e) {
            return defaultDouble;
        }
    }

    public int getForceFieldTypeCount(ForceFieldType type) {
        TreeMap treeMap = (TreeMap)this.forceFieldTypes.get((Object)type);
        if (treeMap == null) {
            logger.log(Level.WARNING, "Unrecognized Force Field Type: {0}", (Object)type);
            return 0;
        }
        return treeMap.size();
    }

    public ImproperTorsionType getImproperType(String key) {
        ImproperTorsionType improperTorsionType = this.imptorsTypes.get(key);
        if (improperTorsionType != null) {
            double units = this.getDouble("IMPTORUNIT", 1.0);
            improperTorsionType.impTorUnit = this.getDouble("IMPTORSUNIT", units);
        }
        return improperTorsionType;
    }

    public Collection<ImproperTorsionType> getImproperTypes() {
        double units = this.getDouble("IMPTORUNIT", 1.0);
        units = this.getDouble("IMPTORSUNIT", units);
        for (ImproperTorsionType improperTorsionType : this.imptorsTypes.values()) {
            improperTorsionType.impTorUnit = units;
        }
        return this.imptorsTypes.values();
    }

    public int getInteger(String property) throws Exception {
        if (property == null) {
            throw new Exception("NULL property");
        }
        String key = ForceField.toPropertyForm(property);
        if (!this.properties.containsKey(key)) {
            throw new Exception("Undefined property: " + key);
        }
        return this.properties.getInt(key);
    }

    public int getInteger(String property, Integer defaultInteger) {
        try {
            return this.getInteger(property);
        }
        catch (Exception e) {
            return defaultInteger;
        }
    }

    public MultipoleType getMultipoleType(String key) {
        return this.multipoleTypes.get(key);
    }

    public MultipoleType getMultipoleTypeBeginsWith(String key) {
        int count = 0;
        MultipoleType multipoleType = null;
        for (String s : this.multipoleTypes.keySet()) {
            if (!s.startsWith(key + " ")) continue;
            ++count;
            multipoleType = this.multipoleTypes.get(s);
        }
        if (count == 1) {
            return multipoleType;
        }
        return null;
    }

    public List<MultipoleType> getMultipoleTypes(String key) {
        ArrayList<MultipoleType> list = new ArrayList<MultipoleType>();
        for (String s : this.multipoleTypes.keySet()) {
            if (!s.startsWith(key + " ")) continue;
            list.add(this.multipoleTypes.get(s));
        }
        return list;
    }

    public Map<String, MultipoleType> getMultipoleTypes() {
        return this.multipoleTypes;
    }

    public Map<String, ? extends BaseType> getTypes(ForceFieldType type) {
        return this.forceFieldTypes.get((Object)type);
    }

    public void clearForceFieldType(ForceFieldType type) {
        Map<String, ? extends BaseType> map = this.forceFieldTypes.get((Object)type);
        map.clear();
    }

    public OutOfPlaneBendType getOutOfPlaneBendType(String key) {
        OutOfPlaneBendType outOfPlaneBendType = this.outOfPlaneBendTypes.get(key);
        if (outOfPlaneBendType != null) {
            outOfPlaneBendType.opBendUnit = this.getDouble("OPBENDUNIT", OutOfPlaneBendType.DEFAULT_OPBEND_UNIT);
            outOfPlaneBendType.cubic = this.getDouble("OPBEND-CUBIC", 0.0);
            outOfPlaneBendType.quartic = this.getDouble("OPBEND-QUARTIC", 0.0);
            outOfPlaneBendType.pentic = this.getDouble("OPBEND-PENTIC", 0.0);
            outOfPlaneBendType.sextic = this.getDouble("OPBEND-SEXTIC", 0.0);
        }
        return outOfPlaneBendType;
    }

    public Map<String, OutOfPlaneBendType> getOutOfPlaneBendTypes() {
        for (String key : this.outOfPlaneBendTypes.keySet()) {
            this.getOutOfPlaneBendType(key);
        }
        return this.outOfPlaneBendTypes;
    }

    public OutOfPlaneBendType getOutOfPlaneBendType(AtomType a4, AtomType a0, AtomType a1, AtomType a2) {
        int class4 = a4.atomClass;
        int class0 = a0.atomClass;
        int class1 = a1.atomClass;
        int class2 = a2.atomClass;
        String key = OutOfPlaneBendType.sortKey(new int[]{class4, class1, class0, class2});
        OutOfPlaneBendType outOfPlaneBendType = this.getOutOfPlaneBendType(key);
        if (outOfPlaneBendType == null) {
            key = OutOfPlaneBendType.sortKey(new int[]{class4, class1, class2, class0});
            outOfPlaneBendType = this.getOutOfPlaneBendType(key);
        }
        if (outOfPlaneBendType == null) {
            key = OutOfPlaneBendType.sortKey(new int[]{class4, class1, 0, 0});
            outOfPlaneBendType = this.getOutOfPlaneBendType(key);
        }
        return outOfPlaneBendType;
    }

    public PiOrbitalTorsionType getPiOrbitalTorsionType(String key) {
        PiOrbitalTorsionType piOrbitalTorsionType = this.piOrbitalTorsionTypes.get(key);
        if (piOrbitalTorsionType != null) {
            piOrbitalTorsionType.piTorsUnit = this.getDouble("PITORSUNIT", 1.0);
        }
        return piOrbitalTorsionType;
    }

    public Map<String, PiOrbitalTorsionType> getPiOrbitalTorsionTypes() {
        for (String key : this.piOrbitalTorsionTypes.keySet()) {
            this.getPiOrbitalTorsionType(key);
        }
        return this.piOrbitalTorsionTypes;
    }

    public PiOrbitalTorsionType getPiOrbitalTorsionType(AtomType a1, AtomType a2) {
        int[] c = new int[]{a1.atomClass, a2.atomClass};
        String key = PiOrbitalTorsionType.sortKey(c);
        return this.getPiOrbitalTorsionType(key);
    }

    public PolarizeType getPolarizeType(String key) {
        return this.polarizeTypes.get(key);
    }

    public Map<String, PolarizeType> getPolarizeTypes() {
        return this.polarizeTypes;
    }

    public CompositeConfiguration getProperties() {
        return this.properties;
    }

    public HashMap<String, RelativeSolvationType> getRelativeSolvationTypes() {
        HashMap<String, RelativeSolvationType> types = new HashMap<String, RelativeSolvationType>();
        for (String key : this.relativeSolvationTypes.keySet()) {
            types.put(key, this.relativeSolvationTypes.get(key));
        }
        return types;
    }

    public SoluteType getSoluteType(String key) {
        return this.soluteTypes.get(key);
    }

    public Map<String, SoluteType> getSoluteTypes() {
        return this.soluteTypes;
    }

    public StretchBendType getStretchBendType(String key) {
        StretchBendType stretchBendType = this.stretchBendTypes.get(key);
        if (stretchBendType != null) {
            stretchBendType.strbndunit = this.getDouble("STRBNDUNIT", Math.PI / 180);
        }
        return stretchBendType;
    }

    public Map<String, StretchBendType> getStretchBendTypes() {
        for (String key : this.stretchBendTypes.keySet()) {
            this.getStretchBendType(key);
        }
        return this.stretchBendTypes;
    }

    public StretchBendType getStretchBendType(AtomType a1, AtomType a2, AtomType a3) {
        int[] c = new int[]{a1.atomClass, a2.atomClass, a3.atomClass};
        String key = AngleType.sortKey(c);
        return this.getStretchBendType(key);
    }

    public StretchTorsionType getStretchTorsionType(String key) {
        StretchTorsionType stretchTorsionType = this.stretchTorsionTypes.get(key);
        if (stretchTorsionType != null) {
            stretchTorsionType.strTorUnit = this.getDouble("STRTORUNIT", 1.0);
        }
        return stretchTorsionType;
    }

    public Map<String, StretchTorsionType> getStretchTorsionTypes() {
        for (String key : this.stretchTorsionTypes.keySet()) {
            this.getStretchTorsionType(key);
        }
        return this.stretchTorsionTypes;
    }

    public String getString(String property) throws Exception {
        if (property == null) {
            throw new Exception("NULL property");
        }
        String key = ForceField.toPropertyForm(property);
        if (!this.properties.containsKey(key)) {
            throw new Exception("Undefined property: " + key);
        }
        return this.properties.getString(key);
    }

    public String getString(String property, String defaultString) {
        try {
            return this.getString(property);
        }
        catch (Exception e) {
            return defaultString;
        }
    }

    public TorsionTorsionType getTorsionTorsionType(String key) {
        TorsionTorsionType torsionTorsionType = this.torsionTorsionTypes.get(key);
        if (torsionTorsionType != null) {
            torsionTorsionType.torTorUnit = this.getDouble("TORTORUNIT", 1.0);
        }
        return torsionTorsionType;
    }

    public Map<String, TorsionTorsionType> getTorsionTorsionTypes() {
        for (String key : this.torsionTorsionTypes.keySet()) {
            this.getTorsionTorsionType(key);
        }
        return this.torsionTorsionTypes;
    }

    public TorsionType getTorsionType(String key) {
        TorsionType torsionType = this.torsionTypes.get(key);
        if (torsionType != null) {
            torsionType.torsionUnit = this.getDouble("TORSIONUNIT", 1.0);
        }
        return torsionType;
    }

    public Map<String, TorsionType> getTorsionTypes() {
        for (String key : this.torsionTypes.keySet()) {
            this.getTorsionType(key);
        }
        return this.torsionTypes;
    }

    private TorsionType getTorsionType(int c0, int c1, int c2, int c3) {
        int[] c = new int[]{c0, c1, c2, c3};
        String key = TorsionType.sortKey(c);
        return this.getTorsionType(key);
    }

    public TorsionType getTorsionType(AtomType a0, AtomType a1, AtomType a2, AtomType a3) {
        int c0 = a0.atomClass;
        int c1 = a1.atomClass;
        int c2 = a2.atomClass;
        int c3 = a3.atomClass;
        TorsionType torsionType = this.getTorsionType(c0, c1, c2, c3);
        if (torsionType == null) {
            if (c0 > c3) {
                torsionType = this.getTorsionType(c0, c1, c2, 0);
                if (torsionType == null) {
                    torsionType = this.getTorsionType(0, c1, c2, c3);
                }
            } else {
                torsionType = this.getTorsionType(0, c1, c2, c3);
                if (torsionType == null) {
                    torsionType = this.getTorsionType(c0, c1, c2, 0);
                }
            }
        }
        if (torsionType == null) {
            torsionType = this.getTorsionType(0, c1, c2, 0);
        }
        return torsionType;
    }

    public UreyBradleyType getUreyBradleyType(String key) {
        UreyBradleyType ureyBradleyType = this.ureyBradleyTypes.get(key);
        if (ureyBradleyType != null) {
            ureyBradleyType.ureyUnit = this.getDouble("UREYUNIT", 1.0);
            ureyBradleyType.cubic = this.getDouble("UREY_CUBIC", 0.0);
            ureyBradleyType.quartic = this.getDouble("UREY_QUARTIC", 0.0);
            double ridingScale = this.getDouble("RIDING_HYDROGEN_SCALE", 1.0);
            if (ridingScale > 1.0 && this.hasHydrogenAtomClass(ureyBradleyType.atomClasses)) {
                ureyBradleyType.ureyUnit *= ridingScale;
            }
        }
        return ureyBradleyType;
    }

    public Map<String, UreyBradleyType> getUreyBradleyTypes() {
        for (String key : this.ureyBradleyTypes.keySet()) {
            this.getUreyBradleyType(key);
        }
        return this.ureyBradleyTypes;
    }

    public VDWType getVDW14Type(String key) {
        return this.vanderWaals14Types.get(key);
    }

    public Map<String, VDWType> getVDW14Types() {
        return this.vanderWaals14Types;
    }

    public VDWType getVDWType(String key) {
        return this.vanderWaalsTypes.get(key);
    }

    public VDWPairType getVDWPairType(String key) {
        return this.vanderWaalsPairTypes.get(key);
    }

    public Map<String, VDWType> getVDWTypes() {
        return this.vanderWaalsTypes;
    }

    public Map<String, VDWPairType> getVDWPairTypes() {
        return this.vanderWaalsPairTypes;
    }

    public boolean hasProperty(String property) {
        if (property == null) {
            return false;
        }
        String key = ForceField.toPropertyForm(property);
        return this.properties.containsKey(key);
    }

    public void log() {
        for (ForceFieldType s : this.forceFieldTypes.keySet()) {
            this.log(s.toString());
        }
    }

    public void log(String key) {
        ForceFieldType type = ForceFieldType.valueOf(key);
        logger.info(this.toString(type));
    }

    public void print() {
        for (ForceFieldType s : this.forceFieldTypes.keySet()) {
            this.print(s.toString());
        }
    }

    public void print(String key) {
        ForceFieldType type = ForceFieldType.valueOf(key);
        logger.info(this.toString(type));
    }

    public void renumberForceField(int classOffset, int typeOffset, int bioTypeOffset) {
        for (AngleType angleType : this.angleTypes.values()) {
            angleType.incrementClasses(classOffset);
        }
        for (AngleType angleType : this.anglepTypes.values()) {
            angleType.incrementClasses(classOffset);
        }
        for (AtomType atomType : this.atomTypes.values()) {
            atomType.incrementClassAndType(classOffset, typeOffset);
        }
        for (BioType bioType : this.bioTypes.values()) {
            bioType.incrementIndexAndType(bioTypeOffset, typeOffset);
        }
        for (BondType bondType : this.bondTypes.values()) {
            bondType.incrementClasses(classOffset);
        }
        for (MultipoleType multipoleType : this.multipoleTypes.values()) {
            multipoleType.incrementType(typeOffset);
        }
        for (OutOfPlaneBendType outOfPlaneBendType : this.outOfPlaneBendTypes.values()) {
            outOfPlaneBendType.incrementClasses(classOffset);
        }
        for (PiOrbitalTorsionType piOrbitalTorsionType : this.piOrbitalTorsionTypes.values()) {
            piOrbitalTorsionType.incrementClasses(classOffset);
        }
        for (PolarizeType polarizeType : this.polarizeTypes.values()) {
            polarizeType.incrementType(typeOffset);
        }
        for (StretchBendType stretchBendType : this.stretchBendTypes.values()) {
            stretchBendType.incrementClasses(classOffset);
        }
        for (StretchTorsionType stretchTorsionType : this.stretchTorsionTypes.values()) {
            stretchTorsionType.incrementClasses(classOffset);
        }
        for (AngleTorsionType angleTorsionType : this.angleTorsionTypes.values()) {
            angleTorsionType.incrementClasses(classOffset);
        }
        for (TorsionTorsionType torsionTorsionType : this.torsionTorsionTypes.values()) {
            torsionTorsionType.incrementClasses(classOffset);
        }
        for (TorsionType torsionType : this.torsionTypes.values()) {
            torsionType.incrementClasses(classOffset);
        }
        for (TorsionType torsionType : this.improperTypes.values()) {
            torsionType.incrementClasses(classOffset);
        }
        for (ImproperTorsionType improperTorsionType : this.imptorsTypes.values()) {
            improperTorsionType.incrementClasses(classOffset);
        }
        for (UreyBradleyType ureyBradleyType : this.ureyBradleyTypes.values()) {
            ureyBradleyType.incrementClasses(classOffset);
        }
        for (VDWType vanderWaalsType : this.vanderWaalsTypes.values()) {
            vanderWaalsType.incrementClass(classOffset);
        }
        for (VDWType vanderWaals14Type : this.vanderWaals14Types.values()) {
            vanderWaals14Type.incrementClass(classOffset);
        }
        for (VDWPairType vanderWaalsPairType : this.vanderWaalsPairTypes.values()) {
            vanderWaalsPairType.incrementClasses(classOffset);
        }
        for (SoluteType soluteType : this.soluteTypes.values()) {
            soluteType.incrementType(typeOffset);
        }
    }

    public void setAngleFunction(AngleType.AngleFunction angleFunction) {
        for (AngleType angleType : this.anglepTypes.values()) {
            angleType.setAngleFunction(angleFunction);
        }
        for (AngleType angleType : this.angleTypes.values()) {
            angleType.setAngleFunction(angleFunction);
        }
    }

    public void setBondFunction(BondType.BondFunction bondFunction) {
        for (BondType bondType : this.bondTypes.values()) {
            bondType.setBondFunction(bondFunction);
        }
    }

    public String toString(ForceFieldType type) {
        StringBuilder sb = new StringBuilder("\n");
        Map<String, ? extends BaseType> t = this.forceFieldTypes.get((Object)type);
        if (t.isEmpty()) {
            return "";
        }
        for (BaseType baseType : t.values()) {
            sb.append(((Object)baseType).toString()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        String forceFieldName;
        try {
            forceFieldName = this.getString("FORCEFIELD");
        }
        catch (Exception ex) {
            forceFieldName = "Unknown";
        }
        return forceFieldName;
    }

    public String toString(String key) {
        if (key == null) {
            return null;
        }
        if (this.properties.containsKey(key = ForceField.toPropertyForm(key))) {
            List l = this.properties.getList(key);
            return key + " " + Arrays.toString(l.toArray());
        }
        return key + " is not defined.";
    }

    public StringBuffer toStringBuffer() {
        StringBuffer sb = new StringBuffer();
        for (ForceFieldType s : this.forceFieldTypes.keySet()) {
            ForceFieldType type = ForceFieldType.valueOf(s.toString());
            sb.append(this.toString(type));
        }
        return sb;
    }

    public void toXML() throws Exception {
        OpenMMXmlFilter xmlFilter = new OpenMMXmlFilter(this);
        xmlFilter.toXML();
    }

    private AtomType updateBioType(String molecule, String atom, int newType) {
        int oldType = 0;
        for (BioType bioType : this.bioTypes.values()) {
            if (!bioType.moleculeName.equalsIgnoreCase(molecule) || atom.length() > bioType.atomName.length() || !bioType.atomName.toUpperCase().startsWith(atom.toUpperCase())) continue;
            oldType = bioType.atomType;
            bioType.atomType = newType;
        }
        return this.getAtomType(Integer.toString(oldType));
    }

    private void patchClassesAndTypes(HashMap<AtomType, AtomType> typeMap, HashMap<String, AtomType> patchTypes) {
        BaseType newType;
        for (BondType bondType : this.bondTypes.values().toArray(new BondType[0])) {
            newType = bondType.patchClasses(typeMap);
            if (newType == null) continue;
            logger.info(" " + String.valueOf(newType));
            this.addForceFieldType(newType);
        }
        for (BaseType baseType : this.angleTypes.values().toArray(new AngleType[0])) {
            newType = ((AngleType)baseType).patchClasses(typeMap);
            if (newType == null) continue;
            logger.info(" " + String.valueOf(newType));
            this.addForceFieldType(newType);
        }
        for (BaseType baseType : this.outOfPlaneBendTypes.values().toArray(new OutOfPlaneBendType[0])) {
            newType = ((OutOfPlaneBendType)baseType).patchClasses(typeMap);
            if (newType == null) continue;
            logger.info(" " + String.valueOf(newType));
            this.addForceFieldType(newType);
        }
        for (BaseType baseType : this.piOrbitalTorsionTypes.values().toArray(new PiOrbitalTorsionType[0])) {
            newType = ((PiOrbitalTorsionType)baseType).patchClasses(typeMap);
            if (newType == null) continue;
            logger.info(" " + String.valueOf(newType));
            this.addForceFieldType(newType);
        }
        for (BaseType baseType : this.stretchBendTypes.values().toArray(new StretchBendType[0])) {
            newType = ((StretchBendType)baseType).patchClasses(typeMap);
            if (newType == null) continue;
            logger.info(" " + String.valueOf(newType));
            this.addForceFieldType(newType);
        }
        for (BaseType baseType : this.torsionTypes.values().toArray(new TorsionType[0])) {
            newType = ((TorsionType)baseType).patchClasses(typeMap);
            if (newType == null) continue;
            logger.info(" " + String.valueOf(newType));
            this.addForceFieldType(newType);
        }
        for (BaseType baseType : this.multipoleTypes.values().toArray(new MultipoleType[0])) {
            newType = ((MultipoleType)baseType).patchTypes(typeMap);
            if (newType == null) continue;
            logger.info(" " + String.valueOf(newType));
            this.addForceFieldType(newType);
        }
        try {
            for (AtomType atomType : patchTypes.values()) {
                PolarizeType polarizeType = this.getPolarizeType(atomType.key);
                if (polarizeType == null || !polarizeType.patchTypes(typeMap)) continue;
                logger.info(" " + String.valueOf(polarizeType));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int minClass() {
        int minClass = this.maxClass();
        for (AtomType type : this.atomTypes.values()) {
            if (type.atomClass >= minClass) continue;
            minClass = type.atomClass;
        }
        return minClass;
    }

    private int minType() {
        int minType = this.maxType();
        for (String key : this.atomTypes.keySet()) {
            int type = Integer.parseInt(key);
            if (type >= minType) continue;
            minType = type;
        }
        return minType;
    }

    private int minBioType() {
        int minBioType = this.maxBioType();
        for (String key : this.bioTypes.keySet()) {
            int type = Integer.parseInt(key);
            if (type >= minBioType) continue;
            minBioType = type;
        }
        return minBioType;
    }

    private int maxClass() {
        int maxClass = 0;
        for (AtomType type : this.atomTypes.values()) {
            if (type.atomClass <= maxClass) continue;
            maxClass = type.atomClass;
        }
        return maxClass;
    }

    private int maxType() {
        int maxType = 0;
        for (String key : this.atomTypes.keySet()) {
            int type = Integer.parseInt(key);
            if (type <= maxType) continue;
            maxType = type;
        }
        return maxType;
    }

    private int maxBioType() {
        int maxBioType = 0;
        for (String key : this.bioTypes.keySet()) {
            int type = Integer.parseInt(key);
            if (type <= maxBioType) continue;
            maxBioType = type;
        }
        return maxBioType;
    }

    private void modifiedResidue(String modres) {
        String[] tokens = modres.trim().split(" +");
        String modResname = tokens[0].toUpperCase();
        String stdName = tokens[1].toUpperCase();
        HashMap<String, AtomType> patchAtomTypes = this.getAtomTypes(modResname);
        HashMap<String, AtomType> stdAtomTypes = this.getAtomTypes(stdName);
        HashMap<String, AtomType> patchTypes = new HashMap<String, AtomType>();
        int len = tokens.length;
        for (int i = 2; i < len; ++i) {
            String atomName = tokens[i].toUpperCase();
            if (patchTypes.containsKey(atomName) || !patchAtomTypes.containsKey(atomName)) continue;
            AtomType type = patchAtomTypes.get(atomName);
            patchTypes.put(atomName, type);
        }
        HashMap<AtomType, AtomType> typeMap = new HashMap<AtomType, AtomType>();
        for (String atomName : stdAtomTypes.keySet()) {
            boolean found = false;
            for (int i = 2; i < len; ++i) {
                if (!atomName.equalsIgnoreCase(tokens[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            AtomType stdType = stdAtomTypes.get(atomName);
            AtomType patchType = this.updateBioType(modResname, atomName, stdType.type);
            if (patchType == null) continue;
            typeMap.put(patchType, stdType);
            logger.info(" " + String.valueOf(patchType) + " -> " + String.valueOf(stdType));
        }
        this.patchClassesAndTypes(typeMap, patchTypes);
    }

    private void trueImpliedBoolean(String toSet, String ... otherBooleans) {
        if (this.getBoolean(toSet, false)) {
            return;
        }
        for (String otherBool : otherBooleans) {
            if (!this.getBoolean(otherBool, false)) continue;
            this.addProperty(toSet, "true");
            logger.info(String.format(" Setting implied boolean %s true due to boolean %s", toSet, otherBool));
        }
    }

    private void checkPolarizationTypes() {
        boolean change = false;
        for (String key : this.polarizeTypes.keySet()) {
            PolarizeType polarizeType = this.polarizeTypes.get(key);
            int orig = Integer.parseInt(key);
            int[] types = polarizeType.polarizationGroup;
            if (types == null) continue;
            for (int type : types) {
                String key2 = Integer.toString(type);
                PolarizeType polarizeType2 = this.polarizeTypes.get(key2);
                if (polarizeType2 == null) {
                    logger.severe(String.format("Polarize type %s references nonexistant polarize type %s.", key, key2));
                    continue;
                }
                int[] types2 = polarizeType2.polarizationGroup;
                if (types2 == null) {
                    polarizeType2.add(orig);
                    change = true;
                    continue;
                }
                boolean found = false;
                for (int type2 : types2) {
                    for (int type3 : types) {
                        if (type2 != type3) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    polarizeType.add(type2);
                    change = true;
                }
            }
        }
        if (change) {
            this.checkPolarizationTypes();
        }
    }

    static {
        ClassLoader cl = ForceField.class.getClassLoader();
        String prefix = "ffx/potential/parameters/ff/";
        for (ForceFieldName ff : ForceFieldName.values()) {
            forceFields.put(ff, cl.getResource(prefix + String.valueOf((Object)ff)));
        }
    }

    public static enum ForceFieldType {
        KEYWORD,
        ANGLE,
        ANGLEP,
        ANGTORS,
        ATOM,
        BIOTYPE,
        BOND,
        CHARGE,
        IMPROPER,
        IMPTORS,
        MULTIPOLE,
        OPBEND,
        PITORS,
        POLARIZE,
        SOLUTE,
        STRBND,
        STRTORS,
        TORSION,
        TORTORS,
        UREYBRAD,
        VDW,
        VDW14,
        VDWPR,
        VDWPAIR,
        RELATIVESOLV;

    }

    public static enum ForceFieldName {
        AMBER_1994,
        AMBER_1996,
        AMBER_1998,
        AMBER_1999,
        AMBER_1999_SB,
        AMOEBA_2004,
        AMOEBA_2009,
        AMOEBA_BIO_2009,
        AMOEBA_BIO_2018,
        AMOEBA_BIO_2018_CPHMD,
        AMOEBA_NUC_2017,
        AMOEBA_PROTEIN_2004,
        AMOEBA_PROTEIN_2013,
        AMOEBA_WATER_2003,
        AMOEBA_WATER_2014,
        CHARMM_22,
        CHARMM_27,
        CHARMM_36,
        IAMOEBA_WATER,
        OPLS_AA_2008,
        OPLS_AAL;

    }

    public static enum ELEC_FORM {
        PAM,
        FIXED_CHARGE;

    }
}

