/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Comparator;

@FFXProperty(name="charge", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[1 integer and 1 real]\nProvides a value for a single atomic partial charge electrostatic parameter.\nThe integer modifier, if positive, gives the atom type number for which the charge parameter is to be defined.\nNote that charge parameters are given for atom types, not atom classes. If the integer modifier is negative,\nthen the parameter value to follow applies only to the individual atom whose atom number is the negative of the modifier.\nThe real number modifier gives the values of the atomic partial charge in electrons.\n")
public final class ChargeType
extends BaseType
implements Comparator<String> {
    public static final double DEFAULT_CHG_12_SCALE = 0.0;
    public static final double DEFAULT_CHG_13_SCALE = 0.0;
    public static final double DEFAULT_CHG_14_SCALE = 2.0;
    public static final double DEFAULT_CHG_15_SCALE = 1.0;
    public final double charge;
    public int atomType;

    public ChargeType(int atomType, double charge) {
        super(ForceField.ForceFieldType.CHARGE, "" + atomType);
        this.atomType = atomType;
        this.charge = charge;
    }

    public static ChargeType average(ChargeType chargeType1, ChargeType chargeType2, int atomType) {
        if (chargeType1 == null || chargeType2 == null) {
            return null;
        }
        double charge = (chargeType1.charge + chargeType2.charge) / 2.0;
        return new ChargeType(atomType, charge);
    }

    @Override
    public int compare(String s1, String s2) {
        int t1 = Integer.parseInt(s1);
        int t2 = Integer.parseInt(s2);
        return Integer.compare(t1, t2);
    }

    public void incrementType(int increment) {
        this.atomType += increment;
    }

    @Override
    public String toString() {
        return String.format("charge  %5d  % 7.5f", this.atomType, this.charge);
    }
}

