/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.parameters;

import ffx.potential.bonded.Atom;
import ffx.potential.parameters.BaseType;
import ffx.potential.parameters.ForceField;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@FFXProperty(name="atom", clazz=String.class, propertyGroup=PropertyGroup.PotentialFunctionParameter, description="[2 integers, name, quoted string, integer, real and integer]\nProvides the values needed to define a single force field atom type.\nThe first two integer modifiers denote the atom type and class numbers.\nIf the type and class are identical, only a single integer value is required.\nThe next modifier is a three-character atom name, followed by an 24-character or less atom description contained in single quotes.\nThe next two modifiers are the atomic number and atomic mass.\nThe final integer modifier is the \"valence\" of the atom, defined as the expected number of attached or bonded atoms.\n")
public final class AtomType
extends BaseType
implements Comparator<String> {
    private static final Logger logger = Logger.getLogger(AtomType.class.getName());
    public final String name;
    public final String environment;
    public final int atomicNumber;
    public final double atomicWeight;
    public final int valence;
    public int type;
    public int atomClass;
    public static final double[] atomicMass = new double[]{1.008, 4.002, 6.94, 9.012, 10.81, 12.011, 14.007, 15.999, 18.998, 20.1797, 22.989, 24.305, 26.981, 28.085, 30.973, 32.06, 35.45, 39.948, 39.0983, 40.078, 44.955, 47.867, 50.9415, 51.9961, 54.938, 55.845, 58.933, 58.6934, 63.546, 65.38, 69.723, 72.63, 74.921, 78.971, 79.904, 83.798, 85.4678, 87.62, 88.905, 91.224, 92.906, 95.95, 97.0, 101.07, 102.905, 106.42, 107.8682, 112.414, 114.818, 118.71, 121.76, 127.6, 126.904, 131.293, 132.905, 137.327, 138.905, 140.116, 140.907, 144.242, 145.0, 150.36, 151.964, 157.25, 158.925, 162.5, 164.93, 167.259, 168.934, 173.045, 174.9668, 178.486, 180.947, 183.84, 186.207, 190.23, 192.217, 195.084, 196.966, 200.592, 204.38, 207.2, 208.98, 209.0, 210.0, 222.0, 223.0, 226.0, 227.0, 232.0377, 231.035, 238.028, 237.0, 244.0, 243.0, 247.0, 247.0, 251.0, 252.0, 257.0, 258.0, 259.0, 262.0, 267.0, 270.0, 269.0, 270.0, 270.0, 278.0, 281.0, 281.0, 285.0, 286.0, 289.0, 289.0, 293.0, 293.0, 294.0};

    public AtomType(int type, int atomClass, String name, String environment, int atomicNumber, double atomicWeight, int valence) {
        super(ForceField.ForceFieldType.ATOM, Integer.toString(type));
        this.type = type;
        this.atomClass = atomClass;
        this.name = name;
        this.environment = environment;
        this.atomicNumber = atomicNumber;
        this.atomicWeight = atomicWeight;
        this.valence = valence;
    }

    public static AtomType parse(String input, String[] tokens) {
        if (tokens.length < 7) {
            logger.log(Level.WARNING, "Invalid ATOM type:\n{0}", input);
        } else {
            try {
                int atomClass;
                int index = 1;
                int type = Integer.parseInt(tokens[index++]);
                try {
                    atomClass = Integer.parseInt(tokens[index]);
                    ++index;
                }
                catch (NumberFormatException e) {
                    atomClass = -1;
                }
                String name = tokens[index].intern();
                int first = input.indexOf("\"");
                int last = input.lastIndexOf("\"");
                if (first >= last) {
                    logger.log(Level.WARNING, "Invalid ATOM type:\n{0}", input);
                    return null;
                }
                String environment = input.substring(first, last + 1).intern();
                tokens = input.substring(last + 1).trim().split(" +");
                index = 0;
                int atomicNumber = Integer.parseInt(tokens[index++]);
                double mass = Double.parseDouble(tokens[index++]);
                int hybridization = Integer.parseInt(tokens[index]);
                AtomType atomType = new AtomType(type, atomClass, name, environment, atomicNumber, mass, hybridization);
                if (!AtomType.checkAtomicNumberAndMass(atomicNumber, mass) && !environment.toUpperCase().contains("UA")) {
                    logger.warning(" Atomic number and weight do not agree:\n" + String.valueOf(atomType));
                }
                return atomType;
            }
            catch (NumberFormatException e) {
                String message = "Exception parsing AtomType:\n" + input + "\n";
                logger.log(Level.SEVERE, message, e);
            }
        }
        return null;
    }

    @Override
    public int compare(String s1, String s2) {
        int t1 = Integer.parseInt(s1);
        int t2 = Integer.parseInt(s2);
        return Integer.compare(t1, t2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomType atomType = (AtomType)o;
        return atomType.type == this.type;
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    @Override
    public String toString() {
        String s = this.atomClass >= 0 ? String.format("atom  %5d  %5d  %-4s  %-25s  %3d  %8.4f  %d", this.type, this.atomClass, this.name, this.environment, this.atomicNumber, this.atomicWeight, this.valence) : String.format("atom  %5d  %-4s  %-25s  %3d  %8.4f  %d", this.type, this.name, this.environment, this.atomicNumber, this.atomicWeight, this.valence);
        return s;
    }

    public static Element getXMLAtomTypes(Document doc, ForceField forceField) {
        Element node = doc.createElement("AtomTypes");
        Map<String, AtomType> types = forceField.getAtomTypes();
        for (AtomType atomType : types.values()) {
            node.appendChild(atomType.toXML(doc));
        }
        return node;
    }

    public Element toXML(Document doc) {
        Element node = doc.createElement("Type");
        node.setAttribute("name", String.format("%d", this.type));
        node.setAttribute("class", String.format("%d", this.atomClass));
        if (this.atomicNumber >= 1) {
            node.setAttribute("element", String.format("%s", new Object[]{Atom.ElementSymbol.values()[this.atomicNumber - 1]}));
        } else {
            node.setAttribute("element", "");
        }
        node.setAttribute("mass", String.format("%.3f", this.atomicWeight));
        return node;
    }

    void incrementClassAndType(int classIncrement, int typeIncrement) {
        this.atomClass += classIncrement;
        this.type += typeIncrement;
        this.setKey(Integer.toString(this.type));
    }

    public static boolean checkAtomicNumberAndMass(int atomicNumber, double mass) {
        return AtomType.checkAtomicNumberAndMass(atomicNumber, mass, 0.1);
    }

    public static boolean checkAtomicNumberAndMass(int atomicNumber, double mass, double tolerance) {
        if (atomicNumber == 0 || atomicNumber >= atomicMass.length) {
            return true;
        }
        double expected = atomicMass[atomicNumber - 1];
        return FastMath.abs((double)(expected - mass)) < tolerance;
    }
}

