/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.Force;
import ffx.openmm.HarmonicBondForce;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.UreyBradley;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.UreyBradleyType;
import ffx.potential.terms.UreyBradleyPotentialEnergy;
import java.util.logging.Logger;

public class UreyBradleyForce
extends HarmonicBondForce {
    private static final Logger logger = Logger.getLogger(UreyBradleyForce.class.getName());

    public UreyBradleyForce(UreyBradleyPotentialEnergy ureyBradleyPotentialEnergy) {
        UreyBradley[] ureyBradleys = ureyBradleyPotentialEnergy.getUreyBradleyArray();
        double kParameterConversion = 418.3999999999999;
        for (UreyBradley ureyBradley : ureyBradleys) {
            int i1 = ureyBradley.getAtom(0).getArrayIndex();
            int i2 = ureyBradley.getAtom(2).getArrayIndex();
            UreyBradleyType ureyBradleyType = ureyBradley.ureyBradleyType;
            double length = ureyBradleyType.distance * 0.1;
            double k = 2.0 * ureyBradleyType.forceConstant * ureyBradleyType.ureyUnit * kParameterConversion;
            this.addBond(i1, i2, length, k);
        }
        int forceGroup = ureyBradleyPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Urey-Bradleys:                     %10d", ureyBradleys.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public UreyBradleyForce(UreyBradleyPotentialEnergy ureyBradleyPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        UreyBradley[] ureyBradleys = ureyBradleyPotentialEnergy.getUreyBradleyArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        double kParameterConversion = 418.3999999999999;
        for (UreyBradley ureyBradley : ureyBradleys) {
            int i1 = ureyBradley.getAtom(0).getArrayIndex();
            int i2 = ureyBradley.getAtom(2).getArrayIndex();
            UreyBradleyType ureyBradleyType = ureyBradley.ureyBradleyType;
            double length = ureyBradleyType.distance * 0.1;
            double k = 2.0 * ureyBradleyType.forceConstant * ureyBradleyType.ureyUnit * kParameterConversion;
            if (!ureyBradley.applyLambda()) {
                k *= scale;
            }
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            this.addBond(i1, i2, length, k);
        }
        int forceGroup = ureyBradleyPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Urey-Bradleys:                     %10d", ureyBradleys.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        UreyBradleyPotentialEnergy ureyBradleyPotentialEnergy = openMMEnergy.getUreyBradleyPotentialEnergy();
        if (ureyBradleyPotentialEnergy == null) {
            return null;
        }
        return new UreyBradleyForce(ureyBradleyPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        UreyBradleyPotentialEnergy ureyBradleyPotentialEnergy = forceFieldEnergy.getUreyBradleyPotentialEnergy();
        if (ureyBradleyPotentialEnergy == null) {
            return null;
        }
        return new UreyBradleyForce(ureyBradleyPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        UreyBradleyPotentialEnergy ureyBradleyPotentialEnergy = openMMEnergy.getUreyBradleyPotentialEnergy();
        if (ureyBradleyPotentialEnergy == null) {
            return;
        }
        UreyBradley[] ureyBradleys = ureyBradleyPotentialEnergy.getUreyBradleyArray();
        double kParameterConversion = 418.3999999999999;
        int index = 0;
        for (UreyBradley ureyBradley : ureyBradleys) {
            int i1 = ureyBradley.getAtom(0).getArrayIndex();
            int i2 = ureyBradley.getAtom(2).getArrayIndex();
            UreyBradleyType ureyBradleyType = ureyBradley.ureyBradleyType;
            double length = ureyBradleyType.distance * 0.1;
            double k = 2.0 * ureyBradleyType.forceConstant * ureyBradleyType.ureyUnit * kParameterConversion;
            this.setBondParameters(index++, i1, i2, length, k);
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        UreyBradleyPotentialEnergy forceFieldEnergyUreyBradley = forceFieldEnergy.getUreyBradleyPotentialEnergy();
        if (forceFieldEnergyUreyBradley == null) {
            return;
        }
        UreyBradley[] ureyBradleys = forceFieldEnergyUreyBradley.getUreyBradleyArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        double kParameterConversion = 418.3999999999999;
        int index = 0;
        for (UreyBradley ureyBradley : ureyBradleys) {
            int i1 = ureyBradley.getAtom(0).getArrayIndex();
            int i2 = ureyBradley.getAtom(2).getArrayIndex();
            UreyBradleyType ureyBradleyType = ureyBradley.ureyBradleyType;
            double length = ureyBradleyType.distance * 0.1;
            double k = 2.0 * ureyBradleyType.forceConstant * ureyBradleyType.ureyUnit * kParameterConversion;
            if (!ureyBradley.applyLambda()) {
                k *= scale;
            }
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            this.setBondParameters(index++, i1, i2, length, k);
        }
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

