/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomCompoundBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.StretchTorsion;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.terms.StretchTorsionPotentialEnergy;
import java.util.logging.Logger;

public class StretchTorsionForce
extends CustomCompoundBondForce {
    private static final Logger logger = Logger.getLogger(StretchTorsionForce.class.getName());

    public StretchTorsionForce(StretchTorsionPotentialEnergy stretchTorsionPotentialEnergy) {
        super(4, StretchTorsion.stretchTorsionForm());
        int m;
        StretchTorsion[] stretchTorsions = stretchTorsionPotentialEnergy.getStretchTorsionArray();
        this.addGlobalParameter("phi1", 0.0);
        this.addGlobalParameter("phi2", Math.PI);
        this.addGlobalParameter("phi3", 0.0);
        for (m = 1; m < 4; ++m) {
            for (int n = 1; n < 4; ++n) {
                this.addPerBondParameter(String.format("k%d%d", m, n));
            }
        }
        for (m = 1; m < 4; ++m) {
            this.addPerBondParameter(String.format("b%d", m));
        }
        double unitConv = 41.839999999999996;
        for (StretchTorsion stretchTorsion : stretchTorsions) {
            double[] constants = stretchTorsion.getConstants();
            DoubleArray parameters = new DoubleArray(0);
            for (int m2 = 0; m2 < 3; ++m2) {
                for (int n = 0; n < 3; ++n) {
                    int index = 3 * m2 + n;
                    parameters.append(constants[index] * 41.839999999999996);
                }
            }
            parameters.append(stretchTorsion.bondType1.distance * 0.1);
            parameters.append(stretchTorsion.bondType2.distance * 0.1);
            parameters.append(stretchTorsion.bondType3.distance * 0.1);
            IntArray particles = new IntArray(0);
            Atom[] atoms = stretchTorsion.getAtomArray(true);
            for (int i = 0; i < 4; ++i) {
                particles.append(atoms[i].getArrayIndex());
            }
            this.addBond(particles, parameters);
            parameters.destroy();
            particles.destroy();
        }
        int forceGroup = stretchTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Stretch-Torsions:                  %10d", stretchTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public StretchTorsionForce(StretchTorsionPotentialEnergy stretchPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        super(4, StretchTorsion.stretchTorsionForm());
        int m;
        StretchTorsion[] stretchTorsions = stretchPotentialEnergy.getStretchTorsionArray();
        this.addGlobalParameter("phi1", 0.0);
        this.addGlobalParameter("phi2", Math.PI);
        this.addGlobalParameter("phi3", 0.0);
        for (m = 1; m < 4; ++m) {
            for (int n = 1; n < 4; ++n) {
                this.addPerBondParameter(String.format("k%d%d", m, n));
            }
        }
        for (m = 1; m < 4; ++m) {
            this.addPerBondParameter(String.format("b%d", m));
        }
        double unitConv = 41.839999999999996;
        double scaleDT = openMMDualTopologyEnergy.getTopologyScale(topology);
        for (StretchTorsion stretchTorsion : stretchTorsions) {
            double scale = 1.0;
            if (!stretchTorsion.applyLambda()) {
                scale = scaleDT;
            }
            double[] constants = stretchTorsion.getConstants();
            DoubleArray parameters = new DoubleArray(0);
            for (int m2 = 0; m2 < 3; ++m2) {
                for (int n = 0; n < 3; ++n) {
                    int index = 3 * m2 + n;
                    parameters.append(constants[index] * 41.839999999999996 * scale);
                }
            }
            parameters.append(stretchTorsion.bondType1.distance * 0.1);
            parameters.append(stretchTorsion.bondType2.distance * 0.1);
            parameters.append(stretchTorsion.bondType3.distance * 0.1);
            IntArray particles = new IntArray(0);
            Atom[] atoms = stretchTorsion.getAtomArray(true);
            for (int i = 0; i < 4; ++i) {
                int atomIndex = atoms[i].getArrayIndex();
                atomIndex = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, atomIndex);
                particles.append(atomIndex);
            }
            this.addBond(particles, parameters);
            parameters.destroy();
            particles.destroy();
        }
        int forceGroup = stretchPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Stretch-Torsions:                  %10d", stretchTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        StretchTorsionPotentialEnergy stretchTorsionPotentialEnergy = openMMEnergy.getStretchTorsionPotentialEnergy();
        if (stretchTorsionPotentialEnergy == null) {
            return null;
        }
        return new StretchTorsionForce(stretchTorsionPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        StretchTorsionPotentialEnergy stretchTorsionPotentialEnergy = forceFieldEnergy.getStretchTorsionPotentialEnergy();
        if (stretchTorsionPotentialEnergy == null) {
            return null;
        }
        return new StretchTorsionForce(stretchTorsionPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        StretchTorsionPotentialEnergy stretchTorsionPotentialEnergy = forceFieldEnergy.getStretchTorsionPotentialEnergy();
        if (stretchTorsionPotentialEnergy == null) {
            return;
        }
        StretchTorsion[] stretchTorsions = stretchTorsionPotentialEnergy.getStretchTorsionArray();
        double unitConv = 41.839999999999996;
        double scaleDT = openMMDualTopologyEnergy.getTopologyScale(topology);
        int stIndex = 0;
        for (StretchTorsion stretchTorsion : stretchTorsions) {
            double scale = 1.0;
            if (!stretchTorsion.applyLambda()) {
                scale = scaleDT;
            }
            double[] constants = stretchTorsion.getConstants();
            DoubleArray parameters = new DoubleArray(0);
            for (int m = 0; m < 3; ++m) {
                for (int n = 0; n < 3; ++n) {
                    int index = 3 * m + n;
                    parameters.append(constants[index] * 41.839999999999996 * scale);
                }
            }
            parameters.append(stretchTorsion.bondType1.distance * 0.1);
            parameters.append(stretchTorsion.bondType2.distance * 0.1);
            parameters.append(stretchTorsion.bondType3.distance * 0.1);
            IntArray particles = new IntArray(0);
            Atom[] atoms = stretchTorsion.getAtomArray(true);
            for (int i = 0; i < 4; ++i) {
                int atomIndex = atoms[i].getArrayIndex();
                atomIndex = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, atomIndex);
                particles.append(atomIndex);
            }
            this.setBondParameters(stIndex++, particles, parameters);
            parameters.destroy();
            particles.destroy();
        }
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

