/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomCompoundBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.StretchBend;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.terms.StretchBendPotentialEnergy;
import java.util.logging.Logger;

public class StretchBendForce
extends CustomCompoundBondForce {
    private static final Logger logger = Logger.getLogger(StretchBendForce.class.getName());

    public StretchBendForce(StretchBendPotentialEnergy stretchBendPotentialEnergy) {
        super(3, StretchBendPotentialEnergy.getStretchBendEnergyString());
        StretchBend[] stretchBends = stretchBendPotentialEnergy.getStretchBendArray();
        this.addPerBondParameter("r12");
        this.addPerBondParameter("r23");
        this.addPerBondParameter("theta0");
        this.addPerBondParameter("k1");
        this.addPerBondParameter("k2");
        this.setName("AmoebaStretchBend");
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (StretchBend stretchBend : stretchBends) {
            int i1 = stretchBend.getAtom(0).getArrayIndex();
            int i2 = stretchBend.getAtom(1).getArrayIndex();
            int i3 = stretchBend.getAtom(2).getArrayIndex();
            double r12 = stretchBend.bond0Eq * 0.1;
            double r23 = stretchBend.bond1Eq * 0.1;
            double theta0 = stretchBend.angleEq * (Math.PI / 180);
            double k1 = stretchBend.force0 * 4.184 / 0.1;
            double k2 = stretchBend.force1 * 4.184 / 0.1;
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            parameters.append(r12);
            parameters.append(r23);
            parameters.append(theta0);
            parameters.append(k1);
            parameters.append(k2);
            this.addBond(particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        int forceGroup = stretchBendPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Stretch-Bends:                     %10d", stretchBends.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public StretchBendForce(StretchBendPotentialEnergy stretchBendPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        super(3, StretchBendPotentialEnergy.getStretchBendEnergyString());
        StretchBend[] stretchBends = stretchBendPotentialEnergy.getStretchBendArray();
        this.addPerBondParameter("r12");
        this.addPerBondParameter("r23");
        this.addPerBondParameter("theta0");
        this.addPerBondParameter("k1");
        this.addPerBondParameter("k2");
        this.setName("AmoebaStretchBend");
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (StretchBend stretchBend : stretchBends) {
            int i1 = stretchBend.getAtom(0).getArrayIndex();
            int i2 = stretchBend.getAtom(1).getArrayIndex();
            int i3 = stretchBend.getAtom(2).getArrayIndex();
            double r12 = stretchBend.bond0Eq * 0.1;
            double r23 = stretchBend.bond1Eq * 0.1;
            double theta0 = stretchBend.angleEq * (Math.PI / 180);
            double k1 = stretchBend.force0 * 4.184 / 0.1;
            double k2 = stretchBend.force1 * 4.184 / 0.1;
            if (!stretchBend.applyLambda()) {
                k1 *= scale;
                k2 *= scale;
            }
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            i3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i3);
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            parameters.append(r12);
            parameters.append(r23);
            parameters.append(theta0);
            parameters.append(k1);
            parameters.append(k2);
            this.addBond(particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        int forceGroup = stretchBendPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Stretch-Bends:                     %10d", stretchBends.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        StretchBendPotentialEnergy stretchBendPotentialEnergy = openMMEnergy.getStretchBendPotentialEnergy();
        if (stretchBendPotentialEnergy == null) {
            return null;
        }
        return new StretchBendForce(stretchBendPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        StretchBendPotentialEnergy stretchBendPotentialEnergy = forceFieldEnergy.getStretchBendPotentialEnergy();
        if (stretchBendPotentialEnergy == null) {
            return null;
        }
        return new StretchBendForce(stretchBendPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        StretchBendPotentialEnergy stretchBendPotentialEnergy = openMMEnergy.getStretchBendPotentialEnergy();
        if (stretchBendPotentialEnergy == null) {
            return;
        }
        StretchBend[] stretchBends = stretchBendPotentialEnergy.getStretchBendArray();
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (StretchBend stretchBend : stretchBends) {
            int i1 = stretchBend.getAtom(0).getArrayIndex();
            int i2 = stretchBend.getAtom(1).getArrayIndex();
            int i3 = stretchBend.getAtom(2).getArrayIndex();
            double r12 = stretchBend.bond0Eq * 0.1;
            double r23 = stretchBend.bond1Eq * 0.1;
            double theta0 = stretchBend.angleEq * (Math.PI / 180);
            double k1 = stretchBend.force0 * 4.184 / 0.1;
            double k2 = stretchBend.force1 * 4.184 / 0.1;
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            parameters.append(r12);
            parameters.append(r23);
            parameters.append(theta0);
            parameters.append(k1);
            parameters.append(k2);
            this.setBondParameters(index++, particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        StretchBendPotentialEnergy stretchBendPotentialEnergy = forceFieldEnergy.getStretchBendPotentialEnergy();
        if (stretchBendPotentialEnergy == null) {
            return;
        }
        StretchBend[] stretchBends = stretchBendPotentialEnergy.getStretchBendArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (StretchBend stretchBend : stretchBends) {
            int i1 = stretchBend.getAtom(0).getArrayIndex();
            int i2 = stretchBend.getAtom(1).getArrayIndex();
            int i3 = stretchBend.getAtom(2).getArrayIndex();
            double r12 = stretchBend.bond0Eq * 0.1;
            double r23 = stretchBend.bond1Eq * 0.1;
            double theta0 = stretchBend.angleEq * (Math.PI / 180);
            double k1 = stretchBend.force0 * 4.184 / 0.1;
            double k2 = stretchBend.force1 * 4.184 / 0.1;
            if (!stretchBend.applyLambda()) {
                k1 *= scale;
                k2 *= scale;
            }
            i1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i1);
            i2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i2);
            i3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, i3);
            particles.append(i1);
            particles.append(i2);
            particles.append(i3);
            parameters.append(r12);
            parameters.append(r23);
            parameters.append(theta0);
            parameters.append(k1);
            parameters.append(k2);
            this.setBondParameters(index++, particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

