/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.Force;
import ffx.openmm.PeriodicTorsionForce;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.Torsion;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.TorsionType;
import ffx.potential.terms.RestrainTorsionPotentialEnergy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestrainTorsionsForce
extends PeriodicTorsionForce {
    private static final Logger logger = Logger.getLogger(RestrainTorsionsForce.class.getName());

    public RestrainTorsionsForce(RestrainTorsionPotentialEnergy restrainTorsionPotentialEnergy) {
        Torsion[] restrainTorsions;
        for (Torsion restrainTorsion : restrainTorsions = restrainTorsionPotentialEnergy.getRestrainTorsionArray()) {
            int a1 = restrainTorsion.getAtom(0).getArrayIndex();
            int a2 = restrainTorsion.getAtom(1).getArrayIndex();
            int a3 = restrainTorsion.getAtom(2).getArrayIndex();
            int a4 = restrainTorsion.getAtom(3).getArrayIndex();
            TorsionType torsionType = restrainTorsion.torsionType;
            int nTerms = torsionType.phase.length;
            for (int j = 0; j < nTerms; ++j) {
                this.addTorsion(a1, a2, a3, a4, j + 1, torsionType.phase[j] * (Math.PI / 180), 4.184 * torsionType.torsionUnit * torsionType.amplitude[j]);
            }
        }
        int forceGroup = restrainTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  Restrain-Torsions \t%6d\t\t%1d", restrainTorsions.length, forceGroup));
    }

    public RestrainTorsionsForce(RestrainTorsionPotentialEnergy restrainTorsionPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        Torsion[] restrainTorsions = restrainTorsionPotentialEnergy.getRestrainTorsionArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        for (Torsion restrainTorsion : restrainTorsions) {
            int a1 = restrainTorsion.getAtom(0).getArrayIndex();
            int a2 = restrainTorsion.getAtom(1).getArrayIndex();
            int a3 = restrainTorsion.getAtom(2).getArrayIndex();
            int a4 = restrainTorsion.getAtom(3).getArrayIndex();
            a1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a1);
            a2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a2);
            a3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a3);
            a4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a4);
            TorsionType torsionType = restrainTorsion.torsionType;
            int nTerms = torsionType.phase.length;
            for (int j = 0; j < nTerms; ++j) {
                double k = restrainTorsion.getTorsionScale() * torsionType.torsionUnit * torsionType.amplitude[j];
                this.addTorsion(a1, a2, a3, a4, j + 1, torsionType.phase[j] * (Math.PI / 180), 4.184 * (k *= 1.0 - scale));
            }
        }
        int forceGroup = forceFieldEnergy.getMolecularAssembly().getForceField().getInteger("RESTRAIN_TORSION_FORCE_GROUP", 0);
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Restrain-Torsions:                 %10d", restrainTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        RestrainTorsionPotentialEnergy restrainTorsionPotentialEnergy = openMMEnergy.getRestrainTorsionPotentialEnergy();
        if (restrainTorsionPotentialEnergy == null) {
            return null;
        }
        return new RestrainTorsionsForce(restrainTorsionPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        RestrainTorsionPotentialEnergy restrainTorsionPotentialEnergy = forceFieldEnergy.getRestrainTorsionPotentialEnergy();
        if (restrainTorsionPotentialEnergy == null) {
            return null;
        }
        return new RestrainTorsionsForce(restrainTorsionPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        RestrainTorsionPotentialEnergy restrainTorsionPotentialEnergy = openMMEnergy.getRestrainTorsionPotentialEnergy();
        if (restrainTorsionPotentialEnergy == null) {
            return;
        }
        Torsion[] restrainTorsions = restrainTorsionPotentialEnergy.getRestrainTorsionArray();
        int index = 0;
        for (Torsion restrainTorsion : restrainTorsions) {
            TorsionType torsionType = restrainTorsion.torsionType;
            int nTerms = torsionType.phase.length;
            int a1 = restrainTorsion.getAtom(0).getArrayIndex();
            int a2 = restrainTorsion.getAtom(1).getArrayIndex();
            int a3 = restrainTorsion.getAtom(2).getArrayIndex();
            int a4 = restrainTorsion.getAtom(3).getArrayIndex();
            for (int j = 0; j < nTerms; ++j) {
                double forceConstant = 4.184 * torsionType.torsionUnit * torsionType.amplitude[j];
                this.setTorsionParameters(index++, a1, a2, a3, a4, j + 1, torsionType.phase[j] * (Math.PI / 180), forceConstant);
            }
        }
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        RestrainTorsionPotentialEnergy restrainTorsionPotentialEnergy = forceFieldEnergy.getRestrainTorsionPotentialEnergy();
        if (restrainTorsionPotentialEnergy == null) {
            return;
        }
        Torsion[] restrainTorsions = restrainTorsionPotentialEnergy.getRestrainTorsionArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        int index = 0;
        for (Torsion restrainTorsion : restrainTorsions) {
            TorsionType torsionType = restrainTorsion.torsionType;
            int nTerms = torsionType.phase.length;
            int a1 = restrainTorsion.getAtom(0).getArrayIndex();
            int a2 = restrainTorsion.getAtom(1).getArrayIndex();
            int a3 = restrainTorsion.getAtom(2).getArrayIndex();
            int a4 = restrainTorsion.getAtom(3).getArrayIndex();
            a1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a1);
            a2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a2);
            a3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a3);
            a4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a4);
            for (int j = 0; j < nTerms; ++j) {
                double forceConstant = restrainTorsion.getTorsionScale() * torsionType.torsionUnit * torsionType.amplitude[j];
                this.setTorsionParameters(index++, a1, a2, a3, a4, j + 1, torsionType.phase[j] * (Math.PI / 180), 4.184 * (forceConstant *= 1.0 - scale));
            }
        }
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

