/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomExternalForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.RestrainPosition;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.terms.RestrainPositionPotentialEnergy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestrainPositionsForce
extends CustomExternalForce {
    private static final Logger logger = Logger.getLogger(RestrainPositionsForce.class.getName());

    public RestrainPositionsForce(RestrainPositionPotentialEnergy restrainPositionPotentialEnergy) {
        super(RestrainPositionPotentialEnergy.getRestrainPositionEnergyString());
        RestrainPosition[] restrainPositions = restrainPositionPotentialEnergy.getRestrainPositionArray();
        this.addPerParticleParameter("k0");
        this.addPerParticleParameter("x0");
        this.addPerParticleParameter("y0");
        this.addPerParticleParameter("z0");
        int nRestraints = restrainPositions.length;
        double convert = 418.3999999999999;
        for (RestrainPosition restrainPosition : restrainPositions) {
            double forceConstant = restrainPosition.getForceConstant() * convert;
            Atom[] restrainPositionAtoms = restrainPosition.getAtoms();
            int numAtoms = restrainPosition.getNumAtoms();
            double[][] equilibriumCoordinates = restrainPosition.getEquilibriumCoordinates();
            for (int i = 0; i < numAtoms; ++i) {
                double[] dArray = equilibriumCoordinates[i];
                dArray[0] = dArray[0] * 0.1;
                double[] dArray2 = equilibriumCoordinates[i];
                dArray2[1] = dArray2[1] * 0.1;
                double[] dArray3 = equilibriumCoordinates[i];
                dArray3[2] = dArray3[2] * 0.1;
            }
            DoubleArray parameters = new DoubleArray(4);
            for (int i = 0; i < numAtoms; ++i) {
                int index = restrainPositionAtoms[i].getXyzIndex() - 1;
                parameters.set(0, forceConstant);
                for (int j = 0; j < 3; ++j) {
                    parameters.set(j + 1, equilibriumCoordinates[i][j]);
                }
                this.addParticle(index, parameters);
            }
            parameters.destroy();
        }
        int forceGroup = restrainPositionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  Restrain Positions\t%6d\t\t%d", nRestraints, forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        RestrainPositionPotentialEnergy restrainPositionPotentialEnergy = openMMEnergy.getRestrainPositionPotentialEnergy();
        if (restrainPositionPotentialEnergy == null) {
            return null;
        }
        return new RestrainPositionsForce(restrainPositionPotentialEnergy);
    }
}

