/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.RestrainDistance;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.BondType;
import ffx.potential.terms.RestrainDistancePotentialEnergy;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestrainDistanceForce
extends CustomBondForce {
    private static final Logger logger = Logger.getLogger(RestrainDistanceForce.class.getName());

    public RestrainDistanceForce(BondType.BondFunction bondFunction, RestrainDistancePotentialEnergy restrainDistancePotentialEnergy) {
        super(bondFunction.toMathematicalForm());
        List<RestrainDistance> restrainDistances = restrainDistancePotentialEnergy.getRestrainDistances(bondFunction);
        if (restrainDistances == null || restrainDistances.isEmpty()) {
            this.destroy();
            return;
        }
        this.addPerBondParameter("k");
        this.addPerBondParameter("r0");
        if (bondFunction.hasFlatBottom()) {
            this.addPerBondParameter("fb");
        }
        BondType bondType = restrainDistances.getFirst().bondType;
        switch (bondFunction) {
            case QUARTIC: 
            case FLAT_BOTTOM_QUARTIC: {
                this.addGlobalParameter("cubic", bondType.cubic / 0.1);
                this.addGlobalParameter("quartic", bondType.quartic / 0.010000000000000002);
            }
        }
        double forceConvert = 836.7999999999998;
        DoubleArray parameters = new DoubleArray(0);
        for (RestrainDistance restrainDistance : restrainDistances) {
            bondType = restrainDistance.bondType;
            double forceConstant = bondType.forceConstant * bondType.bondUnit * forceConvert;
            double distance = bondType.distance * 0.1;
            Atom[] atoms = restrainDistance.getAtomArray();
            int i1 = atoms[0].getXyzIndex() - 1;
            int i2 = atoms[1].getXyzIndex() - 1;
            parameters.append(forceConstant);
            parameters.append(distance);
            if (bondFunction.hasFlatBottom()) {
                parameters.append(bondType.flatBottomRadius * 0.1);
            }
            this.addBond(i1, i2, parameters);
            parameters.destroy();
        }
        parameters.destroy();
        int forceGroup = restrainDistancePotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.log(Level.INFO, String.format("  Restrain-Distance force \t%6d\t%d", restrainDistances.size(), forceGroup));
    }

    public static Force constructForce(BondType.BondFunction bondFunction, OpenMMEnergy openMMEnergy) {
        RestrainDistancePotentialEnergy restrainDistancePotentialEnergy = openMMEnergy.getRestrainDistancePotentialEnergy();
        if (restrainDistancePotentialEnergy == null) {
            return null;
        }
        List<RestrainDistance> restrainDistances = restrainDistancePotentialEnergy.getRestrainDistances(bondFunction);
        if (restrainDistances == null || restrainDistances.isEmpty()) {
            return null;
        }
        return new RestrainDistanceForce(bondFunction, restrainDistancePotentialEnergy);
    }
}

