/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.openmm;

import ffx.openmm.CustomCompoundBondForce;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntArray;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.bonded.PiOrbitalTorsion;
import ffx.potential.openmm.OpenMMDualTopologyEnergy;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.PiOrbitalTorsionType;
import ffx.potential.terms.PiOrbitalTorsionPotentialEnergy;
import java.util.logging.Logger;

public class PiOrbitalTorsionForce
extends CustomCompoundBondForce {
    private static final Logger logger = Logger.getLogger(PiOrbitalTorsionForce.class.getName());

    public PiOrbitalTorsionForce(PiOrbitalTorsionPotentialEnergy piOrbitalTorsionPotentialEnergy) {
        super(6, PiOrbitalTorsionPotentialEnergy.getPiOrbitalTorsionEnergyString());
        PiOrbitalTorsion[] piOrbitalTorsions = piOrbitalTorsionPotentialEnergy.getPiOrbitalTorsionArray();
        this.addPerBondParameter("k");
        this.setName("PiOrbitalTorsion");
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (PiOrbitalTorsion piOrbitalTorsion : piOrbitalTorsions) {
            int a1 = piOrbitalTorsion.getAtom(0).getArrayIndex();
            int a2 = piOrbitalTorsion.getAtom(1).getArrayIndex();
            int a3 = piOrbitalTorsion.getAtom(2).getArrayIndex();
            int a4 = piOrbitalTorsion.getAtom(3).getArrayIndex();
            int a5 = piOrbitalTorsion.getAtom(4).getArrayIndex();
            int a6 = piOrbitalTorsion.getAtom(5).getArrayIndex();
            PiOrbitalTorsionType type = piOrbitalTorsion.piOrbitalTorsionType;
            double k = 4.184 * type.forceConstant * piOrbitalTorsion.piOrbitalTorsionType.piTorsUnit;
            particles.append(a1);
            particles.append(a2);
            particles.append(a3);
            particles.append(a4);
            particles.append(a5);
            particles.append(a6);
            parameters.append(k);
            this.addBond(particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        int forceGroup = piOrbitalTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Pi-Orbital Torsions:               %10d", piOrbitalTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public PiOrbitalTorsionForce(PiOrbitalTorsionPotentialEnergy piOrbitalTorsionPotentialEnergy, int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        super(6, PiOrbitalTorsionPotentialEnergy.getPiOrbitalTorsionEnergyString());
        PiOrbitalTorsion[] piOrbitalTorsions = piOrbitalTorsionPotentialEnergy.getPiOrbitalTorsionArray();
        this.addPerBondParameter("k");
        this.setName("PiOrbitalTorsion");
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        for (PiOrbitalTorsion piOrbitalTorsion : piOrbitalTorsions) {
            int a1 = piOrbitalTorsion.getAtom(0).getArrayIndex();
            int a2 = piOrbitalTorsion.getAtom(1).getArrayIndex();
            int a3 = piOrbitalTorsion.getAtom(2).getArrayIndex();
            int a4 = piOrbitalTorsion.getAtom(3).getArrayIndex();
            int a5 = piOrbitalTorsion.getAtom(4).getArrayIndex();
            int a6 = piOrbitalTorsion.getAtom(5).getArrayIndex();
            PiOrbitalTorsionType type = piOrbitalTorsion.piOrbitalTorsionType;
            double k = 4.184 * type.forceConstant * piOrbitalTorsion.piOrbitalTorsionType.piTorsUnit;
            if (!piOrbitalTorsion.applyLambda()) {
                k *= scale;
            }
            a1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a1);
            a2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a2);
            a3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a3);
            a4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a4);
            a5 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a5);
            a6 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a6);
            particles.append(a1);
            particles.append(a2);
            particles.append(a3);
            particles.append(a4);
            particles.append(a5);
            particles.append(a6);
            parameters.append(k);
            this.addBond(particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        int forceGroup = piOrbitalTorsionPotentialEnergy.getForceGroup();
        this.setForceGroup(forceGroup);
        logger.info(String.format("  Pi-Orbital Torsions:               %10d", piOrbitalTorsions.length));
        logger.fine(String.format("   Force Group:                      %10d", forceGroup));
    }

    public static Force constructForce(OpenMMEnergy openMMEnergy) {
        PiOrbitalTorsionPotentialEnergy piOrbitalTorsionPotentialEnergy = openMMEnergy.getPiOrbitalTorsionPotentialEnergy();
        if (piOrbitalTorsionPotentialEnergy == null) {
            return null;
        }
        return new PiOrbitalTorsionForce(piOrbitalTorsionPotentialEnergy);
    }

    public static Force constructForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        PiOrbitalTorsionPotentialEnergy piOrbitalTorsionPotentialEnergy = forceFieldEnergy.getPiOrbitalTorsionPotentialEnergy();
        if (piOrbitalTorsionPotentialEnergy == null) {
            return null;
        }
        return new PiOrbitalTorsionForce(piOrbitalTorsionPotentialEnergy, topology, openMMDualTopologyEnergy);
    }

    public void updateForce(OpenMMEnergy openMMEnergy) {
        PiOrbitalTorsionPotentialEnergy piOrbitalTorsionPotentialEnergy = openMMEnergy.getPiOrbitalTorsionPotentialEnergy();
        if (piOrbitalTorsionPotentialEnergy == null) {
            return;
        }
        PiOrbitalTorsion[] piOrbitalTorsions = piOrbitalTorsionPotentialEnergy.getPiOrbitalTorsionArray();
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (PiOrbitalTorsion piOrbitalTorsion : piOrbitalTorsions) {
            int a1 = piOrbitalTorsion.getAtom(0).getArrayIndex();
            int a2 = piOrbitalTorsion.getAtom(1).getArrayIndex();
            int a3 = piOrbitalTorsion.getAtom(2).getArrayIndex();
            int a4 = piOrbitalTorsion.getAtom(3).getArrayIndex();
            int a5 = piOrbitalTorsion.getAtom(4).getArrayIndex();
            int a6 = piOrbitalTorsion.getAtom(5).getArrayIndex();
            PiOrbitalTorsionType type = piOrbitalTorsion.piOrbitalTorsionType;
            double k = 4.184 * type.forceConstant * piOrbitalTorsion.piOrbitalTorsionType.piTorsUnit;
            particles.append(a1);
            particles.append(a2);
            particles.append(a3);
            particles.append(a4);
            particles.append(a5);
            particles.append(a6);
            parameters.append(k);
            this.setBondParameters(index++, particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        this.updateParametersInContext(openMMEnergy.getContext());
    }

    public void updateForce(int topology, OpenMMDualTopologyEnergy openMMDualTopologyEnergy) {
        ForceFieldEnergy forceFieldEnergy = openMMDualTopologyEnergy.getForceFieldEnergy(topology);
        PiOrbitalTorsionPotentialEnergy piOrbitalTorsionPotentialEnergy = forceFieldEnergy.getPiOrbitalTorsionPotentialEnergy();
        if (piOrbitalTorsionPotentialEnergy == null) {
            return;
        }
        PiOrbitalTorsion[] piOrbitalTorsions = piOrbitalTorsionPotentialEnergy.getPiOrbitalTorsionArray();
        double scale = openMMDualTopologyEnergy.getTopologyScale(topology);
        IntArray particles = new IntArray(0);
        DoubleArray parameters = new DoubleArray(0);
        int index = 0;
        for (PiOrbitalTorsion piOrbitalTorsion : piOrbitalTorsions) {
            int a1 = piOrbitalTorsion.getAtom(0).getArrayIndex();
            int a2 = piOrbitalTorsion.getAtom(1).getArrayIndex();
            int a3 = piOrbitalTorsion.getAtom(2).getArrayIndex();
            int a4 = piOrbitalTorsion.getAtom(3).getArrayIndex();
            int a5 = piOrbitalTorsion.getAtom(4).getArrayIndex();
            int a6 = piOrbitalTorsion.getAtom(5).getArrayIndex();
            PiOrbitalTorsionType type = piOrbitalTorsion.piOrbitalTorsionType;
            double k = 4.184 * type.forceConstant * piOrbitalTorsion.piOrbitalTorsionType.piTorsUnit;
            if (!piOrbitalTorsion.applyLambda()) {
                k *= scale;
            }
            a1 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a1);
            a2 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a2);
            a3 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a3);
            a4 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a4);
            a5 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a5);
            a6 = openMMDualTopologyEnergy.mapToDualTopologyIndex(topology, a6);
            particles.append(a1);
            particles.append(a2);
            particles.append(a3);
            particles.append(a4);
            particles.append(a5);
            particles.append(a6);
            parameters.append(k);
            this.setBondParameters(index++, particles, parameters);
            particles.resize(0);
            parameters.resize(0);
        }
        particles.destroy();
        parameters.destroy();
        this.updateParametersInContext(openMMDualTopologyEnergy.getContext());
    }
}

